/*
 * Decompiled with CFR 0.152.
 */
package net.phys2d.raw;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import net.phys2d.math.ROVector2f;
import net.phys2d.math.Vector2f;
import net.phys2d.raw.Arbiter;
import net.phys2d.raw.Body;
import net.phys2d.raw.BodyList;
import net.phys2d.raw.BroadCollisionStrategy;
import net.phys2d.raw.CollisionContext;
import net.phys2d.raw.CollisionEvent;
import net.phys2d.raw.CollisionListener;
import net.phys2d.raw.Contact;

public class CollisionSpace
implements CollisionContext {
    protected BodyList bodies = new BodyList();
    protected LinkedHashMap<String, Arbiter> arbiters = new LinkedHashMap();
    protected LinkedHashMap<String, Arbiter> overlapList = new LinkedHashMap();
    protected BroadCollisionStrategy collisionStrategy;
    protected ArrayList listeners = new ArrayList();
    protected float totalTime;
    private long bitmask = -1L;

    public CollisionSpace(BroadCollisionStrategy strategy) {
        this.collisionStrategy = strategy;
    }

    public void addListener(CollisionListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(CollisionListener listener) {
        this.listeners.remove(listener);
    }

    public void collide(float dt) {
        this.totalTime += dt;
        this.collisionStrategy.collideBodies(this, this.bodies, dt);
    }

    public void clear() {
        this.bodies.clear();
        this.arbiters.clear();
        this.overlapList.clear();
    }

    public void add(Body body) {
        body.setAdded(true);
        this.bodies.add(body);
        body.setCollisionSpace(this);
    }

    public void remove(Body body) {
        body.setAdded(false);
        this.bodies.remove(body);
    }

    public BodyList getBodies() {
        return this.bodies;
    }

    public void setCollisionStrategy(BroadCollisionStrategy strategy) {
        this.collisionStrategy = strategy;
    }

    private void notifyCollision(Body body1, Body body2, ROVector2f point, ROVector2f normal, float depth) {
        if (this.listeners.size() == 0) {
            return;
        }
        CollisionEvent event = new CollisionEvent(this.totalTime, body1, body2, point, normal, depth);
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((CollisionListener)this.listeners.get(i)).collisionOccured(event);
        }
    }

    protected void notifySeparation(Body body1, Body body2) {
        if (this.listeners.isEmpty()) {
            return;
        }
        CollisionEvent event = new CollisionEvent(this.totalTime, body1, body2, null, null, 0.0f);
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((CollisionListener)this.listeners.get(i)).separationOccured(event);
        }
    }

    public void nullifyArbiters(Body b) {
        for (Arbiter arb : this.arbiters.values()) {
            if (!arb.concerns(b)) continue;
            this.arbiters.remove(arb.keyCode());
        }
        for (Arbiter arb : this.overlapList.values()) {
            if (!arb.concerns(b)) continue;
            this.overlapList.remove(arb.keyCode());
        }
    }

    @Override
    public void resolve(BodyList bodyList, float dt) {
        for (int i = 0; i < bodyList.size(); ++i) {
            Body bi = bodyList.get(i);
            if (bi.disabled()) continue;
            for (int j = i + 1; j < bodyList.size(); ++j) {
                Body bj = bodyList.get(j);
                boolean doBitmask = true;
                boolean doOverlap = true;
                if (!bi.getIncludedList().contains(bj)) {
                    if (bi.getBitmask() != 0L && bj.getBitmask() != 0L && (bi.getBitmask() & bj.getBitmask()) != 0L) {
                        doBitmask = false;
                    }
                    if (bi.getOverlapMask() == 0L || bj.getOverlapMask() == 0L || (bi.getOverlapMask() & bj.getOverlapMask()) == 0L) {
                        doOverlap = false;
                    }
                    if (bj.disabled() || !doBitmask && !doOverlap || bi.getExcludedList().contains(bj) || bi.getInvMass() == 0.0f && bj.getInvMass() == 0.0f) {
                        continue;
                    }
                } else {
                    doOverlap = false;
                }
                if (!bi.getShape().getBounds().touches(bi.getPosition().getX(), bi.getPosition().getY(), bj.getShape().getBounds(), bj.getPosition().getX(), bj.getPosition().getY())) {
                    boolean removeOverlap;
                    boolean removePhysics = this.arbiters.remove(String.valueOf(bi.hashCode()) + String.valueOf(bj.hashCode())) != null;
                    boolean bl = removeOverlap = this.overlapList.remove(String.valueOf(bi.hashCode()) + String.valueOf(bj.hashCode())) != null;
                    if (!removePhysics && !removeOverlap) continue;
                    this.notifySeparation(bi, bj);
                    continue;
                }
                Arbiter newArb = new Arbiter(bi, bj);
                newArb.collide(dt);
                if (newArb.getNumContacts() > 0) {
                    if (doOverlap) {
                        if (this.overlapList.containsKey(newArb.keyCode())) continue;
                        Contact c = newArb.getContact(0);
                        this.notifyCollision(bi, bj, c.getPosition(), c.getNormal(), c.getSeparation());
                        this.overlapList.put(newArb.keyCode(), newArb);
                        continue;
                    }
                    if (!doBitmask) continue;
                    bi.collided(bj);
                    bj.collided(bi);
                    if (this.arbiters.containsKey(newArb.keyCode())) {
                        Arbiter arb = this.arbiters.get(newArb.keyCode());
                        arb.update(newArb.getContacts(), newArb.getNumContacts());
                        continue;
                    }
                    Contact c = newArb.getContact(0);
                    this.notifyCollision(bi, bj, c.getPosition(), c.getNormal(), c.getSeparation());
                    this.arbiters.put(newArb.keyCode(), newArb);
                    newArb.init();
                    continue;
                }
                if (doOverlap && this.overlapList.containsKey(newArb.keyCode())) {
                    Body smaller;
                    Body bigger;
                    if (bi.getShape().getBounds().getHeight() * bi.getShape().getBounds().getWidth() > bj.getShape().getBounds().getHeight() * bj.getShape().getBounds().getWidth()) {
                        bigger = bi;
                        smaller = bj;
                    } else {
                        bigger = bj;
                        smaller = bi;
                    }
                    if (bigger.getShape().contains(new Vector2f(smaller.getPosition()), bigger.getPosition(), bigger.getRotation())) continue;
                    this.overlapList.remove(newArb.keyCode());
                    this.notifySeparation(bi, bj);
                    continue;
                }
                if (!doBitmask || !this.arbiters.containsKey(newArb.keyCode())) continue;
                this.arbiters.remove(newArb.keyCode());
                this.overlapList.remove(newArb.keyCode());
                this.notifySeparation(bi, bj);
            }
        }
    }

    public long getBitmask() {
        return this.bitmask;
    }

    public void setBitmask(long bitmask) {
        this.bitmask = bitmask;
    }

    public void addBit(long bitmask) {
        this.bitmask |= bitmask;
    }

    public void removeBit(long bitmask) {
        this.bitmask -= bitmask & this.bitmask;
    }
}

