/*
 * Decompiled with CFR 0.152.
 */
package net.phys2d.raw;

import net.phys2d.math.MathUtil;
import net.phys2d.math.Matrix2f;
import net.phys2d.math.Vector2f;
import net.phys2d.raw.Body;
import net.phys2d.raw.Joint;

public class SlideJoint
implements Joint {
    private static final int COLLIDE_MIN = -1;
    private static final int COLLIDE_NONE = 0;
    private static final int COLLIDE_MAX = 1;
    private Body body1;
    private Body body2;
    private Vector2f anchor1;
    private Vector2f anchor2;
    protected Vector2f r1;
    protected Vector2f r2;
    protected float minDistance;
    protected float maxDistance;
    protected float restitutionConstant;
    private int collideSide;
    private Vector2f ndp;
    private float accumulateImpulse;
    private float minDistance2;
    private float maxDistance2;
    private float K;
    private float restitute;

    public SlideJoint(Body body1, Body body2, Vector2f anchor1, Vector2f anchor2, float minDistance, float maxDistance, float restitution) {
        this.restitutionConstant = restitution;
        this.minDistance2 = minDistance;
        this.maxDistance2 = maxDistance;
        this.minDistance = minDistance * minDistance;
        this.maxDistance = maxDistance * maxDistance;
        this.body1 = body1;
        this.body2 = body2;
        this.anchor1 = anchor1;
        this.anchor2 = anchor2;
    }

    @Override
    public void applyImpulse() {
        if (this.collideSide == 0) {
            return;
        }
        Vector2f dv = new Vector2f(this.body2.getVelocity());
        dv.add(MathUtil.cross(this.body2.getAngularVelocity(), this.r2));
        dv.sub(this.body1.getVelocity());
        dv.sub(MathUtil.cross(this.body1.getAngularVelocity(), this.r1));
        float reln = dv.dot(this.ndp);
        reln = this.restitute - reln;
        float P = reln / this.K;
        float newImpulse = this.collideSide == -1 ? (this.accumulateImpulse + P < 0.0f ? this.accumulateImpulse + P : 0.0f) : (this.accumulateImpulse + P > 0.0f ? this.accumulateImpulse + P : 0.0f);
        P = newImpulse - this.accumulateImpulse;
        this.accumulateImpulse = newImpulse;
        Vector2f impulse = new Vector2f(this.ndp);
        impulse.scale(P);
        if (!this.body1.isStatic()) {
            Vector2f accum1 = new Vector2f(impulse);
            accum1.scale(this.body1.getInvMass());
            this.body1.adjustVelocity(accum1);
            this.body1.adjustAngularVelocity(this.body1.getInvI() * MathUtil.cross(this.r1, impulse));
        }
        if (!this.body2.isStatic()) {
            Vector2f accum2 = new Vector2f(impulse);
            accum2.scale(-this.body2.getInvMass());
            this.body2.adjustVelocity(accum2);
            this.body2.adjustAngularVelocity(-(this.body2.getInvI() * MathUtil.cross(this.r2, impulse)));
        }
    }

    @Override
    public Body getBody1() {
        return this.body1;
    }

    @Override
    public Body getBody2() {
        return this.body2;
    }

    @Override
    public void preStep(float invDT) {
        float biasFactor = 0.01f;
        float biasImpulse = 0.0f;
        Matrix2f rot1 = new Matrix2f(this.body1.getRotation());
        Matrix2f rot2 = new Matrix2f(this.body2.getRotation());
        this.r1 = MathUtil.mul(rot1, this.anchor1);
        this.r2 = MathUtil.mul(rot2, this.anchor2);
        Vector2f p1 = new Vector2f(this.body1.getPosition());
        p1.add(this.r1);
        Vector2f p2 = new Vector2f(this.body2.getPosition());
        p2.add(this.r2);
        Vector2f dp = new Vector2f(p2);
        dp.sub(p1);
        Vector2f dv = new Vector2f(this.body2.getVelocity());
        dv.add(MathUtil.cross(this.body2.getAngularVelocity(), this.r2));
        dv.sub(this.body1.getVelocity());
        dv.sub(MathUtil.cross(this.body1.getAngularVelocity(), this.r1));
        this.ndp = new Vector2f(dp);
        this.ndp.normalise();
        this.restitute = -this.restitutionConstant * dv.dot(this.ndp);
        Vector2f v1 = new Vector2f(this.ndp);
        v1.scale(-this.body2.getInvMass() - this.body1.getInvMass());
        Vector2f v2 = MathUtil.cross(MathUtil.cross(this.r2, this.ndp), this.r2);
        v2.scale(-this.body2.getInvI());
        Vector2f v3 = MathUtil.cross(MathUtil.cross(this.r1, this.ndp), this.r1);
        v3.scale(-this.body1.getInvI());
        Vector2f K1 = new Vector2f(v1);
        K1.add(v2);
        K1.add(v3);
        this.K = K1.dot(this.ndp);
        float length = dp.lengthSquared();
        if (length < this.minDistance) {
            if (this.collideSide != -1) {
                this.accumulateImpulse = 0.0f;
            }
            this.collideSide = -1;
            biasImpulse = -biasFactor * (length - this.minDistance);
            if (this.restitute < 0.0f) {
                this.restitute = 0.0f;
            }
        } else if (length > this.maxDistance) {
            if (this.collideSide != 1) {
                this.accumulateImpulse = 0.0f;
            }
            this.collideSide = 1;
            biasImpulse = -biasFactor * (length - this.maxDistance);
            if (this.restitute > 0.0f) {
                this.restitute = 0.0f;
            }
        } else {
            this.collideSide = 0;
            this.accumulateImpulse = 0.0f;
        }
        this.restitute += biasImpulse;
        Vector2f impulse = new Vector2f(this.ndp);
        impulse.scale(this.accumulateImpulse);
        if (!this.body1.isStatic()) {
            Vector2f accum1 = new Vector2f(impulse);
            accum1.scale(this.body1.getInvMass());
            this.body1.adjustVelocity(accum1);
            this.body1.adjustAngularVelocity(this.body1.getInvI() * MathUtil.cross(this.r1, impulse));
        }
        if (!this.body2.isStatic()) {
            Vector2f accum2 = new Vector2f(impulse);
            accum2.scale(-this.body2.getInvMass());
            this.body2.adjustVelocity(accum2);
            this.body2.adjustAngularVelocity(-(this.body2.getInvI() * MathUtil.cross(this.r2, impulse)));
        }
    }

    public float getMinDistance() {
        return this.minDistance2;
    }

    public void setMinDistance(float minDistance) {
        this.minDistance = minDistance;
    }

    public float getMaxDistance() {
        return this.maxDistance2;
    }

    public void setMaxDistance(float maxDistance) {
        this.maxDistance = maxDistance;
    }

    public float getRestitutionConstant() {
        return this.restitutionConstant;
    }

    public void setRestitutionConstant(float restitutionConstant) {
        this.restitutionConstant = restitutionConstant;
    }

    @Override
    public void setRelaxation(float relaxation) {
    }

    public Vector2f getAnchor1() {
        return this.anchor1;
    }

    public Vector2f getAnchor2() {
        return this.anchor2;
    }
}

