/*
 * Decompiled with CFR 0.152.
 */
package net.phys2d.raw.collide;

import net.phys2d.math.MathUtil;
import net.phys2d.math.Vector2f;
import net.phys2d.raw.Body;
import net.phys2d.raw.Contact;
import net.phys2d.raw.collide.Collider;
import net.phys2d.raw.collide.FeaturePair;
import net.phys2d.raw.shapes.Box;
import net.phys2d.raw.shapes.Circle;
import net.phys2d.raw.shapes.Line;

public strictfp class BoxCircleCollider
implements Collider {
    @Override
    public int collide(Contact[] contacts, Body boxBody, Body circleBody) {
        float x1 = boxBody.getPosition().getX();
        float y1 = boxBody.getPosition().getY();
        float x2 = circleBody.getPosition().getX();
        float y2 = circleBody.getPosition().getY();
        boolean touches = boxBody.getShape().getBounds().touches(x1, y1, circleBody.getShape().getBounds(), x2, y2);
        if (!touches) {
            return 0;
        }
        Box box = (Box)boxBody.getShape();
        Circle circle = (Circle)circleBody.getShape();
        Vector2f[] pts = box.getPoints(boxBody.getPosition(), boxBody.getRotation());
        Line[] lines = new Line[]{new Line(pts[0], pts[1]), new Line(pts[1], pts[2]), new Line(pts[2], pts[3]), new Line(pts[3], pts[0])};
        float r2 = circle.getRadius() * circle.getRadius();
        int closest = -1;
        float closestDistance = Float.MAX_VALUE;
        for (int i = 0; i < 4; ++i) {
            float dis = lines[i].distanceSquared(circleBody.getPosition());
            if (!(dis < r2) || !(closestDistance > dis)) continue;
            closestDistance = dis;
            closest = i;
        }
        if (closest > -1) {
            float dis = (float)Math.sqrt(closestDistance);
            contacts[0].setSeparation(dis - circle.getRadius());
            Vector2f contactPoint = new Vector2f();
            lines[closest].getClosestPoint(circleBody.getPosition(), contactPoint);
            Vector2f normal = MathUtil.sub(circleBody.getPosition(), contactPoint);
            normal.normalise();
            contacts[0].setNormal(normal);
            contacts[0].setPosition(contactPoint);
            contacts[0].setFeature(new FeaturePair());
            return 1;
        }
        return 0;
    }
}

