/*
 * Decompiled with CFR 0.152.
 */
package plugins.fab.MiceProfiler;

import icy.canvas.IcyCanvas;
import icy.canvas.IcyCanvas2D;
import icy.gui.util.GuiUtil;
import icy.image.IcyBufferedImage;
import icy.main.Icy;
import icy.painter.Painter;
import icy.roi.ROI;
import icy.roi.ROI2D;
import icy.sequence.Sequence;
import icy.type.DataType;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import net.phys2d.math.ROVector2f;
import net.phys2d.math.Vector2f;
import net.phys2d.raw.Body;
import net.phys2d.raw.DistanceJoint;
import net.phys2d.raw.FixedJoint;
import net.phys2d.raw.SlideJoint;
import net.phys2d.raw.World;
import net.phys2d.raw.shapes.Box;
import net.phys2d.raw.shapes.Circle;
import net.phys2d.raw.shapes.Polygon;
import net.phys2d.raw.shapes.Shape;
import net.phys2d.raw.strategies.QuadSpaceStrategy;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import plugins.fab.MiceProfiler.MAnchor2D;
import plugins.fab.MiceProfiler.XMLTools;

public class PhyMouse
implements ActionListener,
ChangeListener {
    public World world = null;
    ArrayList<Body> bodyList = new ArrayList();
    ArrayList<DistanceJoint> distanceJointList = new ArrayList();
    ArrayList<SlideJoint> slideJointList = new ArrayList();
    public int currentFrame = 0;
    final float MASSE = 1.0f;
    public Color color = new Color((float)Math.random(), (float)Math.random(), (float)Math.random());
    float SCALE = 0.22f;
    float SCALERAY = 1.0f;
    float GRADIENT_ENERGY_MULTIPLICATOR = 10000.0f;
    float BINARY_ENERGY_MULTIPLICATOR = 10000.0f;
    float EAR_ENERGY_MULTIPLICATOR = 10.0f;
    JPanel panel = new JPanel();
    JCheckBox displayForceCheckBox = new JCheckBox("Forces", false);
    JCheckBox displayEnergyAreaCheckBox = new JCheckBox("Energy Area", false);
    JCheckBox displayBodyCenterCheckBox = new JCheckBox("Body Center", false);
    JCheckBox displayBodyShapeCheckBox = new JCheckBox("Body Shape", true);
    JCheckBox displayGlobalSplineCheckBox = new JCheckBox("Global Spline", true);
    JCheckBox displaySlideJointCheckBox = new JCheckBox("Slide Joint", true);
    JCheckBox displayDistanceJointCheckBox = new JCheckBox("Distance Joint", true);
    JCheckBox displayBinaryMapCheckBox = new JCheckBox("Binary Map", false);
    JCheckBox displayGradientMapCheckBox = new JCheckBox("Gradient Map", false);
    JCheckBox displayMemoryCheckBox = new JCheckBox("Track Memory", true);
    JCheckBox pauseTrackAllBox = new JCheckBox("pause track all", false);
    JCheckBox displayStepBox = new JCheckBox("display step", false);
    JTextField scaleTextField = new JTextField();
    public int SEUIL_BINARY_MAP = 30;
    public int SEUIL_EDGE_MAP = 32;
    JSpinner binaryThresholdSpinner = new JSpinner(new SpinnerNumberModel(this.SEUIL_BINARY_MAP, 0, 255, 10));
    JCheckBox useMotionPredictionCheckBox = new JCheckBox("Use motion prediction", false);
    JLabel nbTotalIterationLabel = new JLabel("nb total iteration");
    JButton resultButton = new JButton("give me the results");
    HashMap<Integer, ArrayList<Body>> bodyHash = new HashMap();
    JButton displayScaleBinaryButton = new JButton("display binary scales");
    JButton computeATestAnchorVectorMapButton = new JButton("compute test anchor");
    int nbTotalIteration = 0;
    boolean motion_prediction_state = false;
    HashMap<Integer, MouseView> mouse1view = new HashMap();
    HashMap<Integer, MouseView> mouse2view = new HashMap();
    ArrayList<Mouse> mouseList = new ArrayList();
    ArrayList<Scale> binaryScaleMap = null;
    IcyBufferedImage binaryMap = null;
    BufferedImage earMap = null;
    IcyBufferedImage edgeMap = null;
    Sequence sequence = null;
    HashMap<Integer, MouseInfoRecord> mouseARecord = new HashMap();
    HashMap<Integer, MouseInfoRecord> mouseBRecord = new HashMap();
    boolean reverseThresholdBoolean = false;
    MAnchor2D[] headForcedPosition = new MAnchor2D[2];

    public PhyMouse(Sequence sequence) {
        this.sequence = sequence;
        if (this.world == null) {
            this.world = new World(new Vector2f(0.0f, 0.0f), 10, new QuadSpaceStrategy(20, 5));
        }
        this.world.clear();
        this.world.setGravity(0.0f, 0.0f);
        this.panel = GuiUtil.generatePanel();
        this.panel.add(GuiUtil.besidesPanel((Component[])new Component[]{this.displayBinaryMapCheckBox, this.displayGradientMapCheckBox}));
        this.panel.add(GuiUtil.besidesPanel((Component[])new Component[]{this.displayForceCheckBox, this.displayEnergyAreaCheckBox}));
        this.panel.add(GuiUtil.besidesPanel((Component[])new Component[]{this.displayBodyCenterCheckBox, this.displayBodyShapeCheckBox}));
        this.panel.add(GuiUtil.besidesPanel((Component[])new Component[]{this.displayGlobalSplineCheckBox, this.displaySlideJointCheckBox}));
        this.panel.add(GuiUtil.besidesPanel((Component[])new Component[]{this.displayDistanceJointCheckBox, this.displayMemoryCheckBox}));
        this.panel.add(GuiUtil.besidesPanel((Component[])new Component[]{this.useMotionPredictionCheckBox}));
        this.panel.add(GuiUtil.besidesPanel((Component[])new Component[]{new JLabel("Binary Threshold:"), this.binaryThresholdSpinner}));
        this.scaleTextField.setText("" + this.SCALE);
        JLabel mouseModelScaleLabel = new JLabel("Mouse Model Scale:");
        mouseModelScaleLabel.setToolTipText("Scale of the model.");
        this.panel.add(GuiUtil.besidesPanel((Component[])new Component[]{mouseModelScaleLabel, this.scaleTextField}));
        this.binaryThresholdSpinner.addChangeListener(this);
        this.resultButton.addActionListener(this);
        this.computeATestAnchorVectorMapButton.addActionListener(this);
        this.displayScaleBinaryButton.addActionListener(this);
        this.displayForceCheckBox.addActionListener(this);
        this.displayEnergyAreaCheckBox.addActionListener(this);
        this.displayBodyCenterCheckBox.addActionListener(this);
        this.displayBodyShapeCheckBox.addActionListener(this);
        this.displayGlobalSplineCheckBox.addActionListener(this);
        this.displaySlideJointCheckBox.addActionListener(this);
        this.displayDistanceJointCheckBox.addActionListener(this);
        this.displayBinaryMapCheckBox.addActionListener(this);
        this.displayGradientMapCheckBox.addActionListener(this);
    }

    public void setScaleFieldEnable(boolean enable) {
        this.scaleTextField.setEnabled(enable);
    }

    public void generateMouse(float x, float y, float alpha) {
        this.SCALE = Float.parseFloat(this.scaleTextField.getText());
        this.mouseList.add(new Mouse(x, y, alpha));
    }

    Body copyBody(Body source) {
        Body target = null;
        if (source.getShape() instanceof Box) {
            Box box = (Box)source.getShape();
            target = new Body("", new Box(box.getSize().getX(), box.getSize().getY()), source.getMass());
        }
        if (source.getShape() instanceof Circle) {
            Circle circle = (Circle)source.getShape();
            target = new Body("", new Circle(circle.getRadius()), source.getMass());
        }
        target.setDamping(source.getDamping());
        target.setPosition(source.getPosition().getX(), source.getPosition().getY());
        target.setGravityEffected(false);
        target.setRotation(source.getRotation());
        target.adjustVelocity(new Vector2f(source.getVelocity().getX(), source.getVelocity().getY()));
        EnergyInfo energyInfo = (EnergyInfo)source.getUserData();
        target.setUserData(energyInfo);
        return target;
    }

    public Body generateBody2(BodyType bodyType, float mass, float ray, float width, float height, EnergyMap energyMap, boolean excludeFromOtherMouseContact, boolean excludeFromAttractiveMapOwner) {
        Body body = null;
        if (bodyType == BodyType.BOX) {
            body = new Body("", new Box(width * this.SCALE, height * this.SCALE), mass);
        }
        if (bodyType == BodyType.CIRCLE) {
            body = new Body("", new Circle(width * this.SCALE), mass);
        }
        body.setUserData(new EnergyInfo(ray * this.SCALE * this.SCALERAY, energyMap, excludeFromOtherMouseContact, excludeFromAttractiveMapOwner));
        body.setDamping(0.1f);
        body.setGravityEffected(false);
        this.bodyList.add(body);
        this.world.add(body);
        body.setCanRest(true);
        return body;
    }

    public void computeForcesMap(IcyBufferedImage imageSource) {
        ROI2D clipROI = null;
        Sequence activeSequence = Icy.getMainInterface().getFocusedSequence();
        if (activeSequence != null) {
            for (ROI roi : activeSequence.getROIs()) {
                clipROI = (ROI2D)roi;
            }
        }
        int imageSourceWidth = imageSource.getWidth();
        int imageSourceHeight = imageSource.getHeight();
        if (this.binaryMap == null) {
            this.binaryMap = new IcyBufferedImage(imageSourceWidth, imageSourceHeight, 1, DataType.UBYTE);
        }
        if (this.binaryMap.getWidth() != imageSourceWidth || this.binaryMap.getHeight() != imageSourceHeight) {
            this.binaryMap = new IcyBufferedImage(imageSourceWidth, imageSourceHeight, 1, DataType.UBYTE);
        }
        byte[] binaryMapDataBuffer = this.binaryMap.getDataXYAsByte(0);
        byte[] imageSourceDataBuffer = imageSource.getDataXYAsByte(1);
        for (int x = 0; x < imageSourceWidth; ++x) {
            for (int y = 0; y < imageSourceHeight; ++y) {
                int val = imageSourceDataBuffer[x + y * imageSourceWidth] & 0xFF;
                val = val < this.SEUIL_BINARY_MAP ? 255 : 0;
                if (this.reverseThresholdBoolean) {
                    val = val == 255 ? 0 : 255;
                }
                if (clipROI != null && !clipROI.contains((double)x, (double)y)) {
                    val = 0;
                }
                binaryMapDataBuffer[x + y * imageSourceWidth] = (byte)val;
            }
        }
        if (this.edgeMap == null) {
            this.edgeMap = new IcyBufferedImage(imageSourceWidth, imageSourceHeight, 1, DataType.UBYTE);
        }
        int maxWidth = this.binaryMap.getWidth() - 1;
        int maxHeight = this.binaryMap.getHeight() - 1;
        byte[] edgeMapDataBuffer = this.edgeMap.getDataXYAsByte(0);
        for (int x = 1; x < maxWidth; ++x) {
            for (int y = 1; y < maxHeight; ++y) {
                int val1 = binaryMapDataBuffer[x + y * imageSourceWidth] & 0xFF;
                int val2 = binaryMapDataBuffer[x + 1 + y * imageSourceWidth] & 0xFF;
                int val4 = binaryMapDataBuffer[x + (y + 1) * imageSourceWidth] & 0xFF;
                int val = Math.abs(val1 - val2) + Math.abs(val1 - val4);
                val = val > this.SEUIL_EDGE_MAP ? 255 : 0;
                edgeMapDataBuffer[x + y * imageSourceWidth] = (byte)val;
            }
        }
    }

    private void drawCircleInMaskMap(int centreX, int centreY, int ray, IcyBufferedImage maskImage, boolean set255) {
        int val = 0;
        if (set255) {
            val = -1;
        }
        byte[] maskMapData = maskImage.getDataXYAsByte(0);
        int raySquare = ray * ray;
        int width = maskImage.getWidth();
        int height = maskImage.getHeight();
        for (int y = -ray; y <= ray; ++y) {
            for (int x = -ray; x <= ray; ++x) {
                if (x * x + y * y > raySquare) continue;
                int xx = centreX + x;
                int yy = centreY + y;
                if (xx < 0 || yy < 0 || xx >= width || yy >= height) continue;
                maskMapData[xx + yy * width] = val;
            }
        }
    }

    public void computeForces() {
        MAnchor2D pos;
        if (this.headForcedPosition[0] != null) {
            pos = this.headForcedPosition[0];
            this.mouseList.get((int)0).headBody.setPosition((float)pos.getX(), (float)pos.getY());
        }
        if (this.headForcedPosition[1] != null) {
            pos = this.headForcedPosition[1];
            this.mouseList.get((int)1).headBody.setPosition((float)pos.getX(), (float)pos.getY());
        }
        IcyBufferedImage maskMap = new IcyBufferedImage(this.binaryMap.getWidth(), this.binaryMap.getHeight(), 1, 0);
        byte[] maskMapData = maskMap.getDataXYAsByte(0);
        int maskMapWidth = maskMap.getWidth();
        for (Body body : this.bodyList) {
            int y;
            int x;
            int length = maskMapData.length;
            for (int i = 0; i < length; ++i) {
                maskMapData[i] = 0;
            }
            EnergyInfo energyInfo = (EnergyInfo)body.getUserData();
            this.drawCircleInMaskMap((int)body.getLastPosition().getX(), (int)body.getLastPosition().getY(), (int)energyInfo.ray, maskMap, true);
            for (Body body2 : this.bodyList) {
                if (body == body2) continue;
                EnergyInfo energyInfo2 = (EnergyInfo)body2.getUserData();
                if (energyInfo.energyMap != energyInfo2.energyMap || !energyInfo2.excludeFromAttractiveMapOwner) continue;
                this.drawCircleInMaskMap((int)body2.getLastPosition().getX(), (int)body2.getLastPosition().getY(), (int)energyInfo2.ray, maskMap, false);
            }
            if (energyInfo.energyMap == EnergyMap.BINARY_MOUSE) {
                float vx = 0.0f;
                float vy = 0.0f;
                float count = 0.0f;
                int maxX = (int)(body.getLastPosition().getX() + energyInfo.ray);
                int maxY = (int)(body.getLastPosition().getY() + energyInfo.ray);
                int imageWidth = this.binaryMap.getWidth();
                int imageHeight = this.binaryMap.getHeight();
                byte[] binaryMapDataBuffer = this.binaryMap.getDataXYAsByte(0);
                for (x = (int)(body.getLastPosition().getX() - energyInfo.ray); x < maxX; ++x) {
                    for (y = (int)(body.getLastPosition().getY() - energyInfo.ray); y < maxY; ++y) {
                        if (x >= imageWidth || y >= imageHeight || x < 0 || y < 0) continue;
                        float factor = 0.5f;
                        if (maskMapData[x + y * maskMapWidth] != 0) {
                            factor = 1.0f;
                        }
                        if (maskMapData[x + y * maskMapWidth] == 0) continue;
                        if ((binaryMapDataBuffer[x + y * imageWidth] & 0xFF) == 255) {
                            vx += ((float)x - body.getLastPosition().getX()) * factor;
                            vy += ((float)y - body.getLastPosition().getY()) * factor;
                        }
                        count += 1.0f;
                    }
                }
                if (count > 0.0f) {
                    vx /= count;
                    vy /= count;
                }
                energyInfo.vx = vx *= this.BINARY_ENERGY_MULTIPLICATOR;
                energyInfo.vy = vy *= this.BINARY_ENERGY_MULTIPLICATOR;
                body.setForce(vx, vy);
            }
            if (energyInfo.energyMap != EnergyMap.GRADIENT_MAP) continue;
            float vx = 0.0f;
            float vy = 0.0f;
            float count = 0.0f;
            int imageWidth = this.edgeMap.getWidth();
            int imageHeight = this.edgeMap.getHeight();
            byte[] edgeMapDataBuffer = this.edgeMap.getDataXYAsByte(0);
            int maxX = (int)(body.getLastPosition().getX() + energyInfo.ray);
            int maxY = (int)(body.getLastPosition().getY() + energyInfo.ray);
            for (x = (int)(body.getLastPosition().getX() - energyInfo.ray); x < maxX; ++x) {
                for (y = (int)(body.getLastPosition().getY() - energyInfo.ray); y < maxY; ++y) {
                    if (x >= imageWidth || y >= imageHeight || x < 0 || y < 0 || maskMapData[x + y * maskMapWidth] == 0) continue;
                    if ((edgeMapDataBuffer[x + y * imageWidth] & 0xFF) != 0) {
                        vx += (float)x - body.getLastPosition().getX();
                        vy += (float)y - body.getLastPosition().getY();
                    }
                    count += 1.0f;
                }
            }
            if (count > 0.0f) {
                vx /= count;
                vy /= count;
            }
            energyInfo.vx = vx *= this.GRADIENT_ENERGY_MULTIPLICATOR;
            energyInfo.vy = vy *= this.GRADIENT_ENERGY_MULTIPLICATOR;
            body.setForce(vx, vy);
        }
        this.headForcedPosition[0] = null;
        this.headForcedPosition[1] = null;
    }

    public void swapIdentityRecordFromTToTheEnd(int time) {
        int maxT = 0;
        for (int i : this.mouseARecord.keySet()) {
            if (i <= maxT) continue;
            maxT = i;
        }
        for (int i : this.mouseBRecord.keySet()) {
            if (i <= maxT) continue;
            maxT = i;
        }
        for (int t = time; t <= maxT; ++t) {
            MouseInfoRecord recA = this.mouseARecord.get(t);
            MouseInfoRecord recB = this.mouseBRecord.get(t);
            this.mouseARecord.put(t, recB);
            this.mouseBRecord.put(t, recA);
        }
    }

    public void recordMousePosition(int currentFrame) {
        MouseInfoRecord mouseAInfo = new MouseInfoRecord();
        mouseAInfo.headPosition = new Point2D.Float(this.mouseList.get((int)0).headBody.getPosition().getX(), this.mouseList.get((int)0).headBody.getPosition().getY());
        mouseAInfo.bodyPosition = new Point2D.Float(this.mouseList.get((int)0).tommyBody.getPosition().getX(), this.mouseList.get((int)0).tommyBody.getPosition().getY());
        mouseAInfo.tailPosition = new Point2D.Float(this.mouseList.get((int)0).tail.getPosition().getX(), this.mouseList.get((int)0).tail.getPosition().getY());
        mouseAInfo.neckPosition = new Point2D.Float(this.mouseList.get((int)0).neckAttachBody.getPosition().getX(), this.mouseList.get((int)0).neckAttachBody.getPosition().getY());
        this.mouseARecord.put(currentFrame, mouseAInfo);
        if (this.mouseList.size() > 1) {
            MouseInfoRecord mouseBInfo = new MouseInfoRecord();
            mouseBInfo.headPosition = new Point2D.Float(this.mouseList.get((int)1).headBody.getPosition().getX(), this.mouseList.get((int)1).headBody.getPosition().getY());
            mouseBInfo.bodyPosition = new Point2D.Float(this.mouseList.get((int)1).tommyBody.getPosition().getX(), this.mouseList.get((int)1).tommyBody.getPosition().getY());
            mouseBInfo.tailPosition = new Point2D.Float(this.mouseList.get((int)1).tail.getPosition().getX(), this.mouseList.get((int)1).tail.getPosition().getY());
            mouseBInfo.neckPosition = new Point2D.Float(this.mouseList.get((int)1).neckAttachBody.getPosition().getX(), this.mouseList.get((int)1).neckAttachBody.getPosition().getY());
            this.mouseBRecord.put(currentFrame, mouseBInfo);
        }
    }

    public void worldStep(int currentFrame) {
        this.motion_prediction_state = false;
        this.world.step();
        ++this.nbTotalIteration;
        while (this.pauseTrackAllBox.isSelected()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.recordMousePosition(currentFrame);
        if (this.displayStepBox.isSelected()) {
            this.sequence.painterChanged(null);
        }
    }

    public void applyMotionPrediction() {
        if (!this.useMotionPredictionCheckBox.isSelected()) {
            return;
        }
        this.motion_prediction_state = true;
        for (Mouse mouse : this.mouseList) {
            for (Body body : mouse.bodyList) {
                EnergyInfo eInfo = (EnergyInfo)body.getUserData();
                Vector2f vCopy = new Vector2f(body.getLastPosition().getX(), body.getLastPosition().getY());
                body.setForce(0.0f, 0.0f);
                eInfo.previousPositionList.add(vCopy);
                if (eInfo.previousPositionList.size() <= 1) continue;
                Vector2f newVelocity = new Vector2f(10.0f * (eInfo.previousPositionList.get(1).getX() - eInfo.previousPositionList.get(0).getX()), 10.0f * (eInfo.previousPositionList.get(1).getY() - eInfo.previousPositionList.get(0).getY()));
                body.adjustVelocity(newVelocity);
                eInfo.previousPositionList.remove(eInfo.previousPositionList.get(0));
            }
        }
        for (int i = 0; i < 6; ++i) {
            while (this.pauseTrackAllBox.isSelected()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            this.world.step();
            if (!this.displayStepBox.isSelected()) continue;
        }
        for (Body body : this.bodyList) {
            body.adjustVelocity(new Vector2f(0.0f, 0.0f));
        }
    }

    public SlideJoint generateSlideJoint(Body bodyA, Body bodyB, float min, float max) {
        SlideJoint slideJoint = new SlideJoint(bodyA, bodyB, new Vector2f(0.0f, 0.0f), new Vector2f(0.0f, 0.0f), min, max, 0.0f);
        this.slideJointList.add(slideJoint);
        this.world.add(slideJoint);
        return slideJoint;
    }

    public DistanceJoint generateDistanceJoint(Body bodyA, Body bodyB) {
        Point2D.Float pointA = new Point2D.Float(bodyA.getLastPosition().getX(), bodyA.getLastPosition().getY());
        Point2D.Float pointB = new Point2D.Float(bodyB.getLastPosition().getX(), bodyB.getLastPosition().getY());
        float distance = (float)pointA.distance(pointB);
        DistanceJoint distanceJoint = new DistanceJoint(bodyA, bodyB, new Vector2f(0.0f, 0.0f), new Vector2f(0.0f, 0.0f), distance);
        this.distanceJointList.add(distanceJoint);
        this.world.add(distanceJoint);
        return distanceJoint;
    }

    public DistanceJoint generateDistanceJoint(Body bodyA, Body bodyB, float distance) {
        DistanceJoint distanceJoint = new DistanceJoint(bodyA, bodyB, new Vector2f(0.0f, 0.0f), new Vector2f(0.0f, 0.0f), distance);
        this.distanceJointList.add(distanceJoint);
        this.world.add(distanceJoint);
        return distanceJoint;
    }

    public void paint(Graphics g, IcyCanvas canvas) {
        Line2D.Float line;
        if (!(canvas instanceof IcyCanvas2D)) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setStroke(new BasicStroke(0.3f));
        g2.setComposite(AlphaComposite.getInstance(3, 0.5f));
        try {
            if (this.displayBinaryMapCheckBox.isSelected() && this.binaryMap != null) {
                g2.drawImage(this.binaryMap.convertToBufferedImage(null), null, 0, 0);
            }
            if (this.displayGradientMapCheckBox.isSelected() && this.edgeMap != null) {
                g2.drawImage(this.edgeMap.convertToBufferedImage(null), null, 0, 0);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        g2.setComposite(AlphaComposite.getInstance(3, 1.0f));
        if (this.displaySlideJointCheckBox.isSelected()) {
            g2.setColor(Color.orange);
            for (SlideJoint slideJoint : this.slideJointList) {
                line = new Line2D.Float(slideJoint.getBody1().getLastPosition().getX(), slideJoint.getBody1().getLastPosition().getY(), slideJoint.getBody2().getLastPosition().getX(), slideJoint.getBody2().getLastPosition().getY());
                g2.draw(line);
            }
        }
        if (this.displayDistanceJointCheckBox.isSelected()) {
            g2.setColor(Color.YELLOW);
            for (DistanceJoint distanceJoint : this.distanceJointList) {
                line = new Line2D.Float(distanceJoint.getBody1().getLastPosition().getX(), distanceJoint.getBody1().getLastPosition().getY(), distanceJoint.getBody2().getLastPosition().getX(), distanceJoint.getBody2().getLastPosition().getY());
                g2.draw(line);
            }
        }
        if (this.displayBodyCenterCheckBox.isSelected()) {
            g2.setColor(Color.blue);
            for (Body body : this.bodyList) {
                Ellipse2D.Float ellipse = new Ellipse2D.Float(body.getLastPosition().getX() - 1.5f, body.getLastPosition().getY() - 1.5f, 3.0f, 3.0f);
                g2.draw(ellipse);
            }
        }
        if (this.displayBodyShapeCheckBox.isSelected()) {
            g2.setColor(Color.white);
            for (Body body : this.bodyList) {
                AffineTransform transform;
                Shape shape = body.getShape();
                if (shape != null && shape instanceof Polygon) {
                    ROVector2f[] vert = ((Polygon)shape).getVertices();
                    for (int i = 0; i < vert.length - 1; ++i) {
                        AffineTransform transform2 = g2.getTransform();
                        g2.translate(body.getLastPosition().getX(), body.getLastPosition().getY());
                        g2.rotate(body.getRotation());
                        Line2D.Float line2D = new Line2D.Float(vert[i].getX(), vert[i].getY(), vert[i + 1].getX(), vert[i + 1].getY());
                        g2.draw(line2D);
                        g2.setTransform(transform2);
                    }
                    transform = g2.getTransform();
                    g2.translate(body.getLastPosition().getX(), body.getLastPosition().getY());
                    g2.rotate(body.getRotation());
                    Line2D.Float line2D = new Line2D.Float(vert[0].getX(), vert[0].getY(), vert[vert.length - 1].getX(), vert[vert.length - 1].getY());
                    g2.draw(line2D);
                    g2.setTransform(transform);
                }
                if (shape instanceof Box) {
                    Box maBox = (Box)shape;
                    transform = g2.getTransform();
                    g2.translate(body.getLastPosition().getX(), body.getLastPosition().getY());
                    g2.rotate(body.getRotation());
                    Rectangle2D.Float rect2D = new Rectangle2D.Float(-maBox.getSize().getX() / 2.0f, -maBox.getSize().getY() / 2.0f, maBox.getSize().getX(), maBox.getSize().getY());
                    g2.draw(rect2D);
                    g2.setTransform(transform);
                }
                if (!(shape instanceof Circle)) continue;
                Circle maCircle = (Circle)shape;
                transform = g2.getTransform();
                g2.translate(body.getLastPosition().getX(), body.getLastPosition().getY());
                g2.rotate(body.getRotation());
                Ellipse2D.Double ellipse2D = new Ellipse2D.Double(-maCircle.getRadius(), -maCircle.getRadius(), maCircle.getRadius() * 2.0f, maCircle.getRadius() * 2.0f);
                g2.draw(ellipse2D);
                g2.setTransform(transform);
            }
        }
        for (Body body : this.bodyList) {
            g2.setStroke(new BasicStroke(0.5f));
            EnergyInfo energyInfo = (EnergyInfo)body.getUserData();
            Color color = Color.black;
            if (energyInfo.energyMap == EnergyMap.BINARY_MOUSE) {
                color = Color.green;
            }
            if (energyInfo.energyMap == EnergyMap.BINARY_EAR) {
                color = Color.red;
            }
            if (energyInfo.energyMap == EnergyMap.GRADIENT_MAP) {
                color = Color.pink;
            }
            g2.setColor(color);
            if (this.displayEnergyAreaCheckBox.isSelected() && energyInfo.energyMap != EnergyMap.NO_ENERGY) {
                Ellipse2D.Float ellipse = new Ellipse2D.Float(body.getLastPosition().getX() - energyInfo.ray, body.getLastPosition().getY() - energyInfo.ray, energyInfo.ray * 2.0f + 1.0f, energyInfo.ray * 2.0f + 1.0f);
                g2.draw(ellipse);
            }
            boolean displayForce = this.displayForceCheckBox.isSelected();
            if (this.displayBinaryMapCheckBox.isSelected() && energyInfo.energyMap != EnergyMap.BINARY_MOUSE) {
                displayForce = false;
            }
            if (this.displayGradientMapCheckBox.isSelected() && energyInfo.energyMap != EnergyMap.GRADIENT_MAP) {
                displayForce = false;
            }
            if (!displayForce) continue;
            Line2D.Float energyVector = new Line2D.Float(body.getLastPosition().getX(), body.getLastPosition().getY(), body.getLastPosition().getX() + energyInfo.vx, body.getLastPosition().getY() + energyInfo.vy);
            g2.draw(energyVector);
        }
        if (this.displayGlobalSplineCheckBox.isSelected()) {
            g2.setColor(Color.blue);
            for (Mouse mouse : this.mouseList) {
            }
        }
        g2.setColor(Color.blue);
        if (this.motion_prediction_state) {
            g2.setColor(Color.white);
            g2.drawString("Motion prediction (movie slowed)", 20, 200);
        }
        g2.setColor(Color.white);
        if (this.displayMemoryCheckBox.isSelected()) {
            MouseInfoRecord mouseBInfo;
            Ellipse2D.Double ellipseTail;
            Ellipse2D.Double ellipseBody;
            MouseInfoRecord mouseAInfo = this.mouseARecord.get(this.currentFrame);
            if (mouseAInfo != null) {
                g2.setColor(Color.red);
                Ellipse2D.Double double_ = new Ellipse2D.Double(mouseAInfo.headPosition.getX() - (double)(22.0f * this.SCALE), mouseAInfo.headPosition.getY() - (double)(22.0f * this.SCALE), 45.0f * this.SCALE, 45.0f * this.SCALE);
                ellipseBody = new Ellipse2D.Double(mouseAInfo.bodyPosition.getX() - (double)(45.0f * this.SCALE), mouseAInfo.bodyPosition.getY() - (double)(45.0f * this.SCALE), 90.0f * this.SCALE, 90.0f * this.SCALE);
                ellipseTail = new Ellipse2D.Double(mouseAInfo.tailPosition.getX() - (double)(10.0f * this.SCALE), mouseAInfo.tailPosition.getY() - (double)(10.0f * this.SCALE), 20.0f * this.SCALE, 20.0f * this.SCALE);
                g2.draw(double_);
                g2.draw(ellipseBody);
                g2.draw(ellipseTail);
            }
            if ((mouseBInfo = this.mouseBRecord.get(this.currentFrame)) != null) {
                g2.setColor(Color.green);
                Ellipse2D.Double double_ = new Ellipse2D.Double(mouseBInfo.headPosition.getX() - (double)(22.0f * this.SCALE), mouseBInfo.headPosition.getY() - (double)(22.0f * this.SCALE), 45.0f * this.SCALE, 45.0f * this.SCALE);
                ellipseBody = new Ellipse2D.Double(mouseBInfo.bodyPosition.getX() - (double)(45.0f * this.SCALE), mouseBInfo.bodyPosition.getY() - (double)(45.0f * this.SCALE), 90.0f * this.SCALE, 90.0f * this.SCALE);
                ellipseTail = new Ellipse2D.Double(mouseBInfo.tailPosition.getX() - (double)(10.0f * this.SCALE), mouseBInfo.tailPosition.getY() - (double)(10.0f * this.SCALE), 20.0f * this.SCALE, 20.0f * this.SCALE);
                g2.draw(double_);
                g2.draw(ellipseBody);
                g2.draw(ellipseTail);
            }
        }
    }

    public ArrayList<Body> getBodyList() {
        return this.bodyList;
    }

    public JPanel getPanel() {
        return this.panel;
    }

    public double convertScaleX(double x) {
        x -= 150.0;
        return x *= 0.35;
    }

    public double convertScaleY(double y) {
        y -= 50.0;
        return y *= 0.25;
    }

    public void writeXMLResult() {
        MouseView mouseView;
        int i;
        System.out.println();
        System.out.println("Body Mouse X 1:");
        for (i = 0; i < this.sequence.getLength(); ++i) {
            mouseView = this.mouse1view.get(i);
            System.out.print(this.convertScaleX(mouseView.bodyPosition.getX()) + ", ");
            if (i % 10 != 0) continue;
            System.out.println();
        }
        System.out.println();
        System.out.println("Body Mouse Y 1:");
        for (i = 0; i < this.sequence.getLength(); ++i) {
            mouseView = this.mouse1view.get(i);
            System.out.print(this.convertScaleY(mouseView.bodyPosition.getY()) + ", ");
            if (i % 10 != 0) continue;
            System.out.println();
        }
        System.out.println();
        System.out.println("head Mouse X 1:");
        for (i = 0; i < this.sequence.getLength(); ++i) {
            mouseView = this.mouse1view.get(i);
            System.out.print(this.convertScaleX(mouseView.headPosition.getX()) + ", ");
            if (i % 10 != 0) continue;
            System.out.println();
        }
        System.out.println();
        System.out.println("head Mouse Y 1:");
        for (i = 0; i < this.sequence.getLength(); ++i) {
            mouseView = this.mouse1view.get(i);
            System.out.print(this.convertScaleY(mouseView.headPosition.getY()) + ", ");
            if (i % 10 != 0) continue;
            System.out.println();
        }
        System.out.println();
        System.out.println("Head Mouse Angle 1:");
        for (i = 0; i < this.sequence.getLength(); ++i) {
            mouseView = this.mouse1view.get(i);
            System.out.print((int)(180.0f * mouseView.headAngle / 3.14f) + ", ");
            if (i % 10 != 0) continue;
            System.out.println();
        }
        System.out.println();
        System.out.println("Body Mouse X 2:");
        for (i = 0; i < this.sequence.getLength(); ++i) {
            mouseView = this.mouse2view.get(i);
            System.out.print(this.convertScaleX(mouseView.bodyPosition.getX()) + ", ");
            if (i % 10 != 0) continue;
            System.out.println();
        }
        System.out.println();
        System.out.println("Body Mouse Y 2:");
        for (i = 0; i < this.sequence.getLength(); ++i) {
            mouseView = this.mouse2view.get(i);
            System.out.print(this.convertScaleY(mouseView.bodyPosition.getY()) + ", ");
            if (i % 10 != 0) continue;
            System.out.println();
        }
        System.out.println();
        System.out.println("head Mouse X 1:");
        for (i = 0; i < this.sequence.getLength(); ++i) {
            mouseView = this.mouse2view.get(i);
            System.out.print(this.convertScaleX(mouseView.headPosition.getX()) + ", ");
            if (i % 10 != 0) continue;
            System.out.println();
        }
        System.out.println();
        System.out.println("head Mouse Y 1:");
        for (i = 0; i < this.sequence.getLength(); ++i) {
            mouseView = this.mouse2view.get(i);
            System.out.print(this.convertScaleY(mouseView.headPosition.getY()) + ", ");
            if (i % 10 != 0) continue;
            System.out.println();
        }
        System.out.println();
        System.out.println("Head Mouse Angle 2:");
        for (i = 0; i < this.sequence.getLength(); ++i) {
            mouseView = this.mouse2view.get(i);
            System.out.print((int)(180.0f * mouseView.headAngle / 3.14f) + ", ");
            if (i % 10 != 0) continue;
            System.out.println();
        }
    }

    public void computeATestAnchorVectorMap(boolean DISPLAY, Ancre2 ancre) {
        Sequence sequenceFocused = Icy.getMainInterface().getFocusedSequence();
        Ancre2 a1 = ancre;
        if (DISPLAY) {
            a1.displayAsSequence();
            sequenceFocused.addPainter((Painter)a1);
        }
        int count = 0;
        float vx = 0.0f;
        float vy = 0.0f;
        byte[] dataAncre = a1.carteAncre.getDataXYAsByte(0);
        byte[] dataCarte = sequenceFocused.getDataXYAsByte(0, 0, 0);
        for (int x = a1.minX; x < a1.maxX; ++x) {
            for (int y = a1.minY; y < a1.maxY; ++y) {
                if (dataAncre[x + y * a1.mapWidth] == 0) continue;
                float vectX = ((float)x - a1.centerX) * (float)(dataCarte[x + y * a1.mapWidth] & 0xFF);
                float vectY = ((float)y - a1.centerY) * (float)(dataCarte[x + y * a1.mapWidth] & 0xFF);
                vx += vectX;
                vy += vectY;
                ++count;
            }
        }
        System.out.println("nb iteration simple : " + count);
        System.out.println("Calcul du vecteur via methode simple : vx = " + vx + " vy = " + vy);
        float vx2 = 0.0f;
        float vy2 = 0.0f;
        int count2 = 0;
        for (int scaleNumber = this.binaryScaleMap.size() - 1; scaleNumber >= 0; --scaleNumber) {
            Scale currentScale = this.binaryScaleMap.get(scaleNumber);
            int scaleWidth = currentScale.width;
            int scaleHeight = currentScale.height;
            int scaleMulti = (int)currentScale.getScaleFactor();
            byte[] dataAncre2 = a1.carteAncre.getDataXYAsByte(0);
            int widthDataAncre = a1.carteAncre.getWidth();
            for (int x = 0; x < scaleWidth; ++x) {
                for (int y = 0; y < scaleHeight; ++y) {
                    int p1x = x * scaleMulti;
                    int p1y = y * scaleMulti;
                    int p2x = (x + 1) * scaleMulti - 1;
                    int p2y = (y + 1) * scaleMulti - 1;
                    if (dataAncre2[p1x + p1y * widthDataAncre] == 0 || dataAncre2[p2x + p2y * widthDataAncre] == 0 || dataAncre2[p1x + p2y * widthDataAncre] == 0 || dataAncre2[p2x + p1y * widthDataAncre] == 0) continue;
                    a1.listRect.add(new Rectangle2D.Float(p1x, p1y, p2x - p1x + 1, p2y - p1y + 1));
                    for (int xx = p1x; xx <= p2x; ++xx) {
                        for (int yy = p1y; yy <= p2y; ++yy) {
                            dataAncre2[xx + yy * widthDataAncre] = 0;
                        }
                    }
                    float vectX = (currentScale.barycenterX[x + y * scaleWidth] - a1.centerX) * currentScale.value[x + y * scaleWidth];
                    float vectY = (currentScale.barycenterY[x + y * scaleWidth] - a1.centerY) * currentScale.value[x + y * scaleWidth];
                    vx2 += vectX;
                    vy2 += vectY;
                    ++count2;
                }
            }
            if (!DISPLAY) continue;
            a1.refreshDisplay();
        }
        System.out.println("nb iteration quad : " + count2);
        System.out.println("Calcul du vecteur via methode quad : vx = " + vx2 + " vy = " + vy2);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.displayForceCheckBox || e.getSource() == this.displayEnergyAreaCheckBox || e.getSource() == this.displayBodyCenterCheckBox || e.getSource() == this.displayBodyShapeCheckBox || e.getSource() == this.displayGlobalSplineCheckBox || e.getSource() == this.displaySlideJointCheckBox || e.getSource() == this.displayBinaryMapCheckBox || e.getSource() == this.displayGradientMapCheckBox) {
            this.sequence.painterChanged(null);
        }
        if (e.getSource() == this.computeATestAnchorVectorMapButton) {
            Sequence sequence = Icy.getMainInterface().getFocusedSequence();
            ArrayList ancreListOut = new ArrayList();
            ArrayList<Ancre2> ancreListIn = new ArrayList<Ancre2>();
            Ancre2 a1 = new Ancre2(Icy.getMainInterface().getFocusedSequence().getWidth(), Icy.getMainInterface().getFocusedSequence().getHeight(), 200.0f, 160.0f, 140.0f);
            a1.setColor(Color.yellow);
            Ancre2 a2 = new Ancre2(Icy.getMainInterface().getFocusedSequence().getWidth(), Icy.getMainInterface().getFocusedSequence().getHeight(), 300.0f, 160.0f, 140.0f);
            a2.setColor(Color.orange);
            Ancre2 a3 = new Ancre2(Icy.getMainInterface().getFocusedSequence().getWidth(), Icy.getMainInterface().getFocusedSequence().getHeight(), 250.0f, 250.0f, 100.0f);
            a3.setColor(Color.blue);
            Ancre2 aConflict = new Ancre2(Icy.getMainInterface().getFocusedSequence().getWidth(), Icy.getMainInterface().getFocusedSequence().getHeight(), 250.0f, 160.0f, 140.0f);
            aConflict.setColor(Color.pink);
            byte[] aConflictdata = aConflict.carteAncre.getDataXYAsByte(0);
            byte[] a1data = a1.carteAncre.getDataXYAsByte(0);
            byte[] a2data = a2.carteAncre.getDataXYAsByte(0);
            byte[] a3data = a3.carteAncre.getDataXYAsByte(0);
            for (int i = 0; i < aConflictdata.length; ++i) {
                aConflictdata[i] = 0;
                if (a1data[i] != 0) {
                    int n = i;
                    aConflictdata[n] = (byte)(aConflictdata[n] + 1);
                }
                if (a2data[i] != 0) {
                    int n = i;
                    aConflictdata[n] = (byte)(aConflictdata[n] + 1);
                }
                if (a3data[i] == 0) continue;
                int n = i;
                aConflictdata[n] = (byte)(aConflictdata[n] + 1);
            }
            ancreListIn.add(a1);
            ancreListIn.add(a2);
            ancreListIn.add(a3);
            for (Ancre2 ancre : ancreListIn) {
                int max = 0;
                byte[] mapAncre = ancre.carteAncre.getDataXYAsByte(0);
                for (int i = 0; i < aConflictdata.length; ++i) {
                    if (mapAncre[i] == 0 || aConflictdata[i] <= max) continue;
                    max = aConflictdata[i];
                }
                System.out.println("max = " + max);
                for (int cumulIndex = max; cumulIndex > 0; --cumulIndex) {
                    Ancre2 newAncre = new Ancre2(sequence.getWidth(), sequence.getHeight(), 10.0f, 10.0f, 0.0f);
                    byte[] ancreData = newAncre.carteAncre.getDataXYAsByte(0);
                    for (int i = 0; i < aConflictdata.length; ++i) {
                        if (mapAncre[i] != -1 || aConflictdata[i] != cumulIndex) continue;
                        ancreData[i] = -1;
                    }
                    System.out.println("computing.");
                    this.computeATestAnchorVectorMap(true, newAncre);
                    newAncre.setColor(new Color((float)Math.random(), (float)Math.random(), (float)Math.random()));
                    sequence.addPainter((Painter)newAncre);
                }
            }
        }
        if (e.getSource() == this.displayScaleBinaryButton) {
            this.binaryScaleMap = new ArrayList();
            this.binaryScaleMap.clear();
            Scale binaryScale0 = new Scale(Icy.getMainInterface().getFocusedSequence().getWidth(), Icy.getMainInterface().getFocusedSequence().getHeight(), 0);
            byte[] dataIn = Icy.getMainInterface().getFocusedSequence().getDataXYAsByte(0, 0, 0);
            float[] dataOut = binaryScale0.value;
            int maxWidth = Icy.getMainInterface().getFocusedSequence().getWidth();
            int maxHeight = Icy.getMainInterface().getFocusedSequence().getHeight();
            int offset = 0;
            for (int y = 0; y < maxHeight; ++y) {
                for (int x = 0; x < maxWidth; ++x) {
                    dataOut[offset] = dataIn[offset] & 0xFF;
                    binaryScale0.barycenterX[offset] = x;
                    binaryScale0.barycenterY[offset] = y;
                    ++offset;
                }
            }
            binaryScale0.sendToDisplay();
            this.binaryScaleMap.add(binaryScale0);
            int MAX_SCALE_TO_BUILD = 9;
            for (int scale = 1; scale < 9; ++scale) {
                Scale previousScale = this.binaryScaleMap.get(scale - 1);
                Scale currentScale = new Scale(previousScale.width / 2, previousScale.height / 2, scale);
                float[] in = previousScale.value;
                float[] out = currentScale.value;
                int maxHeight2 = previousScale.height / 2;
                int maxWidth2 = previousScale.width / 2;
                for (int y = 0; y < maxHeight2; ++y) {
                    for (int x = 0; x < maxWidth2; ++x) {
                        boolean LOG = false;
                        if (x == 20 && y == 21 && scale == 2) {
                            System.out.println("log true x: 20 y:21 s:2");
                            LOG = true;
                        }
                        int xx = x * 2;
                        int yy = y * 2;
                        if (LOG) {
                            System.out.println("recherche pour X s= " + x);
                            System.out.println("recherche pour Y s= " + y);
                            System.out.println("recherche pour X s-1= " + xx);
                            System.out.println("recherche pour X s-1= " + (xx + 1));
                            System.out.println("recherche pour Y s-1= " + yy);
                            System.out.println("recherche pour Y s-1= " + (yy + 1));
                        }
                        out[x + y * currentScale.width] = in[xx + yy * previousScale.width] + in[xx + 1 + yy * previousScale.width] + in[xx + (yy + 1) * previousScale.width] + in[xx + 1 + (yy + 1) * previousScale.width];
                        if (LOG) {
                            System.out.println("previous val 1: " + in[xx + yy * previousScale.width]);
                            System.out.println("previous val 2: " + in[xx + 1 + yy * previousScale.width]);
                            System.out.println("previous val 3: " + in[xx + (yy + 1) * previousScale.width]);
                            System.out.println("previous val 4: " + in[xx + 1 + (yy + 1) * previousScale.width]);
                            System.out.println("OUT destination value = " + out[x + y * currentScale.width]);
                        }
                        if (out[x + y * currentScale.width] == 0.0f) continue;
                        if (LOG) {
                            System.out.println("Entree dans barycentre.");
                        }
                        currentScale.barycenterX[x + y * currentScale.width] = (previousScale.value[xx + yy * previousScale.width] * previousScale.barycenterX[xx + yy * previousScale.width] + previousScale.value[xx + 1 + yy * previousScale.width] * previousScale.barycenterX[xx + 1 + yy * previousScale.width] + previousScale.value[xx + (yy + 1) * previousScale.width] * previousScale.barycenterX[xx + (yy + 1) * previousScale.width] + previousScale.value[xx + 1 + (yy + 1) * previousScale.width] * previousScale.barycenterX[xx + 1 + (yy + 1) * previousScale.width]) / out[x + y * currentScale.width];
                        if (LOG) {
                            System.out.println("Calcul de by: ");
                            System.out.println("p1: " + previousScale.barycenterY[xx + yy * previousScale.width]);
                            System.out.println("p2: " + previousScale.barycenterY[xx + 1 + yy * previousScale.width]);
                            System.out.println("p3: " + previousScale.barycenterY[xx + (yy + 1) * previousScale.width]);
                            System.out.println("p4: " + previousScale.barycenterY[xx + 1 + (yy + 1) * previousScale.width]);
                        }
                        currentScale.barycenterY[x + y * currentScale.width] = (previousScale.value[xx + yy * previousScale.width] * previousScale.barycenterY[xx + yy * previousScale.width] + previousScale.value[xx + 1 + yy * previousScale.width] * previousScale.barycenterY[xx + 1 + yy * previousScale.width] + previousScale.value[xx + (yy + 1) * previousScale.width] * previousScale.barycenterY[xx + (yy + 1) * previousScale.width] + previousScale.value[xx + 1 + (yy + 1) * previousScale.width] * previousScale.barycenterY[xx + 1 + (yy + 1) * previousScale.width]) / out[x + y * currentScale.width];
                        if (!LOG) continue;
                        System.out.println("Bary x:" + currentScale.barycenterX[x + y * currentScale.width]);
                        System.out.println("Bary y:" + currentScale.barycenterY[x + y * currentScale.width]);
                    }
                }
                currentScale.sendToDisplay();
                System.out.println("adding scale : " + scale);
                this.binaryScaleMap.add(currentScale);
            }
        }
        if (e.getSource() == this.resultButton) {
            this.writeXMLResult();
        }
    }

    public boolean isStable() {
        double seuil = 1000.0;
        return !((double)this.world.getTotalEnergy() > 1000.0);
    }

    public void loadXML(File currentFile) {
        float neckY;
        float neckX;
        MouseInfoRecord mouseInfoRecord;
        Element detNode;
        int i;
        NodeList nodes;
        this.mouseARecord.clear();
        this.mouseBRecord.clear();
        File XMLFile = new File(currentFile.getAbsoluteFile() + ".xml");
        if (!XMLFile.exists()) {
            return;
        }
        Document XMLDocument = XMLTools.loadDocument(XMLFile);
        XPath xpath = XPathFactory.newInstance().newXPath();
        String expression = "//MOUSEA/DET";
        try {
            nodes = (NodeList)xpath.evaluate("//MOUSEA/DET", XMLDocument, XPathConstants.NODESET);
            System.out.println("node size : " + nodes.getLength());
            for (i = 0; i < nodes.getLength(); ++i) {
                detNode = (Element)nodes.item(i);
                mouseInfoRecord = new MouseInfoRecord();
                mouseInfoRecord.bodyPosition = new Point2D.Float(Float.parseFloat(detNode.getAttribute("bodyx")), Float.parseFloat(detNode.getAttribute("bodyy")));
                mouseInfoRecord.headPosition = new Point2D.Float(Float.parseFloat(detNode.getAttribute("headx")), Float.parseFloat(detNode.getAttribute("heady")));
                mouseInfoRecord.tailPosition = new Point2D.Float(Float.parseFloat(detNode.getAttribute("tailx")), Float.parseFloat(detNode.getAttribute("taily")));
                neckX = 0.0f;
                neckY = 0.0f;
                try {
                    neckX = Float.parseFloat(detNode.getAttribute("neckx"));
                    neckY = Float.parseFloat(detNode.getAttribute("necky"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                mouseInfoRecord.neckPosition = new Point2D.Float(neckX, neckY);
                this.mouseARecord.put(Integer.parseInt(detNode.getAttribute("t")), mouseInfoRecord);
            }
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
        }
        expression = "//MOUSEB/DET";
        try {
            nodes = (NodeList)xpath.evaluate("//MOUSEB/DET", XMLDocument, XPathConstants.NODESET);
            System.out.println("node size : " + nodes.getLength());
            for (i = 0; i < nodes.getLength(); ++i) {
                detNode = (Element)nodes.item(i);
                mouseInfoRecord = new MouseInfoRecord();
                mouseInfoRecord.bodyPosition = new Point2D.Float(Float.parseFloat(detNode.getAttribute("bodyx")), Float.parseFloat(detNode.getAttribute("bodyy")));
                mouseInfoRecord.headPosition = new Point2D.Float(Float.parseFloat(detNode.getAttribute("headx")), Float.parseFloat(detNode.getAttribute("heady")));
                mouseInfoRecord.tailPosition = new Point2D.Float(Float.parseFloat(detNode.getAttribute("tailx")), Float.parseFloat(detNode.getAttribute("taily")));
                neckX = 0.0f;
                neckY = 0.0f;
                try {
                    neckX = Float.parseFloat(detNode.getAttribute("neckx"));
                    neckY = Float.parseFloat(detNode.getAttribute("necky"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                mouseInfoRecord.neckPosition = new Point2D.Float(neckX, neckY);
                this.mouseBRecord.put(Integer.parseInt(detNode.getAttribute("t")), mouseInfoRecord);
            }
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
        }
    }

    public void saveXML(File currentFile) {
        Element newResultElement;
        int t;
        File XMLFile = new File(currentFile.getAbsoluteFile() + ".xml");
        DocumentBuilderFactory dbfac = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = null;
        try {
            docBuilder = dbfac.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        Document XMLDocument = docBuilder.newDocument();
        Element child = XMLDocument.createElement("MOUSETRACK002Puppy");
        Element child1 = XMLDocument.createElement("FILENAME");
        child1.setTextContent(currentFile.getAbsolutePath());
        Element child2 = XMLDocument.createElement("PARAMETERS");
        Element resultChild = XMLDocument.createElement("RESULT");
        XMLDocument.appendChild(child);
        child.appendChild(child1);
        child.appendChild(child2);
        child.appendChild(resultChild);
        Element resultMouseA = XMLDocument.createElement("MOUSEA");
        Element resultMouseB = XMLDocument.createElement("MOUSEB");
        resultChild.appendChild(resultMouseA);
        resultChild.appendChild(resultMouseB);
        int maxT = 0;
        Set<Integer> integerKey = this.mouseARecord.keySet();
        for (Integer t2 : integerKey) {
            if (t2 <= maxT) continue;
            maxT = t2;
        }
        for (t = 0; t <= maxT; ++t) {
            MouseInfoRecord mouseAInfo = this.mouseARecord.get(t);
            if (mouseAInfo == null) continue;
            newResultElement = XMLDocument.createElement("DET");
            newResultElement.setAttribute("t", "" + t);
            newResultElement.setAttribute("headx", "" + mouseAInfo.headPosition.getX());
            newResultElement.setAttribute("heady", "" + mouseAInfo.headPosition.getY());
            newResultElement.setAttribute("bodyx", "" + mouseAInfo.bodyPosition.getX());
            newResultElement.setAttribute("bodyy", "" + mouseAInfo.bodyPosition.getY());
            newResultElement.setAttribute("tailx", "" + mouseAInfo.tailPosition.getX());
            newResultElement.setAttribute("taily", "" + mouseAInfo.tailPosition.getY());
            newResultElement.setAttribute("neckx", "" + mouseAInfo.neckPosition.getX());
            newResultElement.setAttribute("necky", "" + mouseAInfo.neckPosition.getY());
            resultMouseA.appendChild(newResultElement);
        }
        if (this.mouseList.size() > 1) {
            for (t = 0; t <= maxT; ++t) {
                MouseInfoRecord mouseBInfo = this.mouseBRecord.get(t);
                if (mouseBInfo == null) continue;
                newResultElement = XMLDocument.createElement("DET");
                newResultElement.setAttribute("t", "" + t);
                newResultElement.setAttribute("headx", "" + mouseBInfo.headPosition.getX());
                newResultElement.setAttribute("heady", "" + mouseBInfo.headPosition.getY());
                newResultElement.setAttribute("bodyx", "" + mouseBInfo.bodyPosition.getX());
                newResultElement.setAttribute("bodyy", "" + mouseBInfo.bodyPosition.getY());
                newResultElement.setAttribute("tailx", "" + mouseBInfo.tailPosition.getX());
                newResultElement.setAttribute("taily", "" + mouseBInfo.tailPosition.getY());
                newResultElement.setAttribute("neckx", "" + mouseBInfo.neckPosition.getX());
                newResultElement.setAttribute("necky", "" + mouseBInfo.neckPosition.getY());
                resultMouseB.appendChild(newResultElement);
            }
        }
        XMLTools.saveDocument(XMLDocument, XMLFile);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.binaryThresholdSpinner) {
            this.SEUIL_BINARY_MAP = Integer.parseInt(this.binaryThresholdSpinner.getValue().toString());
        }
    }

    public void divideTimePer2() {
        int i;
        int max = 0;
        Set<Integer> integerKey = this.mouseBRecord.keySet();
        for (Integer t : integerKey) {
            if (t <= max) continue;
            max = t;
        }
        System.out.println("Max =" + max);
        for (i = 0; i <= max; i += 2) {
            if (this.mouseARecord.containsKey(i)) {
                MouseInfoRecord mouseRecordA = this.mouseARecord.get(i);
                this.mouseARecord.remove(i);
                this.mouseARecord.put(i / 2, mouseRecordA);
            }
            if (!this.mouseBRecord.containsKey(i)) continue;
            MouseInfoRecord mouseRecordB = this.mouseBRecord.get(i);
            this.mouseBRecord.remove(i);
            this.mouseBRecord.put(i / 2, mouseRecordB);
        }
        for (i = max / 2; i <= max; ++i) {
            this.mouseARecord.remove(i);
            this.mouseBRecord.remove(i);
        }
        System.out.println("Split done.");
    }

    public void setReverseThreshold(boolean reverseThresholdBoolean) {
        this.reverseThresholdBoolean = reverseThresholdBoolean;
    }

    public void setHeadLocation(int mouseNumber, MAnchor2D controlPoint) {
        this.headForcedPosition[mouseNumber] = controlPoint;
    }

    public class Mouse {
        Body nose = null;
        Body earL = null;
        Body earR = null;
        Body neck = null;
        Body shoulderR = null;
        Body shoulderL = null;
        Body tommyL = null;
        Body tommyR = null;
        Body tommyB = null;
        Body assR = null;
        Body assL = null;
        Body tommyBody = null;
        Body tail1 = null;
        Body tail2 = null;
        Body tail3 = null;
        Body tail4 = null;
        Body tail5 = null;
        Body neckAttachBody = null;
        ArrayList<Body> bodyList = new ArrayList();
        ArrayList<Body> contourList = new ArrayList();
        public Body tail;
        public Body headBody;

        void setPosition(Body body, float x, float y, float dx, float dy, float alpha) {
            Point2D.Float point = new Point2D.Float(x *= PhyMouse.this.SCALE, y *= PhyMouse.this.SCALE);
            float xx = (float)(Math.cos(alpha) * (double)(x - 0.0f) - Math.sin(alpha) * (double)(y - 0.0f) + 0.0);
            float yy = (float)(Math.cos(alpha) * (double)(y - 0.0f) + Math.sin(alpha) * (double)(x - 0.0f) + 0.0);
            point = new Point2D.Float(xx + dx, yy + dy);
            body.setPosition((float)((Point2D)point).getX(), (float)((Point2D)point).getY());
            body.setRotation(alpha);
        }

        public Mouse(float x, float y, float alpha) {
            this.tommyBody = PhyMouse.this.generateBody2(BodyType.CIRCLE, 1.0f, 60.0f, 30.0f, 30.0f, EnergyMap.BINARY_MOUSE, false, true);
            this.bodyList.add(this.tommyBody);
            this.setPosition(this.tommyBody, 0.0f, 80.0f, x, y, alpha);
            Body tommyR = PhyMouse.this.generateBody2(BodyType.BOX, 1.0f, 60.0f, 20.0f, 60.0f, EnergyMap.NO_ENERGY, true, true);
            this.bodyList.add(tommyR);
            this.setPosition(tommyR, 20.0f, 80.0f, x, y, alpha);
            Body tommyL = PhyMouse.this.generateBody2(BodyType.BOX, 1.0f, 60.0f, 20.0f, 60.0f, EnergyMap.NO_ENERGY, true, true);
            this.bodyList.add(tommyL);
            this.setPosition(tommyL, -20.0f, 80.0f, x, y, alpha);
            Body tommyBL = PhyMouse.this.generateBody2(BodyType.BOX, 1.0f, 20.0f, 10.0f, 10.0f, EnergyMap.GRADIENT_MAP, true, true);
            this.bodyList.add(tommyBL);
            this.setPosition(tommyBL, -20.0f, 120.0f, x, y, alpha);
            Body tommyBR = PhyMouse.this.generateBody2(BodyType.BOX, 1.0f, 20.0f, 10.0f, 10.0f, EnergyMap.GRADIENT_MAP, true, true);
            this.bodyList.add(tommyBR);
            this.setPosition(tommyBR, 20.0f, 120.0f, x, y, alpha);
            Body tommyBLC = PhyMouse.this.generateBody2(BodyType.BOX, 1.0f, 20.0f, 10.0f, 10.0f, EnergyMap.GRADIENT_MAP, true, true);
            this.bodyList.add(tommyBLC);
            this.setPosition(tommyBLC, -20.0f, 60.0f, x, y, alpha);
            Body tommyBRC = PhyMouse.this.generateBody2(BodyType.BOX, 1.0f, 20.0f, 10.0f, 10.0f, EnergyMap.GRADIENT_MAP, true, true);
            this.bodyList.add(tommyBRC);
            this.setPosition(tommyBRC, 20.0f, 60.0f, x, y, alpha);
            tommyR.addExcludedBody(tommyBRC);
            tommyL.addExcludedBody(tommyBLC);
            tommyR.addExcludedBody(tommyBR);
            tommyL.addExcludedBody(tommyBL);
            this.tommyBody.addExcludedBody(tommyBL);
            this.tommyBody.addExcludedBody(tommyBR);
            this.tommyBody.addExcludedBody(tommyBLC);
            this.tommyBody.addExcludedBody(tommyBRC);
            this.tommyBody.addExcludedBody(tommyL);
            this.tommyBody.addExcludedBody(tommyR);
            PhyMouse.this.world.add(new FixedJoint(this.tommyBody, tommyR));
            PhyMouse.this.world.add(new FixedJoint(this.tommyBody, tommyL));
            PhyMouse.this.world.add(new FixedJoint(this.tommyBody, tommyBL));
            PhyMouse.this.world.add(new FixedJoint(this.tommyBody, tommyBR));
            PhyMouse.this.world.add(new FixedJoint(this.tommyBody, tommyBLC));
            PhyMouse.this.world.add(new FixedJoint(this.tommyBody, tommyBRC));
            Body neckBody = PhyMouse.this.generateBody2(BodyType.BOX, 1.0f, 0.0f, 20.0f, 60.0f, EnergyMap.NO_ENERGY, true, true);
            this.bodyList.add(neckBody);
            this.setPosition(neckBody, 0.0f, 60.0f, x, y, alpha);
            neckBody.addExcludedBody(this.tommyBody);
            this.neckAttachBody = PhyMouse.this.generateBody2(BodyType.CIRCLE, 1.0f, 0.0f, 5.0f, 5.0f, EnergyMap.NO_ENERGY, true, true);
            this.bodyList.add(this.neckAttachBody);
            this.setPosition(this.neckAttachBody, 0.0f, 30.0f, x, y, alpha);
            this.neckAttachBody.addExcludedBody(this.tommyBody);
            this.neckAttachBody.addExcludedBody(neckBody);
            PhyMouse.this.world.add(new FixedJoint(neckBody, this.neckAttachBody));
            PhyMouse.this.generateSlideJoint(neckBody, this.tommyBody, 0.0f, 4.0f);
            this.headBody = PhyMouse.this.generateBody2(BodyType.CIRCLE, 1.0f, 50.0f, 20.0f, 20.0f, EnergyMap.GRADIENT_MAP, false, true);
            this.bodyList.add(this.headBody);
            this.setPosition(this.headBody, 0.0f, 0.0f, x, y, alpha);
            this.headBody.setRotation(0.7853982f);
            PhyMouse.this.generateSlideJoint(this.neckAttachBody, this.headBody, 0.0f, 2.0f);
            this.tail = PhyMouse.this.generateBody2(BodyType.CIRCLE, 1.0f, 0.0f, 5.0f, 5.0f, EnergyMap.NO_ENERGY, true, true);
            this.bodyList.add(this.tail);
            this.setPosition(this.tail, 0.0f, 120.0f, x, y, alpha);
            PhyMouse.this.world.add(new FixedJoint(this.tommyBody, this.tail));
            for (Mouse mouse : PhyMouse.this.mouseList) {
                if (mouse == this) continue;
                for (Body bodyA : this.bodyList) {
                    for (Body bodyB : mouse.bodyList) {
                        EnergyInfo eA = (EnergyInfo)bodyA.getUserData();
                        EnergyInfo eB = (EnergyInfo)bodyB.getUserData();
                        if (!eA.excludeFromOtherMouse && !eB.excludeFromOtherMouse) continue;
                        bodyA.addExcludedBody(bodyB);
                        bodyB.addExcludedBody(bodyA);
                    }
                }
            }
            for (Body body : this.bodyList) {
                EnergyInfo e = (EnergyInfo)body.getUserData();
                e.mouse = this;
            }
        }
    }

    class EnergyInfo {
        public boolean excludeFromAttractiveMapOwner;
        public boolean excludeFromOtherMouse;
        public float ray;
        public EnergyMap energyMap;
        ArrayList<ROVector2f> previousPositionList = new ArrayList();
        public float vx = 0.0f;
        public float vy = 0.0f;
        Mouse mouse;

        EnergyInfo(float ray, EnergyMap energyMap, boolean excludeFromOtherMouse, boolean excludeFromAttractiveMapOwner) {
            this.ray = ray;
            this.energyMap = energyMap;
            this.excludeFromOtherMouse = excludeFromOtherMouse;
            this.excludeFromAttractiveMapOwner = excludeFromAttractiveMapOwner;
        }

        public Object copy() {
            return null;
        }
    }

    static enum BodyType {
        BOX,
        CIRCLE;

    }

    public static enum EnergyMap {
        NO_ENERGY,
        GRADIENT_MAP,
        BINARY_MOUSE,
        BINARY_EAR,
        SPECIAL_ENERGY,
        SPECIAL_ENERGY2;

    }

    class MouseInfoRecord {
        Point2D headPosition;
        Point2D tailPosition;
        Point2D bodyPosition;
        Point2D neckPosition;

        MouseInfoRecord() {
        }
    }

    class MouseView {
        Point2D headPosition;
        Point2D bodyPosition;
        public float headAngle;

        MouseView() {
        }
    }

    class Ancre2
    implements Painter {
        int mapWidth = 0;
        int mapHeight = 0;
        float centerX;
        float centerY;
        float ray;
        IcyBufferedImage carteAncre = null;
        int minX;
        int maxX;
        int minY;
        int maxY;
        ArrayList<Rectangle2D> listRect = new ArrayList();
        Sequence sequence;
        Color color = Color.yellow;

        public Ancre2(int mapWidth, int mapHeight, float centerX, float centerY, float ray) {
            this.mapWidth = mapWidth;
            this.mapHeight = mapHeight;
            this.centerX = centerX;
            this.centerY = centerY;
            this.ray = ray;
            this.minX = (int)(centerX - ray);
            this.maxX = (int)(centerX + ray);
            this.minY = (int)(centerY - ray);
            this.maxY = (int)(centerY + ray);
            this.carteAncre = new IcyBufferedImage(mapWidth, mapHeight, 1, 0);
            byte[] data = this.carteAncre.getDataXYAsByte(0);
            for (int x = this.minX; x < this.maxX; ++x) {
                for (int y = this.minY; y < this.maxY; ++y) {
                    float dis = ((float)x - centerX) * ((float)x - centerX) + ((float)y - centerY) * ((float)y - centerY);
                    if (!(dis < ray * ray)) continue;
                    data[x + y * mapWidth] = -1;
                }
            }
        }

        public void displayAsSequence() {
            this.sequence = new Sequence(this.carteAncre);
            this.sequence.setName("Map Ancre");
            this.sequence.addPainter((Painter)this);
            Icy.addSequence((Sequence)this.sequence);
        }

        public void refreshDisplay() {
            this.sequence.painterChanged(null);
        }

        public void keyPressed(KeyEvent e, Point2D imagePoint, IcyCanvas canvas) {
        }

        public void mouseClick(MouseEvent e, Point2D p, IcyCanvas canvas) {
        }

        public void mouseDrag(MouseEvent e, Point2D p, IcyCanvas canvas) {
        }

        public void mouseMove(MouseEvent e, Point2D p, IcyCanvas canvas) {
        }

        public void paint(Graphics2D g, Sequence sequence, IcyCanvas canvas) {
            g.setStroke(new BasicStroke(1.0f));
            g.setColor(new Color((float)Math.random(), (float)Math.random(), (float)Math.random(), 0.5f));
            for (Rectangle2D rect : this.listRect) {
                g.draw(rect);
            }
        }

        public void setColor(Color color) {
            this.color = color;
        }

        public void keyReleased(KeyEvent e, Point2D imagePoint, IcyCanvas canvas) {
        }

        public void mousePressed(MouseEvent e, Point2D imagePoint, IcyCanvas canvas) {
        }

        public void mouseReleased(MouseEvent e, Point2D imagePoint, IcyCanvas canvas) {
        }
    }

    class Scale
    implements Painter {
        String name;
        int height;
        int width;
        float[] value;
        float[] barycenterX;
        float[] barycenterY;
        int scale;

        public Scale(int width, int height, int scale) {
            this.scale = scale;
            this.width = width;
            this.height = height;
            this.value = new float[width * height];
            this.barycenterX = new float[width * height];
            this.barycenterY = new float[width * height];
        }

        float getScaleFactor() {
            float scaleFactor = 1.0f;
            for (int i = 0; i < this.scale; ++i) {
                scaleFactor *= 2.0f;
            }
            return scaleFactor;
        }

        void sendToDisplay() {
            IcyBufferedImage image = new IcyBufferedImage(this.width, this.height, 1, 4);
            float[] data = image.getDataXYAsFloat(0);
            for (int i = 0; i < this.value.length; ++i) {
                data[i] = this.value[i];
            }
            Sequence sequence = new Sequence(image);
            sequence.setName("Scale " + this.scale + " resol div par " + this.getScaleFactor());
            sequence.addPainter((Painter)this);
            Icy.addSequence((Sequence)sequence);
        }

        public void keyPressed(KeyEvent e, Point2D imagePoint, IcyCanvas canvas) {
        }

        public void mouseClick(MouseEvent e, Point2D p, IcyCanvas canvas) {
            int x = (int)p.getX();
            int y = (int)p.getY();
            System.out.println("Point : x:" + x + " y:" + y + " bx:" + this.barycenterX[x + y * this.width] + " by:" + this.barycenterY[x + y * this.width] + " v:" + this.value[x + y * this.width]);
        }

        public void mouseDrag(MouseEvent e, Point2D p, IcyCanvas canvas) {
        }

        public void mouseMove(MouseEvent e, Point2D p, IcyCanvas canvas) {
        }

        public void paint(Graphics2D g, Sequence sequence, IcyCanvas canvas) {
            g.setStroke(new BasicStroke(0.1f));
            Line2D.Float line = new Line2D.Float();
            g.setColor(Color.red);
            float scaleDivider = this.getScaleFactor();
            for (int x = 0; x < this.width; ++x) {
                for (int y = 0; y < this.height; ++y) {
                    float xx = this.barycenterX[x + y * this.width] / scaleDivider;
                    float yy = this.barycenterY[x + y * this.width] / scaleDivider;
                    if (this.value[x + y * this.width] == 0.0f) continue;
                    g.setColor(Color.yellow);
                    ((Line2D)line).setLine(0.5 + (double)x + 0.25, 0.5 + (double)y + 0.25, 0.5 + (double)x - 0.25, 0.5 + (double)y - 0.25);
                    g.draw(line);
                    ((Line2D)line).setLine(0.5 + (double)x + 0.25, 0.5 + (double)y - 0.25, 0.5 + (double)x - 0.25, 0.5 + (double)y + 0.25);
                    g.draw(line);
                    g.setColor(Color.red);
                    ((Line2D)line).setLine(0.5 + (double)x, 0.5 + (double)y, (double)xx + 0.25, (double)yy + 0.25);
                    g.draw(line);
                }
            }
        }

        public void keyReleased(KeyEvent e, Point2D imagePoint, IcyCanvas canvas) {
        }

        public void mousePressed(MouseEvent e, Point2D imagePoint, IcyCanvas canvas) {
        }

        public void mouseReleased(MouseEvent e, Point2D imagePoint, IcyCanvas canvas) {
        }
    }
}

