/*
 * Decompiled with CFR 0.152.
 */
package org.python.google.common.util.concurrent;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.python.google.common.util.concurrent.ListenableFuture;
import org.python.google.common.util.concurrent.ListenableFutureTask;
import org.python.google.common.util.concurrent.ListeningExecutorService;
import org.python.google.common.util.concurrent.MoreExecutors;

abstract class AbstractListeningExecutorService
implements ListeningExecutorService {
    AbstractListeningExecutorService() {
    }

    @Override
    public ListenableFuture<?> submit(Runnable task) {
        ListenableFutureTask<Object> ftask = ListenableFutureTask.create(task, null);
        this.execute(ftask);
        return ftask;
    }

    @Override
    public <T> ListenableFuture<T> submit(Runnable task, T result) {
        ListenableFutureTask<T> ftask = ListenableFutureTask.create(task, result);
        this.execute(ftask);
        return ftask;
    }

    @Override
    public <T> ListenableFuture<T> submit(Callable<T> task) {
        ListenableFutureTask<T> ftask = ListenableFutureTask.create(task);
        this.execute(ftask);
        return ftask;
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        try {
            return MoreExecutors.invokeAnyImpl(this, tasks, false, 0L);
        }
        catch (TimeoutException cannotHappen) {
            throw new AssertionError();
        }
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return MoreExecutors.invokeAnyImpl(this, tasks, true, unit.toNanos(timeout));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        if (tasks == null) {
            throw new NullPointerException();
        }
        ArrayList<Future<T>> futures = new ArrayList<Future<T>>(tasks.size());
        boolean done = false;
        try {
            for (Callable<T> callable : tasks) {
                ListenableFutureTask<T> listenableFutureTask = ListenableFutureTask.create(callable);
                futures.add(listenableFutureTask);
                this.execute(listenableFutureTask);
            }
            for (Future future : futures) {
                if (future.isDone()) continue;
                try {
                    future.get();
                }
                catch (CancellationException cancellationException) {
                }
                catch (ExecutionException executionException) {}
            }
            done = true;
            ArrayList<Future<T>> arrayList = futures;
            return arrayList;
        }
        finally {
            if (!done) {
                for (Future future : futures) {
                    future.cancel(true);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        if (tasks == null || unit == null) {
            throw new NullPointerException();
        }
        long nanos = unit.toNanos(timeout);
        ArrayList<Future<T>> futures = new ArrayList<Future<T>>(tasks.size());
        boolean done = false;
        try {
            long it;
            for (Callable<T> t : tasks) {
                futures.add(ListenableFutureTask.create(t));
            }
            long l = System.nanoTime();
            Iterator iterator = futures.iterator();
            while (iterator.hasNext()) {
                void f;
                this.execute((Runnable)iterator.next());
                long l2 = System.nanoTime();
                it = l2;
                if ((nanos -= l2 - it) > 0L) continue;
                ArrayList<Future<T>> arrayList = futures;
                return f;
            }
            for (Future object : futures) {
                if (object.isDone()) continue;
                if (nanos <= 0L) {
                    ArrayList<Future<T>> f = futures;
                    return f;
                }
                try {
                    object.get(nanos, TimeUnit.NANOSECONDS);
                }
                catch (CancellationException f) {
                }
                catch (ExecutionException f) {
                }
                catch (TimeoutException f) {
                    ArrayList<Future<T>> arrayList = futures;
                    if (!done) {
                        for (Future future : futures) {
                            future.cancel(true);
                        }
                    }
                    return arrayList;
                }
                long l2 = System.nanoTime();
                nanos -= l2 - it;
                it = l2;
            }
            done = true;
            ArrayList<Future<T>> arrayList = futures;
            return arrayList;
        }
        finally {
            if (!done) {
                for (Future future : futures) {
                    future.cancel(true);
                }
            }
        }
    }
}

