/*
 * Decompiled with CFR 0.152.
 */
package plugins.nchenouard.particletracking.MHTracker;

import java.util.HashSet;
import java.util.LinkedList;
import plugins.nchenouard.particletracking.MHTracker.Association;
import plugins.nchenouard.particletracking.MHTracker.HMMMHTracker;
import plugins.nchenouard.particletracking.MHTracker.Hypothesis;

public class GlobalHypothesis {
    HashSet<Association> usedAssociations;
    LinkedList<Association> realAssociations;
    LinkedList<Hypothesis> hyps;
    int[] usedRealSpotsNum;
    volatile double score;
    int firstT;
    int lastT;
    HMMMHTracker tracker;

    GlobalHypothesis(int firstT, int lastT, HMMMHTracker tracker) {
        this.usedAssociations = new HashSet();
        this.realAssociations = new LinkedList();
        this.hyps = new LinkedList();
        this.score = 0.0;
        this.usedRealSpotsNum = new int[lastT - firstT + 1];
        this.firstT = firstT;
        this.lastT = lastT;
        this.tracker = tracker;
    }

    GlobalHypothesis(HashSet<Association> usedAssociations, LinkedList<Association> realAssociations, LinkedList<Hypothesis> hyps, double score, int[] usedRSpots, int firstT, int lastT, HMMMHTracker tracker) {
        this.usedAssociations = usedAssociations;
        this.realAssociations = realAssociations;
        this.hyps = hyps;
        this.score = score;
        this.usedRealSpotsNum = usedRSpots;
        this.firstT = firstT;
        this.lastT = lastT;
        this.tracker = tracker;
    }

    public void addHypothesis(Hypothesis h) {
        this.hyps.add(h);
        this.usedAssociations.addAll(h.usedAssociations);
        for (Association a : h.usedAssociations) {
            if (a.isPrediction) continue;
            this.realAssociations.add(a);
            this.usedRealSpotsNum[a.t - this.firstT] = this.usedRealSpotsNum[a.t - this.firstT] + 1;
        }
        this.score += h.leaf.score;
    }

    public GlobalHypothesis copy() {
        int[] rsCopy = new int[this.usedRealSpotsNum.length];
        System.arraycopy(this.usedRealSpotsNum, 0, rsCopy, 0, this.usedRealSpotsNum.length);
        return new GlobalHypothesis(new HashSet<Association>(this.usedAssociations), new LinkedList<Association>(this.realAssociations), new LinkedList<Hypothesis>(this.hyps), this.score, rsCopy, this.firstT, this.lastT, this.tracker);
    }

    public void copyInto(GlobalHypothesis ghCopy) {
        System.arraycopy(this.usedRealSpotsNum, 0, ghCopy.usedRealSpotsNum, 0, this.usedRealSpotsNum.length);
        ghCopy.usedAssociations.addAll(this.usedAssociations);
        ghCopy.realAssociations.addAll(this.realAssociations);
        ghCopy.hyps.addAll(this.hyps);
        ghCopy.score = this.score;
        ghCopy.firstT = this.firstT;
        ghCopy.lastT = this.lastT;
        ghCopy.tracker = this.tracker;
    }

    public void clear() {
        this.usedAssociations.clear();
        this.realAssociations.clear();
        this.score = 0.0;
        this.hyps.clear();
    }

    public int getRealSpotsNumAtT(int t) {
        if (t >= this.firstT && t <= this.lastT) {
            return this.usedRealSpotsNum[t - this.firstT];
        }
        return 0;
    }

    public int getNumNewTracks(int t) {
        int numNT = 0;
        for (Hypothesis h : this.hyps) {
            if (h.leaf.family.rootTrack != null || h.leaf.family.rootNode.association.t != t) continue;
            ++numNT;
        }
        return numNT;
    }

    public void penalizeFD(int t, double pFA, HashSet<Association> originalRealAssociations) {
        for (Association a : originalRealAssociations) {
            if (a.t != t || this.realAssociations.contains(a)) continue;
            this.score += Math.log(pFA);
        }
    }

    public void penalizeAllFD(double pFA, HashSet<Association> originalRealAssociations) {
        for (Association a : originalRealAssociations) {
            if (this.realAssociations.contains(a)) continue;
            this.score += Math.log(pFA);
        }
    }
}

