/*
 * Decompiled with CFR 0.152.
 */
package plugins.nchenouard.particletracking.gui;

import icy.util.XMLUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.text.NumberFormat;
import java.text.ParseException;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.tree.DefaultMutableTreeNode;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import plugins.nchenouard.particletracking.MHTparameterSet;

public class TargetExistencePanel
extends JPanel {
    private static final long serialVersionUID = 3528013023762686155L;
    final DefaultMutableTreeNode node = new DefaultMutableTreeNode("Target existence");
    protected final JSpinner spinnerMeanTrackLength = new JSpinner();
    NumberFormat probaFormat = NumberFormat.getNumberInstance();
    protected final JFormattedTextField confirmationTF = new JFormattedTextField(this.probaFormat);
    protected final JFormattedTextField terminationTF = new JFormattedTextField(this.probaFormat);

    public TargetExistencePanel() {
        this.probaFormat.setMinimumFractionDigits(1);
        this.probaFormat.setMaximumFractionDigits(12);
        this.probaFormat.setMaximumIntegerDigits(1);
        this.probaFormat.setMinimumIntegerDigits(1);
        this.setLayout(new BorderLayout());
        JPanel pane = new JPanel();
        GridBagLayout gbl = new GridBagLayout();
        pane.setLayout(gbl);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        c.insets = new Insets(2, 2, 2, 2);
        this.spinnerMeanTrackLength.setModel(new SpinnerNumberModel((Number)20.0, new Double(1.0), null, new Double(1.0)));
        JPanel spinnerPanel = new JPanel();
        spinnerPanel.setLayout(new GridLayout(2, 1, 0, 0));
        spinnerPanel.add(new JLabel("Expected track length"));
        spinnerPanel.add(this.spinnerMeanTrackLength);
        c.gridx = 0;
        c.gridy = 0;
        pane.add((Component)spinnerPanel, c);
        this.confirmationTF.setValue(0.5);
        JPanel confirmationPanel = new JPanel();
        confirmationPanel.setLayout(new GridLayout(2, 1, 0, 0));
        confirmationPanel.add(new JLabel("Minimum probability of existence for confirmation"));
        confirmationPanel.add(this.confirmationTF);
        c.gridx = 0;
        c.gridy = 1;
        pane.add((Component)confirmationPanel, c);
        c.gridx = 0;
        c.gridy = 2;
        this.terminationTF.setValue(1.0E-4);
        JPanel terminationPanel = new JPanel();
        terminationPanel.setLayout(new GridLayout(2, 1, 0, 0));
        terminationPanel.add(new JLabel("Probability of existence threshold for track termination"));
        terminationPanel.add(this.terminationTF);
        pane.add((Component)terminationPanel, c);
        this.add((Component)pane, "North");
    }

    public double getConfirmationThreshold() throws ParseException {
        return this.probaFormat.parse(this.confirmationTF.getText()).doubleValue();
    }

    public double getTerminationThreshold() throws ParseException {
        return this.probaFormat.parse(this.terminationTF.getText()).doubleValue();
    }

    public double getMeanTrackLength() {
        return ((SpinnerNumberModel)this.spinnerMeanTrackLength.getModel()).getNumber().doubleValue();
    }

    public void saveToXML(Node node) {
        Element nodeDetection = XMLUtil.setElement((Node)node, (String)"targetExistence");
        if (nodeDetection != null) {
            double c;
            XMLUtil.setAttributeDoubleValue((Element)nodeDetection, (String)"trackLength", (double)this.getMeanTrackLength());
            try {
                c = this.getConfirmationThreshold();
                XMLUtil.setAttributeDoubleValue((Element)nodeDetection, (String)"confirmationThreshold", (double)c);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                c = this.getTerminationThreshold();
                XMLUtil.setAttributeDoubleValue((Element)nodeDetection, (String)"terminationThreshold", (double)c);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void loadFromFromXML(Node node) {
        Element nodeDetection = XMLUtil.getElement((Node)node, (String)"targetExistence");
        if (nodeDetection != null) {
            ((SpinnerNumberModel)this.spinnerMeanTrackLength.getModel()).setValue(XMLUtil.getAttributeDoubleValue((Element)nodeDetection, (String)"trackLength", (double)this.getMeanTrackLength()));
            try {
                this.confirmationTF.setValue(XMLUtil.getAttributeDoubleValue((Element)nodeDetection, (String)"confirmationThreshold", (double)this.getConfirmationThreshold()));
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            try {
                this.terminationTF.setValue(XMLUtil.getAttributeDoubleValue((Element)nodeDetection, (String)"terminationThreshold", (double)this.getTerminationThreshold()));
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
    }

    public void fillParameterSet(MHTparameterSet parameterSet) {
        try {
            parameterSet.terminationThreshold = this.getTerminationThreshold();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        try {
            parameterSet.confirmationThreshold = this.getConfirmationThreshold();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        parameterSet.meanTrackLength = this.getMeanTrackLength();
    }

    public void setParameters(MHTparameterSet parameterSet) {
        ((SpinnerNumberModel)this.spinnerMeanTrackLength.getModel()).setValue(parameterSet.meanTrackLength);
        this.confirmationTF.setValue(parameterSet.confirmationThreshold);
        this.terminationTF.setValue(parameterSet.terminationThreshold);
    }
}

