/*
 * Decompiled with CFR 0.152.
 */
package plugins.nchenouard.particletracking.gui;

import icy.swimmingPool.SwimmingObject;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import plugins.nchenouard.particletracking.MHTparameterSet;
import plugins.nchenouard.particletracking.gui.ConfigurationFilePanel;
import plugins.nchenouard.particletracking.gui.DetectionInputPanel;
import plugins.nchenouard.particletracking.gui.MHTPanel;
import plugins.nchenouard.particletracking.gui.MotionModelPanel;
import plugins.nchenouard.particletracking.gui.TargetExistencePanel;
import plugins.nchenouard.particletracking.gui.TrackingDescriptionPanel;
import plugins.nchenouard.particletracking.gui.TracksOutputPanel;
import plugins.nchenouard.spot.DetectionResult;

public class TrackingMainPanel
extends JPanel
implements TreeSelectionListener {
    private static final long serialVersionUID = -8896686371450260299L;
    JPanel centerPane = new JPanel(new CardLayout());
    JTree tree;
    public DetectionInputPanel detectionInputPanel = new DetectionInputPanel();
    public TrackingDescriptionPanel trackingPanel = new TrackingDescriptionPanel();
    public TargetExistencePanel targetExistencePanel = new TargetExistencePanel();
    public MotionModelPanel motionModelPanel = new MotionModelPanel();
    public MHTPanel mhtPanel = new MHTPanel();
    public TracksOutputPanel tracksOutputPanel = new TracksOutputPanel();
    public ConfigurationFilePanel configFilePanel = new ConfigurationFilePanel();
    public JButton startTrackingButton = new JButton("Start");

    public TrackingMainPanel() {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("");
        root.add(this.detectionInputPanel.node);
        DefaultMutableTreeNode rootTracking = this.trackingPanel.node;
        root.add(rootTracking);
        rootTracking.add(this.targetExistencePanel.node);
        rootTracking.add(this.motionModelPanel.node);
        rootTracking.add(this.mhtPanel.node);
        root.add(this.tracksOutputPanel.node);
        root.add(this.configFilePanel.node);
        this.tree = new JTree(root);
        this.tree.setRootVisible(false);
        for (int row = 0; row < this.tree.getRowCount(); ++row) {
            this.tree.expandRow(row);
        }
        this.tree.addTreeSelectionListener(this);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.setOpaque(true);
        JScrollPane treeScrollPane = new JScrollPane(this.tree);
        this.centerPane.add((Component)this.detectionInputPanel, this.detectionInputPanel.node.toString());
        this.centerPane.add((Component)this.trackingPanel, this.trackingPanel.node.toString());
        this.centerPane.add((Component)this.targetExistencePanel, this.targetExistencePanel.node.toString());
        this.centerPane.add((Component)this.motionModelPanel, this.motionModelPanel.node.toString());
        this.centerPane.add((Component)this.mhtPanel, this.mhtPanel.node.toString());
        this.centerPane.add((Component)this.tracksOutputPanel, this.tracksOutputPanel.node.toString());
        this.centerPane.add((Component)this.configFilePanel, this.configFilePanel.node.toString());
        JPanel actionPanel = new JPanel(new FlowLayout(2));
        actionPanel.add(this.startTrackingButton);
        this.setLayout(new BorderLayout());
        this.add((Component)treeScrollPane, "West");
        this.add((Component)this.centerPane, "Center");
        this.add((Component)actionPanel, "South");
        this.trackingPanel.spinnerMeanTrackLength.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                TrackingMainPanel.this.targetExistencePanel.spinnerMeanTrackLength.setValue(TrackingMainPanel.this.trackingPanel.spinnerMeanTrackLength.getValue());
            }
        });
        this.targetExistencePanel.spinnerMeanTrackLength.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                TrackingMainPanel.this.trackingPanel.spinnerMeanTrackLength.setValue(TrackingMainPanel.this.targetExistencePanel.spinnerMeanTrackLength.getValue());
            }
        });
        this.trackingPanel.numberNewTrackSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                TrackingMainPanel.this.mhtPanel.numberNewTrackSpinner.setValue(TrackingMainPanel.this.trackingPanel.numberNewTrackSpinner.getValue());
            }
        });
        this.mhtPanel.numberNewTrackSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                TrackingMainPanel.this.trackingPanel.numberNewTrackSpinner.setValue(TrackingMainPanel.this.mhtPanel.numberNewTrackSpinner.getValue());
            }
        });
        this.trackingPanel.numberInitialTrackSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                TrackingMainPanel.this.mhtPanel.numberInitialTrackSpinner.setValue(TrackingMainPanel.this.trackingPanel.numberInitialTrackSpinner.getValue());
            }
        });
        this.mhtPanel.numberInitialTrackSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                TrackingMainPanel.this.trackingPanel.numberInitialTrackSpinner.setValue(TrackingMainPanel.this.mhtPanel.numberInitialTrackSpinner.getValue());
            }
        });
        this.trackingPanel.spinnerXYDisplacement.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                TrackingMainPanel.this.motionModelPanel.singleMotionPanel.diffusionPanel.spinnerXYDisplacement.setValue(TrackingMainPanel.this.trackingPanel.spinnerXYDisplacement.getValue());
            }
        });
        this.motionModelPanel.singleMotionPanel.diffusionPanel.spinnerXYDisplacement.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                TrackingMainPanel.this.trackingPanel.spinnerXYDisplacement.setValue(TrackingMainPanel.this.motionModelPanel.singleMotionPanel.diffusionPanel.spinnerXYDisplacement.getValue());
            }
        });
    }

    @Override
    public void valueChanged(TreeSelectionEvent arg0) {
        CardLayout cl;
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        if (node == this.detectionInputPanel.node) {
            cl = (CardLayout)this.centerPane.getLayout();
            cl.show(this.centerPane, this.detectionInputPanel.node.toString());
        }
        if (node == this.trackingPanel.node) {
            cl = (CardLayout)this.centerPane.getLayout();
            cl.show(this.centerPane, this.trackingPanel.node.toString());
        }
        if (node == this.targetExistencePanel.node) {
            cl = (CardLayout)this.centerPane.getLayout();
            cl.show(this.centerPane, this.targetExistencePanel.node.toString());
        }
        if (node == this.motionModelPanel.node) {
            cl = (CardLayout)this.centerPane.getLayout();
            cl.show(this.centerPane, this.motionModelPanel.node.toString());
        }
        if (node == this.mhtPanel.node) {
            cl = (CardLayout)this.centerPane.getLayout();
            cl.show(this.centerPane, this.mhtPanel.node.toString());
        }
        if (node == this.tracksOutputPanel.node) {
            cl = (CardLayout)this.centerPane.getLayout();
            cl.show(this.centerPane, this.tracksOutputPanel.node.toString());
        }
        if (node == this.configFilePanel.node) {
            cl = (CardLayout)this.centerPane.getLayout();
            cl.show(this.centerPane, this.configFilePanel.node.toString());
        }
    }

    public DetectionResult getSelectedDetectionResult() {
        if (this.detectionInputPanel.detectionChooser.getSelectedDetectionResult() != null) {
            return this.detectionInputPanel.detectionChooser.getSelectedDetectionResult();
        }
        return null;
    }

    public String getTrackGroupName() {
        return this.tracksOutputPanel.trackGroupTF.getText();
    }

    public void setSelectedDetectionResults(DetectionResult dr) {
        if (this.detectionInputPanel.detectionChooser.getSelectedDetectionResult() == dr) {
            return;
        }
        int cnt = this.detectionInputPanel.detectionChooser.getItemCount();
        for (int i = 0; i < cnt; ++i) {
            Object o = this.detectionInputPanel.detectionChooser.getItemAt(i);
            if (!(o instanceof DetectionResult) || o != dr) continue;
            this.detectionInputPanel.detectionChooser.setSelectedIndex(i);
            break;
        }
    }

    public SwimmingObject getSelectedDetectionResults() {
        if (this.detectionInputPanel.detectionChooser.getSelectedItem() != null) {
            return (SwimmingObject)this.detectionInputPanel.detectionChooser.getSelectedItem();
        }
        return null;
    }

    public void changeTrackingState(boolean b) {
    }

    public MHTparameterSet getParameterSet() {
        MHTparameterSet parameterSet = new MHTparameterSet();
        this.detectionInputPanel.fillParameterSet(parameterSet);
        this.targetExistencePanel.fillParameterSet(parameterSet);
        this.motionModelPanel.fillParameterSet(parameterSet);
        this.mhtPanel.fillParameterSet(parameterSet);
        this.tracksOutputPanel.fillParameterSet(parameterSet);
        return parameterSet;
    }

    public void setParameterset(MHTparameterSet parameterSet) {
        this.detectionInputPanel.setParameters(parameterSet);
        this.targetExistencePanel.setParameters(parameterSet);
        this.motionModelPanel.setParameters(parameterSet);
        this.mhtPanel.setParameters(parameterSet);
        this.tracksOutputPanel.setParameters(parameterSet);
    }
}

