/*
 * Decompiled with CFR 0.152.
 */
package plugins.nchenouard.particletracking.legacytracker.associationMethod;

import icy.system.thread.Processor;
import icy.system.thread.ThreadUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Vector;
import plugins.nchenouard.particletracking.filtering.Predictor;
import plugins.nchenouard.particletracking.legacytracker.Tracker;
import plugins.nchenouard.particletracking.legacytracker.associationMethod.AssignProblem;
import plugins.nchenouard.particletracking.legacytracker.associationMethod.AssignProblemSolver;
import plugins.nchenouard.particletracking.legacytracker.associationMethod.Track;
import plugins.nchenouard.spot.Spot;

public class InstantaneousTracker
implements Tracker {
    ArrayList<Track> tracks;
    final Predictor predictor;
    boolean gateLikelihood = true;
    double gateFactor = 4.0;
    double totalGateLikelihood = 0.99;
    final AssignProblemSolver assignementSolver;
    public static final String[] associationMethodsNames = new String[]{"Max Likelihood", "Optimal Bayesian", "Greedy Nearest Neighbor"};
    int trackCount = 0;
    int maxConsecutivePred;
    Processor processor = new Processor(1000000, 8);

    public InstantaneousTracker(AssignProblemSolver assignementSolver, Predictor predictor, boolean gateLikelihood, double gateFactor, int maxConsecutivePred) {
        this.assignementSolver = assignementSolver;
        this.predictor = predictor;
        this.gateLikelihood = gateLikelihood;
        this.gateFactor = gateFactor;
        this.totalGateLikelihood = predictor.getTotalGateLikelihood(gateLikelihood, gateFactor);
        this.tracks = new ArrayList();
        this.maxConsecutivePred = maxConsecutivePred;
    }

    protected double[][] computeLikelihoodTable(int t, ArrayList<Track> activeTracks, ArrayList<Spot> spots) {
        int numTracks = activeTracks.size();
        int numDetect = spots.size();
        if (numTracks == 0 || numDetect == 0) {
            return null;
        }
        double[][] likelihoods = new double[numDetect][numTracks];
        for (int i = 0; i < numTracks; ++i) {
            Track track = activeTracks.get(i);
            for (int j = 0; j < numDetect; ++j) {
                likelihoods[j][i] = track.likelihood(spots.get(j), this.gateLikelihood, this.gateFactor);
            }
        }
        return likelihoods;
    }

    protected double[][] computeLikelihoodTable(int t, ArrayList<Track> activeTracks, ArrayList<Spot> spots, double gateFactor) {
        int numTracks = activeTracks.size();
        int numDetect = spots.size();
        if (numTracks == 0 || numDetect == 0) {
            return null;
        }
        double[][] likelihoods = new double[numDetect][numTracks];
        for (int i = 0; i < numTracks; ++i) {
            Track track = activeTracks.get(i);
            for (int j = 0; j < numDetect; ++j) {
                likelihoods[j][i] = track.likelihood(spots.get(j), this.gateLikelihood, gateFactor);
            }
        }
        return likelihoods;
    }

    protected double[][] computeInnovationTable(int t, ArrayList<Track> activeTracks, ArrayList<Spot> spots) {
        int numTracks = activeTracks.size();
        int numDetect = spots.size();
        if (numTracks == 0 || numDetect == 0) {
            return null;
        }
        double[][] innovations = new double[numDetect][numTracks];
        for (int i = 0; i < numTracks; ++i) {
            Track track = activeTracks.get(i);
            for (int j = 0; j < numDetect; ++j) {
                innovations[j][i] = track.normalizedInnovation(spots.get(j));
            }
        }
        return innovations;
    }

    protected ArrayList<AssignProblem> createIndependentProblems(int t, double[][] likelihoods, double[][] innovations, ArrayList<Track> activeTracks, ArrayList<Spot> detections) {
        HashSet[] hs;
        int i;
        int j;
        int n_pred = activeTracks.size();
        int n_meas = detections.size();
        if (n_meas == 0) {
            ArrayList<AssignProblem> pbList = new ArrayList<AssignProblem>();
            for (Track trk : activeTracks) {
                AssignProblem pb = new AssignProblem();
                pb.tracks.add(trk);
                pb.t = t;
            }
            return pbList;
        }
        ArrayList<HashSet[]> accumulator = new ArrayList<HashSet[]>(n_pred);
        boolean[] trackIsBusy = new boolean[n_pred];
        boolean[] measIsBusy = new boolean[n_meas];
        for (j = 0; j < n_pred; ++j) {
            trackIsBusy[j] = false;
        }
        for (i = 0; i < n_meas; ++i) {
            measIsBusy[i] = false;
        }
        for (j = 0; j < n_pred; ++j) {
            if (trackIsBusy[j]) continue;
            hs = new HashSet[]{new HashSet(5), new HashSet(5)};
            this.recursAddTrack(j, likelihoods, hs[0], hs[1], trackIsBusy, measIsBusy);
            accumulator.add(hs);
        }
        for (i = 0; i < n_meas; ++i) {
            if (measIsBusy[i]) continue;
            hs = new HashSet[]{new HashSet(5), new HashSet(5)};
            this.recursAddMeasurement(i, likelihoods, hs[0], hs[1], trackIsBusy, measIsBusy);
            accumulator.add(hs);
        }
        ArrayList<AssignProblem> problems = new ArrayList<AssignProblem>();
        for (HashSet[] hs2 : accumulator) {
            AssignProblem pb = new AssignProblem();
            Object[] trackTable = hs2[0].toArray();
            for (int i2 = 0; i2 < trackTable.length; ++i2) {
                pb.tracks.add(activeTracks.get((Integer)trackTable[i2]));
            }
            Object[] detectTable = hs2[1].toArray();
            for (int j2 = 0; j2 < detectTable.length; ++j2) {
                pb.detections.add(detections.get((Integer)detectTable[j2]));
            }
            double[][] compactLikelihoods = new double[detectTable.length][trackTable.length];
            double[][] compactInnovations = new double[detectTable.length][trackTable.length];
            for (int j3 = 0; j3 < detectTable.length; ++j3) {
                for (int i3 = 0; i3 < trackTable.length; ++i3) {
                    compactLikelihoods[j3][i3] = likelihoods[(Integer)detectTable[j3]][(Integer)trackTable[i3]];
                    compactInnovations[j3][i3] = innovations[(Integer)detectTable[j3]][(Integer)trackTable[i3]];
                }
            }
            pb.likelihoods = compactLikelihoods;
            pb.innovations = compactInnovations;
            pb.t = t;
            if (this.assignementSolver.numMaxMeasurements <= 0 && this.assignementSolver.numMaxTracks <= 0) {
                problems.add(pb);
                continue;
            }
            this.smallAssignProblemCreation(this.assignementSolver.numMaxMeasurements, this.assignementSolver.numMaxTracks, pb, problems, this.gateFactor);
        }
        return problems;
    }

    protected void smallAssignProblemCreation(int maxNumMeasurements, int maxNumTracks, AssignProblem pb, ArrayList<AssignProblem> problems, double gFactor) {
        boolean valid = maxNumMeasurements <= 0 || pb.detections.size() < maxNumMeasurements;
        boolean bl = valid = valid && (maxNumTracks <= 0 || pb.tracks.size() < maxNumTracks);
        if (valid) {
            problems.add(pb);
        } else {
            HashSet[] hs2;
            int i;
            int j;
            double gFactor2 = gFactor * 0.75;
            int n_pred = pb.tracks.size();
            int n_meas = pb.detections.size();
            double[][] likelihoods = this.computeLikelihoodTable(pb.t, pb.tracks, pb.detections, gFactor2);
            double[][] innovations = this.computeInnovationTable(pb.t, pb.tracks, pb.detections);
            ArrayList<HashSet[]> accumulator = new ArrayList<HashSet[]>(n_pred);
            boolean[] trackIsBusy = new boolean[n_pred];
            boolean[] measIsBusy = new boolean[n_meas];
            for (j = 0; j < n_pred; ++j) {
                trackIsBusy[j] = false;
            }
            for (i = 0; i < n_meas; ++i) {
                measIsBusy[i] = false;
            }
            for (j = 0; j < n_pred; ++j) {
                if (trackIsBusy[j]) continue;
                hs2 = new HashSet[]{new HashSet(5), new HashSet(5)};
                this.recursAddTrack(j, likelihoods, hs2[0], hs2[1], trackIsBusy, measIsBusy);
                accumulator.add(hs2);
            }
            for (i = 0; i < n_meas; ++i) {
                if (measIsBusy[i]) continue;
                hs2 = new HashSet[]{new HashSet(5), new HashSet(5)};
                this.recursAddMeasurement(i, likelihoods, hs2[0], hs2[1], trackIsBusy, measIsBusy);
                accumulator.add(hs2);
            }
            for (HashSet[] hs2 : accumulator) {
                AssignProblem pb2 = new AssignProblem();
                Object[] trackTable = hs2[0].toArray();
                for (int i2 = 0; i2 < trackTable.length; ++i2) {
                    pb2.tracks.add(pb.tracks.get((Integer)trackTable[i2]));
                }
                Object[] detectTable = hs2[1].toArray();
                for (int j2 = 0; j2 < detectTable.length; ++j2) {
                    pb2.detections.add(pb.detections.get((Integer)detectTable[j2]));
                }
                double[][] compactLikelihoods = new double[detectTable.length][trackTable.length];
                double[][] compactInnovations = new double[detectTable.length][trackTable.length];
                for (int j3 = 0; j3 < detectTable.length; ++j3) {
                    for (int i3 = 0; i3 < trackTable.length; ++i3) {
                        compactLikelihoods[j3][i3] = likelihoods[(Integer)detectTable[j3]][(Integer)trackTable[i3]];
                        compactInnovations[j3][i3] = innovations[(Integer)detectTable[j3]][(Integer)trackTable[i3]];
                    }
                }
                pb2.likelihoods = compactLikelihoods;
                pb2.innovations = compactInnovations;
                pb2.t = pb.t;
                this.smallAssignProblemCreation(this.assignementSolver.numMaxMeasurements, this.assignementSolver.numMaxTracks, pb2, problems, gFactor2);
            }
        }
    }

    protected Track createTrack(Spot spot, int t) {
        Predictor new_predictor = this.predictor.copyInit();
        ++this.trackCount;
        Track track = new Track(this.trackCount, new_predictor, t, this.gateFactor);
        track.initTrack(spot, t);
        return track;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ArrayList<Track> filterTracks(ArrayList<Track> tracks, int t) {
        ArrayList<Track> arrayList = tracks;
        synchronized (arrayList) {
            ArrayList<Track> activeTracks = new ArrayList<Track>();
            for (Track track : tracks) {
                if (!track.isStillActive(this.maxConsecutivePred)) continue;
                activeTracks.add(track);
            }
            return activeTracks;
        }
    }

    public ArrayList<Track> getTracks() {
        return this.tracks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initTracks(ArrayList<Spot> spots, int t) {
        for (Spot spot : spots) {
            Track track = this.createTrack(spot, t);
            if (track == null) continue;
            ArrayList<Track> arrayList = this.tracks;
            synchronized (arrayList) {
                this.tracks.add(track);
            }
        }
    }

    protected void postProcess(AssignProblem pb, int t) {
        this.initTracks(pb.tracksToBeCreated, t);
        this.prolongateTracks(pb.tracksToBeProlongated, t);
    }

    protected void postProcessProblems(ArrayList<AssignProblem> problems, int t, boolean parallel) {
        parallel = false;
        if (parallel) {
            LinkedList<PostProcessThr> listThreads = new LinkedList<PostProcessThr>();
            for (AssignProblem assignProblem : problems) {
                PostProcessThr b = new PostProcessThr(assignProblem, t);
                b.start();
                listThreads.add(b);
            }
            for (Thread thread : listThreads) {
                try {
                    thread.join();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            listThreads.clear();
        } else {
            for (AssignProblem p : problems) {
                this.postProcess(p, t);
            }
        }
    }

    protected void preProcess(ArrayList<AssignProblem> problems, AssignProblem pb, int t) {
    }

    protected void preProcessProblems(ArrayList<AssignProblem> problems, int t, boolean parallel) {
        for (AssignProblem p : problems) {
            this.preProcess(problems, p, t);
        }
    }

    protected void prolongateTracks(ArrayList<Track> tracks, int t) {
        for (Track track : tracks) {
            track.prolongate(t);
        }
    }

    protected void recursAddMeasurement(int measIndex, double[][] likelihood, HashSet<Integer> pred, HashSet<Integer> meas, boolean[] trackIsBusy, boolean[] measIsBusy) {
        if (!measIsBusy[measIndex]) {
            measIsBusy[measIndex] = true;
            meas.add(new Integer(measIndex));
            for (int j = 0; j < likelihood[measIndex].length; ++j) {
                if (!(likelihood[measIndex][j] > 0.0)) continue;
                this.recursAddTrack(j, likelihood, pred, meas, trackIsBusy, measIsBusy);
            }
        }
    }

    protected void recursAddTrack(int trackIndex, double[][] likelihood, HashSet<Integer> pred, HashSet<Integer> meas, boolean[] trackIsBusy, boolean[] measIsBusy) {
        if (!trackIsBusy[trackIndex]) {
            trackIsBusy[trackIndex] = true;
            pred.add(new Integer(trackIndex));
            for (int i = 0; i < likelihood.length; ++i) {
                if (!(likelihood[i][trackIndex] > 0.0)) continue;
                this.recursAddMeasurement(i, likelihood, pred, meas, trackIsBusy, measIsBusy);
            }
        }
    }

    protected void solveProblems(ArrayList<AssignProblem> problems, boolean parallel) {
        parallel = false;
        if (parallel) {
            for (AssignProblem p : problems) {
                SolveProblemThr b = new SolveProblemThr(p);
                this.processor.submit((Runnable)b, false);
            }
            while (this.processor.isProcessing()) {
                ThreadUtil.sleep((int)1000);
            }
        } else {
            for (AssignProblem p : problems) {
                this.assignementSolver.solve(p);
            }
        }
    }

    @Override
    public void track(int t, Vector<Spot> spotsVector) {
        ArrayList<Spot> spots = new ArrayList<Spot>(spotsVector);
        ArrayList<Track> activeTracks = this.filterTracks(this.tracks, t);
        if (activeTracks.size() > 0) {
            double[][] likelihoods = this.computeLikelihoodTable(t, activeTracks, spots);
            double[][] innovations = this.computeInnovationTable(t, activeTracks, spots);
            ArrayList<AssignProblem> problems = this.createIndependentProblems(t, likelihoods, innovations, activeTracks, spots);
            boolean parallel = true;
            this.preProcessProblems(problems, t, parallel);
            this.solveProblems(problems, parallel);
            this.postProcessProblems(problems, t, parallel);
        } else {
            this.initTracks(spots, t);
        }
    }

    class PostProcessThr
    extends Thread {
        final AssignProblem p;
        final int t;

        PostProcessThr(AssignProblem p, int t) {
            this.p = p;
            this.t = t;
        }

        @Override
        public void run() {
            InstantaneousTracker.this.postProcess(this.p, this.t);
        }
    }

    class SolveProblemThr
    extends Thread {
        final AssignProblem p;

        public SolveProblemThr(AssignProblem p) {
            this.p = p;
        }

        @Override
        public void run() {
            InstantaneousTracker.this.assignementSolver.solve(this.p);
        }
    }
}

