/*
 * Decompiled with CFR 0.152.
 */
package plugins.stef.roi.bloc.property;

import icy.plugin.abstract_.Plugin;
import icy.plugin.interface_.PluginBundled;
import icy.plugin.interface_.PluginLibrary;
import icy.roi.ROI;
import icy.system.IcyExceptionHandler;
import icy.util.StringUtil;
import java.awt.Color;
import plugins.adufour.blocks.tools.roi.ROIBlock;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.lang.VarBoolean;
import plugins.adufour.vars.lang.VarColor;
import plugins.adufour.vars.lang.VarDouble;
import plugins.adufour.vars.lang.VarFloat;
import plugins.adufour.vars.lang.VarROIArray;
import plugins.adufour.vars.lang.VarString;
import plugins.stef.roi.bloc.RoiBlocks;

public class SetROIProperties
extends Plugin
implements ROIBlock,
PluginLibrary,
PluginBundled {
    protected VarROIArray roiSet = new VarROIArray("ROI(s)", null);
    protected VarString name = new VarString("Name", "");
    protected VarString numSuffix = new VarString("Number suffix", "_%d");
    protected VarColor color = new VarColor("Color", Color.green);
    protected VarFloat opacity = new VarFloat("Opacity", 0.2f);
    protected VarDouble stroke = new VarDouble("Stroke", 2.0);
    protected VarBoolean showName = new VarBoolean("Show name", Boolean.FALSE);

    public void run() {
        int i = 0;
        for (ROI roi : this.roiSet) {
            if (roi == null) continue;
            String newName = (String)this.name.getValue();
            String suf = (String)this.numSuffix.getValue();
            if (!StringUtil.isEmpty((String)suf)) {
                try {
                    newName = newName + String.format(suf, i);
                }
                catch (Exception e) {
                    System.err.println("Warning: block 'Set ROI Properties' cannot parse 'Number suffix' field:");
                    IcyExceptionHandler.showErrorMessage((Throwable)e, (boolean)false);
                    System.err.println("Default suffix used.");
                    newName = newName + String.format("_%d", i);
                }
            }
            roi.setName(newName);
            roi.setColor((Color)this.color.getValue());
            roi.setOpacity(this.opacity.getValue().floatValue());
            roi.setStroke(this.stroke.getValue().doubleValue());
            roi.setShowName(((Boolean)this.showName.getValue()).booleanValue());
            ++i;
        }
    }

    public void declareInput(VarList inputMap) {
        inputMap.add("rois", (Var)this.roiSet);
        inputMap.add("name", (Var)this.name);
        inputMap.add("suffix", (Var)this.numSuffix);
        inputMap.add("color", (Var)this.color);
        inputMap.add("opacity", (Var)this.opacity);
        inputMap.add("stroke", (Var)this.stroke);
        inputMap.add("showName", (Var)this.showName);
    }

    public void declareOutput(VarList outputMap) {
    }

    public String getMainPluginClassName() {
        return RoiBlocks.class.getName();
    }
}

