/*
 * Decompiled with CFR 0.152.
 */
package plugins.adufour.workbooks;

import java.awt.Color;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFPalette;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.formula.FormulaParseException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import plugins.adufour.workbooks.Workbooks;

public class IcySpreadSheet {
    private final Sheet sheet;
    private final FormulaEvaluator evaluator;
    private final Map<Color, CellStyle> colorStyleMap;

    public IcySpreadSheet(Sheet sheet) {
        this.sheet = sheet;
        this.evaluator = sheet.getWorkbook().getCreationHelper().createFormulaEvaluator();
        this.colorStyleMap = new HashMap<Color, CellStyle>();
    }

    public void copyColumn(int sourceColumn, int targetColumn) {
        Row source = this.sheet.getRow(sourceColumn);
        Row target = this.sheet.getRow(targetColumn);
        if (source == null) {
            if (target != null) {
                this.sheet.removeRow(target);
            }
            return;
        }
        if (target == null) {
            this.sheet.createRow(targetColumn);
        }
        int nCells = source.getLastCellNum();
        for (int i = 0; i < nCells; ++i) {
            Cell sourceCell = source.getCell(i, Row.MissingCellPolicy.RETURN_BLANK_AS_NULL);
            if (sourceCell == null) continue;
            Cell targetCell = target.getCell(i, Row.MissingCellPolicy.CREATE_NULL_AS_BLANK);
            Workbooks.copyCell(sourceCell, targetCell);
        }
    }

    public void copyRow(int sourceRow, int targetRow) {
        Row source = this.sheet.getRow(sourceRow);
        Row target = this.getOrCreateRow(targetRow);
        if (source == null) {
            if (target != null) {
                this.sheet.removeRow(target);
            }
            return;
        }
        if (target == null) {
            this.sheet.createRow(targetRow);
        }
        int nCells = source.getLastCellNum();
        for (int i = 0; i < nCells; ++i) {
            Cell sourceCell = source.getCell(i, Row.MissingCellPolicy.RETURN_BLANK_AS_NULL);
            if (sourceCell == null) continue;
            Cell targetCell = target.getCell(i, Row.MissingCellPolicy.CREATE_NULL_AS_BLANK);
            Workbooks.copyCell(sourceCell, targetCell);
        }
    }

    public void deleteCell(int rowIndex, int columnIndex) {
        Row row = this.sheet.getRow(rowIndex);
        if (row == null) {
            return;
        }
        Cell cell = row.getCell(columnIndex);
        if (cell != null) {
            row.removeCell(cell);
            this.evaluator.notifyDeleteCell(cell);
        }
    }

    public void deleteColumn(int columnIndex, boolean shiftData) {
        int lastRow = this.sheet.getLastRowNum();
        for (int r = 0; r <= lastRow; ++r) {
            int lastColumn;
            Row row = this.sheet.getRow(r);
            if (row == null || columnIndex > (lastColumn = row.getLastCellNum() - 1)) continue;
            Cell cell = row.getCell(columnIndex);
            if (cell != null) {
                row.removeCell(cell);
            }
            if (!shiftData || columnIndex >= lastColumn) continue;
            for (int i = columnIndex; i < lastColumn; ++i) {
                Workbooks.copyCell(row.getCell(i + 1), row.getCell(i, Row.MissingCellPolicy.CREATE_NULL_AS_BLANK));
            }
            row.removeCell(row.getCell(lastColumn));
        }
    }

    public void deleteRow(int rowIndex, boolean shiftData) {
        int lastRow = this.sheet.getLastRowNum();
        if (rowIndex >= lastRow) {
            return;
        }
        Row rowToRemove = this.sheet.getRow(rowIndex);
        if (rowToRemove != null) {
            this.sheet.removeRow(rowToRemove);
        }
        if (shiftData && rowIndex < lastRow) {
            for (int i = rowIndex + 1; i <= lastRow; ++i) {
                this.copyRow(i + 1, i);
            }
            this.sheet.removeRow(this.sheet.getRow(lastRow));
        }
    }

    public Color getFillColor(int row, int column) {
        byte[] rgb;
        Cell cell = this.getOrCreateRow(row).getCell(column, Row.MissingCellPolicy.CREATE_NULL_AS_BLANK);
        org.apache.poi.ss.usermodel.Color color = cell.getCellStyle().getFillForegroundColorColor();
        if (color instanceof HSSFColor) {
            short[] rgb2 = ((HSSFColor)color).getTriplet();
            if (rgb2 != null && rgb2.length >= 3 && (rgb2[0] != 0 || rgb2[1] != 0 || rgb2[2] != 0)) {
                return new Color(rgb2[0], rgb2[1], rgb2[2]);
            }
        } else if (color instanceof XSSFColor && (rgb = ((XSSFColor)color).getRGB()) != null && rgb.length >= 3 && (rgb[0] != 0 || rgb[1] != 0 || rgb[2] != 0)) {
            return new Color(rgb[0] & 0xFF, rgb[1] & 0xFF, rgb[2] & 0xFF);
        }
        return null;
    }

    public String getFormula(int rowIndex, int columnIndex) {
        Row row = this.sheet.getRow(rowIndex);
        if (row == null) {
            return "";
        }
        Cell cell = row.getCell(columnIndex, Row.MissingCellPolicy.RETURN_BLANK_AS_NULL);
        if (cell == null) {
            return "";
        }
        return cell.getCellType() == 2 ? cell.getCellFormula() : "";
    }

    public Object getValue(int rowIndex, int columnIndex) {
        Row row = this.sheet.getRow(rowIndex);
        if (row == null) {
            return "";
        }
        Cell cell = row.getCell(columnIndex, Row.MissingCellPolicy.RETURN_BLANK_AS_NULL);
        if (cell == null) {
            return "";
        }
        if (cell.getCellType() == 1) {
            return cell.getStringCellValue();
        }
        if (cell.getCellType() == 4) {
            return cell.getBooleanCellValue();
        }
        return this.evaluator.evaluate(cell).getNumberValue();
    }

    private Row getOrCreateRow(int rowIndex) {
        Row row = this.sheet.getRow(rowIndex);
        return row != null ? row : this.sheet.createRow(rowIndex);
    }

    public int getIndex() {
        return this.sheet.getWorkbook().getSheetIndex(this.sheet);
    }

    public String getName() {
        return this.sheet.getSheetName();
    }

    public int getNumberOfRows() {
        return this.sheet.getLastRowNum() + 1;
    }

    public int getNumberOfColumns() {
        int nCols = 0;
        int lastRow = this.sheet.getLastRowNum();
        for (int i = 0; i <= lastRow; ++i) {
            Row row = this.sheet.getRow(i);
            if (row == null) continue;
            nCols = Math.max(nCols, row.getLastCellNum());
        }
        return nCols;
    }

    public Sheet getSheet() {
        return this.sheet;
    }

    public void setFillColor(int row, int column, Color color) {
        Cell cell = this.getOrCreateRow(row).getCell(column, Row.MissingCellPolicy.CREATE_NULL_AS_BLANK);
        Workbook book = this.sheet.getWorkbook();
        CellStyle style = this.colorStyleMap.get(color);
        try {
            if (style == null) {
                style = book.createCellStyle();
                if (book instanceof HSSFWorkbook) {
                    HSSFPalette palette = ((HSSFWorkbook)book).getCustomPalette();
                    short colorIndex = palette.findSimilarColor(color.getRed(), color.getGreen(), color.getBlue()).getIndex();
                    style.setFillForegroundColor(colorIndex);
                } else if (book instanceof XSSFWorkbook) {
                    ((XSSFCellStyle)style).setFillForegroundColor(new XSSFColor(color));
                }
                style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
                this.colorStyleMap.put(color, style);
            }
            cell.setCellStyle(style);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setFormula(int row, int column, String formula) throws FormulaParseException {
        Cell cell = this.getOrCreateRow(row).getCell(column, Row.MissingCellPolicy.CREATE_NULL_AS_BLANK);
        if (formula.startsWith("=")) {
            formula = formula.substring(1);
        }
        cell.setCellFormula(formula);
        this.evaluator.notifySetFormula(cell);
    }

    public void setValue(int row, int column, Object value) {
        Cell cell;
        block9: {
            if (value == null) {
                this.deleteCell(row, column);
                return;
            }
            cell = this.getOrCreateRow(row).getCell(column, Row.MissingCellPolicy.CREATE_NULL_AS_BLANK);
            if (value instanceof String) {
                String text = (String)value;
                try {
                    value = Double.parseDouble(text);
                }
                catch (NumberFormatException numberE) {
                    if (text.equalsIgnoreCase("true")) {
                        value = true;
                    }
                    if (!text.equalsIgnoreCase("false")) break block9;
                    value = false;
                }
            }
        }
        if (Number.class.isAssignableFrom(value.getClass())) {
            cell.setCellValue(((Number)value).doubleValue());
        } else if (value instanceof Boolean) {
            cell.setCellValue(((Boolean)value).booleanValue());
        } else {
            cell.setCellValue(value.toString());
        }
        this.evaluator.notifyUpdateCell(cell);
    }

    public void setColumn(int columnIndex, Object ... columnValues) {
        this.setColumn(columnIndex, null, columnValues);
    }

    public void setColumn(int columnIndex, String columnHeader, Object ... columnValues) {
        int rowIndex = 0;
        if (columnHeader != null) {
            Row currentRow = this.getOrCreateRow(rowIndex);
            currentRow.getCell(columnIndex, Row.MissingCellPolicy.CREATE_NULL_AS_BLANK).setCellValue(columnHeader);
            rowIndex = 1;
        }
        for (Object obj : columnValues) {
            if (obj == null) {
                ++rowIndex;
                continue;
            }
            this.setValue(rowIndex++, columnIndex, obj);
        }
    }

    public void insertColumn(int columnIndex) {
        Iterable<Row> iterable = new Iterable<Row>(){

            @Override
            public Iterator<Row> iterator() {
                return IcySpreadSheet.this.sheet.rowIterator();
            }
        };
        for (Row row : iterable) {
            for (int i = row.getPhysicalNumberOfCells() - 1; i >= columnIndex; --i) {
                Cell oldCell = row.getCell(i);
                Cell newCell = row.createCell(i + 1, oldCell.getCellType());
                Workbooks.copyCell(oldCell, newCell);
            }
        }
    }

    public void setRow(int rowIndex, Object ... values) {
        List<Object> list = null;
        if (values.length == 1 && values[0].getClass().isArray()) {
            Object array = values[0];
            int n = Array.getLength(array);
            ArrayList<Object> arrayList = new ArrayList<Object>(n);
            for (int i = 0; i < n; ++i) {
                arrayList.add(Array.get(array, i));
            }
            list = arrayList;
        } else {
            list = Arrays.asList(values);
        }
        this.setRow(rowIndex, null, list);
    }

    public void setRow(int rowIndex, String header, Iterable<?> rowValues) {
        int colIndex = 0;
        if (header != null) {
            this.setValue(rowIndex, colIndex++, header);
        }
        for (Object obj : rowValues) {
            if (obj == null) continue;
            this.setValue(rowIndex, colIndex++, obj);
        }
    }

    public void removeRows() {
        this.removeRows(0);
    }

    public void removeRows(int startRowIndex) {
        for (int i = startRowIndex; i <= this.sheet.getLastRowNum(); ++i) {
            Row row = this.sheet.getRow(i);
            if (row == null) continue;
            this.sheet.removeRow(row);
        }
    }

    public double[] getColumnValues(int columnIndex) {
        ArrayList<Double> values = new ArrayList<Double>(this.sheet.getLastRowNum() + 1);
        for (int i = 0; i <= this.sheet.getLastRowNum(); ++i) {
            Object val = this.getValue(i, columnIndex);
            if (!(val instanceof Number)) continue;
            values.add(((Number)val).doubleValue());
        }
        if (values.isEmpty()) {
            return null;
        }
        double[] result = new double[values.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (Double)values.get(i);
        }
        return result;
    }
}

