/*
 * Decompiled with CFR 0.152.
 */
package plugins.adufour.workbooks;

import icy.plugin.abstract_.PluginActionable;
import icy.plugin.interface_.PluginThreaded;
import icy.system.thread.ThreadUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.BoxLayout;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.WorkbookUtil;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import plugins.adufour.blocks.tools.io.FileToWorkbook;
import plugins.adufour.ezplug.EzDialog;
import plugins.adufour.vars.gui.swing.WorkbookEditor;
import plugins.adufour.vars.lang.VarWorkbook;
import plugins.adufour.workbooks.IcySpreadSheet;

public class Workbooks
extends PluginActionable
implements PluginThreaded {
    private final String defaultTitle = "Icy Workbooks v." + this.getDescriptor().getVersion().getMajor() + "." + this.getDescriptor().getVersion().getMinor();

    public void run() {
        Workbooks.show(Workbooks.createEmptyWorkbook(), this.defaultTitle, true);
    }

    public static Workbook createEmptyWorkbook() {
        return Workbooks.createEmptyWorkbook(WorkbookFormat.XLSX);
    }

    public static Workbook createEmptyWorkbook(WorkbookFormat format) {
        Workbook workbook = format.createEmptyWorkbook();
        workbook.setMissingCellPolicy(Row.MissingCellPolicy.CREATE_NULL_AS_BLANK);
        return workbook;
    }

    public static Workbook openWorkbook(String filePath) {
        return Workbooks.openWorkbook(new File(filePath));
    }

    public static Workbook openWorkbook(File file) {
        return FileToWorkbook.readWorkbook(file);
    }

    public static WorkbookFormat getFormat(Workbook wb) {
        return WorkbookFormat.getFormat(wb);
    }

    public static IcySpreadSheet getSheet(Workbook workbook, String sheetName) {
        Sheet sheet = workbook.getSheet(sheetName);
        if (sheet != null) {
            return new IcySpreadSheet(sheet);
        }
        sheet = workbook.getSheet(sheetName = WorkbookUtil.createSafeSheetName((String)sheetName));
        return new IcySpreadSheet(sheet != null ? sheet : workbook.createSheet(sheetName));
    }

    public static Collection<IcySpreadSheet> getSheets(Workbook workbook) {
        int nSheets = workbook.getNumberOfSheets();
        ArrayList<IcySpreadSheet> sheets = new ArrayList<IcySpreadSheet>(nSheets);
        for (int i = 0; i < nSheets; ++i) {
            sheets.add(new IcySpreadSheet(workbook.getSheetAt(i)));
        }
        return sheets;
    }

    public static void copyCell(Cell srcCell, Cell dstCell) {
        dstCell.setCellComment(srcCell.getCellComment());
        dstCell.setCellType(srcCell.getCellType());
        switch (srcCell.getCellType()) {
            case 1: {
                dstCell.setCellValue(srcCell.getStringCellValue());
                break;
            }
            case 0: {
                dstCell.setCellValue(srcCell.getNumericCellValue());
                break;
            }
            case 4: {
                dstCell.setCellValue(srcCell.getBooleanCellValue());
                break;
            }
            case 2: {
                dstCell.setCellFormula(srcCell.getCellFormula());
                break;
            }
            case 5: {
                dstCell.setCellErrorValue(srcCell.getErrorCellValue());
                break;
            }
        }
    }

    public static void copyStyle(CellStyle srcStyle, CellStyle dstStyle) {
        dstStyle.setAlignment(srcStyle.getAlignmentEnum());
        dstStyle.setBorderBottom(srcStyle.getBorderBottomEnum());
        dstStyle.setBorderLeft(srcStyle.getBorderLeftEnum());
        dstStyle.setBorderRight(srcStyle.getBorderRightEnum());
        dstStyle.setBorderTop(srcStyle.getBorderTopEnum());
        dstStyle.setFillBackgroundColor(srcStyle.getFillBackgroundColor());
        dstStyle.setFillForegroundColor(srcStyle.getFillForegroundColor());
        dstStyle.setFillPattern(srcStyle.getFillPatternEnum());
        dstStyle.setHidden(srcStyle.getHidden());
        dstStyle.setIndention(srcStyle.getIndention());
        dstStyle.setLocked(srcStyle.getLocked());
        dstStyle.setVerticalAlignment(srcStyle.getVerticalAlignmentEnum());
        dstStyle.setWrapText(srcStyle.getWrapText());
    }

    public static void copyFont(Font srcFont, Font dstFont) {
        dstFont.setBold(srcFont.getBold());
        dstFont.setCharSet(srcFont.getCharSet());
        dstFont.setColor(srcFont.getColor());
        dstFont.setFontName(srcFont.getFontName());
        dstFont.setFontHeight(srcFont.getFontHeight());
        dstFont.setItalic(srcFont.getItalic());
        dstFont.setStrikeout(srcFont.getStrikeout());
        dstFont.setTypeOffset(srcFont.getTypeOffset());
        dstFont.setUnderline(srcFont.getUnderline());
    }

    public static boolean containsSheet(Workbook workbook, String sheetName) {
        return workbook.getSheet(sheetName = WorkbookUtil.createSafeSheetName((String)sheetName)) != null;
    }

    public static void show(Workbook workbook, String windowTitle) {
        Workbooks.show(workbook, windowTitle, false);
    }

    public static void show(Workbook workbook, final String windowTitle, final boolean editable) {
        final VarWorkbook wb = new VarWorkbook(windowTitle, workbook);
        ThreadUtil.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                EzDialog dialog = new EzDialog(windowTitle);
                dialog.setLayout((LayoutManager)new BoxLayout(dialog.getContentPane(), 1));
                WorkbookEditor editor = new WorkbookEditor(wb);
                editor.setReadOnly(!editable);
                editor.setEnabled(true);
                dialog.add((Component)editor.getEditorComponent());
                dialog.addToDesktopPane();
                dialog.setVisible(true);
            }
        });
    }

    public static void test() {
        Workbook wb = Workbooks.createEmptyWorkbook();
        IcySpreadSheet sheet = Workbooks.getSheet(wb, "Test");
        sheet.setRow(0, "Col 0", "Col 1", "Some other column");
        sheet.setValue(0, 0, "Name");
        sheet.setValue(1, 0, 3);
        sheet.setFormula(1, 1, "A2 * A2");
        sheet.setFillColor(1, 0, Color.cyan);
        Workbooks.show(wb, "Workbook test", false);
    }

    public static enum WorkbookFormat {
        XLS,
        XLSX;


        Workbook createEmptyWorkbook() {
            switch (this) {
                case XLS: {
                    return new HSSFWorkbook();
                }
                case XLSX: {
                    return new XSSFWorkbook();
                }
            }
            throw new UnsupportedOperationException("Unknown format: " + this.toString());
        }

        public String getExtension() {
            return '.' + this.name().toLowerCase();
        }

        public static WorkbookFormat getFormat(Workbook workbook) {
            if (workbook instanceof HSSFWorkbook) {
                return XLS;
            }
            if (workbook instanceof XSSFWorkbook) {
                return XLSX;
            }
            throw new IllegalArgumentException("Unknown format for workbook " + workbook);
        }
    }
}

