/*
 * Decompiled with CFR 0.152.
 */
package icy.main;

import icy.action.ActionManager;
import icy.common.Version;
import icy.file.FileUtil;
import icy.file.Loader;
import icy.gui.dialog.ConfirmDialog;
import icy.gui.dialog.IdConfirmDialog;
import icy.gui.frame.ExitFrame;
import icy.gui.frame.IcyExternalFrame;
import icy.gui.frame.SplashScreenFrame;
import icy.gui.frame.progress.AnnounceFrame;
import icy.gui.frame.progress.ToolTipFrame;
import icy.gui.inspector.InspectorPanel;
import icy.gui.main.IcyDesktopPane;
import icy.gui.main.MainFrame;
import icy.gui.main.MainInterface;
import icy.gui.main.MainInterfaceBatch;
import icy.gui.main.MainInterfaceGui;
import icy.gui.system.NewVersionFrame;
import icy.gui.util.LookAndFeelUtil;
import icy.image.cache.ImageCache;
import icy.imagej.ImageJPatcher;
import icy.imagej.ImageJWrapper;
import icy.math.UnitUtil;
import icy.network.NetworkUtil;
import icy.plugin.PluginDescriptor;
import icy.plugin.PluginInstaller;
import icy.plugin.PluginLauncher;
import icy.plugin.PluginLoader;
import icy.plugin.PluginUpdater;
import icy.plugin.abstract_.Plugin;
import icy.preferences.ApplicationPreferences;
import icy.preferences.GeneralPreferences;
import icy.preferences.IcyPreferences;
import icy.preferences.PluginPreferences;
import icy.sequence.Sequence;
import icy.sequence.SequencePrefetcher;
import icy.system.AppleUtil;
import icy.system.IcyExceptionHandler;
import icy.system.SingleInstanceCheck;
import icy.system.SystemUtil;
import icy.system.audit.Audit;
import icy.system.thread.ThreadUtil;
import icy.type.collection.CollectionUtil;
import icy.update.IcyUpdater;
import icy.util.StringUtil;
import icy.workspace.WorkspaceInstaller;
import icy.workspace.WorkspaceLoader;
import java.awt.EventQueue;
import java.beans.PropertyVetoException;
import java.io.File;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.HashSet;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import loci.common.DebugTools;
import vtk.vtkNativeLibrary;
import vtk.vtkVersion;

public class Icy {
    public static final String LIB_PATH = "lib";
    public static final int EXIT_FORCE_DELAY = 3000;
    public static Version version = new Version("2.5.1.0");
    private static MainInterface mainInterface = null;
    static FileLock lock = null;
    static SplashScreenFrame splashScreen = null;
    static boolean vtkLibraryLoaded = false;
    static boolean itkLibraryLoaded = false;
    static boolean noSplash = false;
    static boolean noHLExit = false;
    static boolean exiting = false;
    static String[] args;
    static String[] pluginArgs;
    static String startupPluginName;
    static Plugin startupPlugin;
    static String startupImage;
    static ExitFrame exitFrame;
    static Thread terminer;
    private static boolean disableCache;
    private static boolean disableNetwork;

    public static void main(String[] args) {
        boolean headless = false;
        try {
            System.out.println("Initializing...");
            System.out.println();
            headless = Icy.handleAppArgs(args);
            if (!headless && SystemUtil.isHeadLess()) {
                headless = true;
            }
            IcyPreferences.init();
            lock = SingleInstanceCheck.lock((String)"icy");
            if (lock == null && !headless) {
                IdConfirmDialog.Confirmer confirmer = new IdConfirmDialog.Confirmer("Confirmation", "Icy is already running on this computer. Start anyway ?", 0, "singleInstance");
                ThreadUtil.invokeNow((Runnable)confirmer);
                if (!confirmer.getResult()) {
                    System.out.println("Exiting...");
                    IcyPreferences.save();
                    System.exit(0);
                    return;
                }
            }
            System.setProperty("java.util.Arrays.useLegacyMergeSort", "true");
            DebugTools.enableLogging((String)"ERROR");
            if (SystemUtil.isMac()) {
                System.setProperty("jogl.gljpanel.noglsl", "true");
            }
            if (!headless && !noSplash) {
                splashScreen = new SplashScreenFrame();
                EventQueue.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        splashScreen.setVisible(true);
                    }
                });
            }
            new Thread(new Runnable(){

                @Override
                public void run() {
                    ImageCache.isEnabled();
                }
            }, "Initializer: Cache").start();
            new Thread(new Runnable(){

                @Override
                public void run() {
                    NetworkUtil.init();
                }
            }, "Initializer: Network").start();
            new Thread(new Runnable(){

                @Override
                public void run() {
                    PluginLoader.reloadAsynch();
                    WorkspaceLoader.reloadAsynch();
                }
            }, "Initializer: Plugin and WS").start();
            try {
                ImageJPatcher.applyPatches();
            }
            catch (Throwable t) {
                System.err.println("Error while patching ImageJ classes:");
                IcyExceptionHandler.showErrorMessage(t, false);
            }
            mainInterface = headless ? new MainInterfaceBatch() : new MainInterfaceGui();
        }
        catch (Throwable t) {
            Icy.fatalError(t, headless);
        }
        if (!headless) {
            ThreadUtil.invokeNow(new Runnable(){

                @Override
                public void run() {
                    try {
                        LookAndFeelUtil.init();
                        Icy.getMainInterface().init();
                    }
                    catch (Throwable t) {
                        Icy.fatalError(t, false);
                    }
                }
            });
        } else {
            Icy.getMainInterface().init();
        }
        if (splashScreen != null) {
            ThreadUtil.invokeLater(new Runnable(){

                @Override
                public void run() {
                    splashScreen.dispose();
                    splashScreen = null;
                }
            });
        }
        System.out.println(SystemUtil.getJavaName() + " " + SystemUtil.getJavaVersion() + " (" + SystemUtil.getJavaArchDataModel() + " bit)");
        System.out.println("Running on " + SystemUtil.getOSName() + " " + SystemUtil.getOSVersion() + " (" + SystemUtil.getOSArch() + ")");
        System.out.println("Number of processors : " + SystemUtil.getNumberOfCPUs());
        System.out.println("System total memory : " + UnitUtil.getBytesString((double)SystemUtil.getTotalMemory()));
        System.out.println("System available memory : " + UnitUtil.getBytesString((double)SystemUtil.getFreeMemory()));
        System.out.println("Max java memory : " + UnitUtil.getBytesString((double)SystemUtil.getJavaMaxMemory()));
        if (Icy.isCacheDisabled()) {
            System.out.println("Image cache is disabled.");
            InspectorPanel inspector = Icy.getMainInterface().getInspector();
            if (inspector != null) {
                inspector.imageCacheDisabled();
            }
        } else if (InspectorPanel.getVirtualMode()) {
            ImageCache.init((int)ApplicationPreferences.getCacheMemoryMB(), (String)ApplicationPreferences.getCachePath());
        }
        if (headless) {
            System.out.println("Headless mode.");
        }
        System.out.println();
        if (!headless && SystemUtil.isMac()) {
            AppleUtil.init();
        }
        IcyExceptionHandler.init();
        if (!headless) {
            ActionManager.init();
        }
        Icy.nativeLibrariesInit();
        if (!ApplicationPreferences.getVersion().equals(version)) {
            String changeLog;
            if (!headless && !StringUtil.isEmpty(changeLog = Icy.getChangeLog())) {
                ThreadUtil.invokeNow(new Runnable(){

                    @Override
                    public void run() {
                        new NewVersionFrame(Icy.getChangeLog());
                    }
                });
            }
            GeneralPreferences.setLastUpdateCheckTime(0L);
        }
        long currentTime = System.currentTimeMillis();
        long halfDayInterval = 43200000L;
        if (!Icy.isNetworkDisabled() && currentTime > GeneralPreferences.getLastUpdateCheckTime() + 43200000L) {
            if (GeneralPreferences.getAutomaticUpdate()) {
                IcyUpdater.checkUpdate((boolean)true);
            }
            if (PluginPreferences.getAutomaticUpdate()) {
                PluginUpdater.checkUpdate((boolean)true);
            }
            GeneralPreferences.setLastUpdateCheckTime(currentTime);
        }
        ApplicationPreferences.setVersion(version);
        System.out.println();
        System.out.println("Icy Version " + version + " started !");
        System.out.println();
        Icy.checkParameters();
        if (startupImage != null) {
            Icy.getMainInterface().addSequence(Loader.loadSequence((String)FileUtil.getGenericPath(startupImage), (int)0, (boolean)false));
        }
        while (PluginUpdater.isCheckingForUpdate() || PluginInstaller.isProcessing() || WorkspaceInstaller.isProcessing()) {
            ThreadUtil.sleep(1);
        }
        if (startupPluginName != null) {
            PluginLoader.waitWhileLoading();
            PluginDescriptor plugin = PluginLoader.getPlugin((String)startupPluginName);
            if (plugin == null) {
                System.err.println("Could not launch plugin '" + startupPluginName + "': the plugin was not found.");
                System.err.println("Be sure you correctly wrote the complete class name and respected the case.");
                System.err.println("Ex: plugins.mydevid.analysis.MyPluginClass");
            } else {
                startupPlugin = PluginLauncher.start((PluginDescriptor)plugin);
            }
        }
        if (headless && !noHLExit) {
            Icy.exit(false);
        }
    }

    private static boolean handleAppArgs(String[] args) {
        ArrayList<String> pluginArgsList = new ArrayList<String>();
        startupImage = null;
        startupPluginName = null;
        startupPlugin = null;
        boolean execute = false;
        boolean headless = false;
        disableCache = false;
        disableNetwork = false;
        Icy.args = args;
        for (String arg : args) {
            if (startupPluginName != null) {
                pluginArgsList.add(arg);
                continue;
            }
            if (execute) {
                startupPluginName = arg;
                continue;
            }
            if (arg.equalsIgnoreCase("--disableJCL") || arg.equalsIgnoreCase("-dJCL")) {
                PluginLoader.setJCLDisabled((boolean)true);
                continue;
            }
            if (arg.equalsIgnoreCase("--headless") || arg.equalsIgnoreCase("-hl")) {
                headless = true;
                continue;
            }
            if (arg.equalsIgnoreCase("--nocache") || arg.equalsIgnoreCase("-nc")) {
                disableCache = true;
                continue;
            }
            if (arg.equalsIgnoreCase("--nonetwork") || arg.equalsIgnoreCase("-nnt")) {
                disableNetwork = true;
                continue;
            }
            if (arg.equalsIgnoreCase("--nosplash") || arg.equalsIgnoreCase("-ns")) {
                noSplash = true;
                continue;
            }
            if (arg.equalsIgnoreCase("--noHLexit") || arg.equalsIgnoreCase("-nhle")) {
                noHLExit = true;
                continue;
            }
            if (arg.equalsIgnoreCase("--execute") || arg.equalsIgnoreCase("-x")) {
                execute = true;
                continue;
            }
            startupImage = arg;
        }
        pluginArgs = pluginArgsList.toArray(new String[pluginArgsList.size()]);
        return headless;
    }

    static void checkParameters() {
        String text;
        double javaVersion;
        if (SystemUtil.isWindows64() && SystemUtil.is32bits()) {
            String text2 = "You're using a 32 bits Java with a 64 bits OS, try to upgrade to 64 bits java for better performance !";
            System.out.println("Warning: You're using a 32 bits Java with a 64 bits OS, try to upgrade to 64 bits java for better performance !");
            if (!Icy.getMainInterface().isHeadLess()) {
                new ToolTipFrame("<html>You're using a 32 bits Java with a 64 bits OS, try to upgrade to 64 bits java for better performance !</html>", 15, "badJavaArchTip");
            }
        }
        if ((javaVersion = SystemUtil.getJavaVersionAsNumber()) > 0.0 && javaVersion < 7.0 && SystemUtil.isMac()) {
            text = "It looks like you're using a old version of Java (1.6)<br>It's recommended to use last JDK 8 for OSX for a better user experience.<br>See the <a href=\"https://icy.bioimageanalysis.org/faq#35\">FAQ</a> to get information about how to update java.";
            System.out.println("Warning: It looks like you're using a old version of Java (1.6)<br>It's recommended to use last JDK 8 for OSX for a better user experience.<br>See the <a href=\"https://icy.bioimageanalysis.org/faq#35\">FAQ</a> to get information about how to update java.");
            if (!Icy.getMainInterface().isHeadLess()) {
                new ToolTipFrame("<html>It looks like you're using a old version of Java (1.6)<br>It's recommended to use last JDK 8 for OSX for a better user experience.<br>See the <a href=\"https://icy.bioimageanalysis.org/faq#35\">FAQ</a> to get information about how to update java.</html>", 15, "outdatedJavaOSX");
            }
        }
        if (!NetworkUtil.isHTTPSSupported()) {
            String text1 = "Your version of java does not support HTTPS protocol which will be used soon by the new web site.";
            String text2 = "You need to upgrade your version of java to 7u111 (Java 7) or 8u101 (Java 8) at least to use online features (as search or plugin update) in future.";
            System.err.println("Warning: Your version of java does not support HTTPS protocol which will be used soon by the new web site.");
            System.err.println("You need to upgrade your version of java to 7u111 (Java 7) or 8u101 (Java 8) at least to use online features (as search or plugin update) in future.");
            if (!Icy.getMainInterface().isHeadLess()) {
                new ToolTipFrame("<html><b>WARNING:</b> Your version of java does not support HTTPS protocol which will be used soon by the new web site.<br>You need to upgrade your version of java to 7u111 (Java 7) or 8u101 (Java 8) at least to use online features (as search or plugin update) in future.</html>", 0, "httpsNotSupportedWarning");
            }
        }
        if (ApplicationPreferences.getMaxMemoryMB() <= 128 && ApplicationPreferences.getMaxMemoryMBLimit() > 256) {
            text = "Your maximum memory setting is low, you should increase it in Preferences.";
            System.out.println("Warning: Your maximum memory setting is low, you should increase it in Preferences.");
            if (!Icy.getMainInterface().isHeadLess()) {
                new ToolTipFrame("<html>Your maximum memory setting is low, you should increase it in Preferences.</html>", 15, "lowMemoryTip");
            }
        } else if (ApplicationPreferences.getMaxMemoryMB() < ApplicationPreferences.getDefaultMemoryMB() / 2 && !Icy.getMainInterface().isHeadLess()) {
            new ToolTipFrame("<html><b>Tip:</b> you can increase your maximum memory in preferences setting.</html>", 15, "maxMemoryTip");
        }
        if (!Icy.getMainInterface().isHeadLess()) {
            ToolTipFrame tooltip = new ToolTipFrame("<html>Access the main menu by clicking on top left icon<br><img src=\"" + Icy.class.getResource("/image/help/main_menu.png").toString() + "\" /></html>", 30, "mainMenuTip");
            tooltip.setSize(456, 240);
            tooltip = new ToolTipFrame("<html><img src=\"" + Icy.class.getResource("/image/help/virtual_mode.jpg").toString() + "\" /><br>This new button allow to enable/disable Icy <b>virtual mode</b>.<br><br>Virtual mode will force all new created images to be in <i>virtual mode</i> which mean their data can be stored on disk to spare memory.<br>Note that <i>virtual mode</i> is still experimental and <b>some plugins don't support it</b> (processed data can be lost) so use it carefully and only if you're running out of memory.<br><i>You can change the image caching settings in Icy preferences</i></html>", 30, "virtualMode");
            tooltip.setSize(380, 240);
            tooltip = new ToolTipFrame("<html><img src=\"" + Icy.class.getResource("/image/help/magic_wand.png").toString() + "\" /><br><b>Magic Wand</b> is now available in Icy !<br><br>You can access its settings from preferences :<br><img src=\"" + Icy.class.getResource("/image/help/icy_prefs.png").toString() + "\" /></html>", 30, "magicWand");
            tooltip.setSize(300, 260);
        }
    }

    static void fatalError(Throwable t, boolean headless) {
        if (splashScreen != null && splashScreen.isVisible()) {
            splashScreen.dispose();
        }
        IcyExceptionHandler.showErrorMessage(t, true);
        if (!headless) {
            JOptionPane.showMessageDialog(null, IcyExceptionHandler.getErrorMessage(t, true), "Fatal error", 0);
        }
        System.exit(1);
    }

    public static void confirmRestart() {
        Icy.confirmRestart(null);
    }

    public static void confirmRestart(String message) {
        String mess = StringUtil.isEmpty(message) ? "Application need to be restarted so changes can take effect. Do it now ?" : message;
        if (ConfirmDialog.confirm((String)mess)) {
            Icy.exit(true);
        }
    }

    public static void announceRestart() {
        Icy.announceRestart(null);
    }

    public static void announceRestart(String message) {
        String mess = StringUtil.isEmpty(message) ? "Application need to be restarted so changes can take effet." : message;
        if (Icy.getMainInterface().isHeadLess()) {
            System.out.println(mess);
        } else {
            new AnnounceFrame(mess, "Restart Now", new Runnable(){

                @Override
                public void run() {
                    Icy.exit(true);
                }
            }, 20);
        }
    }

    public static boolean canExit(boolean showConfirm) {
        boolean safeExit;
        if (!Icy.getMainInterface().canExitExternal()) {
            return false;
        }
        if (Icy.getMainInterface().isHeadLess()) {
            return true;
        }
        boolean bl = safeExit = !PluginInstaller.isProcessing() && !WorkspaceInstaller.isProcessing();
        if (!safeExit) {
            return ConfirmDialog.confirm((String)"Quit the application", (String)"Some processes are not yet completed, are you sure you want to quit ?", (int)1);
        }
        if (showConfirm && GeneralPreferences.getExitConfirm()) {
            return IdConfirmDialog.confirm((String)"Quit the application ?", (String)"exit");
        }
        return true;
    }

    public static boolean exit(final boolean restart) {
        if (!Icy.canExit(!restart)) {
            return false;
        }
        if (exiting && terminer.isAlive()) {
            if (exitFrame != null) {
                exitFrame.requestFocus();
            }
            return true;
        }
        terminer = new Thread(new Runnable(){

            @Override
            public void run() {
                boolean doUpdate;
                exiting = true;
                System.out.print("Exiting...");
                ImageJWrapper ij = Icy.getMainInterface().getImageJ();
                if (ij != null) {
                    ij.quit();
                }
                final MainFrame mainFrame = Icy.getMainInterface().getMainFrame();
                ThreadUtil.invokeNow(new Runnable(){

                    @Override
                    public void run() {
                        IcyDesktopPane desktopPane = Icy.getMainInterface().getDesktopPane();
                        if (desktopPane != null) {
                            for (JInternalFrame frame : desktopPane.getAllFrames()) {
                                try {
                                    try {
                                        frame.setClosed(true);
                                    }
                                    catch (PropertyVetoException e) {
                                        frame.dispose();
                                    }
                                    catch (Throwable t) {
                                        frame.dispose();
                                    }
                                }
                                catch (Throwable throwable) {
                                    // empty catch block
                                }
                            }
                        }
                        for (JFrame frame : Icy.getMainInterface().getExternalFrames()) {
                            if (frame == mainFrame) continue;
                            if (frame instanceof IcyExternalFrame) {
                                IcyExternalFrame iFrame = (IcyExternalFrame)frame;
                                iFrame.close();
                                if (iFrame.getDefaultCloseOperation() == 2) continue;
                                iFrame.dispose();
                                continue;
                            }
                            frame.dispose();
                        }
                    }
                });
                PluginLoader.stopDaemons();
                ThreadUtil.shutdown();
                SequencePrefetcher.shutdown();
                if (Icy.getMainInterface().isHeadLess()) {
                    while (!ThreadUtil.isShutdownAndTerminated()) {
                        ThreadUtil.sleep(1);
                    }
                } else {
                    ThreadUtil.invokeNow(new Runnable(){

                        @Override
                        public void run() {
                            exitFrame = new ExitFrame(3000);
                        }
                    });
                    while (!ThreadUtil.isShutdownAndTerminated() && !exitFrame.isForced()) {
                        ThreadUtil.sleep(1);
                    }
                    ThreadUtil.invokeNow(new Runnable(){

                        @Override
                        public void run() {
                            exitFrame.dispose();
                        }
                    });
                }
                ThreadUtil.invokeNow(new Runnable(){

                    @Override
                    public void run() {
                        if (mainFrame != null) {
                            mainFrame.dispose();
                        }
                    }
                });
                IcyPreferences.save();
                Audit.save();
                ImageCache.shutDown();
                if (lock != null) {
                    SingleInstanceCheck.release((FileLock)lock);
                }
                if ((doUpdate = IcyUpdater.getWantUpdate()) || restart) {
                    IcyUpdater.launchUpdater((boolean)doUpdate, (boolean)restart);
                }
                System.out.println(" done");
                System.exit(0);
            }
        });
        terminer.setName("Icy Shutdown");
        terminer.start();
        return true;
    }

    @Deprecated
    public static boolean exit(boolean restart, boolean force) {
        return Icy.exit(restart);
    }

    public static boolean isVtkLibraryLoaded() {
        return vtkLibraryLoaded;
    }

    public static boolean isItkLibraryLoaded() {
        return itkLibraryLoaded;
    }

    @Deprecated
    public static boolean isHeadLess() {
        return Icy.getMainInterface().isHeadLess();
    }

    @Deprecated
    public static boolean isCacheEnabled() {
        return !Icy.isCacheDisabled();
    }

    @Deprecated
    public static boolean isNetworkEnabled() {
        return !Icy.isNetworkDisabled();
    }

    public static boolean isCacheDisabled() {
        return disableCache;
    }

    public static boolean isNetworkDisabled() {
        return disableNetwork;
    }

    public static boolean isExiting() {
        return exiting;
    }

    public static MainInterface getMainInterface() {
        if (mainInterface == null) {
            mainInterface = new MainInterfaceBatch();
        }
        return mainInterface;
    }

    public static String[] getCommandLineArgs() {
        return args;
    }

    public static String[] getCommandLinePluginArgs() {
        return pluginArgs;
    }

    public static void clearCommandLinePluginArgs() {
        pluginArgs = new String[0];
    }

    public static Plugin getStartupPlugin() {
        return startupPlugin;
    }

    public static String getChangeLog() {
        if (FileUtil.exists("CHANGELOG.md")) {
            return new String(FileUtil.load("CHANGELOG.md", false));
        }
        return "";
    }

    public static String getLicense() {
        if (FileUtil.exists("LICENSE")) {
            return new String(FileUtil.load("LICENSE", false));
        }
        return "";
    }

    public static String getReadMe() {
        if (FileUtil.exists("README.md")) {
            return new String(FileUtil.load("README.md", false));
        }
        return "";
    }

    @Deprecated
    public static void addSequence(Sequence sequence) {
        Icy.getMainInterface().addSequence(sequence);
    }

    static void nativeLibrariesInit() {
        String libPath = "lib/" + SystemUtil.getOSArchIdString();
        File libPathFile = new File(libPath);
        File[] files = FileUtil.getFiles(libPathFile, null, true, true, false);
        ArrayList<String> directories = new ArrayList<String>();
        directories.add(libPathFile.getAbsolutePath());
        directories.add(new File(SystemUtil.getTempLibraryDirectory()).getAbsolutePath());
        for (File f : files) {
            String filePath;
            if (!f.isDirectory() || directories.contains(filePath = f.getAbsolutePath())) continue;
            directories.add(filePath);
        }
        if (SystemUtil.isUnix()) {
            directories.add(new File("/lib").getAbsolutePath());
            directories.add(new File("/usr/lib").getAbsolutePath());
            if (SystemUtil.is64bits()) {
                directories.add(new File("/lib64").getAbsolutePath());
                directories.add(new File("/lib/x86_64").getAbsolutePath());
                directories.add(new File("/lib/x86_64-linux-gnu").getAbsolutePath());
                directories.add(new File("/usr/lib64").getAbsolutePath());
                directories.add(new File("/usr/lib/x86_64").getAbsolutePath());
                directories.add(new File("/usr/lib/x86_64-linux-gnu").getAbsolutePath());
            } else {
                directories.add(new File("/lib/x86").getAbsolutePath());
                directories.add(new File("/lib/x86-linux-gnu").getAbsolutePath());
                directories.add(new File("/usr/lib/x86").getAbsolutePath());
                directories.add(new File("/usr/lib/x86-linux-gnu").getAbsolutePath());
            }
        }
        if (!SystemUtil.addToJavaLibraryPath(directories.toArray(new String[directories.size()]))) {
            System.out.println("Some native libraries may not load correctly.");
        }
        Icy.loadVtkLibrary(libPathFile);
        SystemUtil.setProperty("com.sun.media.jai.disableMediaLib", "true");
    }

    private static void loadVtkLibrary(File libPathFile) {
        String vtkLibPath = FileUtil.getGenericPath(new File(libPathFile, "vtk").getAbsolutePath());
        System.setProperty("vtk.lib.dir", vtkLibPath);
        vtkLibraryLoaded = false;
        HashSet nativeLibraries = new HashSet(CollectionUtil.asList((Object[])FileUtil.getFiles(vtkLibPath, null, false, false)));
        int numFile = nativeLibraries.size();
        boolean load = true;
        while (load) {
            load = false;
            for (String lib : new ArrayList(nativeLibraries)) {
                if (!Icy.loadLibrary(lib)) continue;
                nativeLibraries.remove(lib);
                load = true;
            }
        }
        if (!nativeLibraries.isEmpty()) {
            System.out.println("Warning: following VTK library files couldn't be loaded:");
            for (String lib : nativeLibraries) {
                System.out.println(FileUtil.getFileName(lib));
            }
        }
        if (nativeLibraries.size() < numFile) {
            vtkLibraryLoaded = true;
        }
        if (vtkLibraryLoaded) {
            vtkNativeLibrary.DisableOutputWindow((File)new File("vtk.log"));
            System.out.println("VTK " + new vtkVersion().GetVTKVersion() + " library successfully loaded...");
        } else {
            String osVer;
            System.out.println("Cannot load VTK library...");
            if (SystemUtil.isMac() && ((osVer = SystemUtil.getOSVersion()).startsWith("10.6") || osVer.startsWith("10.5"))) {
                System.out.println("VTK is not supported on OSX " + osVer + ", version 10.7 or above is required.");
            }
        }
    }

    private static void loadItkLibrary(String osDir) {
        String itkLibDir = osDir + "/" + "itk";
        try {
            Icy.loadLibrary(itkLibDir, "SimpleITKJava", true);
            System.out.println("SimpleITK library successfully loaded...");
            itkLibraryLoaded = true;
        }
        catch (Throwable e) {
            System.out.println("Cannot load SimpleITK library...");
        }
    }

    private static boolean loadLibrary(String path) {
        if (FileUtil.exists(path)) {
            try {
                System.load(path);
                return true;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return false;
    }

    private static void loadLibrary(String dir, String name, boolean mandatory, boolean showLog) {
        block4: {
            if (mandatory) {
                SystemUtil.loadLibrary(dir, name);
            } else {
                try {
                    SystemUtil.loadLibrary(dir, name);
                }
                catch (Throwable e) {
                    if (!showLog) break block4;
                    System.out.println("cannot load " + name + ", skipping...");
                }
            }
        }
    }

    private static void loadLibrary(String dir, String name, boolean mandatory) {
        Icy.loadLibrary(dir, name, mandatory, false);
    }

    private static void loadLibrary(String dir, String name) {
        Icy.loadLibrary(dir, name, true, false);
    }

    static void nativeLibrariesShutdown() {
        File[] libraryFiles;
        String path = "lib/" + SystemUtil.getOSArchIdString();
        for (File libraryFile : libraryFiles = FileUtil.getFiles(new File(path), null, true, false, false)) {
            File file = new File(libraryFile.getName());
            if (!file.exists()) continue;
            file.deleteOnExit();
        }
        for (File libraryFile : libraryFiles = FileUtil.getFiles(new File(SystemUtil.getTempLibraryDirectory()), null, true, false, false)) {
            if (FileUtil.delete(libraryFile, false)) continue;
            libraryFile.deleteOnExit();
        }
    }

    static {
        exitFrame = null;
        terminer = null;
        disableCache = false;
        disableNetwork = false;
    }
}

