/*
 * Decompiled with CFR 0.152.
 */
package icy.updater;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

public class UpdateFrame
extends JFrame {
    private static final long serialVersionUID = -1849973451683594479L;
    final JLabel title = new JLabel();
    final JProgressBar progress = new JProgressBar();
    final JTextPane infos = new JTextPane();
    final JButton closeBtn = new JButton("close");

    public UpdateFrame(String title) throws HeadlessException {
        super(title);
        this.infos.setContentType("text/html");
        this.infos.setText("<html>");
        this.setDefaultCloseOperation(3);
        UpdateFrame.setDefaultLookAndFeelDecorated(true);
        this.setMinimumSize(new Dimension(640, 300));
        this.setPreferredSize(new Dimension(640, 300));
        this.setLocation(150, 150);
        this.build();
    }

    public void build() {
        this.setLayout(new BorderLayout());
        JPanel topPanel = new JPanel();
        JPanel mainPanel = new JPanel();
        JPanel bottomPanel = new JPanel();
        topPanel.setLayout(new BoxLayout(topPanel, 3));
        topPanel.setBorder(BorderFactory.createEmptyBorder(4, 8, 4, 8));
        mainPanel.setLayout(new BorderLayout());
        mainPanel.setBorder(BorderFactory.createEmptyBorder(0, 8, 0, 8));
        bottomPanel.setLayout(new BoxLayout(bottomPanel, 2));
        bottomPanel.setBorder(BorderFactory.createEmptyBorder(4, 8, 4, 8));
        JPanel labelPanel = new JPanel();
        JPanel progressPanel = new JPanel();
        labelPanel.setLayout(new BoxLayout(labelPanel, 2));
        progressPanel.setLayout(new BoxLayout(progressPanel, 2));
        this.title.setText("Waiting shutdown, please wait...");
        this.title.setHorizontalAlignment(0);
        this.title.setHorizontalTextPosition(0);
        this.infos.setEditable(false);
        this.infos.setMinimumSize(new Dimension(540, 160));
        this.infos.setPreferredSize(new Dimension(540, 160));
        this.progress.setMinimum(0);
        this.progress.setMaximum(100);
        this.closeBtn.setEnabled(false);
        this.closeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UpdateFrame.this.dispose();
            }
        });
        labelPanel.add(Box.createHorizontalGlue());
        labelPanel.add(this.title);
        labelPanel.add(Box.createHorizontalGlue());
        progressPanel.add(Box.createHorizontalGlue());
        progressPanel.add(this.progress);
        progressPanel.add(Box.createHorizontalGlue());
        topPanel.add(labelPanel);
        topPanel.add(progressPanel);
        mainPanel.add((Component)new JScrollPane(this.infos), "Center");
        bottomPanel.add(Box.createHorizontalGlue());
        bottomPanel.add(this.closeBtn);
        bottomPanel.add(Box.createHorizontalGlue());
        this.add((Component)topPanel, "North");
        this.add((Component)mainPanel, "Center");
        this.add((Component)bottomPanel, "South");
        this.validate();
        this.pack();
    }

    @Override
    public void setTitle(String text) {
        this.title.setText(text);
    }

    public void setCanClose(boolean value) {
        this.closeBtn.setEnabled(value);
    }

    public void addMessage(String message, boolean error) {
        SimpleAttributeSet set = new SimpleAttributeSet();
        if (error) {
            StyleConstants.setForeground(set, Color.red);
            this.setVisible(true);
        } else {
            StyleConstants.setForeground(set, Color.black);
        }
        try {
            this.infos.getDocument().insertString(this.infos.getDocument().getLength(), message, set);
            this.infos.setCaretPosition(this.infos.getDocument().getLength());
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public void setProgress(int value) {
        this.progress.setValue(value);
    }

    public void setProgressVisible(boolean value) {
        this.progress.setVisible(value);
    }
}

