/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.api.common.icon;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.imageio.ImageIO;
import org.pushingpixels.flamingo.api.common.icon.BadIcoResException;

class Ico {
    private static final int FDE_OFFSET = 6;
    private static final int DE_LENGTH = 16;
    private static final int BMIH_LENGTH = 40;
    private byte[] icoimage = new byte[0];
    private int numImages;
    private BufferedImage[] bi;
    private int[] colorCount;

    public Ico(File file) throws BadIcoResException, IOException {
        this(file.getAbsolutePath());
    }

    public Ico(InputStream is) throws BadIcoResException, IOException {
        try {
            this.read(is);
            this.parseICOImage();
        }
        finally {
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
    }

    public Ico(String filename) throws BadIcoResException, IOException {
        this(new FileInputStream(filename));
    }

    public Ico(URL url) throws BadIcoResException, IOException {
        this(url.openStream());
    }

    public BufferedImage getImage(int index) {
        if (index < 0 || index >= this.numImages) {
            throw new IllegalArgumentException("index out of range");
        }
        return this.bi[index];
    }

    public int getNumColors(int index) {
        if (index < 0 || index >= this.numImages) {
            throw new IllegalArgumentException("index out of range");
        }
        return this.colorCount[index];
    }

    public int getNumImages() {
        return this.numImages;
    }

    private int calcScanlineBytes(int width, int bitCount) {
        return (width * bitCount + 31) / 32 * 4;
    }

    private void parseICOImage() throws BadIcoResException, IOException {
        if (this.icoimage[2] != 1 || this.icoimage[3] != 0) {
            throw new BadIcoResException("Not an ICO resource");
        }
        this.numImages = this.ubyte(this.icoimage[5]);
        this.numImages <<= 8;
        this.numImages |= this.icoimage[4];
        this.bi = new BufferedImage[this.numImages];
        this.colorCount = new int[this.numImages];
        int i = 0;
        while (i < this.numImages) {
            int width = this.ubyte(this.icoimage[6 + i * 16]);
            int height = this.ubyte(this.icoimage[6 + i * 16 + 1]);
            this.colorCount[i] = this.ubyte(this.icoimage[6 + i * 16 + 2]);
            int bytesInRes = this.ubyte(this.icoimage[6 + i * 16 + 11]);
            bytesInRes <<= 8;
            bytesInRes |= this.ubyte(this.icoimage[6 + i * 16 + 10]);
            bytesInRes <<= 8;
            bytesInRes |= this.ubyte(this.icoimage[6 + i * 16 + 9]);
            bytesInRes <<= 8;
            bytesInRes |= this.ubyte(this.icoimage[6 + i * 16 + 8]);
            int imageOffset = this.ubyte(this.icoimage[6 + i * 16 + 15]);
            imageOffset <<= 8;
            imageOffset |= this.ubyte(this.icoimage[6 + i * 16 + 14]);
            imageOffset <<= 8;
            imageOffset |= this.ubyte(this.icoimage[6 + i * 16 + 13]);
            imageOffset <<= 8;
            if (this.icoimage[imageOffset |= this.ubyte(this.icoimage[6 + i * 16 + 12])] == 40 && this.icoimage[imageOffset + 1] == 0 && this.icoimage[imageOffset + 2] == 0 && this.icoimage[imageOffset + 3] == 0) {
                int rgb;
                int index;
                int col;
                int row;
                int andImageOffset;
                int scanlineBytes;
                int xorImageOffset;
                int _width = this.ubyte(this.icoimage[imageOffset + 7]);
                _width <<= 8;
                _width |= this.ubyte(this.icoimage[imageOffset + 6]);
                _width <<= 8;
                _width |= this.ubyte(this.icoimage[imageOffset + 5]);
                _width <<= 8;
                _width |= this.ubyte(this.icoimage[imageOffset + 4]);
                if (width == 0) {
                    width = _width;
                }
                int _height = this.ubyte(this.icoimage[imageOffset + 11]);
                _height <<= 8;
                _height |= this.ubyte(this.icoimage[imageOffset + 10]);
                _height <<= 8;
                _height |= this.ubyte(this.icoimage[imageOffset + 9]);
                _height <<= 8;
                _height |= this.ubyte(this.icoimage[imageOffset + 8]);
                if (height == 0) {
                    height = _height >> 1;
                }
                int planes = this.ubyte(this.icoimage[imageOffset + 13]);
                planes <<= 8;
                planes |= this.ubyte(this.icoimage[imageOffset + 12]);
                int bitCount = this.ubyte(this.icoimage[imageOffset + 15]);
                bitCount <<= 8;
                bitCount |= this.ubyte(this.icoimage[imageOffset + 14]);
                if (this.colorCount[i] == 0) {
                    if (planes == 1) {
                        if (bitCount == 1) {
                            this.colorCount[i] = 2;
                        } else if (bitCount == 4) {
                            this.colorCount[i] = 16;
                        } else if (bitCount == 8) {
                            this.colorCount[i] = 256;
                        } else if (bitCount != 32) {
                            this.colorCount[i] = (int)Math.pow(2.0, bitCount);
                        }
                    } else {
                        this.colorCount[i] = (int)Math.pow(2.0, bitCount * planes);
                    }
                }
                this.bi[i] = new BufferedImage(width, height, 2);
                int colorTableOffset = imageOffset + 40;
                if (this.colorCount[i] == 2) {
                    xorImageOffset = colorTableOffset + 8;
                    scanlineBytes = this.calcScanlineBytes(width, 1);
                    andImageOffset = xorImageOffset + scanlineBytes * height;
                    int[] masks = new int[]{128, 64, 32, 16, 8, 4, 2, 1};
                    row = 0;
                    while (row < height) {
                        col = 0;
                        while (col < width) {
                            index = (this.ubyte(this.icoimage[xorImageOffset + row * scanlineBytes + col / 8]) & masks[col % 8]) != 0 ? 1 : 0;
                            rgb = 0;
                            rgb |= this.ubyte(this.icoimage[colorTableOffset + index * 4 + 2]);
                            rgb <<= 8;
                            rgb |= this.ubyte(this.icoimage[colorTableOffset + index * 4 + 1]);
                            rgb <<= 8;
                            rgb |= this.ubyte(this.icoimage[colorTableOffset + index * 4]);
                            if ((this.ubyte(this.icoimage[andImageOffset + row * scanlineBytes + col / 8]) & masks[col % 8]) != 0) {
                                this.bi[i].setRGB(col, height - 1 - row, rgb);
                            } else {
                                this.bi[i].setRGB(col, height - 1 - row, 0xFF000000 | rgb);
                            }
                            ++col;
                        }
                        ++row;
                    }
                } else if (this.colorCount[i] == 16) {
                    xorImageOffset = colorTableOffset + 64;
                    scanlineBytes = this.calcScanlineBytes(width, 4);
                    andImageOffset = xorImageOffset + scanlineBytes * height;
                    int[] masks = new int[]{128, 64, 32, 16, 8, 4, 2, 1};
                    row = 0;
                    while (row < height) {
                        col = 0;
                        while (col < width) {
                            if ((col & 1) == 0) {
                                index = this.ubyte(this.icoimage[xorImageOffset + row * scanlineBytes + col / 2]);
                                index >>= 4;
                            } else {
                                index = this.ubyte(this.icoimage[xorImageOffset + row * scanlineBytes + col / 2]) & 0xF;
                            }
                            rgb = 0;
                            rgb |= this.ubyte(this.icoimage[colorTableOffset + index * 4 + 2]);
                            rgb <<= 8;
                            rgb |= this.ubyte(this.icoimage[colorTableOffset + index * 4 + 1]);
                            rgb <<= 8;
                            rgb |= this.ubyte(this.icoimage[colorTableOffset + index * 4]);
                            if ((this.ubyte(this.icoimage[andImageOffset + row * this.calcScanlineBytes(width, 1) + col / 8]) & masks[col % 8]) != 0) {
                                this.bi[i].setRGB(col, height - 1 - row, rgb);
                            } else {
                                this.bi[i].setRGB(col, height - 1 - row, 0xFF000000 | rgb);
                            }
                            ++col;
                        }
                        ++row;
                    }
                } else if (this.colorCount[i] == 256) {
                    xorImageOffset = colorTableOffset + 1024;
                    scanlineBytes = this.calcScanlineBytes(width, 8);
                    andImageOffset = xorImageOffset + scanlineBytes * height;
                    int[] masks = new int[]{128, 64, 32, 16, 8, 4, 2, 1};
                    row = 0;
                    while (row < height) {
                        col = 0;
                        while (col < width) {
                            index = this.ubyte(this.icoimage[xorImageOffset + row * scanlineBytes + col]);
                            rgb = 0;
                            rgb |= this.ubyte(this.icoimage[colorTableOffset + index * 4 + 2]);
                            rgb <<= 8;
                            rgb |= this.ubyte(this.icoimage[colorTableOffset + index * 4 + 1]);
                            rgb <<= 8;
                            rgb |= this.ubyte(this.icoimage[colorTableOffset + index * 4]);
                            if ((this.ubyte(this.icoimage[andImageOffset + row * this.calcScanlineBytes(width, 1) + col / 8]) & masks[col % 8]) != 0) {
                                this.bi[i].setRGB(col, height - 1 - row, rgb);
                            } else {
                                this.bi[i].setRGB(col, height - 1 - row, 0xFF000000 | rgb);
                            }
                            ++col;
                        }
                        ++row;
                    }
                } else if (this.colorCount[i] == 0) {
                    int scanlineBytes2 = this.calcScanlineBytes(width, 32);
                    int row2 = 0;
                    while (row2 < height) {
                        int col2 = 0;
                        while (col2 < width) {
                            int rgb2 = this.ubyte(this.icoimage[colorTableOffset + row2 * scanlineBytes2 + col2 * 4 + 3]);
                            rgb2 <<= 8;
                            rgb2 |= this.ubyte(this.icoimage[colorTableOffset + row2 * scanlineBytes2 + col2 * 4 + 2]);
                            rgb2 <<= 8;
                            rgb2 |= this.ubyte(this.icoimage[colorTableOffset + row2 * scanlineBytes2 + col2 * 4 + 1]);
                            rgb2 <<= 8;
                            this.bi[i].setRGB(col2, height - 1 - row2, rgb2 |= this.ubyte(this.icoimage[colorTableOffset + row2 * scanlineBytes2 + col2 * 4]));
                            ++col2;
                        }
                        ++row2;
                    }
                }
            } else if (this.ubyte(this.icoimage[imageOffset]) == 137 && this.icoimage[imageOffset + 1] == 80 && this.icoimage[imageOffset + 2] == 78 && this.icoimage[imageOffset + 3] == 71 && this.icoimage[imageOffset + 4] == 13 && this.icoimage[imageOffset + 5] == 10 && this.icoimage[imageOffset + 6] == 26 && this.icoimage[imageOffset + 7] == 10) {
                ByteArrayInputStream bais = new ByteArrayInputStream(this.icoimage, imageOffset, bytesInRes);
                this.bi[i] = ImageIO.read(bais);
            } else {
                throw new BadIcoResException("BITMAPINFOHEADER or PNG expected");
            }
            ++i;
        }
        this.icoimage = null;
    }

    private void read(InputStream is) throws IOException {
        int bytesToRead;
        while ((bytesToRead = is.available()) != 0) {
            byte[] icoimage2 = new byte[this.icoimage.length + bytesToRead];
            System.arraycopy(this.icoimage, 0, icoimage2, 0, this.icoimage.length);
            is.read(icoimage2, this.icoimage.length, bytesToRead);
            this.icoimage = icoimage2;
        }
    }

    private int ubyte(byte b) {
        return b < 0 ? 256 + b : b;
    }
}

