/*
 * Decompiled with CFR 0.152.
 */
package icy.gui.component.button;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EventListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JColorChooser;

public class ColorChooserButton
extends JButton
implements ActionListener {
    private static final long serialVersionUID = -5130821224410911737L;
    private String colorChooseText;

    public ColorChooserButton() {
        this(Color.black);
    }

    public ColorChooserButton(Color color) {
        this.setFocusPainted(false);
        Dimension dim = new Dimension(24, 18);
        this.add(new Box.Filler(dim, dim, dim));
        this.setBackground(color);
        this.colorChooseText = "Choose color";
        this.addActionListener(this);
    }

    public Color getColor() {
        return this.getBackground();
    }

    public void setColor(Color color) {
        if (this.getColor() != color) {
            this.setBackground(color);
            this.fireColorChanged();
        }
    }

    public String getColorChooseText() {
        return this.colorChooseText;
    }

    public void setColorChooseText(String colorChooseText) {
        this.colorChooseText = colorChooseText;
    }

    protected void fireColorChanged() {
        for (ColorChangeListener listener : (ColorChangeListener[])this.listenerList.getListeners(ColorChangeListener.class)) {
            listener.colorChanged(this);
        }
    }

    public void addColorChangeListener(ColorChangeListener l) {
        this.listenerList.add(ColorChangeListener.class, l);
    }

    public void removeColorChangeListener(ColorChangeListener l) {
        this.listenerList.remove(ColorChangeListener.class, l);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Color c = JColorChooser.showDialog(this, this.colorChooseText, this.getColor());
        if (c != null) {
            this.setColor(c);
        }
    }

    public static interface ColorChangeListener
    extends EventListener {
        public void colorChanged(ColorChooserButton var1);
    }
}

