/*
 * Decompiled with CFR 0.152.
 */
package icy.gui.inspector;

import icy.gui.component.ImageComponent;
import icy.gui.component.button.IcyButton;
import icy.gui.main.GlobalPluginListener;
import icy.gui.util.ComponentUtil;
import icy.main.Icy;
import icy.plugin.PluginDescriptor;
import icy.plugin.abstract_.Plugin;
import icy.resource.ResourceUtil;
import icy.resource.icon.IcyIcon;
import icy.system.thread.ThreadUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.ref.WeakReference;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class PluginsPanel
extends JPanel
implements GlobalPluginListener,
Runnable {
    private static final long serialVersionUID = 8950935360929507468L;
    private final JPanel pluginsPanel = new JPanel(true);

    public PluginsPanel() {
        super(true);
        this.pluginsPanel.setLayout(new BoxLayout(this.pluginsPanel, 3));
        this.setLayout(new BorderLayout());
        this.add((Component)new JScrollPane(this.pluginsPanel), "Center");
        this.rebuildPluginPanel();
        this.validate();
        this.setVisible(true);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        Icy.getMainInterface().addGlobalPluginListener(this);
    }

    @Override
    public void removeNotify() {
        Icy.getMainInterface().removeGlobalPluginListener(this);
        super.removeNotify();
    }

    void rebuildPluginPanel() {
        this.pluginsPanel.removeAll();
        for (Plugin plugin : Icy.getMainInterface().getActivePlugins()) {
            this.pluginsPanel.add(new PluginComponent(plugin));
        }
        this.pluginsPanel.add(Box.createVerticalGlue());
        this.pluginsPanel.validate();
        this.pluginsPanel.getParent().validate();
        this.pluginsPanel.getParent().repaint();
    }

    private PluginComponent getPluginComponent(Plugin plugin) {
        for (Component comp : this.pluginsPanel.getComponents()) {
            PluginComponent pluginComponent;
            if (!(comp instanceof PluginComponent) || (pluginComponent = (PluginComponent)comp).getPlugin() != plugin) continue;
            return pluginComponent;
        }
        return null;
    }

    @Override
    public void run() {
        ThreadUtil.invokeNow(new Runnable(){

            @Override
            public void run() {
                PluginsPanel.this.rebuildPluginPanel();
            }
        });
    }

    @Override
    public void pluginStarted(Plugin plugin) {
        ThreadUtil.runSingle(this);
    }

    @Override
    public void pluginEnded(Plugin plugin) {
        ThreadUtil.runSingle(this);
    }

    private class PluginComponent
    extends JPanel {
        private static final long serialVersionUID = -6723991851130108797L;
        final WeakReference<Plugin> plugin;
        final PluginDescriptor descriptor;

        public PluginComponent(Plugin plugin) {
            super(true);
            this.plugin = new WeakReference<Plugin>(plugin);
            this.descriptor = plugin.getDescriptor();
            this.setLayout(new BoxLayout(this, 2));
            this.setBorder(BorderFactory.createEtchedBorder());
            ComponentUtil.setFixedHeight(this, 24);
            this.build();
        }

        private void build() {
            this.removeAll();
            ImageComponent image = new ImageComponent(this.descriptor.getIconAsImage());
            ComponentUtil.setFixedSize(image, new Dimension(20, 20));
            JLabel label = new JLabel(this.descriptor.getName());
            label.setToolTipText(this.descriptor.getName() + " " + this.descriptor.getVersion());
            IcyButton killButton = new IcyButton(new IcyIcon(ResourceUtil.ICON_CLOSE, 16));
            killButton.setFlat(true);
            killButton.setEnabled(false);
            killButton.setToolTipText("kill plugin");
            ComponentUtil.setFixedSize(killButton, new Dimension(18, 18));
            killButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                }
            });
            this.add(image);
            this.add(Box.createHorizontalStrut(4));
            this.add(label);
            this.add(Box.createHorizontalGlue());
            this.add(killButton);
            this.add(Box.createHorizontalStrut(2));
            this.refresh();
        }

        void refresh() {
            this.validate();
        }

        public Plugin getPlugin() {
            return (Plugin)this.plugin.get();
        }
    }
}

