/*
 * Decompiled with CFR 0.152.
 */
package icy.gui.plugin;

import icy.gui.component.renderer.CustomComboBoxRenderer;
import icy.plugin.PluginDescriptor;
import icy.plugin.PluginLoader;
import icy.resource.ResourceUtil;
import javax.swing.JComboBox;
import javax.swing.JList;

public class PluginComboBoxRenderer
extends CustomComboBoxRenderer {
    private static final long serialVersionUID = -8450810538242826922L;
    private final boolean showLabel;

    public PluginComboBoxRenderer(JComboBox combo, boolean showLabel) {
        super(combo);
        this.showLabel = showLabel;
    }

    @Override
    protected void updateItem(JList list, Object value) {
        if (value instanceof String) {
            PluginDescriptor plugin = PluginLoader.getPlugin((String)value);
            if (plugin != null) {
                this.setIcon(ResourceUtil.scaleIcon(plugin.getIcon(), 20));
                if (this.showLabel) {
                    this.setText(plugin.getName());
                } else {
                    this.setText("");
                }
                this.setToolTipText(plugin.getDescription());
            }
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
        } else {
            super.updateItem(list, value);
        }
    }
}

