/*
 * Decompiled with CFR 0.152.
 */
package icy.gui.util;

import icy.gui.frame.IcyFrame;
import icy.gui.util.FontUtil;
import icy.network.NetworkUtil;
import icy.system.SystemUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsDevice;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JSlider;
import javax.swing.JTextPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class ComponentUtil {
    public static void setPreferredWidth(Component c, int w) {
        c.setPreferredSize(new Dimension(w, c.getPreferredSize().height));
    }

    public static void setPreferredHeight(Component c, int h) {
        c.setPreferredSize(new Dimension(c.getPreferredSize().width, h));
    }

    public static void setFixedSize(Component c, Dimension d) {
        c.setMinimumSize(d);
        c.setMaximumSize(d);
        c.setPreferredSize(d);
    }

    public static void setFixedWidth(Component c, int w) {
        c.setMinimumSize(new Dimension(w, 0));
        c.setMaximumSize(new Dimension(w, 65535));
        c.setPreferredSize(new Dimension(w, c.getPreferredSize().height));
    }

    public static void setFixedHeight(Component c, int h) {
        c.setMinimumSize(new Dimension(0, h));
        c.setMaximumSize(new Dimension(65535, h));
        c.setPreferredSize(new Dimension(c.getPreferredSize().width, h));
    }

    public static void setPreferredWidth(IcyFrame frm, int w) {
        frm.setPreferredSize(new Dimension(w, frm.getPreferredSize().height));
    }

    public static void setPreferredHeight(IcyFrame frm, int h) {
        frm.setPreferredSize(new Dimension(frm.getPreferredSize().width, h));
    }

    public static void setFixedSize(IcyFrame frm, Dimension d) {
        frm.setMinimumSize(d);
        frm.setMaximumSize(d);
        frm.setPreferredSize(d);
    }

    public static void setFixedWidth(IcyFrame frm, int w) {
        frm.setMinimumSize(new Dimension(w, 0));
        frm.setMaximumSize(new Dimension(w, 65535));
        frm.setPreferredSize(new Dimension(w, frm.getPreferredSize().height));
    }

    public static void setFixedHeight(IcyFrame frm, int h) {
        frm.setMinimumSize(new Dimension(0, h));
        frm.setMaximumSize(new Dimension(65535, h));
        frm.setPreferredSize(new Dimension(frm.getPreferredSize().width, h));
    }

    public static void removeFixedSize(Component c) {
        c.setMinimumSize(new Dimension(0, 0));
        c.setMaximumSize(new Dimension(65535, 65535));
    }

    public static void center(Component comp) {
        Container parent = comp.getParent();
        if (parent != null) {
            int x = (parent.getWidth() - comp.getWidth()) / 2;
            int y = (parent.getHeight() - comp.getHeight()) / 2;
            comp.setLocation(x < 0 ? 0 : x, y < 0 ? 0 : y);
        }
    }

    public static void center(Window window) {
        window.setLocationRelativeTo(window.getParent());
    }

    public static void center(JInternalFrame frame) {
        ComponentUtil.center((Component)frame);
    }

    public static void centerOn(Window window, Point position) {
        int x = position.x - window.getWidth() / 2;
        int y = position.y - window.getHeight() / 2;
        window.setLocation(x < 0 ? 0 : x, y < 0 ? 0 : y);
    }

    public static void centerOn(JInternalFrame f, Point position) {
        ComponentUtil.centerOn((Component)f, position);
    }

    public static void centerOn(Component comp, Point position) {
        int x = position.x - comp.getWidth() / 2;
        int y = position.y - comp.getHeight() / 2;
        comp.setLocation(x < 0 ? 0 : x, y < 0 ? 0 : y);
    }

    @Deprecated
    public static void center(IcyFrame f) {
        f.center();
    }

    public static void center(Component dst, Component src) {
        dst.setLocation(src.getX() + (src.getWidth() - dst.getWidth()) / 2, src.getY() + (src.getHeight() - dst.getHeight()) / 2);
    }

    public static void center(IcyFrame dst, Component src) {
        dst.setLocation(src.getX() + (src.getWidth() - dst.getWidth()) / 2, src.getY() + (src.getHeight() - dst.getHeight()) / 2);
    }

    public static void center(Component dst, IcyFrame src) {
        dst.setLocation(src.getX() + (src.getWidth() - dst.getWidth()) / 2, src.getY() + (src.getHeight() - dst.getHeight()) / 2);
    }

    public static void center(IcyFrame dst, IcyFrame src) {
        dst.setLocation(src.getX() + (src.getWidth() - dst.getWidth()) / 2, src.getY() + (src.getHeight() - dst.getHeight()) / 2);
    }

    public static Point2D.Double getCenter(Component c) {
        if (c != null) {
            Rectangle r = c.getBounds();
            return new Point2D.Double(r.getX() + r.getWidth() / 2.0, r.getY() + r.getHeight() / 2.0);
        }
        return new Point2D.Double(0.0, 0.0);
    }

    public static List<GraphicsDevice> getScreens(Component c) {
        return SystemUtil.getScreenDevices(c.getBounds());
    }

    public static GraphicsDevice getScreen(Component c) {
        Point2D.Double pos2d = ComponentUtil.getCenter(c);
        Point pos = new Point((int)pos2d.getX(), (int)pos2d.getY());
        GraphicsDevice result = SystemUtil.getScreenDevice(pos);
        if (result == null) {
            result = SystemUtil.getScreenDevice(c.getBounds());
        }
        return result;
    }

    public static Point fixPosition(Rectangle wantedBounds, Rectangle screenBounds) {
        if (screenBounds.isEmpty()) {
            return null;
        }
        int margeX = 80;
        int margeY = 40;
        int x = wantedBounds.x;
        int y = wantedBounds.y;
        int sx = screenBounds.x;
        int sy = screenBounds.y;
        int minX = sx - wantedBounds.width + 80;
        int maxX = sx + screenBounds.width - 80;
        int minY = sy;
        int maxY = sy + screenBounds.height - 40;
        if (y < minY) {
            y = minY;
        } else if (y > maxY) {
            y = maxY;
        }
        if (x < minX) {
            x = minX;
        } else if (x > maxX) {
            x = maxX;
        }
        Point pos = wantedBounds.getLocation();
        if (pos.x != x || pos.y != y) {
            return new Point(x, y);
        }
        return null;
    }

    public static boolean fixPosition(Component component, Rectangle wantedBounds) {
        List<GraphicsDevice> screens = SystemUtil.getScreenDevices();
        if (screens.isEmpty()) {
            return false;
        }
        Point newPos = null;
        boolean useMainScreen = false;
        for (GraphicsDevice screen : screens) {
            Point pt = ComponentUtil.fixPosition(wantedBounds, SystemUtil.getScreenBounds(screen, true));
            if (pt == null) {
                return false;
            }
            if (newPos != null) {
                useMainScreen = true;
                continue;
            }
            newPos = pt;
        }
        if (useMainScreen) {
            newPos = ComponentUtil.fixPosition(wantedBounds, SystemUtil.getScreenBounds(ComponentUtil.getScreen(component), true));
        }
        if (newPos != null) {
            wantedBounds.setLocation(newPos);
            return true;
        }
        return false;
    }

    public static boolean fixPosition(Component component) {
        Rectangle bounds = component.getBounds();
        if (ComponentUtil.fixPosition(component, bounds)) {
            component.setBounds(bounds);
            return true;
        }
        return false;
    }

    public static int getComponentIndex(Component c) {
        Container container;
        if (c != null && (container = c.getParent()) != null) {
            for (int i = 0; i < container.getComponentCount(); ++i) {
                if (container.getComponent(i) != c) continue;
                return i;
            }
        }
        return -1;
    }

    public static Point convertPoint(Component src, Point p, Component dst) {
        return SwingUtilities.convertPoint(src, p, dst);
    }

    public static Point convertPointFromScreen(Point p, Component c) {
        Point result = new Point(p);
        SwingUtilities.convertPointFromScreen(result, c);
        return result;
    }

    public static Point convertPointToScreen(Point p, Component c) {
        Point result = new Point(p);
        SwingUtilities.convertPointToScreen(result, c);
        return result;
    }

    public static boolean isOutside(Component c, Rectangle r) {
        return !r.intersects(c.getBounds());
    }

    public static boolean isInside(Component c, Rectangle r) {
        return r.contains(c.getBounds());
    }

    public static void increaseFontSize(Component c, int value) {
        ComponentUtil.setFontSize(c, c.getFont().getSize() + value);
    }

    public static void decreaseFontSize(Component c, int value) {
        ComponentUtil.setFontSize(c, c.getFont().getSize() - value);
    }

    public static void setFontSize(Component c, int fontSize) {
        c.setFont(FontUtil.setSize(c.getFont(), fontSize));
    }

    public static void setFontStyle(Component c, int fontStyle) {
        c.setFont(FontUtil.setStyle(c.getFont(), fontStyle));
    }

    public static void setFontBold(Component c) {
        ComponentUtil.setFontStyle(c, c.getFont().getStyle() | 1);
    }

    public static void setJTextPaneFont(JTextPane tp, Font font, Color c) {
        MutableAttributeSet attrs = tp.getInputAttributes();
        StyleConstants.setFontFamily(attrs, font.getFamily());
        StyleConstants.setFontSize(attrs, font.getSize());
        StyleConstants.setItalic(attrs, (font.getStyle() & 2) != 0);
        StyleConstants.setBold(attrs, (font.getStyle() & 1) != 0);
        StyleConstants.setForeground(attrs, c);
        StyledDocument doc = tp.getStyledDocument();
        doc.setCharacterAttributes(0, doc.getLength() + 1, attrs, false);
    }

    public static void setTickMarkers(JSlider slider) {
        int min = slider.getMinimum();
        int max = slider.getMaximum();
        int delta = max - min;
        if (delta > 0) {
            int sliderSize = slider.getOrientation() == 0 ? slider.getPreferredSize().width : slider.getPreferredSize().height;
            int majTick = ComponentUtil.findBestMajTickSpace(sliderSize, delta);
            slider.setMinorTickSpacing(Math.max(1, majTick / 5));
            slider.setMajorTickSpacing(majTick);
            slider.setLabelTable(slider.createStandardLabels(slider.getMajorTickSpacing(), majTick));
        }
    }

    private static int findBestMajTickSpace(int sliderSize, int delta) {
        int[] values = new int[]{1, 2, 5, 10, 20, 25, 50, 100, 200, 250, 500, 1000, 2000, 2500, 5000};
        int wantedMajTickSpace = delta / (sliderSize / 40);
        int min = Integer.MAX_VALUE;
        int bestValue = 1;
        for (int value : values) {
            int dx = Math.abs(value - wantedMajTickSpace);
            if (dx >= min) continue;
            min = dx;
            bestValue = value;
        }
        return bestValue;
    }

    public static void split(JMenu menu, int maxItemsPerMenu) {
        ArrayList<Component> components = new ArrayList<Component>(Arrays.asList(menu.getPopupMenu().getComponents()));
        if (components.size() > maxItemsPerMenu) {
            menu.removeAll();
            JMenu currentMenu = menu;
            while (components.size() > 0) {
                int n = Math.min(components.size(), maxItemsPerMenu - 1);
                for (int i = 0; i < n; ++i) {
                    currentMenu.add(components.remove(0));
                }
                if (components.size() <= 0) continue;
                currentMenu = (JMenu)currentMenu.add(new JMenu("More..."));
            }
            if (components.size() > 0) {
                System.err.println(components.size() + " are remaining !!");
            }
        }
        for (Component component : menu.getPopupMenu().getComponents()) {
            if (!(component instanceof JMenu)) continue;
            ComponentUtil.split((JMenu)component, maxItemsPerMenu);
        }
    }

    public static TreePath buildTreePath(TreeNode node) {
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>();
        nodes.add(node);
        TreeNode n = node;
        while (n.getParent() != null) {
            n = n.getParent();
            nodes.add(n);
        }
        Collections.reverse(nodes);
        return new TreePath(nodes.toArray());
    }

    public static void expandAllTree(JTree tree) {
        for (int i = 0; i < tree.getRowCount(); ++i) {
            tree.expandRow(i);
        }
    }

    public static HyperlinkListener getDefaultHyperlinkListener() {
        return new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    NetworkUtil.openURL(e.getURL());
                }
            }
        };
    }

    public static boolean isMaximized(Frame f) {
        return (f.getExtendedState() & 6) == 6;
    }

    public static void setMaximized(Frame f, boolean b) {
        if (ComponentUtil.isMaximized(f) ^ b) {
            if (b) {
                f.setExtendedState(6);
            } else {
                f.setExtendedState(0);
            }
        }
    }

    public static boolean isMinimized(Frame f) {
        return (f.getExtendedState() & 1) == 1;
    }

    public static void setMinimized(Frame f, boolean b) {
        if (ComponentUtil.isMinimized(f) ^ b) {
            if (b) {
                f.setExtendedState(1);
            } else {
                f.setExtendedState(0);
            }
        }
    }
}

