/*
 * Decompiled with CFR 0.152.
 */
package icy.image.colormap;

public class FromRGBColorMap {
    public static final int COLORMAP_SIZE = 256;
    public static final int COLORMAP_MAX = 255;
    public final float[][] maps;

    public FromRGBColorMap(int numComponents) {
        this.maps = new float[numComponents][256];
        for (int comp = 0; comp < numComponents; ++comp) {
            for (int index = 0; index < 256; ++index) {
                this.maps[comp][index] = (float)index / 255.0f;
            }
        }
    }

    public float getFromRGBColor(int component, float rgbValue) {
        return this.maps[component][(int)(rgbValue * 255.0f)];
    }

    public float getFromRGBColor(int component, int rgbValue) {
        return this.maps[component][rgbValue];
    }

    public void setFromRGBColor(int component, float rgbValue, float value) {
        this.maps[component][(int)(rgbValue * 255.0f)] = value;
    }
}

