/*
 * Decompiled with CFR 0.152.
 */
package icy.imagej;

import icy.file.FileUtil;
import icy.gui.util.LookAndFeelUtil;
import icy.imagej.ImageJWrapper;
import icy.system.IcyExceptionHandler;
import icy.system.SystemUtil;
import icy.util.ColorUtil;
import icy.util.ReflectionUtil;
import ij.IJ;
import ij.gui.Toolbar;
import ij.plugin.MacroInstaller;
import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.MenuComponent;
import java.awt.PopupMenu;
import java.lang.reflect.Field;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JToolBar;
import org.pushingpixels.substance.api.skin.SkinChangeListener;

public class ToolbarWrapper
extends Toolbar {
    private static final long serialVersionUID = 6546185720732862969L;
    protected CustomToolBar swingComponent;
    private final SkinChangeListener skinChangeListener;
    Field grayField = null;
    Field brighterField = null;
    Field darkerField = null;
    Field evenDarkerField = null;
    Field toolColorField = null;

    public ToolbarWrapper(ImageJWrapper ijw) {
        if (this.swingComponent == null) {
            this.swingComponent = new CustomToolBar(0);
        }
        this.swingComponent.setMinimumSize(this.getMinimumSize());
        this.swingComponent.setPreferredSize(this.getPreferredSize());
        this.swingComponent.addKeyListener(ijw);
        this.swingComponent.addMouseListener(this);
        this.swingComponent.addMouseMotionListener(this);
        try {
            this.grayField = ReflectionUtil.getField(this.getClass(), "gray", true);
            this.brighterField = ReflectionUtil.getField(this.getClass(), "brighter", true);
            this.darkerField = ReflectionUtil.getField(this.getClass(), "darker", true);
            this.evenDarkerField = ReflectionUtil.getField(this.getClass(), "evenDarker", true);
            this.toolColorField = ReflectionUtil.getField(this.getClass(), "toolColor", true);
        }
        catch (Throwable t) {
            System.out.println("Warning: cannot access toolbar buttons from ImageJ");
        }
        this.skinChangeListener = new SkinChangeListener(){

            public void skinChanged() {
                Color bgCol = LookAndFeelUtil.getBackground(ToolbarWrapper.this.swingComponent);
                if (ColorUtil.getLuminance(bgCol) < 64) {
                    bgCol = ColorUtil.mix(bgCol, Color.gray);
                }
                Color brighterCol = ColorUtil.mix(bgCol, Color.white);
                Color darkerCol = ColorUtil.mix(bgCol, Color.black);
                Color evenDarkerCol = ColorUtil.mix(darkerCol, Color.black);
                if (ColorUtil.getLuminance(bgCol) < 128) {
                    brighterCol = ColorUtil.mix(bgCol, brighterCol);
                } else {
                    darkerCol = ColorUtil.mix(bgCol, darkerCol);
                    evenDarkerCol = ColorUtil.mix(darkerCol, evenDarkerCol);
                }
                if (ToolbarWrapper.this.grayField == null) {
                    System.out.println("Warning: cannot set background color of ImageJ toolbar.");
                }
                try {
                    if (ToolbarWrapper.this.grayField != null) {
                        ToolbarWrapper.this.grayField.set(ToolbarWrapper.this, bgCol);
                    }
                    if (ToolbarWrapper.this.brighterField != null) {
                        ToolbarWrapper.this.brighterField.set(ToolbarWrapper.this, brighterCol);
                    }
                    if (ToolbarWrapper.this.darkerField != null) {
                        ToolbarWrapper.this.darkerField.set(ToolbarWrapper.this, darkerCol);
                    }
                    if (ToolbarWrapper.this.evenDarkerField != null) {
                        ToolbarWrapper.this.evenDarkerField.set(ToolbarWrapper.this, evenDarkerCol);
                    }
                    if (ToolbarWrapper.this.toolColorField != null) {
                        ToolbarWrapper.this.toolColorField.set(ToolbarWrapper.this, LookAndFeelUtil.getForeground(ToolbarWrapper.this.swingComponent));
                    }
                    ToolbarWrapper.this.swingComponent.repaint();
                }
                catch (Exception e) {
                    IcyExceptionHandler.showErrorMessage(e, false);
                    System.err.println("Cannot hack background color of ImageJ toolbar.");
                }
            }
        };
        String file = IJ.getDirectory("macros") + "StartupMacros.txt";
        if (FileUtil.exists(file)) {
            new MacroInstaller().run(file);
        }
        LookAndFeelUtil.addSkinChangeListener(new LookAndFeelUtil.WeakSkinChangeListener(this.skinChangeListener));
    }

    @Override
    public Container getParent() {
        if (this.swingComponent == null) {
            return null;
        }
        return this.swingComponent.getParent();
    }

    public JToolBar getSwingComponent() {
        return this.swingComponent;
    }

    @Override
    public synchronized void add(PopupMenu popup) {
        if (this.swingComponent == null) {
            this.swingComponent = new CustomToolBar(0);
        }
        this.swingComponent.add(popup);
        this.swingComponent.repaint();
    }

    @Override
    public synchronized void remove(MenuComponent popup) {
        if (this.swingComponent == null) {
            this.swingComponent = new CustomToolBar(0);
        } else {
            this.swingComponent.remove(popup);
            this.swingComponent.repaint();
        }
    }

    @Override
    public Graphics getGraphics() {
        if (this.swingComponent == null) {
            return null;
        }
        return this.swingComponent.getGraphics();
    }

    @Override
    public void repaint() {
        super.repaint();
        this.swingComponent.repaint();
    }

    private class CustomToolBar
    extends JToolBar {
        private static final long serialVersionUID = -3278693015639517146L;

        public CustomToolBar(int orientation) {
            super(orientation);
            this.setBorder(BorderFactory.createEmptyBorder());
            this.setFloatable(false);
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            ToolbarWrapper.this.paint(g);
        }

        @Override
        public void removeNotify() {
            try {
                if (SystemUtil.isUnix()) {
                    Vector pp = (Vector)ReflectionUtil.getFieldObject(this, "popups", true);
                    pp.clear();
                }
            }
            catch (Exception e) {
                System.out.println("Warning: cannot remove toolbar buttons from ImageJ.");
            }
            super.removeNotify();
        }
    }
}

