/*
 * Decompiled with CFR 0.152.
 */
package icy.math;

import icy.math.Interpolator;
import icy.math.SmoothMover;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.Timer;

public class MultiSmoothMover
implements ActionListener {
    protected double[] currentValues;
    protected SmoothMover.SmoothMoveType type;
    protected int moveTime;
    protected final Timer timer;
    protected boolean[] moving;
    protected double[] destValues;
    protected double[][] stepValues;
    protected long[] startTime;
    protected final ArrayList<MultiSmoothMoverListener> listeners;

    public MultiSmoothMover(int size, SmoothMover.SmoothMoveType type) {
        this.currentValues = new double[size];
        this.moving = new boolean[size];
        this.destValues = new double[size];
        this.startTime = new long[size];
        this.type = type;
        this.timer = new Timer(16, this);
        this.timer.setInitialDelay(0);
        this.timer.setRepeats(true);
        this.timer.start();
        this.moveTime = 1000;
        this.stepValues = new double[size][0];
        this.listeners = new ArrayList();
    }

    public MultiSmoothMover(int size) {
        this(size, SmoothMover.SmoothMoveType.LINEAR);
    }

    public void moveTo(int index, double value) {
        if (this.destValues[index] != value) {
            this.destValues[index] = value;
            this.start(index, System.currentTimeMillis());
        }
    }

    public void moveTo(double[] values) {
        int maxInd = Math.min(values.length, this.destValues.length);
        boolean changed = false;
        for (int index = 0; index < maxInd; ++index) {
            if (this.destValues[index] == values[index]) continue;
            changed = true;
            break;
        }
        if (changed) {
            long time = System.currentTimeMillis();
            for (int index = 0; index < maxInd; ++index) {
                this.destValues[index] = values[index];
                this.start(index, time);
            }
        }
    }

    public boolean isMoving(int index) {
        return this.moving[index];
    }

    public boolean isMoving() {
        for (boolean b : this.moving) {
            if (!b) continue;
            return true;
        }
        return false;
    }

    protected void start(int index, long time) {
        double current = this.currentValues[index];
        double dest = this.destValues[index];
        int size = Math.max(this.moveTime / this.timer.getDelay(), 1);
        switch (this.type) {
            case NONE: {
                this.stepValues[index] = new double[2];
                this.stepValues[index][0] = current;
                this.stepValues[index][1] = dest;
                break;
            }
            case LINEAR: {
                this.stepValues[index] = Interpolator.doLinearInterpolation(current, dest, size);
                break;
            }
            case LOG: {
                this.stepValues[index] = Interpolator.doLogInterpolation(current, dest, size);
                break;
            }
            case EXP: {
                this.stepValues[index] = Interpolator.doExpInterpolation(current, dest, size);
            }
        }
        if (!this.isMoving(index)) {
            this.moveStarted(index, time);
            this.moving[index] = true;
        } else {
            this.moveModified(index, time);
        }
    }

    public void stop(int index) {
        if (this.isMoving(index)) {
            this.moving[index] = false;
            this.moveEnded(index);
        }
    }

    public void stopAll() {
        for (int index = 0; index < this.moving.length; ++index) {
            if (!this.moving[index]) continue;
            this.moveEnded(index);
        }
    }

    public void shutDown() {
        this.timer.stop();
        this.timer.removeActionListener(this);
        this.listeners.clear();
    }

    public int getUpdateDelay() {
        return this.timer.getDelay();
    }

    public void setUpdateDelay(int updateDelay) {
        this.timer.setDelay(updateDelay);
    }

    public SmoothMover.SmoothMoveType getType() {
        return this.type;
    }

    public void setType(SmoothMover.SmoothMoveType type) {
        this.type = type;
    }

    public int getMoveTime() {
        return this.moveTime;
    }

    public void setMoveTime(int moveTime) {
        this.moveTime = Math.max(moveTime, 1);
    }

    public void setValue(int index, double value) {
        this.stop(index);
        this.destValues[index] = value;
        this.setCurrentValue(index, value, 100);
    }

    public void setValues(double[] values) {
        int maxInd = Math.min(values.length, this.destValues.length);
        for (int index = 0; index < maxInd; ++index) {
            double value = values[index];
            this.stop(index);
            this.destValues[index] = value;
            this.setCurrentValue(index, value, 100);
        }
    }

    public double getValue(int index) {
        return this.currentValues[index];
    }

    public double getDestValue(int index) {
        return this.destValues[index];
    }

    protected void updateCurrentValue(int index, long time) {
        int elapsedMsTime = (int)(time - this.startTime[index]);
        if (this.type == SmoothMover.SmoothMoveType.NONE || elapsedMsTime >= this.moveTime) {
            this.setCurrentValue(index, this.destValues[index], 100);
            this.stop(index);
        } else {
            int len = this.stepValues[index].length;
            int ind = Math.min(elapsedMsTime * len / this.moveTime, len - 2) + 1;
            if (ind >= 0 && ind < this.stepValues[index].length) {
                this.setCurrentValue(index, this.stepValues[index][ind], elapsedMsTime * 100 / this.moveTime);
            }
        }
    }

    protected void setCurrentValue(int index, double value, int pourcent) {
        if (this.currentValues[index] != value) {
            this.currentValues[index] = value;
            this.changed(index, value, pourcent);
        }
    }

    public void addListener(MultiSmoothMoverListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(MultiSmoothMoverListener listener) {
        this.listeners.remove(listener);
    }

    protected void moveStarted(int index, long time) {
        this.startTime[index] = time;
        for (MultiSmoothMoverListener listener : this.listeners) {
            listener.moveStarted(this, index, this.currentValues[index], this.destValues[index]);
        }
    }

    protected void moveModified(int index, long time) {
        this.startTime[index] = time;
        for (MultiSmoothMoverListener listener : this.listeners) {
            listener.moveModified(this, index, this.currentValues[index], this.destValues[index]);
        }
    }

    protected void moveEnded(int index) {
        for (MultiSmoothMoverListener listener : this.listeners) {
            listener.moveEnded(this, index, this.currentValues[index]);
        }
    }

    protected void changed(int index, double newValue, int pourcent) {
        for (MultiSmoothMoverListener listener : this.listeners) {
            listener.valueChanged(this, index, newValue, pourcent);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        long time = System.currentTimeMillis();
        for (int index = 0; index < this.moving.length; ++index) {
            if (!this.moving[index]) continue;
            this.updateCurrentValue(index, time);
        }
    }

    public static interface MultiSmoothMoverListener {
        public void moveStarted(MultiSmoothMover var1, int var2, double var3, double var5);

        public void moveModified(MultiSmoothMover var1, int var2, double var3, double var5);

        public void moveEnded(MultiSmoothMover var1, int var2, double var3);

        public void valueChanged(MultiSmoothMover var1, int var2, double var3, int var5);
    }

    public static class MultiSmoothMoverAdapter
    implements MultiSmoothMoverListener {
        @Override
        public void moveStarted(MultiSmoothMover source, int index, double start, double end) {
        }

        @Override
        public void moveModified(MultiSmoothMover source, int index, double start, double end) {
        }

        @Override
        public void moveEnded(MultiSmoothMover source, int index, double value) {
        }

        @Override
        public void valueChanged(MultiSmoothMover source, int index, double newValue, int pourcent) {
        }
    }
}

