/*
 * Decompiled with CFR 0.152.
 */
package icy.math;

import icy.common.CollapsibleEvent;
import icy.common.UpdateEventHandler;
import icy.common.listener.ChangeListener;
import icy.file.xml.XMLPersistent;
import icy.math.ScalerEvent;
import icy.math.ScalerListener;
import icy.type.TypeUtil;
import icy.type.collection.array.ArrayUtil;
import icy.util.XMLUtil;
import javax.swing.event.EventListenerList;
import org.w3c.dom.Node;

public class Scaler
implements ChangeListener,
XMLPersistent {
    private static final String ID_ABSLEFTIN = "absleftin";
    private static final String ID_ABSRIGHTIN = "absrightin";
    private static final String ID_LEFTIN = "leftin";
    private static final String ID_RIGHTIN = "rightin";
    private static final String ID_LEFTOUT = "leftout";
    private static final String ID_RIGHTOUT = "rightout";
    private static final String ID_INTEGERDATA = "integerdata";
    private static final String ID_CANCROSS = "cancross";
    private double absLeftIn;
    private double absRightIn;
    private double leftIn;
    private double rightIn;
    private double leftOut;
    private double rightOut;
    private double scaler;
    private double unscaler;
    private boolean integerData;
    private boolean canCross;
    private boolean crossed;
    public double[] scaleLK;
    private final EventListenerList listeners;
    private final UpdateEventHandler updater;

    public static int indexOf(Scaler[] scalers, Scaler scaler) {
        for (int i = 0; i < scalers.length; ++i) {
            if (!scalers[i].equals(scaler)) continue;
            return i;
        }
        return -1;
    }

    public static boolean contains(Scaler[] scalers, Scaler scaler) {
        return Scaler.indexOf(scalers, scaler) != -1;
    }

    public Scaler(double leftIn, double rightIn, double leftOut, double rightOut, boolean integerData) {
        this(leftIn, rightIn, leftIn, rightIn, leftOut, rightOut, integerData, false);
    }

    public Scaler(double leftIn, double rightIn, double leftOut, double rightOut, boolean integerData, boolean canCross) {
        this(leftIn, rightIn, leftIn, rightIn, leftOut, rightOut, integerData, canCross);
    }

    public Scaler(double absLeftIn, double absRightIn, double leftIn, double rightIn, double leftOut, double rightOut, boolean integerData, boolean canCross) {
        this.absLeftIn = absLeftIn;
        this.absRightIn = absRightIn;
        this.leftIn = leftIn;
        this.rightIn = rightIn;
        this.leftOut = leftOut;
        this.rightOut = rightOut;
        this.integerData = integerData;
        this.canCross = canCross;
        boolean bl = this.crossed = absLeftIn > absRightIn;
        if (this.crossed && !canCross) {
            throw new IllegalArgumentException("Can't create scaler : left > right and canCross = false");
        }
        this.listeners = new EventListenerList();
        this.updater = new UpdateEventHandler(this, false);
        this.updateScaler(false);
    }

    private void updateLookup() {
        this.scaleLK = null;
        if (this.integerData) {
            boolean rangeOk;
            if (this.crossed) {
                rangeOk = this.absLeftIn <= 65535.0 && this.absRightIn >= 0.0;
            } else {
                boolean bl = rangeOk = this.absLeftIn >= 0.0 && this.absRightIn <= 65535.0;
            }
            if (rangeOk) {
                int len = this.crossed ? (int)this.absRightIn : (int)this.absLeftIn;
                this.scaleLK = new double[len];
                for (int i = 0; i < len; ++i) {
                    this.scaleLK[i] = this.scale(i);
                }
            }
        }
    }

    private void updateScaler(boolean notify) {
        double deltaIn = this.rightIn - this.leftIn;
        double deltaOut = this.rightOut - this.leftOut;
        if (deltaIn == 0.0 || deltaOut == 0.0) {
            this.scaler = 1.0;
        } else {
            this.scaler = deltaOut / deltaIn;
            this.unscaler = deltaIn / deltaOut;
        }
        this.updateLookup();
        if (notify) {
            this.changed();
        }
    }

    private void checkBounds() {
        double l = this.leftIn;
        double r = this.rightIn;
        if (this.crossed) {
            if (l > this.absLeftIn && r > (l = this.absLeftIn)) {
                r = l - (double)1.4E-45f;
            }
            if (r < this.absRightIn && l < (r = this.absRightIn)) {
                l = r + (double)1.4E-45f;
            }
        } else {
            if (l < this.absLeftIn && r < (l = this.absLeftIn)) {
                r = l + (double)1.4E-45f;
            }
            if (r > this.absRightIn && l > (r = this.absRightIn)) {
                l = r - (double)1.4E-45f;
            }
        }
        this.leftIn = l;
        this.rightIn = r;
    }

    private void setLeftRight(double left, double right, ScalerRange range, boolean leftPrio) {
        double l = left;
        double r = right;
        if (!this.canCross && l > r) {
            if (leftPrio) {
                r = l + (double)1.4E-45f;
            } else {
                l = r - (double)1.4E-45f;
            }
        }
        switch (range.ordinal()) {
            case 0: {
                if (this.absLeftIn == l && this.absRightIn == r) {
                    return;
                }
                this.crossed = l > r;
                this.absLeftIn = l;
                this.absRightIn = r;
                this.checkBounds();
                break;
            }
            case 1: {
                if (this.leftIn == l && this.rightIn == r) {
                    return;
                }
                this.leftIn = l;
                this.rightIn = r;
                this.checkBounds();
                break;
            }
            case 2: {
                if (this.leftOut == l && this.rightOut == r) {
                    return;
                }
                this.leftOut = l;
                this.rightOut = r;
            }
        }
        this.updateScaler(true);
    }

    public double scale(double value) {
        if (this.crossed) {
            if (value >= this.leftIn) {
                return this.leftOut;
            }
            if (value <= this.rightIn) {
                return this.rightOut;
            }
            return (value - this.leftIn) * this.scaler + this.leftOut;
        }
        if (value <= this.leftIn) {
            return this.leftOut;
        }
        if (value >= this.rightIn) {
            return this.rightOut;
        }
        return (value - this.leftIn) * this.scaler + this.leftOut;
    }

    public double unscale(double value) {
        if (this.crossed) {
            if (value >= this.leftOut) {
                return this.leftIn;
            }
            if (value <= this.rightOut) {
                return this.rightIn;
            }
            return (value - this.leftOut) * this.unscaler + this.leftIn;
        }
        if (value <= this.leftOut) {
            return this.leftIn;
        }
        if (value >= this.rightOut) {
            return this.rightIn;
        }
        return (value - this.leftOut) * this.unscaler + this.leftIn;
    }

    public void scale(Object src, int srcOffset, int[] dest, int destOffset, int len, boolean signed) {
        if (src == null || dest == null) {
            throw new IllegalArgumentException("Parameters 'src' and 'dest' should not be null !");
        }
        switch (ArrayUtil.getDataType(src)) {
            case BYTE: {
                this.scale((byte[])src, srcOffset, dest, destOffset, len, signed);
                break;
            }
            case SHORT: {
                this.scale((short[])src, srcOffset, dest, destOffset, len, signed);
                break;
            }
            case INT: {
                this.scale((int[])src, srcOffset, dest, destOffset, len, signed);
                break;
            }
            case LONG: {
                this.scale((long[])src, srcOffset, dest, destOffset, len, signed);
                break;
            }
            case FLOAT: {
                this.scale((float[])src, srcOffset, dest, destOffset, len);
                break;
            }
            case DOUBLE: {
                this.scale((double[])src, srcOffset, dest, destOffset, len);
            }
        }
    }

    public void scale(byte[] src, int srcOffset, int[] dest, int destOffset, int len, boolean signed) {
        if (src == null || dest == null) {
            throw new IllegalArgumentException("Parameters 'src' and 'dest' should not be null !");
        }
        if (signed) {
            for (int i = 0; i < len; ++i) {
                dest[destOffset + i] = (int)this.scale(src[srcOffset + i]);
            }
        } else {
            for (int i = 0; i < len; ++i) {
                dest[destOffset + i] = (int)this.scale(TypeUtil.unsign(src[srcOffset + i]));
            }
        }
    }

    public void scale(short[] src, int srcOffset, int[] dest, int destOffset, int len, boolean signed) {
        if (src == null || dest == null) {
            throw new IllegalArgumentException("Parameters 'src' and 'dest' should not be null !");
        }
        if (signed) {
            for (int i = 0; i < len; ++i) {
                dest[destOffset + i] = (int)this.scale(src[srcOffset + i]);
            }
        } else {
            for (int i = 0; i < len; ++i) {
                dest[destOffset + i] = (int)this.scale(TypeUtil.unsign(src[srcOffset + i]));
            }
        }
    }

    public void scale(int[] src, int srcOffset, int[] dest, int destOffset, int len, boolean signed) {
        if (src == null || dest == null) {
            throw new IllegalArgumentException("Parameters 'src' and 'dest' should not be null !");
        }
        if (signed) {
            for (int i = 0; i < len; ++i) {
                dest[destOffset + i] = (int)this.scale(src[srcOffset + i]);
            }
        } else {
            for (int i = 0; i < len; ++i) {
                dest[destOffset + i] = (int)this.scale(TypeUtil.unsign(src[srcOffset + i]));
            }
        }
    }

    public void scale(long[] src, int srcOffset, int[] dest, int destOffset, int len, boolean signed) {
        if (src == null || dest == null) {
            throw new IllegalArgumentException("Parameters 'src' and 'dest' should not be null !");
        }
        if (signed) {
            for (int i = 0; i < len; ++i) {
                dest[destOffset + i] = (int)this.scale(src[srcOffset + i]);
            }
        } else {
            for (int i = 0; i < len; ++i) {
                dest[destOffset + i] = (int)this.scale(TypeUtil.unsign(src[srcOffset + i]));
            }
        }
    }

    public void scale(float[] src, int srcOffset, int[] dest, int destOffset, int len) {
        if (src == null || dest == null) {
            throw new IllegalArgumentException("Parameters 'src' and 'dest' should not be null !");
        }
        for (int i = 0; i < len; ++i) {
            dest[destOffset + i] = (int)this.scale(src[srcOffset + i]);
        }
    }

    public void scale(double[] src, int srcOffset, int[] dest, int destOffset, int len) {
        if (src == null || dest == null) {
            throw new IllegalArgumentException("Parameters 'src' and 'dest' should not be null !");
        }
        for (int i = 0; i < len; ++i) {
            dest[destOffset + i] = (int)this.scale(src[srcOffset + i]);
        }
    }

    public void scale(byte[] src, int srcOffset, double[] dest, int destOffset, int len, boolean signed) {
        if (src == null || dest == null) {
            throw new IllegalArgumentException("Parameters 'src' and 'dest' should not be null !");
        }
        if (signed) {
            for (int i = 0; i < len; ++i) {
                dest[destOffset + i] = this.scale(src[srcOffset + i]);
            }
        } else {
            for (int i = 0; i < len; ++i) {
                dest[destOffset + i] = this.scale(TypeUtil.unsign(src[srcOffset + i]));
            }
        }
    }

    public void scale(short[] src, int srcOffset, double[] dest, int destOffset, int len, boolean signed) {
        if (src == null || dest == null) {
            throw new IllegalArgumentException("Parameters 'src' and 'dest' should not be null !");
        }
        if (signed) {
            for (int i = 0; i < len; ++i) {
                dest[destOffset + i] = this.scale(src[srcOffset + i]);
            }
        } else {
            for (int i = 0; i < len; ++i) {
                dest[destOffset + i] = this.scale(TypeUtil.unsign(src[srcOffset + i]));
            }
        }
    }

    public void scale(int[] src, int srcOffset, double[] dest, int destOffset, int len, boolean signed) {
        if (src == null || dest == null) {
            throw new IllegalArgumentException("Parameters 'src' and 'dest' should not be null !");
        }
        if (signed) {
            for (int i = 0; i < len; ++i) {
                dest[destOffset + i] = this.scale(src[srcOffset + i]);
            }
        } else {
            for (int i = 0; i < len; ++i) {
                dest[destOffset + i] = this.scale(TypeUtil.unsign(src[srcOffset + i]));
            }
        }
    }

    public void scale(long[] src, int srcOffset, double[] dest, int destOffset, int len, boolean signed) {
        if (src == null || dest == null) {
            throw new IllegalArgumentException("Parameters 'src' and 'dest' should not be null !");
        }
        if (signed) {
            for (int i = 0; i < len; ++i) {
                dest[destOffset + i] = this.scale(src[srcOffset + i]);
            }
        } else {
            for (int i = 0; i < len; ++i) {
                dest[destOffset + i] = this.scale(TypeUtil.unsign(src[srcOffset + i]));
            }
        }
    }

    public void scale(float[] src, int srcOffset, double[] dest, int destOffset, int len) {
        if (src == null || dest == null) {
            throw new IllegalArgumentException("Parameters 'src' and 'dest' should not be null !");
        }
        for (int i = 0; i < len; ++i) {
            dest[destOffset + i] = this.scale(src[srcOffset + i]);
        }
    }

    public void scale(double[] src, int srcOffset, double[] dest, int destOffset, int len) {
        if (src == null || dest == null) {
            throw new IllegalArgumentException("Parameters 'src' and 'dest' should not be null !");
        }
        for (int i = 0; i < len; ++i) {
            dest[destOffset + i] = this.scale(src[srcOffset + i]);
        }
    }

    public void scale(float[] data, int offset, int len) {
        if (data == null) {
            throw new IllegalArgumentException("Parameters 'data' should not be null !");
        }
        for (int i = 0; i < len; ++i) {
            data[offset + i] = (float)this.scale(data[i]);
        }
    }

    public void scale(double[] data, int offset, int len) {
        if (data == null) {
            throw new IllegalArgumentException("Parameters 'data' should not be null !");
        }
        for (int i = 0; i < len; ++i) {
            data[offset + i] = this.scale(data[i]);
        }
    }

    public void scale(Object src, int[] dest, boolean signed) {
        this.scale(src, 0, dest, 0, ArrayUtil.getTotalLength(src), signed);
    }

    public void scale(byte[] src, int[] dest, boolean signed) {
        this.scale(src, 0, dest, 0, ArrayUtil.getTotalLength(src), signed);
    }

    public void scale(short[] src, int[] dest, boolean signed) {
        this.scale(src, 0, dest, 0, ArrayUtil.getTotalLength(src), signed);
    }

    public void scale(int[] src, int[] dest, boolean signed) {
        this.scale(src, 0, dest, 0, ArrayUtil.getTotalLength(src), signed);
    }

    public void scale(float[] src, int[] dest) {
        this.scale(src, 0, dest, 0, ArrayUtil.getTotalLength(src));
    }

    public void scale(double[] src, int[] dest) {
        this.scale(src, 0, dest, 0, ArrayUtil.getTotalLength(src));
    }

    public void scale(byte[] src, double[] dest, boolean signed) {
        this.scale(src, 0, dest, 0, ArrayUtil.getTotalLength(src), signed);
    }

    public void scale(short[] src, double[] dest, boolean signed) {
        this.scale(src, 0, dest, 0, ArrayUtil.getTotalLength(src), signed);
    }

    public void scale(int[] src, double[] dest, boolean signed) {
        this.scale(src, 0, dest, 0, ArrayUtil.getTotalLength(src), signed);
    }

    public void scale(float[] src, double[] dest) {
        this.scale(src, 0, dest, 0, ArrayUtil.getTotalLength(src));
    }

    public void scale(double[] src, double[] dest) {
        this.scale(src, 0, dest, 0, ArrayUtil.getTotalLength(src));
    }

    public void scale(float[] data) {
        this.scale(data, 0, data.length);
    }

    public void scale(double[] data) {
        this.scale(data, 0, data.length);
    }

    public double getScaler() {
        return this.scaler;
    }

    public boolean isIntegerData() {
        return this.integerData;
    }

    public boolean isCrossed() {
        return this.crossed;
    }

    public boolean isNull() {
        return this.leftIn == this.leftOut && this.rightIn == this.rightOut;
    }

    public boolean getCanCross() {
        return this.canCross;
    }

    public void setCanCross(boolean canCross) {
        if (this.canCross != canCross) {
            if (!canCross && this.crossed) {
                double ali = this.absLeftIn;
                double ari = this.absRightIn;
                double li = this.leftIn;
                double ri = this.rightIn;
                this.setLeftRight(ari, ali, ScalerRange.SR_ABSIN, true);
                this.setLeftRight(ri, li, ScalerRange.SR_IN, true);
            }
            this.canCross = canCross;
        }
    }

    public double getAbsLeftIn() {
        return this.absLeftIn;
    }

    public void setAbsLeftIn(double absLeftIn) {
        this.setLeftRight(absLeftIn, this.absRightIn, ScalerRange.SR_ABSIN, true);
    }

    public double getAbsRightIn() {
        return this.absRightIn;
    }

    public void setAbsRightIn(double absRightIn) {
        this.setLeftRight(this.absLeftIn, absRightIn, ScalerRange.SR_ABSIN, false);
    }

    public double getLeftIn() {
        return this.leftIn;
    }

    public void setLeftIn(double leftIn) {
        this.setLeftRight(leftIn, this.rightIn, ScalerRange.SR_IN, true);
    }

    public double getRightIn() {
        return this.rightIn;
    }

    public void setRightIn(double rightIn) {
        this.setLeftRight(this.leftIn, rightIn, ScalerRange.SR_IN, false);
    }

    public double getLeftOut() {
        return this.leftOut;
    }

    public void setLeftOut(double leftOut) {
        this.setLeftRight(leftOut, this.rightOut, ScalerRange.SR_OUT, true);
    }

    public double getRightOut() {
        return this.rightOut;
    }

    public void setRightOut(double rightOut) {
        this.setLeftRight(this.leftOut, rightOut, ScalerRange.SR_OUT, false);
    }

    public void setAbsLeftRightIn(double left, double right) {
        this.setLeftRight(left, right, ScalerRange.SR_ABSIN, false);
    }

    public void setLeftRightIn(double left, double right) {
        this.setLeftRight(left, right, ScalerRange.SR_IN, false);
    }

    public void setLeftRightOut(double left, double right) {
        this.setLeftRight(left, right, ScalerRange.SR_OUT, false);
    }

    public void fireEvent(ScalerEvent e) {
        for (ScalerListener listener : (ScalerListener[])this.listeners.getListeners(ScalerListener.class)) {
            listener.scalerChanged(e);
        }
    }

    public void addListener(ScalerListener listener) {
        this.listeners.add(ScalerListener.class, listener);
    }

    public void removeListener(ScalerListener listener) {
        this.listeners.remove(ScalerListener.class, listener);
    }

    @Override
    public void onChanged(CollapsibleEvent compare) {
        ScalerEvent event = (ScalerEvent)compare;
        this.fireEvent(event);
    }

    private void changed() {
        this.updater.changed(new ScalerEvent(this));
    }

    public void beginUpdate() {
        this.updater.beginUpdate();
    }

    public void endUpdate() {
        this.updater.endUpdate();
    }

    public boolean isUpdating() {
        return this.updater.isUpdating();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean loadFromXML(Node node) {
        if (node == null) {
            return false;
        }
        this.beginUpdate();
        try {
            this.setCanCross(XMLUtil.getElementBooleanValue(node, ID_CANCROSS, false));
            this.integerData = XMLUtil.getElementBooleanValue(node, ID_INTEGERDATA, false);
            double l = XMLUtil.getElementDoubleValue(node, ID_ABSLEFTIN, 0.0);
            double r = XMLUtil.getElementDoubleValue(node, ID_ABSRIGHTIN, 0.0);
            this.setLeftRight(l, r, ScalerRange.SR_ABSIN, true);
            l = XMLUtil.getElementDoubleValue(node, ID_LEFTIN, 0.0);
            r = XMLUtil.getElementDoubleValue(node, ID_RIGHTIN, 0.0);
            this.setLeftRight(l, r, ScalerRange.SR_IN, true);
            l = XMLUtil.getElementDoubleValue(node, ID_LEFTOUT, 0.0);
            r = XMLUtil.getElementDoubleValue(node, ID_RIGHTOUT, 0.0);
            this.setLeftRight(l, r, ScalerRange.SR_OUT, true);
        }
        finally {
            this.endUpdate();
        }
        return true;
    }

    @Override
    public boolean saveToXML(Node node) {
        if (node == null) {
            return false;
        }
        XMLUtil.setElementBooleanValue(node, ID_CANCROSS, this.getCanCross());
        XMLUtil.setElementBooleanValue(node, ID_INTEGERDATA, this.isIntegerData());
        XMLUtil.setElementDoubleValue(node, ID_ABSLEFTIN, this.getAbsLeftIn());
        XMLUtil.setElementDoubleValue(node, ID_ABSRIGHTIN, this.getAbsRightIn());
        XMLUtil.setElementDoubleValue(node, ID_LEFTIN, this.getLeftIn());
        XMLUtil.setElementDoubleValue(node, ID_RIGHTIN, this.getRightIn());
        XMLUtil.setElementDoubleValue(node, ID_LEFTOUT, this.getLeftOut());
        XMLUtil.setElementDoubleValue(node, ID_RIGHTOUT, this.getRightOut());
        return true;
    }

    private static enum ScalerRange {
        SR_ABSIN,
        SR_IN,
        SR_OUT;

    }
}

