/*
 * Decompiled with CFR 0.152.
 */
package icy.preferences;

import icy.preferences.ApplicationPreferences;
import icy.preferences.XMLPreferences;
import java.util.ArrayList;

public class PluginPreferences {
    private static final String PREF_ID = "plugin";
    private static final String ID_ALLOW_BETA = "allowBeta";
    private static final String ID_AUTO_UPDATE = "autoUpdate";
    private static final String ID_INACTIVES_DAEMON = "inactivesdaemon";
    private static XMLPreferences preferences;

    public static void load() {
        preferences = ApplicationPreferences.getPreferences().node(PREF_ID);
    }

    public static XMLPreferences getPreferences() {
        return preferences;
    }

    public static boolean getAutomaticUpdate() {
        return preferences.getBoolean(ID_AUTO_UPDATE, true);
    }

    public static boolean getAllowBeta() {
        return preferences.getBoolean(ID_ALLOW_BETA, false);
    }

    public static ArrayList<String> getInactiveDaemons() {
        ArrayList<String> result = new ArrayList<String>();
        if (preferences.nodeExists(ID_INACTIVES_DAEMON)) {
            XMLPreferences node = preferences.node(ID_INACTIVES_DAEMON);
            for (String name : node.keys()) {
                if (!node.getBoolean(name, false)) continue;
                result.add(name);
            }
        }
        return result;
    }

    public static void setAutomaticUpdate(boolean value) {
        preferences.putBoolean(ID_AUTO_UPDATE, value);
    }

    public static void setAllowBeta(boolean value) {
        preferences.putBoolean(ID_ALLOW_BETA, value);
    }

    public static void setInactiveDaemons(ArrayList<String> names) {
        ArrayList<String> inactives = PluginPreferences.getInactiveDaemons();
        if (inactives.size() == names.size() && inactives.containsAll(names)) {
            return;
        }
        XMLPreferences node = preferences.node(ID_INACTIVES_DAEMON);
        node.clear();
        for (String name : names) {
            node.putBoolean(name, true);
        }
        node.clean();
    }
}

