/*
 * Decompiled with CFR 0.152.
 */
package icy.roi;

import icy.canvas.IcyCanvas;
import icy.canvas.IcyCanvas2D;
import icy.canvas.IcyCanvas3D;
import icy.gui.util.FontUtil;
import icy.preferences.GeneralPreferences;
import icy.roi.BooleanMask2D;
import icy.roi.ROI;
import icy.roi.ROIUtil;
import icy.roi.edit.PositionROIEdit;
import icy.sequence.Sequence;
import icy.type.point.Point5D;
import icy.type.rectangle.Rectangle5D;
import icy.util.EventUtil;
import icy.util.GraphicsUtil;
import icy.util.ShapeUtil;
import icy.util.XMLUtil;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Node;
import plugins.kernel.roi.roi2d.ROI2DArea;

public abstract class ROI2D
extends ROI {
    public static final String ID_Z = "z";
    public static final String ID_T = "t";
    public static final String ID_C = "c";
    protected int z = -1;
    protected int t = -1;
    protected int c = -1;

    public static List<ROI2D> getROI2DList(List<ROI> rois) {
        ArrayList<ROI2D> result = new ArrayList<ROI2D>();
        for (ROI roi : rois) {
            if (!(roi instanceof ROI2D)) continue;
            result.add((ROI2D)roi);
        }
        return result;
    }

    @Deprecated
    public static ArrayList<ROI2D> getROI2DList(ArrayList<ROI> rois) {
        ArrayList<ROI2D> result = new ArrayList<ROI2D>();
        for (ROI roi : rois) {
            if (!(roi instanceof ROI2D)) continue;
            result.add((ROI2D)roi);
        }
        return result;
    }

    @Deprecated
    public static ROI2D[] getROI2DList(ROI[] rois) {
        ArrayList<ROI2D> result = new ArrayList<ROI2D>();
        for (ROI roi : rois) {
            if (!(roi instanceof ROI2D)) continue;
            result.add((ROI2D)roi);
        }
        return result.toArray(new ROI2D[result.size()]);
    }

    @Deprecated
    public static ROI2D merge(ROI2D[] rois, ShapeUtil.ShapeOperation operation) throws UnsupportedOperationException, InterruptedException {
        ArrayList<ROI2D> list = new ArrayList<ROI2D>();
        for (ROI2D roi2d : rois) {
            list.add(roi2d);
        }
        return (ROI2D)ROIUtil.merge(list, operation.getBooleanOperator());
    }

    @Deprecated
    public static ROI2D substract(ROI2D roi1, ROI2D roi2) throws InterruptedException {
        return ROI2D.subtract(roi1, roi2);
    }

    @Deprecated
    public static ROI2D subtract(ROI2D roi1, ROI2D roi2) throws InterruptedException {
        ROI result = roi1.getSubtraction(roi2);
        if (result instanceof ROI2D) {
            return (ROI2D)result;
        }
        result = new ROI2DArea(BooleanMask2D.getSubtraction(roi1.getBooleanMask(true), roi2.getBooleanMask(true)));
        result.setName("Subtraction");
        return (ROI2D)result;
    }

    @Override
    public String getDefaultName() {
        return "ROI2D";
    }

    @Override
    public final int getDimension() {
        return 2;
    }

    public int getZ() {
        return this.z;
    }

    public void setZ(int value) {
        int v = value == Integer.MIN_VALUE ? -1 : value;
        if (this.z != v) {
            this.z = v;
            this.roiChanged(false);
        }
    }

    public int getT() {
        return this.t;
    }

    public void setT(int value) {
        int v = value == Integer.MIN_VALUE ? -1 : value;
        if (this.t != v) {
            this.t = v;
            this.roiChanged(false);
        }
    }

    public int getC() {
        return this.c;
    }

    public void setC(int value) {
        int v = value == Integer.MIN_VALUE ? -1 : value;
        if (this.c != v) {
            this.c = v;
            this.roiChanged(false);
        }
    }

    @Override
    public boolean isActiveFor(IcyCanvas canvas) {
        return this.isActiveFor(canvas.getPositionZ(), canvas.getPositionT(), canvas.getPositionC());
    }

    public boolean isActiveFor(int z, int t, int c) {
        return !(this.getZ() != -1 && z != -1 && this.getZ() != z || this.getT() != -1 && t != -1 && this.getT() != t || this.getC() != -1 && c != -1 && this.getC() != c);
    }

    @Deprecated
    public boolean isOver(IcyCanvas canvas, Point2D p) {
        return this.isOverEdge(canvas, p.getX(), p.getY());
    }

    @Deprecated
    public boolean isOver(IcyCanvas canvas, double x, double y) {
        return this.isOverEdge(canvas, x, y);
    }

    public boolean isOverEdge(IcyCanvas canvas, Point2D p) {
        return this.isOverEdge(canvas, p.getX(), p.getY());
    }

    public abstract boolean isOverEdge(IcyCanvas var1, double var2, double var4);

    public boolean isOverEdge(IcyCanvas canvas, Point5D p) {
        return this.isOverEdge(canvas, p.getX(), p.getY(), p.getZ(), p.getT(), p.getC());
    }

    public boolean isOverEdge(IcyCanvas canvas, double x, double y, double z, double t, double c) {
        if (this.isActiveFor((int)z, (int)t, (int)c)) {
            return this.isOverEdge(canvas, x, y);
        }
        return false;
    }

    protected boolean onSamePos(ROI2D roi, boolean shouldContain) {
        int z = this.getZ();
        int t = this.getT();
        int c = this.getC();
        int roiZ = roi.getZ();
        int roiT = roi.getT();
        int roiC = roi.getC();
        if (shouldContain) {
            if (z != -1 && z != roiZ) {
                return false;
            }
            if (t != -1 && t != roiT) {
                return false;
            }
            if (c != -1 && c != roiC) {
                return false;
            }
        } else {
            if (z != -1 && roiZ != -1 && z != roiZ) {
                return false;
            }
            if (t != -1 && roiT != -1 && t != roiT) {
                return false;
            }
            if (c != -1 && roiC != -1 && c != roiC) {
                return false;
            }
        }
        return true;
    }

    public boolean contains(Point2D p) {
        return this.contains(p.getX(), p.getY());
    }

    public boolean contains(Rectangle2D r) {
        return this.contains(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    public abstract boolean contains(double var1, double var3);

    public abstract boolean contains(double var1, double var3, double var5, double var7);

    @Override
    public boolean contains(double x, double y, double z, double t, double c) {
        boolean tok;
        boolean zok;
        if (this.getZ() == -1) {
            zok = true;
        } else {
            boolean bl = zok = z >= (double)this.getZ() && z < (double)this.getZ() + 1.0;
        }
        if (this.getT() == -1) {
            tok = true;
        } else {
            boolean bl = tok = t >= (double)this.getT() && t < (double)this.getT() + 1.0;
        }
        boolean cok = this.getC() == -1 ? true : c >= (double)this.getC() && c < (double)this.getC() + 1.0;
        return cok && zok && tok && this.contains(x, y);
    }

    @Override
    public boolean contains(double x, double y, double z, double t, double c, double sizeX, double sizeY, double sizeZ, double sizeT, double sizeC) {
        boolean tok;
        boolean zok;
        if (this.getZ() == -1) {
            zok = true;
        } else {
            boolean bl = zok = z >= (double)this.getZ() && z + sizeZ <= (double)this.getZ() + 1.0;
        }
        if (this.getT() == -1) {
            tok = true;
        } else {
            boolean bl = tok = t >= (double)this.getT() && t + sizeT <= (double)this.getT() + 1.0;
        }
        boolean cok = this.getC() == -1 ? true : c >= (double)this.getC() && c + sizeC <= (double)this.getC() + 1.0;
        return zok && tok && cok && this.contains(x, y, sizeX, sizeY);
    }

    @Override
    public boolean contains(ROI roi) throws InterruptedException {
        if (roi instanceof ROI2D) {
            ROI2D roi2d = (ROI2D)roi;
            if (this.onSamePos(roi2d, true)) {
                BooleanMask2D roiMask;
                if (roi2d.isEmpty()) {
                    return this.contains(roi2d.getPosition2D());
                }
                if (!this.contains(roi2d.getBounds2D())) {
                    return false;
                }
                BooleanMask2D mask = this.getBooleanMask(false);
                if (!mask.contains(roiMask = roi2d.getBooleanMask(false))) {
                    return false;
                }
                mask = this.getBooleanMask(true);
                return mask.contains(roiMask = roi2d.getBooleanMask(true));
            }
            return false;
        }
        return super.contains(roi);
    }

    public boolean intersects(Rectangle2D r) {
        return this.intersects(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    public abstract boolean intersects(double var1, double var3, double var5, double var7);

    @Override
    public boolean intersects(double x, double y, double z, double t, double c, double sizeX, double sizeY, double sizeZ, double sizeT, double sizeC) {
        boolean tok;
        boolean zok;
        if (sizeX == 0.0 || sizeY == 0.0 || sizeZ == 0.0 || sizeT == 0.0 || sizeC == 0.0) {
            return false;
        }
        if (this.getZ() == -1 || sizeZ == Double.POSITIVE_INFINITY) {
            zok = true;
        } else {
            boolean bl = zok = z + sizeZ > (double)this.getZ() && z < (double)this.getZ() + 1.0;
        }
        if (this.getT() == -1 || sizeT == Double.POSITIVE_INFINITY) {
            tok = true;
        } else {
            boolean bl = tok = t + sizeT > (double)this.getT() && t < (double)this.getT() + 1.0;
        }
        boolean cok = this.getC() == -1 || sizeC == Double.POSITIVE_INFINITY ? true : c + sizeC > (double)this.getC() && c < (double)this.getC() + 1.0;
        return this.intersects(x, y, sizeX, sizeY) && zok && tok && cok;
    }

    @Override
    public boolean intersects(ROI roi) throws InterruptedException {
        ROI2D roi2d;
        if (roi instanceof ROI2D && this.onSamePos(roi2d = (ROI2D)roi, false)) {
            if (!this.intersects(roi2d.getBounds2D())) {
                return false;
            }
            return this.getBooleanMask(true).intersects(roi2d.getBooleanMask(true));
        }
        return super.intersects(roi);
    }

    public abstract Rectangle2D computeBounds2D();

    @Override
    public Rectangle5D computeBounds5D() {
        Rectangle2D bounds2D = this.computeBounds2D();
        if (bounds2D == null) {
            return new Rectangle5D.Double();
        }
        Rectangle5D.Double result = new Rectangle5D.Double(bounds2D.getX(), bounds2D.getY(), 0.0, 0.0, 0.0, bounds2D.getWidth(), bounds2D.getHeight(), 0.0, 0.0, 0.0);
        if (this.getZ() == -1) {
            result.z = Double.NEGATIVE_INFINITY;
            result.sizeZ = Double.POSITIVE_INFINITY;
        } else {
            result.z = this.getZ();
            result.sizeZ = 1.0;
        }
        if (this.getT() == -1) {
            result.t = Double.NEGATIVE_INFINITY;
            result.sizeT = Double.POSITIVE_INFINITY;
        } else {
            result.t = this.getT();
            result.sizeT = 1.0;
        }
        if (this.getC() == -1) {
            result.c = Double.NEGATIVE_INFINITY;
            result.sizeC = Double.POSITIVE_INFINITY;
        } else {
            result.c = this.getC();
            result.sizeC = 1.0;
        }
        return result;
    }

    public Rectangle getBounds() {
        return this.getBounds2D().getBounds();
    }

    public Rectangle2D getBounds2D() {
        return this.getBounds5D().toRectangle2D();
    }

    public Point getPosition() {
        return this.getBounds().getLocation();
    }

    public Point2D getPosition2D() {
        Rectangle2D r = this.getBounds2D();
        return new Point2D.Double(r.getX(), r.getY());
    }

    @Override
    public boolean canSetBounds() {
        return false;
    }

    public void setBounds2D(Rectangle2D bounds) {
    }

    @Override
    public void setBounds5D(Rectangle5D bounds) {
        this.beginUpdate();
        try {
            if (bounds.getSizeZ() == Double.POSITIVE_INFINITY) {
                this.setZ(-1);
            } else {
                this.setZ((int)bounds.getZ());
            }
            if (bounds.getSizeT() == Double.POSITIVE_INFINITY) {
                this.setT(-1);
            } else {
                this.setT((int)bounds.getT());
            }
            if (bounds.getSizeC() == Double.POSITIVE_INFINITY) {
                this.setC(-1);
            } else {
                this.setC((int)bounds.getC());
            }
            this.setBounds2D(bounds.toRectangle2D());
        }
        finally {
            this.endUpdate();
        }
    }

    @Override
    public boolean canSetPosition() {
        return this.canTranslate();
    }

    @Deprecated
    public void setPosition(Point2D position) {
        this.setPosition2D(position);
    }

    public void setPosition2D(Point2D position) {
        if (this.canTranslate()) {
            Point2D oldPos = this.getPosition2D();
            this.translate(position.getX() - oldPos.getX(), position.getY() - oldPos.getY());
        }
    }

    @Override
    public void setPosition5D(Point5D position) {
        this.beginUpdate();
        try {
            this.setZ((int)position.getZ());
            this.setT((int)position.getT());
            this.setC((int)position.getC());
            this.setPosition2D(position.toPoint2D());
        }
        finally {
            this.endUpdate();
        }
    }

    public boolean canTranslate() {
        return false;
    }

    public void translate(double dx, double dy) {
    }

    @Override
    public boolean[] getBooleanMask2D(int x, int y, int width, int height, int z, int t, int c, boolean inclusive) throws InterruptedException {
        if (!this.isActiveFor(z, t, c)) {
            return new boolean[Math.max(0, width) * Math.max(0, height)];
        }
        return this.getBooleanMask(x, y, width, height, inclusive);
    }

    public boolean[] getBooleanMask(int x, int y, int width, int height, boolean inclusive) throws InterruptedException {
        boolean[] result = new boolean[Math.max(0, width) * Math.max(0, height)];
        int offset = 0;
        for (int j = 0; j < height; ++j) {
            for (int i = 0; i < width; ++i) {
                result[offset] = inclusive ? this.intersects(x + i, y + j, 1.0, 1.0) : this.contains(x + i, y + j, 1.0, 1.0);
                ++offset;
            }
            if ((j & 0xF) != 15 || !Thread.interrupted()) continue;
            throw new InterruptedException("ROI2D.getBooleanMask(..) process interrupted.");
        }
        return result;
    }

    @Deprecated
    public boolean[] getBooleanMask(int x, int y, int width, int height) throws InterruptedException {
        return this.getBooleanMask(x, y, width, height, false);
    }

    public boolean[] getBooleanMask(Rectangle rect, boolean inclusive) throws InterruptedException {
        return this.getBooleanMask(rect.x, rect.y, rect.width, rect.height, inclusive);
    }

    @Deprecated
    public boolean[] getBooleanMask(Rectangle rect) throws InterruptedException {
        return this.getBooleanMask(rect, false);
    }

    @Override
    public BooleanMask2D getBooleanMask2D(int z, int t, int c, boolean inclusive) throws InterruptedException {
        if (!this.isActiveFor(z, t, c)) {
            return new BooleanMask2D();
        }
        return this.getBooleanMask(inclusive);
    }

    public BooleanMask2D getBooleanMask(boolean inclusive) throws InterruptedException {
        Rectangle bounds = this.getBounds();
        if (bounds.isEmpty()) {
            return new BooleanMask2D(new Rectangle(), new boolean[0]);
        }
        return new BooleanMask2D(bounds, this.getBooleanMask(bounds, inclusive));
    }

    @Deprecated
    public BooleanMask2D getBooleanMask() throws InterruptedException {
        return this.getBooleanMask(false);
    }

    @Deprecated
    public BooleanMask2D getAsBooleanMask(boolean inclusive) throws InterruptedException {
        return this.getBooleanMask(inclusive);
    }

    @Deprecated
    public boolean[] getAsBooleanMask(Rectangle rect, boolean inclusive) throws InterruptedException {
        return this.getBooleanMask(rect, inclusive);
    }

    @Deprecated
    public boolean[] getAsBooleanMask(int x, int y, int w, int h, boolean inclusive) throws InterruptedException {
        return this.getBooleanMask(x, y, w, h, inclusive);
    }

    @Deprecated
    public BooleanMask2D getAsBooleanMask() throws InterruptedException {
        return this.getBooleanMask();
    }

    @Deprecated
    public boolean[] getAsBooleanMask(Rectangle rect) throws InterruptedException {
        return this.getBooleanMask(rect);
    }

    @Deprecated
    public boolean[] getAsBooleanMask(int x, int y, int w, int h) throws InterruptedException {
        return this.getBooleanMask(x, y, w, h);
    }

    @Override
    public double computeNumberOfContourPoints() throws InterruptedException {
        return this.getBooleanMask(true).getContourLength();
    }

    @Override
    public double computeNumberOfPoints() throws InterruptedException {
        double numPoints = 0.0;
        numPoints += (double)this.getBooleanMask(true).getNumberOfPoints();
        numPoints += (double)this.getBooleanMask(false).getNumberOfPoints();
        return numPoints /= 2.0;
    }

    @Deprecated
    public double computePerimeter(Sequence sequence) throws UnsupportedOperationException, InterruptedException {
        return this.getLength(sequence);
    }

    @Deprecated
    public double getPerimeter(Sequence sequence) throws UnsupportedOperationException, InterruptedException {
        return this.getLength(sequence);
    }

    @Override
    @Deprecated
    public double getPerimeter() throws InterruptedException {
        return this.getNumberOfContourPoints();
    }

    @Deprecated
    public double getArea() throws InterruptedException {
        return this.getNumberOfPoints();
    }

    @Override
    public ROI getSubROI(int z, int t, int c) {
        if (!this.isActiveFor(z, t, c)) {
            return null;
        }
        ROI2D result = (ROI2D)this.getCopy();
        if (result != null) {
            if (z != -1) {
                result.setZ(z);
            }
            if (t != -1) {
                result.setT(t);
            }
            if (c != -1) {
                result.setC(c);
            }
            result.setName(this.getName() + ROI2D.getNameSuffix(z, t, c));
        }
        return result;
    }

    @Override
    public boolean loadFromXML(Node node) {
        this.beginUpdate();
        try {
            if (!super.loadFromXML(node)) {
                boolean bl = false;
                return bl;
            }
            this.setZ(XMLUtil.getElementIntValue(node, ID_Z, -1));
            this.setT(XMLUtil.getElementIntValue(node, ID_T, -1));
            this.setC(XMLUtil.getElementIntValue(node, ID_C, -1));
        }
        finally {
            this.endUpdate();
        }
        return true;
    }

    @Override
    public boolean saveToXML(Node node) {
        if (!super.saveToXML(node)) {
            return false;
        }
        XMLUtil.setElementIntValue(node, ID_Z, this.getZ());
        XMLUtil.setElementIntValue(node, ID_T, this.getT());
        XMLUtil.setElementIntValue(node, ID_C, this.getC());
        return true;
    }

    public abstract class ROI2DPainter
    extends ROI.ROIPainter {
        protected Point2D startDragMousePosition;
        protected Point2D startDragROIPosition;
        protected int startDragMouseZ;
        protected int startDragROIZ;

        public ROI2DPainter() {
            super(ROI2D.this);
            this.startDragMousePosition = null;
            this.startDragROIPosition = null;
            this.startDragMouseZ = 0;
            this.startDragROIZ = 0;
        }

        @Override
        protected boolean updateFocus(InputEvent e, Point5D imagePoint, IcyCanvas canvas) {
            if (imagePoint == null) {
                return false;
            }
            boolean focus = ROI2D.this.isOverEdge(canvas, imagePoint.getX(), imagePoint.getY());
            ROI2D.this.setFocused(focus);
            return ROI2D.this.focused;
        }

        @Override
        protected boolean updateDrag(InputEvent e, Point5D imagePoint, IcyCanvas canvas) {
            int dz;
            if (this.startDragMousePosition == null) {
                return false;
            }
            if (imagePoint == null) {
                return false;
            }
            if (!ROI2D.this.canSetPosition()) {
                return false;
            }
            double dx = imagePoint.getX() - this.startDragMousePosition.getX();
            double dy = imagePoint.getY() - this.startDragMousePosition.getY();
            int n = dz = ROI2D.this.getZ() == -1 || imagePoint.getZ() == -1.0 || this.startDragMouseZ == -1 ? 0 : (int)imagePoint.getZ() - this.startDragMouseZ;
            if (EventUtil.isShiftDown(e)) {
                if (Math.abs(dx) > Math.abs(dy)) {
                    dy = 0.0;
                } else {
                    dx = 0.0;
                }
            }
            Sequence sequence = canvas != null ? canvas.getSequence() : null;
            Point5D savePosition = sequence != null ? ROI2D.this.getPosition5D() : null;
            ROI2D.this.setPosition2D(new Point2D.Double(this.startDragROIPosition.getX() + dx, this.startDragROIPosition.getY() + dy));
            if (dz != 0) {
                int newZ = this.startDragROIZ + dz;
                if (newZ < 0) {
                    newZ = 0;
                }
                if (sequence != null && newZ >= sequence.getSizeZ()) {
                    newZ = sequence.getSizeZ() - 1;
                }
                ROI2D.this.setZ(newZ);
            }
            if (sequence != null && savePosition != null) {
                sequence.addUndoableEdit(new PositionROIEdit((ROI)ROI2D.this, savePosition));
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void mousePressed(MouseEvent e, Point5D.Double imagePoint, IcyCanvas canvas) {
            super.mousePressed(e, imagePoint, canvas);
            if (!this.isReadOnly() && imagePoint != null && ROI2D.this.isActiveFor(canvas) && EventUtil.isLeftMouseButton(e)) {
                ROI2D.this.beginUpdate();
                try {
                    if (ROI2D.this.isFocused()) {
                        this.startDragMousePosition = imagePoint.toPoint2D();
                        this.startDragMouseZ = (int)imagePoint.getZ();
                        this.startDragROIPosition = ROI2D.this.getPosition2D();
                        this.startDragROIZ = ROI2D.this.getZ();
                    }
                }
                finally {
                    ROI2D.this.endUpdate();
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent e, Point5D.Double imagePoint, IcyCanvas canvas) {
            super.mouseReleased(e, imagePoint, canvas);
            this.startDragMousePosition = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void mouseDrag(MouseEvent e, Point5D.Double imagePoint, IcyCanvas canvas) {
            super.mouseDrag(e, imagePoint, canvas);
            if (!e.isConsumed() && !this.isReadOnly() && imagePoint != null && ROI2D.this.isActiveFor(canvas) && EventUtil.isLeftMouseButton(e)) {
                ROI2D.this.beginUpdate();
                try {
                    if (ROI2D.this.isFocused()) {
                        if (this.startDragMousePosition == null) {
                            this.startDragMousePosition = imagePoint.toPoint2D();
                            this.startDragMouseZ = (int)imagePoint.getZ();
                            this.startDragROIPosition = ROI2D.this.getPosition2D();
                            this.startDragROIZ = ROI2D.this.getZ();
                        }
                        this.updateDrag(e, imagePoint, canvas);
                        e.consume();
                    }
                }
                finally {
                    ROI2D.this.endUpdate();
                }
            }
        }

        @Override
        public void paint(Graphics2D g, Sequence sequence, IcyCanvas canvas) {
            super.paint(g, sequence, canvas);
            if (ROI2D.this.isActiveFor(canvas)) {
                this.drawROI(g, sequence, canvas);
                if (this.getShowName()) {
                    this.drawName(g, sequence, canvas);
                }
            }
        }

        public abstract void drawROI(Graphics2D var1, Sequence var2, IcyCanvas var3);

        public void drawName(Graphics2D g, Sequence sequence, IcyCanvas canvas) {
            if (canvas instanceof IcyCanvas2D) {
                if (g == null) {
                    return;
                }
                Graphics2D g2 = (Graphics2D)g.create();
                IcyCanvas2D cnv2d = (IcyCanvas2D)canvas;
                Rectangle2D bounds = ROI2D.this.getBounds2D();
                Point pos = cnv2d.imageToCanvas(bounds.getCenterX(), bounds.getMinY());
                double coef = Math.log(canvas.getScaleX() + 1.0);
                double fontSize = GeneralPreferences.getGuiFontSize() - 4 + (int)(coef * 10.0);
                g2.transform(cnv2d.getInverseTransform());
                g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                g2.setFont(FontUtil.setSize(g2.getFont(), (int)fontSize));
                g2.setColor(this.getColor());
                GraphicsUtil.drawHCenteredString(g2, this.getName(), pos.x, pos.y - (int)(2.0 * fontSize), true);
                g2.dispose();
            }
            if (canvas instanceof IcyCanvas3D) {
                // empty if block
            }
        }
    }
}

