/*
 * Decompiled with CFR 0.152.
 */
package plugins.kernel.roi.roi2d;

import icy.resource.ResourceUtil;
import icy.roi.ROI;
import icy.type.point.Point5D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import plugins.kernel.roi.roi2d.ROI2DLine;
import plugins.kernel.roi.roi2d.ROI2DPoint;
import plugins.kernel.roi.roi2d.ROI2DRectShape;

public class ROI2DRectangle
extends ROI2DRectShape {
    @Deprecated
    public ROI2DRectangle(Point2D topLeft, Point2D bottomRight, boolean cm) {
        this(topLeft, bottomRight);
    }

    public ROI2DRectangle(Point2D topLeft, Point2D bottomRight) {
        super(new Rectangle2D.Double(), topLeft, bottomRight);
        this.setIcon(ResourceUtil.ICON_ROI_RECTANGLE);
    }

    public ROI2DRectangle(double xmin, double ymin, double xmax, double ymax) {
        this((Point2D)new Point2D.Double(xmin, ymin), new Point2D.Double(xmax, ymax));
    }

    @Deprecated
    public ROI2DRectangle(Rectangle2D rectangle, boolean cm) {
        this(rectangle);
    }

    public ROI2DRectangle(Rectangle2D rectangle) {
        this((Point2D)new Point2D.Double(rectangle.getMinX(), rectangle.getMinY()), new Point2D.Double(rectangle.getMaxX(), rectangle.getMaxY()));
    }

    @Deprecated
    public ROI2DRectangle(Point2D pt, boolean cm) {
        this(pt);
    }

    public ROI2DRectangle(Point2D pt) {
        this((Point2D)new Point2D.Double(pt.getX(), pt.getY()), pt);
    }

    public ROI2DRectangle(Point5D pt) {
        this(pt.toPoint2D());
    }

    public ROI2DRectangle() {
        this((Point2D)new Point2D.Double(), new Point2D.Double());
    }

    @Override
    public String getDefaultName() {
        return "Rectangle2D";
    }

    public Rectangle2D getRectangle() {
        return (Rectangle2D)this.shape;
    }

    public void setRectangle(Rectangle2D rectangle) {
        this.setBounds2D(rectangle);
    }

    @Override
    public boolean contains(ROI roi) throws InterruptedException {
        if (roi instanceof ROI2DPoint) {
            return this.onSamePos((ROI2DPoint)roi, true) && this.contains(((ROI2DPoint)roi).getPoint());
        }
        if (roi instanceof ROI2DLine) {
            return this.onSamePos((ROI2DLine)roi, true) && this.contains(((ROI2DLine)roi).getBounds2D());
        }
        if (roi instanceof ROI2DRectangle) {
            return this.onSamePos((ROI2DRectangle)roi, true) && this.contains(((ROI2DRectangle)roi).getRectangle());
        }
        return super.contains(roi);
    }

    @Override
    public boolean intersects(ROI roi) throws InterruptedException {
        if (roi instanceof ROI2DPoint) {
            return this.onSamePos((ROI2DPoint)roi, false) && this.contains(((ROI2DPoint)roi).getPoint());
        }
        if (roi instanceof ROI2DLine) {
            return this.onSamePos((ROI2DLine)roi, false) && ((ROI2DLine)roi).getLine().intersects(this.getRectangle());
        }
        if (roi instanceof ROI2DRectangle) {
            return this.onSamePos((ROI2DRectangle)roi, false) && ((ROI2DRectangle)roi).getRectangle().intersects(this.getRectangle());
        }
        return super.intersects(roi);
    }

    @Override
    public double computeNumberOfPoints() {
        Rectangle2D r = this.getRectangle();
        return r.getWidth() * r.getHeight();
    }
}

