/*
 * Decompiled with CFR 0.152.
 */
package plugins.fab.trackmanager;

import icy.util.Random;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import plugins.fab.trackmanager.TrackGroup;
import plugins.nchenouard.spot.Detection;

public class TrackSegment
implements Cloneable {
    protected static Map<Integer, Reference<TrackSegment>> idKeyHashMapList = new HashMap<Integer, Reference<TrackSegment>>();
    List<Detection> detectionList = new ArrayList<Detection>();
    List<TrackSegment> previousList = new ArrayList<TrackSegment>();
    List<TrackSegment> nextList = new ArrayList<TrackSegment>();
    private TrackGroup ownerTrackGroup = null;
    private int id = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TrackSegment getTrackSegmentById(int id) {
        Integer iid = id;
        Map<Integer, Reference<TrackSegment>> map = idKeyHashMapList;
        synchronized (map) {
            Reference<TrackSegment> ref = idKeyHashMapList.get(iid);
            if (ref.get() == null) {
                idKeyHashMapList.remove(iid);
            }
            return ref.get();
        }
    }

    public TrackSegment() {
        this.generateId();
    }

    public TrackSegment(ArrayList<Detection> detectionList) {
        this.detectionList = detectionList;
        this.generateId();
    }

    protected Object clone() throws CloneNotSupportedException {
        TrackSegment cloneSegment = (TrackSegment)super.clone();
        for (Detection detection : this.detectionList) {
            Detection cloneDetection = (Detection)detection.clone();
            cloneSegment.detectionList.add(cloneDetection);
        }
        this.previousList = new ArrayList<TrackSegment>(this.previousList);
        this.nextList = new ArrayList<TrackSegment>(this.nextList);
        this.generateId();
        return cloneSegment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeId() {
        Map<Integer, Reference<TrackSegment>> map = idKeyHashMapList;
        synchronized (map) {
            idKeyHashMapList.remove(this.id);
        }
    }

    public int getId() {
        return this.id;
    }

    public void generateId() {
        this.removeId();
        Map<Integer, Reference<TrackSegment>> map = idKeyHashMapList;
        synchronized (map) {
            Integer key;
            while (idKeyHashMapList.get(key = Integer.valueOf(Random.nextInt())) != null) {
            }
            idKeyHashMapList.put(key, new WeakReference<TrackSegment>(this));
            this.id = key;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setId(int id) {
        Integer key = id;
        Map<Integer, Reference<TrackSegment>> map = idKeyHashMapList;
        synchronized (map) {
            if (idKeyHashMapList.get(key) == null) {
                idKeyHashMapList.put(key, new WeakReference<TrackSegment>(this));
                this.id = key;
            } else {
                System.out.println("track id already loaded");
            }
        }
    }

    public boolean containsDetection(Detection detection) {
        return this.detectionList.contains(detection);
    }

    public void setAllDetectionEnabled(boolean selected) {
        for (Detection d : this.detectionList) {
            d.setEnabled(selected);
        }
    }

    public boolean isAllDetectionEnabled() {
        if (this.detectionList.isEmpty()) {
            return false;
        }
        boolean result = true;
        for (Detection d : this.detectionList) {
            if (d.isEnabled()) continue;
            result = false;
        }
        return result;
    }

    public void setAllDetectionSelected(boolean selected) {
        for (Detection d : this.detectionList) {
            d.setSelected(selected);
        }
    }

    public boolean isAllDetectionSelected() {
        if (this.detectionList.isEmpty()) {
            return false;
        }
        boolean result = true;
        for (Detection d : this.detectionList) {
            if (d.isSelected()) continue;
            result = false;
        }
        return result;
    }

    public void addDetection(Detection detection) {
        if (this.detectionList.size() > 0) {
            Detection detectionPrevious = this.getLastDetection();
            if (detection.getT() != detectionPrevious.getT() + 1) {
                System.err.println("TrackSegment : The detection must be added with consecutive T value. Detection was not added");
                return;
            }
        }
        this.detectionList.add(detection);
    }

    public void removeDetection(Detection detection) {
        this.detectionList.remove(detection);
    }

    public void removeLastDetection() {
        this.detectionList.remove(this.getLastDetection());
    }

    public void addPrevious(TrackSegment trackSegment) {
        this.previousList.add(trackSegment);
        trackSegment.nextList.add(this);
    }

    public void removePrevious(TrackSegment trackSegment) {
        this.previousList.remove(trackSegment);
        trackSegment.nextList.remove(this);
    }

    public void addNext(TrackSegment trackSegment) {
        this.nextList.add(trackSegment);
        trackSegment.previousList.add(this);
    }

    public void removeNext(TrackSegment trackSegment) {
        this.nextList.remove(trackSegment);
        trackSegment.previousList.remove(this);
    }

    public Detection getFirstDetection() {
        if (this.detectionList.size() == 0) {
            return null;
        }
        return this.detectionList.get(0);
    }

    public Detection getDetectionAt(int i) {
        return this.detectionList.get(i);
    }

    public Detection getDetectionAtTime(int t) {
        for (Detection detection : this.detectionList) {
            if (detection.getT() != t) continue;
            return detection;
        }
        return null;
    }

    public ArrayList<Detection> getDetectionList() {
        return (ArrayList)this.detectionList;
    }

    public Detection getLastDetection() {
        if (this.detectionList.size() == 0) {
            return null;
        }
        return this.detectionList.get(this.detectionList.size() - 1);
    }

    public int getDetectionIndex(Detection detection) {
        return this.detectionList.indexOf(detection);
    }

    public void setOwnerTrackGroup(TrackGroup tg) {
        this.ownerTrackGroup = tg;
    }

    public TrackGroup getOwnerTrackGroup() {
        return this.ownerTrackGroup;
    }

    public void removeAllLinks() {
        ArrayList<TrackSegment> previousListCopy = new ArrayList<TrackSegment>(this.previousList);
        for (TrackSegment previousTrackSegment : previousListCopy) {
            this.removePrevious(previousTrackSegment);
        }
        ArrayList<TrackSegment> nextListCopy = new ArrayList<TrackSegment>(this.nextList);
        for (TrackSegment nextTrackSegment : nextListCopy) {
            this.removeNext(nextTrackSegment);
        }
    }
}

