/*
 * Decompiled with CFR 0.152.
 */
package plugins.stef.tools.overlay;

import icy.gui.dialog.ConfirmDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.util.EventListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import plugins.stef.tools.overlay.ColorBarOverlay;

public class ColorBarSettingPanel
extends JPanel
implements ActionListener,
ChangeListener {
    public static final String PROPERTY_POSITION = "position";
    public static final String PROPERTY_SCALE = "scale";
    public static final String PROPERTY_OFFSET_X = "offsetX";
    public static final String PROPERTY_OFFSET_Y = "offsetY";
    public static final String PROPERTY_DISPLAY_MINMAX = "displayMinMax";
    protected JComboBox<ColorBarOverlay.ColorBarPosition> positionComboBox;
    protected JSlider offsetXSlider;
    protected JSlider offsetYSlider;
    protected JSlider scaleSlider;
    protected JCheckBox minMaxCheckBox;
    protected JButton resetDefaultButton;

    public ColorBarSettingPanel() {
        this.initialize();
        this.positionComboBox.setSelectedItem((Object)ColorBarOverlay.ColorBarPosition.RIGHT);
        this.offsetXSlider.setValue(0);
        this.offsetYSlider.setValue(0);
        this.scaleSlider.setValue(100);
        this.minMaxCheckBox.setSelected(true);
        this.positionComboBox.addActionListener(this);
        this.scaleSlider.addChangeListener(this);
        this.offsetXSlider.addChangeListener(this);
        this.offsetYSlider.addChangeListener(this);
        this.minMaxCheckBox.addChangeListener(this);
        this.resetDefaultButton.addActionListener(this);
    }

    public void addSettingChangeListener(SettingChangeListener listener) {
        this.listenerList.add(SettingChangeListener.class, listener);
    }

    public void removeSettingChangeListener(SettingChangeListener listener) {
        this.listenerList.remove(SettingChangeListener.class, listener);
    }

    private void initialize() {
        this.setBorder(new EmptyBorder(2, 0, 0, 0));
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{120, 40, 0, 0};
        gridBagLayout.rowHeights = new int[]{0, 0, 0, 0, 0, 0};
        gridBagLayout.columnWeights = new double[]{0.0, 0.0, 1.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
        this.setLayout(gridBagLayout);
        JLabel lblPosition = new JLabel(" Position");
        GridBagConstraints gbc_lblPosition = new GridBagConstraints();
        gbc_lblPosition.insets = new Insets(0, 0, 5, 5);
        gbc_lblPosition.anchor = 17;
        gbc_lblPosition.gridx = 0;
        gbc_lblPosition.gridy = 0;
        this.add((Component)lblPosition, gbc_lblPosition);
        this.positionComboBox = new JComboBox();
        this.positionComboBox.setToolTipText("Position of the color bar");
        this.positionComboBox.setModel(new DefaultComboBoxModel<ColorBarOverlay.ColorBarPosition>(ColorBarOverlay.ColorBarPosition.values()));
        GridBagConstraints gbc_positionComboBox = new GridBagConstraints();
        gbc_positionComboBox.fill = 2;
        gbc_positionComboBox.gridwidth = 2;
        gbc_positionComboBox.insets = new Insets(0, 0, 5, 0);
        gbc_positionComboBox.gridx = 1;
        gbc_positionComboBox.gridy = 0;
        this.add(this.positionComboBox, gbc_positionComboBox);
        JLabel lblOffset = new JLabel(" Offset X");
        GridBagConstraints gbc_lblOffset = new GridBagConstraints();
        gbc_lblOffset.anchor = 17;
        gbc_lblOffset.insets = new Insets(0, 0, 5, 5);
        gbc_lblOffset.gridx = 0;
        gbc_lblOffset.gridy = 1;
        this.add((Component)lblOffset, gbc_lblOffset);
        this.offsetXSlider = new JSlider();
        this.offsetXSlider.setPreferredSize(new Dimension(60, 26));
        this.offsetXSlider.setToolTipText("X position offset of the color bar");
        this.offsetXSlider.setMinorTickSpacing(10);
        this.offsetXSlider.setMajorTickSpacing(50);
        this.offsetXSlider.setPaintTicks(true);
        this.offsetXSlider.setMinimum(-100);
        GridBagConstraints gbc_offsetXSlider = new GridBagConstraints();
        gbc_offsetXSlider.fill = 2;
        gbc_offsetXSlider.gridwidth = 2;
        gbc_offsetXSlider.insets = new Insets(0, 0, 5, 0);
        gbc_offsetXSlider.gridx = 1;
        gbc_offsetXSlider.gridy = 1;
        this.add((Component)this.offsetXSlider, gbc_offsetXSlider);
        JLabel lblOffsetY = new JLabel(" Offset Y");
        GridBagConstraints gbc_lblOffsetY = new GridBagConstraints();
        gbc_lblOffsetY.anchor = 17;
        gbc_lblOffsetY.insets = new Insets(0, 0, 5, 5);
        gbc_lblOffsetY.gridx = 0;
        gbc_lblOffsetY.gridy = 2;
        this.add((Component)lblOffsetY, gbc_lblOffsetY);
        this.offsetYSlider = new JSlider();
        this.offsetYSlider.setPreferredSize(new Dimension(60, 26));
        this.offsetYSlider.setToolTipText("Y position offset of the color bar");
        this.offsetYSlider.setMinorTickSpacing(10);
        this.offsetYSlider.setMajorTickSpacing(50);
        this.offsetYSlider.setPaintTicks(true);
        this.offsetYSlider.setMinimum(-100);
        GridBagConstraints gbc_offsetYSlider = new GridBagConstraints();
        gbc_offsetYSlider.fill = 2;
        gbc_offsetYSlider.gridwidth = 2;
        gbc_offsetYSlider.insets = new Insets(0, 0, 5, 0);
        gbc_offsetYSlider.gridx = 1;
        gbc_offsetYSlider.gridy = 2;
        this.add((Component)this.offsetYSlider, gbc_offsetYSlider);
        JLabel lblWidth = new JLabel(" Scale");
        GridBagConstraints gbc_lblWidth = new GridBagConstraints();
        gbc_lblWidth.anchor = 17;
        gbc_lblWidth.insets = new Insets(0, 0, 5, 5);
        gbc_lblWidth.gridx = 0;
        gbc_lblWidth.gridy = 3;
        this.add((Component)lblWidth, gbc_lblWidth);
        this.scaleSlider = new JSlider();
        this.scaleSlider.setPreferredSize(new Dimension(60, 26));
        this.scaleSlider.setToolTipText("Scale factor of the color bar");
        this.scaleSlider.setMinorTickSpacing(10);
        this.scaleSlider.setMajorTickSpacing(50);
        this.scaleSlider.setMaximum(200);
        this.scaleSlider.setPaintTicks(true);
        this.scaleSlider.setMinimum(50);
        GridBagConstraints gbc_sizeSlider = new GridBagConstraints();
        gbc_sizeSlider.fill = 2;
        gbc_sizeSlider.gridwidth = 2;
        gbc_sizeSlider.insets = new Insets(0, 0, 5, 0);
        gbc_sizeSlider.gridx = 1;
        gbc_sizeSlider.gridy = 3;
        this.add((Component)this.scaleSlider, gbc_sizeSlider);
        JLabel lblDisplayMin = new JLabel(" Display min / max");
        GridBagConstraints gbc_lblDisplayMin = new GridBagConstraints();
        gbc_lblDisplayMin.anchor = 17;
        gbc_lblDisplayMin.insets = new Insets(0, 0, 0, 5);
        gbc_lblDisplayMin.gridx = 0;
        gbc_lblDisplayMin.gridy = 4;
        this.add((Component)lblDisplayMin, gbc_lblDisplayMin);
        this.minMaxCheckBox = new JCheckBox("");
        this.minMaxCheckBox.setToolTipText("Display the minimum and maximum intensity value");
        GridBagConstraints gbc_minMaxCheckBox = new GridBagConstraints();
        gbc_minMaxCheckBox.anchor = 17;
        gbc_minMaxCheckBox.insets = new Insets(0, 0, 0, 5);
        gbc_minMaxCheckBox.gridx = 1;
        gbc_minMaxCheckBox.gridy = 4;
        this.add((Component)this.minMaxCheckBox, gbc_minMaxCheckBox);
        this.resetDefaultButton = new JButton("Restore default");
        this.resetDefaultButton.setToolTipText("Restore default values");
        GridBagConstraints gbc_resetDefaultButton = new GridBagConstraints();
        gbc_resetDefaultButton.fill = 2;
        gbc_resetDefaultButton.gridx = 2;
        gbc_resetDefaultButton.gridy = 4;
        this.add((Component)this.resetDefaultButton, gbc_resetDefaultButton);
        this.validate();
    }

    public boolean getDisplayMinMax() {
        return this.minMaxCheckBox.isSelected();
    }

    public void setDisplayMinMax(boolean value) {
        this.minMaxCheckBox.setSelected(value);
    }

    public double getColorBarOffsetX() {
        return (double)this.offsetXSlider.getValue() / 100.0;
    }

    public void setColorBarOffsetX(double value) {
        this.offsetXSlider.setValue((int)(value * 100.0));
    }

    public double getColorBarOffsetY() {
        return (double)this.offsetYSlider.getValue() / 100.0;
    }

    public void setColorBarOffsetY(double value) {
        this.offsetYSlider.setValue((int)(value * 100.0));
    }

    public double getColorBarScale() {
        return (double)this.scaleSlider.getValue() / 100.0;
    }

    public void setColorBarScale(double value) {
        this.scaleSlider.setValue((int)(value * 100.0));
    }

    public ColorBarOverlay.ColorBarPosition getPosition() {
        return (ColorBarOverlay.ColorBarPosition)((Object)this.positionComboBox.getSelectedItem());
    }

    public void setPosition(ColorBarOverlay.ColorBarPosition value) {
        this.positionComboBox.setSelectedItem((Object)value);
    }

    public void fireSettingChanged(Object source, String property, Object value) {
        PropertyChangeEvent event = new PropertyChangeEvent(source, property, null, value);
        for (SettingChangeListener listener : (SettingChangeListener[])this.getListeners(SettingChangeListener.class)) {
            listener.settingChange(event);
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Object source = e.getSource();
        if (source == this.scaleSlider) {
            this.fireSettingChanged(source, PROPERTY_SCALE, this.getColorBarScale());
        } else if (source == this.offsetXSlider) {
            this.fireSettingChanged(source, PROPERTY_OFFSET_X, this.getColorBarOffsetX());
        } else if (source == this.offsetYSlider) {
            this.fireSettingChanged(source, PROPERTY_OFFSET_Y, this.getColorBarOffsetY());
        } else if (source == this.minMaxCheckBox) {
            this.fireSettingChanged(source, PROPERTY_DISPLAY_MINMAX, this.minMaxCheckBox.isSelected());
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.positionComboBox) {
            this.fireSettingChanged(source, PROPERTY_POSITION, this.positionComboBox.getSelectedItem());
        } else if (source == this.resetDefaultButton && ConfirmDialog.confirm((String)"Restore defaults settings of color bar ?")) {
            this.setDisplayMinMax(false);
            this.setColorBarOffsetX(0.0);
            this.setColorBarOffsetY(0.0);
            this.setColorBarScale(1.0);
            this.setPosition(ColorBarOverlay.ColorBarPosition.RIGHT);
        }
    }

    public static interface SettingChangeListener
    extends EventListener {
        public void settingChange(PropertyChangeEvent var1);
    }
}

