/*
 * Decompiled with CFR 0.152.
 */
package plugins.adufour.vars.gui;

import icy.plugin.PluginDescriptor;
import icy.sequence.Sequence;
import icy.swimmingPool.SwimmingObject;
import java.awt.Color;
import plugins.adufour.vars.gui.VarEditor;
import plugins.adufour.vars.gui.swing.SwingFactory;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.lang.VarChannel;
import plugins.adufour.vars.lang.VarFrame;
import plugins.adufour.vars.lang.VarGenericArray;
import plugins.adufour.vars.lang.VarMutable;
import plugins.adufour.vars.lang.VarSlice;
import plugins.adufour.vars.lang.VarTrigger;

public abstract class VarEditorFactory {
    private static VarEditorFactory defaultFactory;

    public static VarEditorFactory getDefaultFactory() {
        return defaultFactory;
    }

    public static VarEditorFactory setDefaultFactory(VarEditorFactoryType factoryType) {
        switch (factoryType) {
            case SWING: {
                defaultFactory = new SwingFactory();
                return defaultFactory;
            }
        }
        throw new IllegalArgumentException("Cannot load the \"" + (Object)((Object)factoryType) + "\" factory");
    }

    public abstract VarEditor<Integer> createButton(VarTrigger var1);

    public abstract VarEditor<Integer> createChannelSelector(VarChannel var1, Var<Sequence> var2, boolean var3);

    public abstract VarEditor<Integer> createFrameSelector(VarFrame var1, Var<Sequence> var2, boolean var3);

    public abstract VarEditor<Integer> createSliceSelector(VarSlice var1, Var<Sequence> var2, boolean var3);

    public abstract VarEditor<Boolean> createCheckBox(Var<Boolean> var1);

    public abstract VarEditor<Color> createColorChooser(Var<Color> var1);

    public abstract <V> VarEditor<V> createComboBox(Var<V> var1);

    public abstract <V> VarEditor<V> createLabel(Var<V> var1);

    public abstract VarEditor createMutableVarEditor(VarMutable var1);

    public abstract VarEditor<PluginDescriptor> createPluginChooser(Var<PluginDescriptor> var1);

    public abstract VarEditor<Sequence> createSequenceChooser(Var<Sequence> var1);

    public abstract VarEditor<Sequence[]> createSequenceList(VarGenericArray<Sequence[]> var1);

    public abstract VarEditor<Sequence> createSequenceViewer(Var<Sequence> var1);

    public abstract <N extends Number> VarEditor<N> createSlider(Var<N> var1);

    public abstract VarEditor<SwimmingObject> createSwimmingObjectChooser(Var<SwimmingObject> var1);

    public abstract <N extends Number> VarEditor<N> createSpinner(Var<N> var1);

    public abstract <V> VarEditor<V> createTextArea(Var<V> var1, int var2);

    public abstract <V> VarEditor<V> createTextField(Var<V> var1);

    public abstract VarEditor<String> createPasswordField(Var<String> var1);

    public abstract VarEditor<VarMutable> createTypeChooser(VarMutable var1);

    static {
        VarEditorFactory.setDefaultFactory(VarEditorFactoryType.SWING);
    }

    public static enum VarEditorFactoryType {
        SWING;

    }
}

