/*
 * Decompiled with CFR 0.152.
 */
package plugins.adufour.vars.gui.swing;

import java.awt.Dimension;
import java.awt.Font;
import java.util.HashMap;
import java.util.Hashtable;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.SliderUI;
import org.pushingpixels.substance.internal.ui.SubstanceSliderUI;
import plugins.adufour.vars.gui.model.RangeModel;
import plugins.adufour.vars.gui.model.VarEditorModel;
import plugins.adufour.vars.gui.swing.SwingVarEditor;
import plugins.adufour.vars.lang.Var;

class Slider<N extends Number>
extends SwingVarEditor<N> {
    private ChangeListener changeListener;

    public Slider(Var<N> variable) {
        super(variable);
    }

    @Override
    public JComponent createEditorComponent() {
        VarEditorModel model = this.variable.getDefaultEditorModel();
        if (model == null || !(model instanceof RangeModel)) {
            throw new UnsupportedOperationException("Incorrect model for variable " + this.variable.getName() + ": " + model);
        }
        final RangeModel constraint = (RangeModel)model;
        int nbTicks = constraint.getRangeSize();
        int currentTick = constraint.indexOf(constraint.getDefaultValue());
        final JSlider jSlider = new JSlider(0, 0, nbTicks, currentTick);
        jSlider.setUI((SliderUI)new SubstanceSliderUI(jSlider){

            protected void calculateTickRect() {
                if (this.slider.getOrientation() == 0) {
                    this.tickRect.x = this.trackRect.x - 5;
                    this.tickRect.y = this.trackRect.y + this.trackRect.height;
                    this.tickRect.width = this.trackRect.width;
                    this.tickRect.height = this.slider.getPaintTicks() ? this.getTickLength() : 0;
                } else {
                    super.calculateTickRect();
                }
            }
        });
        jSlider.setMajorTickSpacing(nbTicks);
        jSlider.setMinorTickSpacing(1);
        jSlider.setPaintTicks(true);
        jSlider.setSnapToTicks(true);
        HashMap labels = constraint.getLabels();
        Hashtable<Integer, JLabel> table = new Hashtable<Integer, JLabel>();
        Font font = new Font("Serif", 0, 11);
        int maxWidth = 0;
        for (Number n : labels.keySet()) {
            JLabel label = new JLabel(labels.get(n));
            label.setOpaque(true);
            label.setFont(font);
            table.put(constraint.indexOf(n), label);
            maxWidth += label.getPreferredSize().width;
        }
        jSlider.setLabelTable(table);
        jSlider.setPaintLabels(true);
        this.changeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (Slider.this.variable.getReference() == null) {
                    Slider.this.variable.setValue(constraint.getValueForIndex(jSlider.getValue()));
                }
            }
        };
        Dimension dim = jSlider.getPreferredSize();
        dim.width = Math.min(dim.width, maxWidth);
        jSlider.setPreferredSize(dim);
        return jSlider;
    }

    @Override
    protected void updateInterfaceValue() {
        Number value = (Number)this.variable.getValue();
        if (value == null) {
            value = (Number)this.variable.getDefaultValue();
        }
        int tick = ((RangeModel)this.variable.getDefaultEditorModel()).indexOf(value);
        this.getEditorComponent().setValue(tick);
    }

    @Override
    public JSlider getEditorComponent() {
        return (JSlider)super.getEditorComponent();
    }

    @Override
    protected void activateListeners() {
        JSlider jSlider = this.getEditorComponent();
        jSlider.addChangeListener(this.changeListener);
    }

    @Override
    protected void deactivateListeners() {
        JSlider jSlider = this.getEditorComponent();
        jSlider.removeChangeListener(this.changeListener);
    }
}

