/*
 * Decompiled with CFR 0.152.
 */
package plugins.adufour.vars.gui.swing;

import java.awt.Dimension;
import java.text.DecimalFormat;
import java.text.ParseException;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.text.NumberFormatter;
import plugins.adufour.vars.gui.model.RangeModel;
import plugins.adufour.vars.gui.model.VarEditorModel;
import plugins.adufour.vars.gui.swing.SwingVarEditor;
import plugins.adufour.vars.lang.Var;

public class Spinner<N extends Number>
extends SwingVarEditor<N> {
    private static final int MAX_SPINNER_WIDTH = 100;
    private NumberFormatter formatter;

    public Spinner(Var<N> variable) {
        super(variable);
    }

    @Override
    public JComponent createEditorComponent() {
        VarEditorModel model = this.variable.getDefaultEditorModel();
        if (model == null || !(model instanceof RangeModel)) {
            throw new UnsupportedOperationException("Incorrect model for variable " + this.variable.getName() + ": " + model);
        }
        RangeModel constraint = (RangeModel)model;
        JSpinner jSpinner = new JSpinner(new SpinnerNumberModel((Number)constraint.getDefaultValue(), constraint.getMinimum(), constraint.getMaximum(), (Number)constraint.getStepSize()){

            @Override
            public void setValue(Object value) {
                super.setValue(value);
                Spinner.this.variable.setValue((Number)value);
            }
        });
        JSpinner.NumberEditor editor = (JSpinner.NumberEditor)jSpinner.getEditor();
        JFormattedTextField field = (JFormattedTextField)editor.getComponent(0);
        this.formatter = (NumberFormatter)field.getFormatter();
        try {
            String min = this.formatter.valueToString(constraint.getMinimum());
            String max = this.formatter.valueToString(constraint.getMaximum());
            String step = this.formatter.valueToString(constraint.getStepSize());
            field.setColumns(Math.max(min.length(), Math.max(max.length(), step.length())));
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        return jSpinner;
    }

    public void setMaximum(Comparable<N> maxValue) {
        ((SpinnerNumberModel)this.getEditorComponent().getModel()).setMaximum(maxValue);
        ((RangeModel)this.variable.getDefaultEditorModel()).setMaximum(maxValue);
    }

    public void setMinimum(Comparable<N> minValue) {
        ((SpinnerNumberModel)this.getEditorComponent().getModel()).setMinimum(minValue);
        ((RangeModel)this.variable.getDefaultEditorModel()).setMinimum(minValue);
    }

    public void setStepSize(N stepSize) {
        ((SpinnerNumberModel)this.getEditorComponent().getModel()).setStepSize((Number)stepSize);
        ((RangeModel)this.variable.getDefaultEditorModel()).setStepSize(stepSize);
    }

    @Override
    protected void updateInterfaceValue() {
        Number value = (Number)this.variable.getValue();
        if (value == null) {
            return;
        }
        if (!value.toString().contains("E") && this.formatter != null && this.formatter.getFormat() != null) {
            ((DecimalFormat)this.formatter.getFormat()).applyPattern(value.toString().replace("-", "").replaceAll("[0-9]", "#"));
        }
        this.getEditorComponent().setValue(value);
    }

    @Override
    public JSpinner getEditorComponent() {
        return (JSpinner)super.getEditorComponent();
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dim = super.getPreferredSize();
        dim.width = Math.min(100, dim.width);
        return dim;
    }

    @Override
    protected void activateListeners() {
    }

    @Override
    protected void deactivateListeners() {
    }
}

