/*
 * Decompiled with CFR 0.152.
 */
package plugins.fab.spotDetector;

import icy.plugin.PluginDescriptor;
import icy.plugin.PluginLoader;
import icy.plugin.abstract_.Plugin;
import icy.roi.ROI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import plugins.fab.spotDetector.GeneralSpotDetectionPanel;
import plugins.fab.spotDetector.GlobalDetectionToken;
import plugins.fab.spotDetector.SpotDetector;
import plugins.fab.spotDetector.roi.ROIDetectionAbstract;

public class ROIPanel
extends GeneralSpotDetectionPanel
implements ActionListener {
    private static final long serialVersionUID = -8556671504886645654L;
    JComboBox inputChoice = new JComboBox();
    JPanel pluginPanel = new JPanel();
    ROIDetectionAbstract roiDetection = null;

    public ROIPanel(SpotDetector spotDetector) {
        super(spotDetector);
        this.setTitle("Region of Interest");
        this.pluginPanel.setLayout(new BorderLayout());
        this.add((Component)this.inputChoice, "North");
        this.add((Component)this.pluginPanel, "Center");
        this.buildInputChoice();
        this.inputChoice.addActionListener(this);
        this.refreshInterface();
    }

    private void buildInputChoice() {
        this.inputChoice.removeAll();
        for (PluginDescriptor pluginDescriptor : PluginLoader.getPlugins()) {
            if (!pluginDescriptor.isInstanceOf(ROIDetectionAbstract.class) || pluginDescriptor.isAbstract()) continue;
            this.inputChoice.addItem(pluginDescriptor);
            if (!pluginDescriptor.getClassName().contains("FromSequence")) continue;
            this.inputChoice.setSelectedItem(pluginDescriptor);
        }
    }

    private void refreshInterface() {
        PluginDescriptor pluginDescriptor = (PluginDescriptor)this.inputChoice.getSelectedItem();
        this.pluginPanel.removeAll();
        Plugin plugin = null;
        try {
            plugin = (Plugin)pluginDescriptor.getPluginClass().newInstance();
        }
        catch (InstantiationException e1) {
            e1.printStackTrace();
        }
        catch (IllegalAccessException e1) {
            e1.printStackTrace();
        }
        this.roiDetection = (ROIDetectionAbstract)plugin;
        this.pluginPanel.add((Component)this.roiDetection.getPanel(), "Center");
        this.pluginPanel.updateUI();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.inputChoice) {
            this.refreshInterface();
        }
    }

    public ArrayList<ROI> getROIs() {
        return null;
    }

    public void process(GlobalDetectionToken gdt) {
        this.roiDetection.process(gdt);
    }
}

