/*
 * Decompiled with CFR 0.152.
 */
package plugins.fab.spotDetector;

import icy.gui.frame.IcyFrame;
import icy.gui.frame.IcyFrameEvent;
import icy.gui.frame.IcyFrameListener;
import icy.gui.frame.progress.AnnounceFrame;
import icy.gui.frame.progress.FailedAnnounceFrame;
import icy.gui.util.GuiUtil;
import icy.network.NetworkUtil;
import icy.plugin.PluginDescriptor;
import icy.plugin.abstract_.PluginActionable;
import icy.system.thread.ThreadUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import plugins.fab.ROITagger.TagPainterManager;
import plugins.fab.spotDetector.ColocalizationPanel;
import plugins.fab.spotDetector.DetectorPanel;
import plugins.fab.spotDetector.DisplayDetectionPanel;
import plugins.fab.spotDetector.FilteringPanel;
import plugins.fab.spotDetector.GeneralSpotDetectionPanel;
import plugins.fab.spotDetector.GlobalDetectionToken;
import plugins.fab.spotDetector.InputPanel;
import plugins.fab.spotDetector.OutPutPanel;
import plugins.fab.spotDetector.PreProcessPanel;
import plugins.fab.spotDetector.ROIPanel;
import plugins.fab.spotDetector.SettingPanel;

public class SpotDetector
extends PluginActionable
implements TreeSelectionListener,
ActionListener,
IcyFrameListener {
    IcyFrame icyFrame;
    private JTree tree;
    private JPanel rightPanel = new JPanel();
    JPanel actionPanel = new JPanel();
    JButton startButton = new JButton("Start Detection");
    JButton helpButton = new JButton("Help");
    JPanel leftPanel = new JPanel();
    JPanel mainPanel = null;
    private ArrayList<GeneralSpotDetectionPanel> spotModulePanelArrayList = new ArrayList();
    SettingPanel settingPanel = new SettingPanel();
    InputPanel inputPanel = new InputPanel(this);
    PreProcessPanel preProcessPanel = new PreProcessPanel(this);
    ROIPanel roiPanel = new ROIPanel(this);
    ColocalizationPanel colocalizationPanel = new ColocalizationPanel(this);
    OutPutPanel outputPanel = new OutPutPanel(this);
    DetectorPanel detectorPanel = new DetectorPanel(this);
    DisplayDetectionPanel displayDetectionPanel = new DisplayDetectionPanel(this);
    FilteringPanel filteringPanel = new FilteringPanel(this);
    DefaultMutableTreeNode rootWizzard = null;
    JScrollPane rightScrollPane = null;
    ComputationThread computationThread = null;

    public ArrayList<GeneralSpotDetectionPanel> getSpotModulePanelArrayList() {
        return new ArrayList<GeneralSpotDetectionPanel>(this.spotModulePanelArrayList);
    }

    private void buildDetectionModulePanelArrayList() {
        this.spotModulePanelArrayList.clear();
        this.spotModulePanelArrayList.add(this.inputPanel);
        this.spotModulePanelArrayList.add(this.preProcessPanel);
        this.spotModulePanelArrayList.add(this.detectorPanel);
        this.spotModulePanelArrayList.add(this.roiPanel);
        this.spotModulePanelArrayList.add(this.filteringPanel);
        this.spotModulePanelArrayList.add(this.outputPanel);
        this.spotModulePanelArrayList.add(this.displayDetectionPanel);
    }

    public void setSelection(String selection) {
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>();
        TreeNode root = (TreeNode)this.tree.getModel().getRoot();
        nodes.add(root);
        Enumeration<? extends TreeNode> children = root.children();
        if (children != null) {
            while (children.hasMoreElements()) {
                TreeNode node = children.nextElement();
                if (node.toString().compareTo(selection) != 0) continue;
                TreePath path = new TreePath(new Object[]{root, node});
                this.tree.setSelectionPath(path);
            }
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        this.rightPanel.removeAll();
        if (node == this.rootWizzard) {
            this.rightPanel.add((Component)this.settingPanel, "Center");
            this.rightPanel.updateUI();
        }
        for (GeneralSpotDetectionPanel pp : this.spotModulePanelArrayList) {
            if (pp.getNode() != node) continue;
            this.rightPanel.add((Component)pp, "Center");
            pp.setVisible(true);
            this.rightPanel.updateUI();
        }
    }

    public void checkAndSetBasicPreferences() {
        this.buildDetectionModulePanelArrayList();
    }

    public void run() {
        this.mainPanel = GuiUtil.generatePanel();
        this.icyFrame = GuiUtil.generateTitleFrame((String)"Spot Detector", (JPanel)this.mainPanel, (Dimension)new Dimension(600, 120), (boolean)true, (boolean)true, (boolean)true, (boolean)true);
        this.buildDetectionModulePanelArrayList();
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("");
        this.rootWizzard = new DefaultMutableTreeNode("Wizard");
        DefaultMutableTreeNode rootSettings = new DefaultMutableTreeNode("Settings");
        for (GeneralSpotDetectionPanel pp : this.spotModulePanelArrayList) {
            rootSettings.add(pp.getNode());
        }
        root.add(rootSettings);
        this.tree = new JTree(root);
        this.tree.setRootVisible(false);
        for (int row = 0; row < this.tree.getRowCount(); ++row) {
            this.tree.expandRow(row);
        }
        this.tree.addTreeSelectionListener(this);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.setOpaque(true);
        JScrollPane treeScrollPane = new JScrollPane(this.tree);
        this.mainPanel.setLayout(new BorderLayout());
        treeScrollPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.actionPanel.setLayout(new BorderLayout());
        this.actionPanel.add((Component)this.startButton, "East");
        this.actionPanel.add((Component)this.helpButton, "West");
        this.helpButton.addActionListener(this);
        this.startButton.addActionListener(this);
        this.leftPanel.setLayout(new BorderLayout());
        this.leftPanel.add((Component)treeScrollPane, "Center");
        this.rightScrollPane = new JScrollPane(this.rightPanel);
        this.mainPanel.add((Component)this.leftPanel, "West");
        this.mainPanel.add((Component)this.rightScrollPane, "Center");
        this.mainPanel.add((Component)this.actionPanel, "South");
        this.rightPanel.setLayout(new BorderLayout());
        this.rightPanel.removeAll();
        this.rightPanel.removeAll();
        this.rightPanel.add(this.settingPanel);
        this.rightPanel.revalidate();
        this.rightScrollPane.revalidate();
        this.icyFrame.addToMainDesktopPane();
        this.icyFrame.setSize(new Dimension(512, 480));
        this.icyFrame.center();
        this.icyFrame.toFront();
        new TagPainterManager();
        this.icyFrame.addFrameListener((IcyFrameListener)this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.startButton) {
            this.startComputation(true, true);
        }
        if (e.getSource() == this.helpButton) {
            NetworkUtil.openBrowser((String)this.getDescriptor().getWeb());
        }
    }

    private void startComputation(boolean performSaveOperation, boolean waitForComputationThreadAndLaunch) {
        if (this.computationThread != null && this.computationThread.busy) {
            return;
        }
        this.computationThread = new ComputationThread();
        this.computationThread.performSaveOperation = performSaveOperation;
        this.computationThread.start();
    }

    public void detectionModuleRequestRecompute(boolean performSaveOperation, boolean waitForComputationThreadAndLaunch) {
        this.startComputation(performSaveOperation, waitForComputationThreadAndLaunch);
    }

    public void fireChange(InputPanel inputPanel) {
    }

    public void icyFrameClosed(IcyFrameEvent e) {
        this.displayDetectionPanel.close();
    }

    public void icyFrameActivated(IcyFrameEvent e) {
    }

    public void icyFrameClosing(IcyFrameEvent e) {
    }

    public void icyFrameDeactivated(IcyFrameEvent e) {
    }

    public void icyFrameDeiconified(IcyFrameEvent e) {
    }

    public void icyFrameExternalized(IcyFrameEvent e) {
    }

    public void icyFrameIconified(IcyFrameEvent e) {
    }

    public void icyFrameInternalized(IcyFrameEvent e) {
    }

    public void icyFrameOpened(IcyFrameEvent e) {
    }

    public void setDetector(PluginDescriptor detectorPluginDescriptorClass) {
        this.detectorPanel.setDetectorPlugin(detectorPluginDescriptorClass);
    }

    class ComputationThread
    extends Thread {
        public boolean performSaveOperation;
        GlobalDetectionToken gdt;
        boolean busy = true;

        ComputationThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        @Override
        public void run() {
            block9: {
                GlobalDetectionToken gdt;
                AnnounceFrame annonceFrame;
                block8: {
                    block7: {
                        annonceFrame = new AnnounceFrame("Computation started");
                        ThreadUtil.invokeNow((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                SpotDetector.this.startButton.setEnabled(false);
                            }
                        });
                        gdt = new GlobalDetectionToken();
                        SpotDetector.this.inputPanel.process(gdt);
                        if (gdt.inputSequence != null) break block7;
                        new FailedAnnounceFrame("No input sequence found");
                        annonceFrame.close();
                        ThreadUtil.invokeNow((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                SpotDetector.this.startButton.setEnabled(true);
                            }
                        });
                        this.busy = false;
                        gdt.fireDetectionFinished();
                        return;
                    }
                    try {
                        SpotDetector.this.preProcessPanel.process(gdt);
                        SpotDetector.this.detectorPanel.process(gdt);
                        SpotDetector.this.roiPanel.process(gdt);
                        SpotDetector.this.filteringPanel.process(gdt);
                        SpotDetector.this.displayDetectionPanel.process(gdt);
                        if (!this.performSaveOperation) break block8;
                        SpotDetector.this.outputPanel.process(gdt);
                    }
                    catch (InterruptedException e) {
                        new FailedAnnounceFrame(e.getMessage());
                        annonceFrame.close();
                        ThreadUtil.invokeNow((Runnable)new /* invalid duplicate definition of identical inner class */);
                        this.busy = false;
                        gdt.fireDetectionFinished();
                        break block9;
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                        {
                            catch (Throwable throwable) {
                                annonceFrame.close();
                                ThreadUtil.invokeNow((Runnable)new /* invalid duplicate definition of identical inner class */);
                                this.busy = false;
                                gdt.fireDetectionFinished();
                                throw throwable;
                            }
                        }
                        annonceFrame.close();
                        ThreadUtil.invokeNow((Runnable)new /* invalid duplicate definition of identical inner class */);
                        this.busy = false;
                        gdt.fireDetectionFinished();
                    }
                }
                annonceFrame.close();
                ThreadUtil.invokeNow((Runnable)new /* invalid duplicate definition of identical inner class */);
                this.busy = false;
                gdt.fireDetectionFinished();
            }
        }
    }
}

