/*
 * Decompiled with CFR 0.152.
 */
package plugins.fab.spotDetector.display;

import icy.gui.component.button.ColorChooserButton;
import icy.gui.main.MainEvent;
import icy.gui.main.MainListener;
import icy.gui.util.ComponentUtil;
import icy.gui.util.GuiUtil;
import icy.main.Icy;
import icy.painter.Painter;
import icy.sequence.Sequence;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import jxl.write.WritableSheet;
import plugins.fab.spotDetector.GlobalDetectionToken;
import plugins.fab.spotDetector.display.BasicDetectionPainter;
import plugins.fab.spotDetector.display.DisplayDetectionAbstract;

public class BasicDetection
extends DisplayDetectionAbstract
implements ActionListener,
ColorChooserButton.ColorChangeListener,
MainListener {
    JCheckBox displayROINumber = new JCheckBox("Display ROI number and name", true);
    JCheckBox displayDetectionMark = new JCheckBox("Display detection mark", true);
    JCheckBox displayDetectionNumberOverROICheckBox = new JCheckBox("Display number of detection of ROI", true);
    ColorChooserButton colorChooserButton = new ColorChooserButton(Color.red);
    JCheckBox projectDetectionMark = new JCheckBox("Project all detections of a same stack", true);
    JCheckBox displayDetectionIndexCheckBox = new JCheckBox("Display detection index", false);
    JTextField fontSizeTextField = new JTextField("14");

    @Override
    public void actionPerformed(ActionEvent e) {
        this.refreshPainterFromInterface();
    }

    public void colorChanged(ColorChooserButton source) {
        this.refreshPainterFromInterface();
    }

    public BasicDetection() {
        this.getPanel().setLayout(new BoxLayout(this.getPanel(), 3));
        this.getPanel().setBorder(new TitledBorder("Basic detection painter"));
        this.getPanel().add(GuiUtil.createLineBoxPanel((Component[])new Component[]{Box.createVerticalStrut(10)}));
        this.getPanel().add(GuiUtil.createLineBoxPanel((Component[])new Component[]{this.displayDetectionMark, Box.createHorizontalGlue()}));
        this.getPanel().add(GuiUtil.createLineBoxPanel((Component[])new Component[]{this.displayDetectionNumberOverROICheckBox, Box.createHorizontalGlue()}));
        this.getPanel().add(GuiUtil.createLineBoxPanel((Component[])new Component[]{this.displayROINumber, Box.createHorizontalGlue()}));
        this.getPanel().add(GuiUtil.createLineBoxPanel((Component[])new Component[]{new JLabel("Detection color: "), this.colorChooserButton, Box.createHorizontalGlue()}));
        this.getPanel().add(GuiUtil.createLineBoxPanel((Component[])new Component[]{this.projectDetectionMark, Box.createHorizontalGlue()}));
        this.getPanel().add(GuiUtil.createLineBoxPanel((Component[])new Component[]{this.displayDetectionIndexCheckBox, Box.createHorizontalGlue()}));
        this.getPanel().add(GuiUtil.createLineBoxPanel((Component[])new Component[]{new JLabel("Font size:"), this.fontSizeTextField, Box.createHorizontalGlue()}));
        ComponentUtil.setFixedHeight((Component)this.fontSizeTextField, (int)20);
        this.displayDetectionNumberOverROICheckBox.addActionListener(this);
        this.displayDetectionMark.addActionListener(this);
        this.displayDetectionIndexCheckBox.addActionListener(this);
        this.displayROINumber.addActionListener(this);
        this.projectDetectionMark.addActionListener(this);
        this.colorChooserButton.addColorChangeListener((ColorChooserButton.ColorChangeListener)this);
        this.fontSizeTextField.addActionListener(this);
        this.getPanel().add(GuiUtil.createLineBoxPanel((Component[])new Component[]{Box.createVerticalStrut(50)}));
        this.getPanel().add(GuiUtil.createLineBoxPanel((Component[])new Component[]{Box.createVerticalGlue()}));
        Icy.getMainInterface().addListener((MainListener)this);
    }

    @Override
    public void process(GlobalDetectionToken gdt) {
        for (Painter painter : gdt.inputSequence.getPainters()) {
            if (!(painter instanceof BasicDetectionPainter)) continue;
            gdt.inputSequence.removePainter(painter);
        }
        BasicDetectionPainter basicDetectionPainter = new BasicDetectionPainter();
        basicDetectionPainter.detectionsHashMap = gdt.roi2detection;
        gdt.inputSequence.addPainter((Painter)basicDetectionPainter);
        this.updatePainter(basicDetectionPainter);
    }

    private void updatePainter(BasicDetectionPainter basicDetectionPainter) {
        basicDetectionPainter.color = this.colorChooserButton.getColor();
        basicDetectionPainter.displayDetectionMark = this.displayDetectionMark.isSelected();
        basicDetectionPainter.displayDetectionNumberOverROI = this.displayDetectionNumberOverROICheckBox.isSelected();
        basicDetectionPainter.displayROINumber = this.displayROINumber.isSelected();
        basicDetectionPainter.projectDetection = this.projectDetectionMark.isSelected();
        basicDetectionPainter.displayDetectionIndex = this.displayDetectionIndexCheckBox.isSelected();
        try {
            basicDetectionPainter.fontLabelSize = Integer.parseInt(this.fontSizeTextField.getText());
        }
        catch (Exception e) {
            basicDetectionPainter.fontLabelSize = 14;
        }
        for (Sequence sequence : Icy.getMainInterface().getSequencesContaining((Painter)basicDetectionPainter)) {
            sequence.painterChanged((Painter)basicDetectionPainter);
        }
    }

    @Override
    public void close() {
        for (Sequence sequence : Icy.getMainInterface().getSequences()) {
            for (Painter painter : sequence.getPainters()) {
                if (!(painter instanceof BasicDetectionPainter)) continue;
                sequence.removePainter(painter);
            }
        }
    }

    public void sequenceFocused(MainEvent event) {
        this.refreshDetectionInterfaceFromSequencePainter();
    }

    private void refreshPainterFromInterface() {
        Sequence focusedSequence = this.getFocusedSequence();
        if (focusedSequence != null) {
            for (Painter painter : focusedSequence.getPainters()) {
                if (!(painter instanceof BasicDetectionPainter)) continue;
                BasicDetectionPainter bdp = (BasicDetectionPainter)painter;
                this.updatePainter(bdp);
            }
        }
    }

    private void refreshDetectionInterfaceFromSequencePainter() {
        Sequence focusedSequence = this.getFocusedSequence();
        if (focusedSequence != null) {
            for (Painter painter : focusedSequence.getPainters()) {
                if (!(painter instanceof BasicDetectionPainter)) continue;
                BasicDetectionPainter basicDetectionPainter = (BasicDetectionPainter)painter;
                this.colorChooserButton.setEnabled(false);
                this.colorChooserButton.setColor(basicDetectionPainter.color);
                this.colorChooserButton.setEnabled(true);
                this.displayDetectionMark.setEnabled(false);
                this.displayDetectionMark.setSelected(basicDetectionPainter.displayDetectionMark);
                this.displayDetectionMark.setEnabled(true);
                this.displayDetectionNumberOverROICheckBox.setEnabled(false);
                this.displayDetectionNumberOverROICheckBox.setSelected(basicDetectionPainter.displayDetectionNumberOverROI);
                this.displayDetectionNumberOverROICheckBox.setEnabled(true);
                this.displayROINumber.setEnabled(false);
                this.displayROINumber.setSelected(basicDetectionPainter.displayROINumber);
                this.displayROINumber.setEnabled(true);
                this.projectDetectionMark.setEnabled(false);
                this.projectDetectionMark.setSelected(basicDetectionPainter.projectDetection);
                this.projectDetectionMark.setEnabled(true);
            }
        }
    }

    public void pluginOpened(MainEvent event) {
    }

    public void pluginClosed(MainEvent event) {
    }

    public void viewerOpened(MainEvent event) {
    }

    public void viewerFocused(MainEvent event) {
    }

    public void viewerClosed(MainEvent event) {
    }

    public void sequenceOpened(MainEvent event) {
    }

    public void sequenceClosed(MainEvent event) {
    }

    public void roiAdded(MainEvent event) {
    }

    public void roiRemoved(MainEvent event) {
    }

    public void painterAdded(MainEvent event) {
    }

    public void painterRemoved(MainEvent event) {
    }

    @Override
    public void saveXLS(WritableSheet page, GlobalDetectionToken gdt) {
    }
}

