/*
 * Decompiled with CFR 0.152.
 */
package plugins.fab.spotDetector.input;

import icy.file.FileUtil;
import icy.file.Loader;
import icy.file.SequenceFileImporter;
import icy.gui.frame.progress.ProgressFrame;
import icy.gui.util.GuiUtil;
import icy.main.Icy;
import icy.sequence.Sequence;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.border.TitledBorder;
import jxl.write.WritableSheet;
import plugins.fab.spotDetector.GlobalDetectionToken;
import plugins.fab.spotDetector.GlobalDetectionTokenListener;
import plugins.fab.spotDetector.input.InputDetectionAbstract;

public class batchInputDetection
extends InputDetectionAbstract
implements ActionListener,
GlobalDetectionTokenListener {
    JButton inputFolderButton = new JButton("No folder selected");
    JLabel fileToProcessLabel = new JLabel("no files to process");
    ArrayList<File> originalFileToProcessArrayList = new ArrayList();
    ArrayList<File> processFileToProcessArrayList = new ArrayList();
    ProgressFrame progressFrame = null;

    public batchInputDetection() {
        this.getPanel().setLayout(new BoxLayout(this.getPanel(), 3));
        this.getPanel().setBorder(new TitledBorder("Batch Input. Grab all file recursivly but does not enter in 'save' folders"));
        this.getPanel().add(GuiUtil.createLineBoxPanel((Component[])new Component[]{Box.createVerticalGlue()}));
        this.getPanel().add(GuiUtil.createLineBoxPanel((Component[])new Component[]{new JLabel("Current input folder:")}));
        this.getPanel().add(GuiUtil.createLineBoxPanel((Component[])new Component[]{Box.createVerticalStrut(10)}));
        this.getPanel().add(GuiUtil.createLineBoxPanel((Component[])new Component[]{this.inputFolderButton}));
        this.inputFolderButton.addActionListener(this);
        this.getPanel().add(GuiUtil.createLineBoxPanel((Component[])new Component[]{Box.createVerticalStrut(10)}));
        this.getPanel().add(GuiUtil.createLineBoxPanel((Component[])new Component[]{this.fileToProcessLabel}));
        this.getPanel().add(GuiUtil.createLineBoxPanel((Component[])new Component[]{Box.createVerticalStrut(50)}));
        this.getPanel().add(GuiUtil.createLineBoxPanel((Component[])new Component[]{Box.createVerticalGlue()}));
    }

    @Override
    public void detectionFinished() {
        if (this.processFileToProcessArrayList.size() > 0) {
            this.spotDetector.detectionModuleRequestRecompute(true, true);
        } else {
            this.processFileToProcessArrayList = new ArrayList<File>(this.originalFileToProcessArrayList);
            this.progressFrame = null;
        }
    }

    @Override
    public void process(GlobalDetectionToken gdt) {
        Icy.getMainInterface().closeAllViewers();
        if (this.progressFrame == null) {
            this.progressFrame = new ProgressFrame("");
        }
        this.progressFrame.setMessage("Processing ... " + this.processFileToProcessArrayList.size() + " remaining.");
        gdt.addGlobalDetectionTokenListener(this);
        if (this.processFileToProcessArrayList.size() > 0) {
            Sequence sequence;
            String path = this.processFileToProcessArrayList.remove(0).getAbsolutePath();
            gdt.inputSequence = sequence = Loader.loadSequence((SequenceFileImporter)Loader.getSequenceFileImporter((String)path, (boolean)true), (String)path, (int)0, (boolean)false);
        }
        if (this.processFileToProcessArrayList.size() == 0) {
            this.progressFrame.close();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.inputFolderButton) {
            int returnValue;
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.setDialogType(1);
            fileChooser.setFileSelectionMode(1);
            Preferences preferences = Preferences.userRoot().node("icy/browser");
            String browserDirectory = preferences.get("path", "");
            if (browserDirectory == "") {
                fileChooser.setCurrentDirectory(new File(browserDirectory));
            }
            if ((returnValue = fileChooser.showDialog(null, "Root Directory of scan")) == 0) {
                String scanDirectory = fileChooser.getSelectedFile().getAbsolutePath();
                this.inputFolderButton.setText(scanDirectory);
                preferences.put("path", fileChooser.getCurrentDirectory().getPath());
                this.buildFileList(scanDirectory);
            }
        }
    }

    private void buildFileList(String scanDirectory) {
        File mainDir = new File(scanDirectory);
        this.originalFileToProcessArrayList.clear();
        this.scanDir(mainDir);
        this.fileToProcessLabel.setText("Total number of files in batch:" + this.originalFileToProcessArrayList.size());
    }

    public void scanDir(File directory) {
        List<File> listImages = null;
        try {
            listImages = Arrays.asList(directory.listFiles());
            if (listImages == null || listImages.size() == 0) {
                JOptionPane.showMessageDialog(null, "No file ! Try selecting the parent directory of this folder", "Error", 0);
                return;
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "No file ! Try selecting the parent directory of this folder", "Error", 0);
            return;
        }
        Collections.sort(listImages);
        for (File file : listImages) {
            if (file.isDirectory()) {
                String fileAsString = file.getAbsolutePath();
                if (fileAsString.contains("save")) continue;
                this.scanDir(file);
                continue;
            }
            if (file.isHidden() || FileUtil.getFileExtension((String)file.getName(), (boolean)false).toLowerCase().contains("xml")) continue;
            this.originalFileToProcessArrayList.add(file);
        }
        this.processFileToProcessArrayList = new ArrayList<File>(this.originalFileToProcessArrayList);
    }

    @Override
    public void saveXLS(WritableSheet page, GlobalDetectionToken gdt) {
    }
}

