/*
 * Decompiled with CFR 0.152.
 */
package plugins.tprovoost.scripteditor.completion.types;

import japa.parser.ast.body.ClassOrInterfaceDeclaration;
import japa.parser.ast.body.JavadocComment;
import java.io.InputStream;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Segment;
import org.fife.ui.autocomplete.CompletionProvider;
import org.fife.ui.autocomplete.VariableCompletion;
import plugins.tprovoost.scripteditor.javasource.ClassSource;
import plugins.tprovoost.scripteditor.javasource.JarAccess;

public class BasicJavaClassCompletion
extends VariableCompletion {
    private static HashMap<Class<?>, String> cache = new HashMap();
    private Class<?> clazz;
    private boolean importOnly;
    private boolean parsingDone = false;

    public BasicJavaClassCompletion(CompletionProvider provider, Class<?> clazz) {
        this(provider, clazz, false);
    }

    public BasicJavaClassCompletion(CompletionProvider provider, Class<?> clazz, boolean importOnly) {
        super(provider, clazz.getSimpleName(), clazz.getSimpleName());
        this.clazz = clazz;
        this.importOnly = importOnly;
    }

    public Class<?> getJavaClass() {
        return this.clazz;
    }

    public boolean isParsingDone() {
        return this.parsingDone;
    }

    public boolean isAbstract() {
        return Modifier.isAbstract(this.clazz.getModifiers());
    }

    public String getSummary() {
        String summaryCache = cache.get(this.clazz);
        if (!this.parsingDone) {
            if (summaryCache == null) {
                ClassOrInterfaceDeclaration coi;
                ClassSource cs = ClassSource.getClassSource(this.clazz);
                if (!cs.isClassOrInterfacesSet()) {
                    cs.populateClassesOrInterfaces();
                }
                if ((coi = cs.getClassOrInterfaces().get(this.clazz.getName())) != null && coi.getJavaDoc() != null) {
                    JavadocComment comment = coi.getJavaDoc();
                    if (comment != null) {
                        String content = comment.getContent();
                        summaryCache = content = ClassSource.docCommentToHtml("/**" + content + "*/");
                    }
                } else {
                    summaryCache = "";
                }
                cache.put(this.clazz, summaryCache);
            }
            this.parsingDone = true;
            super.setSummary(summaryCache);
        }
        StringBuilder sb = new StringBuilder();
        this.addDefinitionString(sb);
        this.possiblyAddDescription(sb);
        this.possiblyAddDefinedIn(sb);
        this.possiblyAddSource(sb);
        sb.append("</html>");
        return sb.toString();
    }

    private void possiblyAddSource(StringBuilder sb) {
        InputStream is = JarAccess.getJavaSourceInputStream(this.clazz);
        if (is != null) {
            sb.append("<hr><a href=\"SourceCodeLink\">View Source</a>");
        }
    }

    public String getShortDescription() {
        if (this.parsingDone && cache.get(this.clazz) != null) {
            return cache.get(this.clazz);
        }
        return super.getDefinitionString();
    }

    public String getAlreadyEntered(JTextComponent comp) {
        Document doc = comp.getDocument();
        Segment seg = new Segment();
        int dot = comp.getCaretPosition();
        Element root = doc.getDefaultRootElement();
        int index = root.getElementIndex(dot);
        Element elem = root.getElement(index);
        int start = elem.getStartOffset();
        int len = dot - start;
        try {
            doc.getText(start, len, seg);
        }
        catch (BadLocationException ble) {
            ble.printStackTrace();
            return "";
        }
        int segEnd = seg.offset + len;
        start = segEnd - 1;
        while (start >= seg.offset && this.isValidChar(seg.array[start])) {
            --start;
        }
        return (len = segEnd - ++start) == 0 ? "" : new String(seg.array, start, len);
    }

    private boolean isValidChar(char ch) {
        return Character.isLetterOrDigit(ch) || ch == '_' || ch == '\"';
    }

    public boolean importOnly() {
        return this.importOnly;
    }
}

