/*
 * Decompiled with CFR 0.152.
 */
package plugins.tprovoost.scripteditor.gui;

import icy.gui.frame.IcyFrame;
import icy.preferences.GeneralPreferences;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.EventListenerList;
import plugins.tprovoost.scripteditor.gui.Preferences;
import plugins.tprovoost.scripteditor.gui.PreferencesListener;

public class PreferencesWindow
extends IcyFrame {
    private static PreferencesWindow singleton = new PreferencesWindow();
    private Preferences preferences = Preferences.getPreferences();
    private JSpinner spinFontSize;
    private JSpinner tfSpacesTab;
    private JCheckBox cboxSoft;
    private JCheckBox cboxAutoClearOutput;
    private JCheckBox cboxFullAutocomplete;
    private final EventListenerList listeners = new EventListenerList();

    private PreferencesWindow() {
        super("Script Editor Preferences", true, true, false, true);
        this.setContentPane(this.createGUI());
    }

    public static PreferencesWindow getPreferencesWindow() {
        return singleton;
    }

    private JPanel createGUI() {
        JPanel toReturn = new JPanel();
        toReturn.setBorder(new EmptyBorder(4, 4, 4, 4));
        toReturn.setLayout(new BorderLayout(0, 0));
        JLabel lblPreferences = new JLabel("<html><h2>Preferences</h2></html>");
        lblPreferences.setHorizontalAlignment(0);
        toReturn.add((Component)lblPreferences, "North");
        JPanel panelCenter = new JPanel();
        toReturn.add((Component)panelCenter, "Center");
        GridBagLayout gbl_panel_1 = new GridBagLayout();
        gbl_panel_1.columnWidths = new int[3];
        gbl_panel_1.rowHeights = new int[6];
        gbl_panel_1.columnWeights = new double[]{1.0, 0.0, Double.MIN_VALUE};
        gbl_panel_1.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
        panelCenter.setLayout(gbl_panel_1);
        JLabel lblFullAutocomplete = new JLabel("Enable 'auto complete' after any character typed");
        GridBagConstraints gbc_lblFullAutocomplete = new GridBagConstraints();
        gbc_lblFullAutocomplete.anchor = 17;
        gbc_lblFullAutocomplete.insets = new Insets(0, 0, 5, 5);
        gbc_lblFullAutocomplete.gridx = 0;
        gbc_lblFullAutocomplete.gridy = 0;
        panelCenter.add((Component)lblFullAutocomplete, gbc_lblFullAutocomplete);
        this.cboxFullAutocomplete = new JCheckBox("");
        GridBagConstraints gbc_cboxFullAutocomplete = new GridBagConstraints();
        gbc_cboxFullAutocomplete.anchor = 17;
        gbc_cboxFullAutocomplete.insets = new Insets(0, 0, 5, 0);
        gbc_cboxFullAutocomplete.gridx = 1;
        gbc_cboxFullAutocomplete.gridy = 0;
        panelCenter.add((Component)this.cboxFullAutocomplete, gbc_cboxFullAutocomplete);
        JLabel lblAutoClearOutput = new JLabel("Always clear the output when run is clicked");
        GridBagConstraints gbc_lblAutoClearOutput = new GridBagConstraints();
        gbc_lblAutoClearOutput.anchor = 17;
        gbc_lblAutoClearOutput.insets = new Insets(0, 0, 5, 5);
        gbc_lblAutoClearOutput.gridx = 0;
        gbc_lblAutoClearOutput.gridy = 1;
        panelCenter.add((Component)lblAutoClearOutput, gbc_lblAutoClearOutput);
        this.cboxAutoClearOutput = new JCheckBox("");
        GridBagConstraints gbc_cboxAutoClearOutput = new GridBagConstraints();
        gbc_cboxAutoClearOutput.anchor = 17;
        gbc_cboxAutoClearOutput.insets = new Insets(0, 0, 5, 0);
        gbc_cboxAutoClearOutput.gridx = 1;
        gbc_cboxAutoClearOutput.gridy = 1;
        panelCenter.add((Component)this.cboxAutoClearOutput, gbc_cboxAutoClearOutput);
        JLabel lblSoft = new JLabel("Use Soft tabs");
        lblSoft.setToolTipText("Auto-expand tabs to spaces");
        GridBagConstraints gbc_lblSoft = new GridBagConstraints();
        gbc_lblSoft.anchor = 17;
        gbc_lblSoft.insets = new Insets(0, 0, 5, 5);
        gbc_lblSoft.gridx = 0;
        gbc_lblSoft.gridy = 2;
        panelCenter.add((Component)lblSoft, gbc_lblSoft);
        this.cboxSoft = new JCheckBox("");
        GridBagConstraints gbc_cboxSoft = new GridBagConstraints();
        gbc_cboxSoft.anchor = 17;
        gbc_cboxSoft.insets = new Insets(0, 0, 5, 0);
        gbc_cboxSoft.gridx = 1;
        gbc_cboxSoft.gridy = 2;
        panelCenter.add((Component)this.cboxSoft, gbc_cboxSoft);
        JLabel lblSpacesTab = new JLabel("Tab width");
        GridBagConstraints gbc_lblSpacesTab = new GridBagConstraints();
        gbc_lblSpacesTab.anchor = 17;
        gbc_lblSpacesTab.insets = new Insets(0, 0, 5, 5);
        gbc_lblSpacesTab.gridx = 0;
        gbc_lblSpacesTab.gridy = 3;
        panelCenter.add((Component)lblSpacesTab, gbc_lblSpacesTab);
        this.tfSpacesTab = new JSpinner();
        this.tfSpacesTab.setModel(new SpinnerNumberModel(4, 1, 10, 1));
        GridBagConstraints gbc_tfSpacesTab = new GridBagConstraints();
        gbc_tfSpacesTab.fill = 2;
        gbc_tfSpacesTab.insets = new Insets(0, 0, 5, 0);
        gbc_tfSpacesTab.gridx = 1;
        gbc_tfSpacesTab.gridy = 3;
        panelCenter.add((Component)this.tfSpacesTab, gbc_tfSpacesTab);
        JLabel lblFontSize = new JLabel("Font size");
        GridBagConstraints gbc_lblFontSize = new GridBagConstraints();
        gbc_lblFontSize.anchor = 17;
        gbc_lblFontSize.insets = new Insets(0, 0, 0, 5);
        gbc_lblFontSize.gridx = 0;
        gbc_lblFontSize.gridy = 4;
        panelCenter.add((Component)lblFontSize, gbc_lblFontSize);
        this.spinFontSize = new JSpinner(new SpinnerNumberModel(GeneralPreferences.getGuiFontSize(), 4, 30, 1));
        GridBagConstraints gbc_spinFontSize = new GridBagConstraints();
        gbc_spinFontSize.fill = 2;
        gbc_spinFontSize.gridx = 1;
        gbc_spinFontSize.gridy = 4;
        panelCenter.add((Component)this.spinFontSize, gbc_spinFontSize);
        JPanel panelButton = new JPanel();
        toReturn.add((Component)panelButton, "South");
        GridBagLayout gbl_panelButton = new GridBagLayout();
        int[] nArray = new int[5];
        nArray[0] = 131;
        nArray[1] = 59;
        nArray[2] = 45;
        nArray[3] = 65;
        gbl_panelButton.columnWidths = nArray;
        int[] nArray2 = new int[2];
        nArray2[0] = 23;
        gbl_panelButton.rowHeights = nArray2;
        gbl_panelButton.columnWeights = new double[]{1.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
        gbl_panelButton.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        panelButton.setLayout(gbl_panelButton);
        JButton btnApply = new JButton("Apply");
        GridBagConstraints gbc_btnApply = new GridBagConstraints();
        gbc_btnApply.anchor = 11;
        gbc_btnApply.insets = new Insets(0, 0, 0, 5);
        gbc_btnApply.gridx = 1;
        gbc_btnApply.gridy = 0;
        panelButton.add((Component)btnApply, gbc_btnApply);
        btnApply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreferencesWindow.this.applyPreferences();
            }
        });
        JButton btnOk = new JButton("Ok");
        GridBagConstraints gbc_btnOk = new GridBagConstraints();
        gbc_btnOk.anchor = 11;
        gbc_btnOk.insets = new Insets(0, 0, 0, 5);
        gbc_btnOk.gridx = 2;
        gbc_btnOk.gridy = 0;
        panelButton.add((Component)btnOk, gbc_btnOk);
        btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreferencesWindow.this.applyPreferences();
                PreferencesWindow.this.close();
            }
        });
        JButton btnCancel = new JButton("Cancel");
        GridBagConstraints gbc_btnCancel = new GridBagConstraints();
        gbc_btnCancel.anchor = 11;
        gbc_btnCancel.gridx = 3;
        gbc_btnCancel.gridy = 0;
        panelButton.add((Component)btnCancel, gbc_btnCancel);
        btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreferencesWindow.this.initGUI();
                PreferencesWindow.this.close();
            }
        });
        this.initGUI();
        return toReturn;
    }

    void initGUI() {
        this.cboxFullAutocomplete.setSelected(this.preferences.isFullAutoCompleteEnabled());
        this.cboxAutoClearOutput.setSelected(this.preferences.isAutoClearOutputEnabled());
        this.cboxSoft.setSelected(this.preferences.isSoftTabsEnabled());
        this.tfSpacesTab.setValue(this.preferences.indentSpacesCount());
        this.spinFontSize.setValue(this.preferences.getFontSize());
    }

    void applyPreferences() {
        this.preferences.setFullAutoCompleteEnabled(this.cboxFullAutocomplete.isSelected());
        this.preferences.setAutoClearOutputEnabled(this.cboxAutoClearOutput.isSelected());
        this.preferences.setSoftTabsEnabled(this.cboxSoft.isSelected());
        this.preferences.setTabWidth((Integer)this.tfSpacesTab.getValue());
        this.preferences.setFontSize((Integer)this.spinFontSize.getValue());
        this.preferences.savePrefs();
        this.firePreferencesChanged();
    }

    public void addPreferencesListener(PreferencesListener listener) {
        this.listeners.add(PreferencesListener.class, listener);
    }

    public void removePreferencesListener(PreferencesListener listener) {
        this.listeners.remove(PreferencesListener.class, listener);
    }

    protected void firePreferencesChanged() {
        PreferencesListener[] preferencesListenerArray = this.getPreferencesListeners();
        int n = preferencesListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            PreferencesListener listener = preferencesListenerArray[n2];
            listener.preferencesChanged();
            ++n2;
        }
    }

    public PreferencesListener[] getPreferencesListeners() {
        return (PreferencesListener[])this.listeners.getListeners(PreferencesListener.class);
    }
}

