/*
 * Decompiled with CFR 0.152.
 */
package icy.math;

import icy.file.FileUtil;
import icy.gui.dialog.MessageDialog;
import icy.gui.dialog.SaveDialog;
import icy.type.TypeUtil;
import icy.type.collection.array.ArrayUtil;
import icy.util.StringUtil;
import icy.util.XLSUtil;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;

public class Histogram {
    protected final int[] bins;
    protected final double minValue;
    protected final double maxValue;
    protected final boolean integer;
    protected final double dataToBin;
    protected final double binWidth;

    public Histogram(double minValue, double maxValue, int nbBin, boolean integer) {
        double bw;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.integer = integer;
        double range = maxValue - minValue;
        if (integer) {
            if ((double)nbBin > range) {
                bw = 1.0;
            } else {
                bw = (range + 1.0) / (double)nbBin;
                bw = Math.max(1.0, Math.floor(bw));
            }
            this.bins = new int[(int)Math.ceil((range + 1.0) / bw)];
        } else {
            bw = range / (double)nbBin;
            this.bins = new int[nbBin];
        }
        this.binWidth = bw;
        this.dataToBin = range > 0.0 ? (double)(this.bins.length - 1) / range : 0.0;
    }

    public String getCSVFormattedData() {
        StringBuffer sbf = new StringBuffer();
        double bw = this.getBinWidth();
        sbf.append("Bin range min (inclusive)");
        sbf.append("\t");
        sbf.append("Bin range max (exclusive)");
        sbf.append("\t");
        sbf.append("Pixel number");
        sbf.append("\t");
        sbf.append("\r\n");
        double range = this.getMinValue();
        for (int bin : this.getBins()) {
            sbf.append(StringUtil.toString(range));
            sbf.append("\t");
            sbf.append(StringUtil.toString(range += bw));
            sbf.append("\t");
            sbf.append(StringUtil.toString(bin));
            sbf.append("\r\n");
        }
        return sbf.toString();
    }

    public void doXLSExport() throws IOException, WriteException {
        this.exportToXLS(SaveDialog.chooseFileForResult("Export histogram...", "histo", ".xls"));
    }

    public void exportToXLS(String path) throws IOException, WriteException {
        if (StringUtil.isEmpty(path)) {
            return;
        }
        String csvContent = this.getCSVFormattedData();
        if (!FileUtil.getFileExtension(path, false).toLowerCase().startsWith("xls")) {
            PrintWriter out = new PrintWriter(path);
            out.println(csvContent);
            out.close();
        } else {
            WritableWorkbook workbook = XLSUtil.createWorkbook(path);
            WritableSheet sheet = XLSUtil.createNewPage(workbook, "ROIS");
            try {
                if (XLSUtil.setFromCSV(sheet, csvContent)) {
                    XLSUtil.saveAndClose(workbook);
                } else {
                    MessageDialog.showDialog("Error", "Error while exporting ROIs table content to XLS file.", 0);
                }
            }
            catch (InterruptedException e1) {
                MessageDialog.showDialog("Operation interrupted", e1.getLocalizedMessage(), 0);
            }
        }
    }

    public void reset() {
        Arrays.fill(this.bins, 0);
    }

    public void addValue(double value) {
        int index = (int)((value - this.minValue) * this.dataToBin);
        if (index >= 0 && index < this.bins.length) {
            int n = index;
            this.bins[n] = this.bins[n] + 1;
        }
    }

    public void addValues(Object array, boolean signed) {
        switch (ArrayUtil.getDataType(array)) {
            case BYTE: {
                this.addValues((byte[])array, signed);
                break;
            }
            case SHORT: {
                this.addValues((short[])array, signed);
                break;
            }
            case INT: {
                this.addValues((int[])array, signed);
                break;
            }
            case LONG: {
                this.addValues((long[])array, signed);
                break;
            }
            case FLOAT: {
                this.addValues((float[])array);
                break;
            }
            case DOUBLE: {
                this.addValues((double[])array);
            }
        }
    }

    public void addValues(byte[] array, boolean signed) {
        if (signed) {
            for (byte value : array) {
                int n = (int)(((double)value - this.minValue) * this.dataToBin);
                this.bins[n] = this.bins[n] + 1;
            }
        } else {
            for (byte value : array) {
                int n = (int)(((double)TypeUtil.unsign(value) - this.minValue) * this.dataToBin);
                this.bins[n] = this.bins[n] + 1;
            }
        }
    }

    public void addValues(short[] array, boolean signed) {
        if (signed) {
            for (short value : array) {
                int n = (int)(((double)value - this.minValue) * this.dataToBin);
                this.bins[n] = this.bins[n] + 1;
            }
        } else {
            for (short value : array) {
                int n = (int)(((double)TypeUtil.unsign(value) - this.minValue) * this.dataToBin);
                this.bins[n] = this.bins[n] + 1;
            }
        }
    }

    public void addValues(int[] array, boolean signed) {
        if (signed) {
            for (int value : array) {
                int n = (int)(((double)value - this.minValue) * this.dataToBin);
                this.bins[n] = this.bins[n] + 1;
            }
        } else {
            for (int value : array) {
                int n = (int)(((double)TypeUtil.unsign(value) - this.minValue) * this.dataToBin);
                this.bins[n] = this.bins[n] + 1;
            }
        }
    }

    public void addValues(long[] array, boolean signed) {
        if (signed) {
            for (long value : array) {
                int n = (int)(((double)value - this.minValue) * this.dataToBin);
                this.bins[n] = this.bins[n] + 1;
            }
        } else {
            for (long value : array) {
                int n = (int)((TypeUtil.unsign(value) - this.minValue) * this.dataToBin);
                this.bins[n] = this.bins[n] + 1;
            }
        }
    }

    public void addValues(float[] array) {
        for (float value : array) {
            int n = (int)(((double)value - this.minValue) * this.dataToBin);
            this.bins[n] = this.bins[n] + 1;
        }
    }

    public void addValues(double[] array) {
        for (double value : array) {
            int n = (int)((value - this.minValue) * this.dataToBin);
            this.bins[n] = this.bins[n] + 1;
        }
    }

    protected int toBinIndex(double value) {
        return (int)Math.round((value - this.minValue) * this.dataToBin);
    }

    public double getMinValue() {
        return this.minValue;
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    public boolean isIntegerType() {
        return this.integer;
    }

    public int getBinNumber() {
        return this.bins.length;
    }

    public double getBinWidth() {
        return this.binWidth;
    }

    public int getBinSize(int index) {
        if (index < 0 || index >= this.bins.length) {
            return 0;
        }
        return this.bins[index];
    }

    public int[] getBins() {
        return this.bins;
    }
}

