/*
 * Decompiled with CFR 0.152.
 */
package plugins.kernel.roi.morphology;

import icy.image.IcyBufferedImage;
import icy.roi.ROI;
import icy.roi.ROI2D;
import icy.roi.ROI3D;
import icy.sequence.Sequence;
import icy.sequence.SequenceDataIterator;
import icy.sequence.VolumetricImage;
import icy.type.DataIteratorUtil;
import icy.type.DataType;
import icy.type.dimension.Dimension3D;
import icy.type.dimension.Dimension5D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class ROIDistanceTransformCalculator {
    private Dimension5D imageSize;
    private Dimension3D pixelSize;
    private boolean constrainImageBorders;
    private List<ROI> rois;
    Sequence distanceMap;
    double[] buffer;
    private VolumetricImage currentVolumeImage;
    private double[][] currentVolumePlanes;
    private int currentK;
    private int currentJ;
    private int currentI;
    private double squaredSizeY;
    private double squaredSizeZ;
    private double maxDistance;

    public ROIDistanceTransformCalculator(Dimension5D imageSize, Dimension3D pixelSize, boolean constrainImageBorders) {
        this.imageSize = imageSize;
        this.pixelSize = pixelSize;
        this.constrainImageBorders = constrainImageBorders;
        this.rois = new ArrayList<ROI>();
    }

    public <T extends ROI> void addROI(T roi) {
        this.rois.add(roi);
    }

    public <T extends ROI> void addAll(Collection<T> rois) {
        this.rois.addAll(rois);
    }

    public Sequence getDistanceMap() throws InterruptedException {
        if (this.distanceMap == null) {
            this.compute();
        }
        return this.distanceMap;
    }

    public void compute() throws InterruptedException {
        this.initializeDistanceMap();
        this.drawROIs();
        this.processTimePoints();
    }

    private void initializeDistanceMap() {
        this.distanceMap = new Sequence();
        this.distanceMap.setPixelSizeX(this.pixelSize.getSizeX());
        this.distanceMap.setPixelSizeY(this.pixelSize.getSizeY());
        this.distanceMap.setPixelSizeZ(this.pixelSize.getSizeZ());
        int m = 0;
        while ((double)m < this.imageSize.getSizeT()) {
            VolumetricImage volume = new VolumetricImage();
            int k = 0;
            while ((double)k < this.imageSize.getSizeZ()) {
                IcyBufferedImage plane = new IcyBufferedImage((int)this.imageSize.getSizeX(), (int)this.imageSize.getSizeY(), 1, DataType.DOUBLE);
                volume.setImage(k, plane);
                ++k;
            }
            this.distanceMap.addVolumetricImage(m, volume);
            ++m;
        }
        this.buffer = new double[Math.max((int)this.imageSize.getSizeY(), (int)this.imageSize.getSizeZ())];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawROIs() throws InterruptedException {
        Iterator<ROI> iterator = this.rois.iterator();
        while (iterator.hasNext()) {
            ROI roi;
            ROI rOI = roi = iterator.next();
            synchronized (rOI) {
                int oldC = 0;
                if (roi instanceof ROI2D) {
                    oldC = ((ROI2D)roi).getC();
                    ((ROI2D)roi).setC(0);
                } else if (roi instanceof ROI3D) {
                    oldC = ((ROI3D)roi).getC();
                    ((ROI3D)roi).setC(0);
                }
                try {
                    DataIteratorUtil.set(new SequenceDataIterator(this.distanceMap, roi, true), 1.0);
                }
                finally {
                    if (roi instanceof ROI2D) {
                        ((ROI2D)roi).setC(oldC);
                    } else if (roi instanceof ROI3D) {
                        ((ROI3D)roi).setC(oldC);
                    }
                }
            }
        }
    }

    private void processTimePoints() throws InterruptedException {
        int t = 0;
        while ((double)t < this.imageSize.getSizeT()) {
            if (Thread.interrupted()) {
                throw new InterruptedException("ROI distance transform descriptor computation interrupted.");
            }
            this.currentVolumeImage = this.distanceMap.getVolumetricImage(t);
            this.processCurrentVolume();
            ++t;
        }
        this.distanceMap.dataChanged();
    }

    private void processCurrentVolume() throws InterruptedException {
        this.currentVolumePlanes = new double[(int)this.imageSize.getSizeZ()][];
        this.squaredSizeY = this.pixelSize.getSizeY() * this.pixelSize.getSizeY();
        this.squaredSizeZ = this.pixelSize.getSizeZ() * this.pixelSize.getSizeZ();
        this.maxDistance = Math.max(Math.max(this.imageSize.getSizeX() * this.pixelSize.getSizeX(), this.imageSize.getSizeY() * this.pixelSize.getSizeY()), this.imageSize.getSizeZ() * this.pixelSize.getSizeZ());
        this.maxDistance *= this.maxDistance;
        int k = 0;
        while ((double)k < this.imageSize.getSizeZ()) {
            if (Thread.interrupted()) {
                throw new InterruptedException("ROI distance transform descriptor computation interrupted.");
            }
            double[] currentPlaneData = this.currentVolumeImage.getImage(k).getDataXYAsDouble(0);
            this.currentVolumePlanes[k] = currentPlaneData;
            this.currentK = k++;
            this.processCurrentPlane();
        }
        if (this.imageSize.getSizeZ() > 1.0) {
            int j = 0;
            while ((double)j < this.imageSize.getSizeY()) {
                if (Thread.interrupted()) {
                    throw new InterruptedException("ROI distance transform descriptor computation interrupted.");
                }
                this.currentJ = j;
                int i = 0;
                while ((double)i < this.imageSize.getSizeX()) {
                    this.currentI = i++;
                    this.processCurrentFiber();
                }
                ++j;
            }
        }
        k = 0;
        while ((double)k < this.imageSize.getSizeZ()) {
            if (Thread.interrupted()) {
                throw new InterruptedException("ROI distance transform descriptor computation interrupted.");
            }
            int j = 0;
            while ((double)j < this.imageSize.getSizeY()) {
                this.currentJ = j;
                int i = 0;
                while ((double)i < this.imageSize.getSizeX()) {
                    this.setValueAt(i, j, k, Math.sqrt(this.getValueAt(i, j, k)));
                    ++i;
                }
                ++j;
            }
            ++k;
        }
    }

    private void processCurrentPlane() {
        int j = 0;
        while ((double)j < this.imageSize.getSizeY()) {
            this.currentJ = j++;
            this.processCurrentRow();
        }
        int i = 0;
        while ((double)i < this.imageSize.getSizeX()) {
            this.currentI = i++;
            this.processCurrentCol();
        }
    }

    private void processCurrentRow() {
        this.forwardPassCurrentRow();
        this.backwardPassCurrentRow();
    }

    private void forwardPassCurrentRow() {
        double affectedValue = this.constrainImageBorders ? 0.0 : this.maxDistance;
        int i = 0;
        while ((double)i < this.imageSize.getSizeX()) {
            affectedValue = this.getValueAt(i, this.currentJ, this.currentK) != 0.0 ? (affectedValue += this.pixelSize.getSizeX()) : 0.0;
            this.setValueAt(i, this.currentJ, this.currentK, affectedValue * affectedValue);
            ++i;
        }
    }

    private void backwardPassCurrentRow() {
        double affectedValue = this.constrainImageBorders ? 0.0 : this.maxDistance;
        for (int i = (int)this.imageSize.getSizeX() - 1; i >= 0; --i) {
            affectedValue = this.getValueAt(i, this.currentJ, this.currentK) != 0.0 ? (affectedValue += this.pixelSize.getSizeX()) : 0.0;
            this.setValueAt(i, this.currentJ, this.currentK, Math.min(this.getValueAt(i, this.currentJ, this.currentK), affectedValue * affectedValue));
        }
    }

    private void processCurrentCol() {
        int j = 0;
        while ((double)j < this.imageSize.getSizeY()) {
            this.buffer[j] = this.getValueAt(this.currentI, j, this.currentK);
            ++j;
        }
        this.forwardPassCurrentCol();
        this.backwardPassCurrentCol();
    }

    private void forwardPassCurrentCol() {
        int j;
        int a = 0;
        int n = j = this.constrainImageBorders ? 0 : 1;
        while ((double)j < this.imageSize.getSizeY()) {
            double dj1;
            if (a > 0) {
                --a;
            }
            double dj = this.buffer[j] / this.squaredSizeY;
            double d = dj1 = j == 0 ? 0.0 : this.buffer[j - 1] / this.squaredSizeY;
            if (dj > dj1 + 1.0) {
                double b = Math.ceil((dj - dj1 - 1.0) / 2.0);
                if ((double)j + b > this.imageSize.getSizeY()) {
                    b = (int)this.imageSize.getSizeY() - j;
                }
                int bi = (int)b;
                for (int n2 = a; n2 < bi; ++n2) {
                    int nSq = n2 + 1;
                    nSq *= nSq;
                    double m = dj1 + (double)nSq;
                    try {
                        if (this.buffer[j + n2] / this.squaredSizeY <= m) {
                            break;
                        }
                    }
                    catch (Exception e) {
                        System.out.println(e);
                        throw e;
                    }
                    if (!(m < this.getValueAt(this.currentI, j + n2, this.currentK) / this.squaredSizeY)) continue;
                    this.setValueAt(this.currentI, j + n2, this.currentK, m * this.squaredSizeY);
                }
                a = bi;
            } else {
                a = 0;
            }
            ++j;
        }
    }

    private void backwardPassCurrentCol() {
        int a = 0;
        for (int j = (int)this.imageSize.getSizeY() - (this.constrainImageBorders ? 1 : 2); j >= 0; --j) {
            double dj1;
            if (a > 0) {
                --a;
            }
            double dj = this.buffer[j] / this.squaredSizeY;
            double d = dj1 = j == (int)this.imageSize.getSizeY() - 1 ? 0.0 : this.buffer[j + 1] / this.squaredSizeY;
            if (dj > dj1) {
                double b = Math.ceil((dj - dj1 - 1.0) / 2.0);
                if ((double)j - b < 0.0) {
                    b = j;
                }
                int bi = (int)b;
                for (int n = a; n <= bi; ++n) {
                    double m;
                    double nSq = n + 1;
                    if (this.buffer[j - n] / this.squaredSizeY <= (m = dj1 + (nSq *= nSq))) break;
                    if (!(m < this.getValueAt(this.currentI, j - n, this.currentK) / this.squaredSizeY)) continue;
                    this.setValueAt(this.currentI, j - n, this.currentK, m * this.squaredSizeY);
                }
                a = bi;
                continue;
            }
            a = 0;
        }
    }

    private void processCurrentFiber() {
        int k = 0;
        while ((double)k < this.imageSize.getSizeZ()) {
            this.buffer[k] = this.getValueAt(this.currentI, this.currentJ, k);
            ++k;
        }
        this.forwardPassCurrentFiber();
        this.backwardPassCurrentFiber();
    }

    private void forwardPassCurrentFiber() {
        int k;
        int a = 0;
        int n = k = this.constrainImageBorders ? 0 : 1;
        while ((double)k < this.imageSize.getSizeZ()) {
            double dk1;
            if (a > 0) {
                --a;
            }
            double dk = this.buffer[k] / this.squaredSizeZ;
            double d = dk1 = k == 0 ? 0.0 : this.buffer[k - 1] / this.squaredSizeZ;
            if (dk > dk1 + 1.0) {
                double b = Math.ceil((dk - dk1 - 1.0) / 2.0);
                if ((double)k + b > this.imageSize.getSizeZ()) {
                    b = (int)this.imageSize.getSizeZ() - k;
                }
                int bi = (int)b;
                for (int n2 = a; n2 < bi; ++n2) {
                    double m;
                    int nSq = n2 + 1;
                    if (this.buffer[k + n2] / this.squaredSizeZ <= (m = dk1 + (double)(nSq *= nSq))) break;
                    if (!(m < this.getValueAt(this.currentI, this.currentJ, k + n2) / this.squaredSizeZ)) continue;
                    this.setValueAt(this.currentI, this.currentJ, k + n2, m * this.squaredSizeZ);
                }
                a = bi;
            } else {
                a = 0;
            }
            ++k;
        }
    }

    private void backwardPassCurrentFiber() {
        int a = 0;
        for (int k = (int)this.imageSize.getSizeZ() - (this.constrainImageBorders ? 1 : 2); k >= 0; --k) {
            double dk1;
            if (a > 0) {
                --a;
            }
            double dk = this.buffer[k] / this.squaredSizeZ;
            double d = dk1 = k == (int)this.imageSize.getSizeZ() - 1 ? 0.0 : this.buffer[k + 1] / this.squaredSizeZ;
            if (dk > dk1 + 1.0) {
                double b = (int)Math.ceil((dk - dk1 - 1.0) / 2.0);
                if ((double)k - b < 0.0) {
                    b = k;
                }
                int bi = (int)b;
                for (int n = a; n <= bi; ++n) {
                    double m;
                    double nSq = n + 1;
                    if (this.buffer[k - n] / this.squaredSizeZ <= (m = dk1 + (nSq *= nSq))) break;
                    if (!(m < this.getValueAt(this.currentI, this.currentJ, k - n) / this.squaredSizeZ)) continue;
                    this.setValueAt(this.currentI, this.currentJ, k - n, m * this.squaredSizeZ);
                }
                a = bi;
                continue;
            }
            a = 0;
        }
    }

    private double getValueAt(int x, int y, int z) {
        return this.currentVolumePlanes[z][y * (int)this.imageSize.getSizeX() + x];
    }

    private void setValueAt(int x, int y, int z, double value) {
        this.currentVolumePlanes[z][y * (int)this.imageSize.getSizeX() + x] = value;
    }
}

