/*
 * Decompiled with CFR 0.152.
 */
package plugins.nchenouard.rieszwavelets;

import java.util.ArrayList;
import plugins.nchenouard.rieszwavelets.HarmonicTypes;
import plugins.nchenouard.rieszwavelets.RieszConfig;
import plugins.nchenouard.rieszwavelets.StandardRieszFrames;

public class RieszGeneralization {
    StandardRieszFrames frameType;
    double[][] weightMatrixForward;
    double[][] weightMatrixBackward;
    boolean realCoefficients;

    public RieszGeneralization(StandardRieszFrames frameType, RieszConfig config) {
        this.frameType = frameType;
        switch (frameType) {
            case CircularHarmonics: {
                this.weightMatrixForward = new double[config.numChannels][2 * config.numChannels];
                this.weightMatrixBackward = this.weightMatrixForward;
                for (int i = 0; i < config.numChannels; ++i) {
                    this.weightMatrixForward[i][2 * i] = 1.0 / Math.sqrt(config.numChannels);
                }
                this.realCoefficients = false;
                break;
            }
            case Gradient: {
                if (config.order != 1 || config.harmonicType != HarmonicTypes.odd) {
                    throw new IllegalArgumentException("Gradient frame requires Riesz of order 1 and odd harmonics");
                }
                this.weightMatrixForward = new double[config.numChannels][2 * config.numChannels];
                this.weightMatrixForward[0][0] = 0.0;
                this.weightMatrixForward[0][1] = 0.5;
                this.weightMatrixForward[0][2] = -0.5;
                this.weightMatrixForward[0][3] = 0.0;
                this.weightMatrixForward[1][0] = 0.0;
                this.weightMatrixForward[1][1] = 0.5;
                this.weightMatrixForward[1][2] = 0.5;
                this.weightMatrixForward[1][3] = 0.0;
                this.weightMatrixBackward = this.transposeComplexMatrix(this.weightMatrixForward);
                this.realCoefficients = true;
                break;
            }
            case Hessian: {
                if (config.order != 2 || config.harmonicType != HarmonicTypes.even) {
                    throw new IllegalArgumentException("Hessian frame requires Riesz of order 2 and even harmonics");
                }
                this.weightMatrixForward = new double[config.numChannels][2 * config.numChannels];
                this.weightMatrixForward[0][0] = -0.25;
                this.weightMatrixForward[0][1] = 0.0;
                this.weightMatrixForward[0][2] = -0.5;
                this.weightMatrixForward[0][3] = 0.0;
                this.weightMatrixForward[0][4] = -0.25;
                this.weightMatrixForward[0][5] = 0.0;
                this.weightMatrixForward[1][0] = 0.0;
                this.weightMatrixForward[1][1] = -1.0 / (2.0 * Math.sqrt(2.0));
                this.weightMatrixForward[1][2] = 0.0;
                this.weightMatrixForward[1][3] = 0.0;
                this.weightMatrixForward[1][4] = 0.0;
                this.weightMatrixForward[1][5] = 1.0 / (2.0 * Math.sqrt(2.0));
                this.weightMatrixForward[2][0] = 0.25;
                this.weightMatrixForward[2][1] = 0.0;
                this.weightMatrixForward[2][2] = -0.5;
                this.weightMatrixForward[2][3] = 0.0;
                this.weightMatrixForward[2][4] = 0.25;
                this.weightMatrixForward[2][5] = 0.0;
                this.weightMatrixBackward = this.transposeComplexMatrix(this.weightMatrixForward);
                this.realCoefficients = true;
                break;
            }
            case Monogenic: {
                if (config.order != 1 || config.harmonicType != HarmonicTypes.complete) {
                    throw new IllegalArgumentException("Monogenic frame requires Riesz of order 1 and complete harmonics");
                }
                this.weightMatrixForward = new double[config.numChannels][2 * config.numChannels];
                this.weightMatrixForward[0][0] = 0.0;
                this.weightMatrixForward[0][1] = 0.0;
                this.weightMatrixForward[0][2] = 1.0 / Math.sqrt(2.0);
                this.weightMatrixForward[0][3] = 0.0;
                this.weightMatrixForward[0][4] = 0.0;
                this.weightMatrixForward[0][5] = 0.0;
                this.weightMatrixForward[1][0] = 0.0;
                this.weightMatrixForward[1][1] = -1.0 / (2.0 * Math.sqrt(2.0));
                this.weightMatrixForward[1][2] = 0.0;
                this.weightMatrixForward[1][3] = 0.0;
                this.weightMatrixForward[1][4] = 0.0;
                this.weightMatrixForward[1][5] = -1.0 / (2.0 * Math.sqrt(2.0));
                this.weightMatrixForward[2][0] = 1.0 / (2.0 * Math.sqrt(2.0));
                this.weightMatrixForward[2][1] = 0.0;
                this.weightMatrixForward[2][2] = 0.0;
                this.weightMatrixForward[2][3] = 0.0;
                this.weightMatrixForward[2][4] = -1.0 / (2.0 * Math.sqrt(2.0));
                this.weightMatrixForward[2][5] = 0.0;
                this.weightMatrixBackward = this.transposeComplexMatrix(this.weightMatrixForward);
                this.realCoefficients = false;
                break;
            }
            case Prolate: {
                throw new IllegalArgumentException("Prolate Riesz wavelets not implemented yet in the library");
            }
            case ProlateUniSided: {
                throw new IllegalArgumentException("Prolate Riesz wavelets not implemented yet in the library");
            }
            case Riesz: {
                switch (config.harmonicType) {
                    case even: {
                        this.weightMatrixForward = this.getRieszForwardMatrix(config.order, config.harmonics);
                        this.realCoefficients = true;
                        break;
                    }
                    case odd: {
                        this.weightMatrixForward = this.getRieszForwardMatrix(config.order, config.harmonics);
                        this.realCoefficients = true;
                        break;
                    }
                    case complete: {
                        int i;
                        int orderEven = config.order - config.order % 2;
                        ArrayList<Integer> evenHarmonics = new ArrayList<Integer>();
                        ArrayList<Integer> oddHarmonics = new ArrayList<Integer>();
                        for (int i2 = 0; i2 < config.harmonics.length; ++i2) {
                            if (Math.abs(config.harmonics[i2]) % 2 == 0) {
                                evenHarmonics.add(config.harmonics[i2]);
                                continue;
                            }
                            oddHarmonics.add(config.harmonics[i2]);
                        }
                        int[] evenHarmonicsTab = new int[evenHarmonics.size()];
                        for (int i3 = 0; i3 < evenHarmonics.size(); ++i3) {
                            evenHarmonicsTab[i3] = (Integer)evenHarmonics.get(i3);
                        }
                        int[] oddHarmonicsTab = new int[oddHarmonics.size()];
                        for (int i4 = 0; i4 < oddHarmonics.size(); ++i4) {
                            oddHarmonicsTab[i4] = (Integer)oddHarmonics.get(i4);
                        }
                        double[][] evenMatrix = this.getRieszForwardMatrix(orderEven, evenHarmonicsTab);
                        int orderOdd = config.order + config.order % 2 - 1;
                        double[][] oddMatrix = this.getRieszForwardMatrix(orderOdd, oddHarmonicsTab);
                        this.weightMatrixForward = new double[config.numChannels][2 * config.numChannels];
                        int idxEven = 0;
                        int idxOdd = 0;
                        for (i = 0; i < config.harmonics.length; ++i) {
                            int j;
                            if (Math.abs(config.harmonics[i]) % 2 == 0) {
                                int idxEven2 = 0;
                                for (j = 0; j < config.harmonics.length; ++j) {
                                    if (Math.abs(config.harmonics[j]) % 2 != 0) continue;
                                    this.weightMatrixForward[i][2 * j] = evenMatrix[idxEven][2 * idxEven2];
                                    this.weightMatrixForward[i][2 * j + 1] = evenMatrix[idxEven][2 * idxEven2 + 1];
                                    ++idxEven2;
                                }
                                ++idxEven;
                                continue;
                            }
                            int idxOdd2 = 0;
                            for (j = 0; j < config.harmonics.length; ++j) {
                                if (Math.abs(config.harmonics[j]) % 2 == 0) continue;
                                this.weightMatrixForward[i][2 * j] = oddMatrix[idxOdd][2 * idxOdd2];
                                this.weightMatrixForward[i][2 * j + 1] = oddMatrix[idxOdd][2 * idxOdd2 + 1];
                                ++idxOdd2;
                            }
                            ++idxOdd;
                        }
                        for (i = 0; i < this.weightMatrixForward.length; ++i) {
                            for (int j = 0; j < this.weightMatrixForward[i].length; ++j) {
                                this.weightMatrixForward[i][j] = this.weightMatrixForward[i][j] / Math.sqrt(2.0);
                            }
                        }
                        this.realCoefficients = true;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("This type of harmonics is not supported for Riesz frames");
                    }
                }
                this.weightMatrixBackward = this.transposeComplexMatrix(this.weightMatrixForward);
                break;
            }
            case Simoncelli: {
                switch (config.harmonicType) {
                    case even: {
                        this.weightMatrixForward = this.getSimoncelliForwardMatrix(config.order, config.harmonics);
                        this.realCoefficients = true;
                        break;
                    }
                    case odd: {
                        this.weightMatrixForward = this.getSimoncelliForwardMatrix(config.order, config.harmonics);
                        this.realCoefficients = true;
                        break;
                    }
                    case complete: {
                        int i;
                        int orderEven = config.order - config.order % 2;
                        ArrayList<Integer> evenHarmonics = new ArrayList<Integer>();
                        ArrayList<Integer> oddHarmonics = new ArrayList<Integer>();
                        for (int i5 = 0; i5 < config.harmonics.length; ++i5) {
                            if (Math.abs(config.harmonics[i5]) % 2 == 0) {
                                evenHarmonics.add(config.harmonics[i5]);
                                continue;
                            }
                            oddHarmonics.add(config.harmonics[i5]);
                        }
                        int[] evenHarmonicsTab = new int[evenHarmonics.size()];
                        for (int i6 = 0; i6 < evenHarmonics.size(); ++i6) {
                            evenHarmonicsTab[i6] = (Integer)evenHarmonics.get(i6);
                        }
                        int[] oddHarmonicsTab = new int[oddHarmonics.size()];
                        for (int i7 = 0; i7 < oddHarmonics.size(); ++i7) {
                            oddHarmonicsTab[i7] = (Integer)oddHarmonics.get(i7);
                        }
                        double[][] evenMatrix = this.getSimoncelliForwardMatrix(orderEven, evenHarmonicsTab);
                        int orderOdd = config.order + config.order % 2 - 1;
                        double[][] oddMatrix = this.getSimoncelliForwardMatrix(orderOdd, oddHarmonicsTab);
                        this.weightMatrixForward = new double[config.numChannels][2 * config.numChannels];
                        int idxEven = 0;
                        int idxOdd = 0;
                        for (i = 0; i < config.harmonics.length; ++i) {
                            int j;
                            if (Math.abs(config.harmonics[i]) % 2 == 0) {
                                int idxEven2 = 0;
                                for (j = 0; j < config.harmonics.length; ++j) {
                                    if (Math.abs(config.harmonics[j]) % 2 != 0) continue;
                                    this.weightMatrixForward[i][2 * j] = evenMatrix[idxEven][2 * idxEven2];
                                    this.weightMatrixForward[i][2 * j + 1] = evenMatrix[idxEven][2 * idxEven2 + 1];
                                    ++idxEven2;
                                }
                                ++idxEven;
                                continue;
                            }
                            int idxOdd2 = 0;
                            for (j = 0; j < config.harmonics.length; ++j) {
                                if (Math.abs(config.harmonics[j]) % 2 == 0) continue;
                                this.weightMatrixForward[i][2 * j] = oddMatrix[idxOdd][2 * idxOdd2];
                                this.weightMatrixForward[i][2 * j + 1] = oddMatrix[idxOdd][2 * idxOdd2 + 1];
                                ++idxOdd2;
                            }
                            ++idxOdd;
                        }
                        for (i = 0; i < this.weightMatrixForward.length; ++i) {
                            for (int j = 0; j < this.weightMatrixForward[i].length; ++j) {
                                this.weightMatrixForward[i][j] = this.weightMatrixForward[i][j] / Math.sqrt(2.0);
                            }
                        }
                        this.realCoefficients = true;
                    }
                }
                this.weightMatrixBackward = this.transposeComplexMatrix(this.weightMatrixForward);
                break;
            }
            case Slepian: {
                throw new IllegalArgumentException("Slepian Riesz wavelets not implemented yet in the library");
            }
        }
    }

    private long factorial(int n) {
        long factorial = 1L;
        for (int i = 2; i <= n; ++i) {
            factorial *= (long)i;
        }
        return factorial;
    }

    public void printForwardMatrix() {
        System.out.println("Forward generalization matrix:");
        if (this.weightMatrixForward == null) {
            System.out.println("null");
        } else {
            for (int i = 0; i < this.weightMatrixForward.length; ++i) {
                for (int j = 0; j < this.weightMatrixForward[i].length / 2; ++j) {
                    System.out.print(this.weightMatrixForward[i][2 * j] + " + " + this.weightMatrixForward[i][2 * j + 1] + "j |");
                }
                System.out.println();
            }
        }
    }

    public void printBackwardMatrix() {
        System.out.println("Backward generalization matrix:");
        if (this.weightMatrixBackward == null) {
            System.out.println("null");
        } else {
            for (int i = 0; i < this.weightMatrixBackward.length; ++i) {
                for (int j = 0; j < this.weightMatrixBackward[i].length / 2; ++j) {
                    System.out.print(this.weightMatrixBackward[i][2 * j] + " + " + this.weightMatrixBackward[i][2 * j + 1] + "j |");
                }
                System.out.println();
            }
        }
    }

    public double[][] transposeComplexMatrix(double[][] matrix) {
        double[][] transposeMatrix = new double[matrix[0].length / 2][matrix.length * 2];
        for (int i = 0; i < transposeMatrix.length; ++i) {
            for (int j = 0; j < transposeMatrix[i].length / 2; ++j) {
                transposeMatrix[j][2 * i] = matrix[i][2 * j];
                transposeMatrix[j][2 * i + 1] = -matrix[i][2 * j + 1];
            }
        }
        return transposeMatrix;
    }

    public double[][] getRieszForwardMatrix(int order, int[] harmonics) {
        double[][] matrix = new double[harmonics.length][2 * harmonics.length];
        long factorialOrder = this.factorial(order);
        int n = order / 2;
        for (int n1 = 0; n1 <= order; ++n1) {
            int n2 = order - n1;
            long factN1 = this.factorial(n1);
            long factN2 = this.factorial(n2);
            double fact1 = Math.sqrt(factorialOrder / (factN1 * factN2)) / Math.pow(-2.0, order);
            double factR1 = 0.0;
            double factI1 = 0.0;
            switch (n1 % 4) {
                case 0: {
                    factR1 = fact1;
                    break;
                }
                case 1: {
                    factI1 = fact1;
                    break;
                }
                case 2: {
                    factR1 = -fact1;
                    break;
                }
                case 3: {
                    factI1 = -fact1;
                }
            }
            for (int n1b = 0; n1b <= n1; ++n1b) {
                long factN1b = this.factorial(n1b);
                long factN1c = this.factorial(n1 - n1b);
                for (int n2b = 0; n2b <= n2; ++n2b) {
                    long factN2b = this.factorial(n2b);
                    long factN2c = this.factorial(n2 - n2b);
                    double factb = factN1 * factN2 / (factN1b * factN1c * factN2b * factN2c);
                    if ((n2 - n2b) % 2 > 0) {
                        factb = -factb;
                    }
                    int h = order % 2 == 0 ? 2 * (n1b + n2b - n) : 2 * (n1b + n2b - n) - 1;
                    int idx = -1;
                    for (int i = 0; i < harmonics.length; ++i) {
                        if (harmonics[i] != h) continue;
                        idx = i;
                        break;
                    }
                    double[] dArray = matrix[idx];
                    int n3 = 2 * n1;
                    dArray[n3] = dArray[n3] + factR1 * factb;
                    double[] dArray2 = matrix[idx];
                    int n4 = 2 * n1 + 1;
                    dArray2[n4] = dArray2[n4] + factI1 * factb;
                }
            }
        }
        return matrix;
    }

    public double[][] getSimoncelliForwardMatrix(int order, int[] harmonics) {
        int j;
        int i;
        int numChannels = harmonics.length;
        int Np = (int)Math.floor(order / 2);
        long factOrder = this.factorial(order);
        double[][] matrix = new double[harmonics.length][2 * harmonics.length];
        for (int j2 = 0; j2 < numChannels; ++j2) {
            double thetaj = Math.PI * (double)j2 / (double)numChannels + 1.5707963267948966;
            block7: for (int i2 = 0; i2 < numChannels; ++i2) {
                int npp = harmonics[i2];
                double fact = 0.0;
                fact = npp % 2 == 0 ? (double)(factOrder / (this.factorial(Np + npp / 2) * this.factorial(Np - npp / 2))) : (double)(factOrder / (this.factorial(Np + (npp + 1) / 2) * this.factorial(Np - (npp - 1) / 2)));
                switch (order % 4) {
                    case 0: {
                        matrix[i2][2 * j2] = fact * Math.cos((double)npp * thetaj);
                        matrix[i2][2 * j2 + 1] = fact * Math.sin((double)npp * thetaj);
                        continue block7;
                    }
                    case 1: {
                        matrix[i2][2 * j2] = fact * Math.sin((double)npp * thetaj);
                        matrix[i2][2 * j2 + 1] = -fact * Math.cos((double)npp * thetaj);
                        continue block7;
                    }
                    case 2: {
                        matrix[i2][2 * j2] = -fact * Math.cos((double)npp * thetaj);
                        matrix[i2][2 * j2 + 1] = -fact * Math.sin((double)npp * thetaj);
                        continue block7;
                    }
                    case 3: {
                        matrix[i2][2 * j2] = -fact * Math.sin((double)npp * thetaj);
                        matrix[i2][2 * j2 + 1] = fact * Math.cos((double)npp * thetaj);
                    }
                }
            }
        }
        double sumSq = 0.0;
        for (i = 0; i < matrix.length; ++i) {
            for (j = 0; j < matrix[i].length; ++j) {
                sumSq += matrix[i][j] * matrix[i][j];
            }
        }
        sumSq = Math.sqrt(sumSq);
        for (i = 0; i < matrix.length; ++i) {
            for (j = 0; j < matrix[i].length; ++j) {
                matrix[i][j] = matrix[i][j] / sumSq;
            }
        }
        return matrix;
    }

    public double[][] combineBandsForwardComplex(double[][] bands) {
        return this.combineBandsComplex(bands, this.weightMatrixForward);
    }

    public double[][] combineBandsBackwardComplex(double[][] bands) {
        return this.combineBandsComplex(bands, this.weightMatrixBackward);
    }

    public double[][] combineBandsComplex(double[][] bands, double[][] weightMatrix) {
        int numCoefficients = bands[0].length / 2;
        double[][] projectedBands = new double[weightMatrix[0].length / 2][numCoefficients * 2];
        for (int i = 0; i < projectedBands.length; ++i) {
            for (int t = 0; t < numCoefficients; ++t) {
                int j;
                double val = 0.0;
                for (j = 0; j < bands.length; ++j) {
                    val += bands[j][2 * t] * weightMatrix[j][2 * i] - bands[j][2 * t + 1] * weightMatrix[j][2 * i + 1];
                }
                projectedBands[i][2 * t] = val;
                val = 0.0;
                for (j = 0; j < bands.length; ++j) {
                    val += bands[j][2 * t] * weightMatrix[j][2 * i + 1] + bands[j][2 * t + 1] * weightMatrix[j][2 * i];
                }
                projectedBands[i][2 * t + 1] = val;
            }
        }
        return projectedBands;
    }

    public StandardRieszFrames getRieszFrame() {
        return this.frameType;
    }
}

