/*
 * Decompiled with CFR 0.152.
 */
package plugins.adufour.thresholder;

import icy.plugin.abstract_.Plugin;
import icy.plugin.interface_.PluginBundled;
import icy.sequence.Sequence;
import plugins.adufour.blocks.lang.Block;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.thresholder.KMeans;
import plugins.adufour.thresholder.Thresholder;
import plugins.adufour.vars.gui.model.IntegerRangeModel;
import plugins.adufour.vars.gui.model.VarEditorModel;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.lang.VarDoubleArrayNative;
import plugins.adufour.vars.lang.VarInteger;
import plugins.adufour.vars.lang.VarSequence;
import plugins.adufour.vars.util.VarException;

public class KMeansThresholdBlock
extends Plugin
implements Block,
PluginBundled {
    VarSequence input = new VarSequence("Input", null);
    VarInteger channel = new VarInteger("Channel", 0);
    VarInteger nbClasses = new VarInteger("Classes", 2);
    VarDoubleArrayNative thresholds = new VarDoubleArrayNative("thresholds", new double[0]);

    public void run() {
        int sizeC;
        Sequence seq = (Sequence)this.input.getValue();
        if (seq == null) {
            throw new VarException((Var)this.input, "Thresholder: no sequence selected");
        }
        int c = this.channel.getValue();
        if (c >= (sizeC = seq.getSizeC())) {
            throw new VarException((Var)this.channel, "Thresholder: channel " + c + " does not exist");
        }
        int nC = this.nbClasses.getValue();
        double[][] thrs = KMeans.computeKMeansThresholds(seq, nC);
        this.thresholds.setValue((Object)thrs[c]);
    }

    public void declareInput(VarList inputMap) {
        this.nbClasses.setDefaultEditorModel((VarEditorModel)new IntegerRangeModel(Integer.valueOf(2), Integer.valueOf(2), Integer.valueOf(65535), Integer.valueOf(1)));
        this.channel.setDefaultEditorModel((VarEditorModel)new IntegerRangeModel(Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(65535), Integer.valueOf(1)));
        inputMap.add("Input", (Var)this.input);
        inputMap.add("Channel", (Var)this.channel);
        inputMap.add("Classes", (Var)this.nbClasses);
    }

    public void declareOutput(VarList outputMap) {
        outputMap.add("thresholds", (Var)this.thresholds);
    }

    public String getMainPluginClassName() {
        return Thresholder.class.getCanonicalName();
    }
}

