/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Menus;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.io.OpenDialog;
import ij.macro.Interpreter;
import ij.plugin.MacroInstaller;
import ij.plugin.PlugIn;
import ij.plugin.PlugInInterpreter;
import ij.plugin.PluginInstaller;
import ij.plugin.frame.Editor;
import ij.plugin.frame.Recorder;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;

public class Macro_Runner
implements PlugIn {
    private static String filePath;

    @Override
    public void run(String name) {
        Thread thread;
        String threadName;
        if (IJ.debugMode) {
            IJ.log("Macro_Runner.run(): " + name);
        }
        if (!(threadName = (thread = Thread.currentThread()).getName()).endsWith("Macro$")) {
            if (name.endsWith(".js") || name.endsWith(".bsh") || name.endsWith(".py")) {
                thread.setName(threadName + "_Script_Macro$");
            } else {
                thread.setName(threadName + "_Macro$");
            }
        }
        String path = null;
        if (name.equals("")) {
            OpenDialog od = new OpenDialog("Run Macro or Script...", path);
            String directory = od.getDirectory();
            name = od.getFileName();
            if (name != null) {
                path = directory + name;
                this.runMacroFile(path, null);
                if (Recorder.record) {
                    path = Recorder.fixPath(path);
                    if (Recorder.scriptMode()) {
                        Recorder.recordCall("IJ.runMacroFile(\"" + path + "\");");
                    } else {
                        Recorder.record("runMacro", path);
                    }
                }
            }
        } else if (name.startsWith("JAR:")) {
            Macro_Runner.runMacroFromJar(name.substring(4), null);
        } else if (name.startsWith("ij.jar:")) {
            this.runMacroFromIJJar(name, null);
        } else if (name.endsWith("Tool.ijm") || name.endsWith("Tool.txt") || name.endsWith("Menu.ijm") || name.endsWith("Menu.txt")) {
            new MacroInstaller().installTool(Menus.getPlugInsPath() + name);
        } else {
            boolean fullPath = name.startsWith("/") || name.startsWith("\\") || name.indexOf(":\\") == 1 || name.indexOf(":/") == 1;
            path = fullPath ? name : Menus.getPlugInsPath() + name;
            this.runMacroFile(path, null);
        }
    }

    public String runMacroFile(String name, String arg) {
        String path2;
        File f;
        boolean hasExtension;
        String macrosDir;
        if (arg == null) {
            arg = "";
        }
        if (name.startsWith("ij.jar:")) {
            return this.runMacroFromIJJar(name, arg);
        }
        boolean fullPath = name.startsWith("/") || name.startsWith("\\") || name.indexOf(":\\") == 1 || name.indexOf(":/") == 1;
        String path = name;
        boolean exists = false;
        if (!fullPath && (macrosDir = Menus.getMacrosPath()) != null) {
            path = Menus.getMacrosPath() + name;
        }
        if (hasExtension = (f = new File(path)).getName().contains(".")) {
            exists = f.exists();
        }
        if (!(exists || fullPath || hasExtension)) {
            path2 = path + ".txt";
            f = new File(path2);
            exists = f.exists();
            if (exists) {
                path = path2;
            } else {
                path2 = path + ".ijm";
                f = new File(path2);
                exists = f.exists();
                if (exists) {
                    path = path2;
                }
            }
        }
        if (!exists) {
            f = new File(path);
            exists = f.exists();
        }
        if (!exists && !fullPath) {
            path2 = System.getProperty("user.dir") + File.separator + name;
            if (!hasExtension) {
                String path3 = path2 + ".txt";
                f = new File(path3);
                exists = f.exists();
                if (exists) {
                    path = path3;
                } else {
                    path3 = path2 + ".ijm";
                    f = new File(path3);
                    exists = f.exists();
                    if (exists) {
                        path = path3;
                    }
                }
            }
            if (!exists && (exists = (f = new File(path2)).exists())) {
                path = path2;
            }
        }
        if (IJ.debugMode) {
            IJ.log("runMacro: " + path + " (" + name + ")");
        }
        if (!exists || f == null) {
            IJ.error("RunMacro", "Macro or script not found:\n \n" + path);
            return null;
        }
        filePath = path;
        try {
            int size = (int)f.length();
            byte[] buffer = new byte[size];
            FileInputStream in = new FileInputStream(f);
            in.read(buffer, 0, size);
            String macro = new String(buffer, 0, size, "ISO8859_1");
            in.close();
            OpenDialog.setLastDirectory(f.getParent() + File.separator);
            OpenDialog.setLastName(f.getName());
            if (name.endsWith(".js")) {
                return this.runJavaScript(macro, arg);
            }
            if (name.endsWith(".bsh")) {
                return Macro_Runner.runBeanShell(macro, arg);
            }
            if (name.endsWith(".py")) {
                return Macro_Runner.runPython(macro, arg);
            }
            return this.runMacro(macro, arg);
        }
        catch (Exception e) {
            if (!"Macro canceled".equals(e.getMessage())) {
                IJ.error(e.getMessage());
            }
            return null;
        }
    }

    public String runMacro(String macro, String arg) {
        Interpreter interp = new Interpreter();
        try {
            return interp.run(macro, arg);
        }
        catch (Throwable e) {
            interp.abortMacro();
            IJ.showStatus("");
            IJ.showProgress(1.0);
            ImagePlus imp = WindowManager.getCurrentImage();
            if (imp != null) {
                imp.unlock();
            }
            String msg = e.getMessage();
            if (e instanceof RuntimeException && msg != null && e.getMessage().equals("Macro canceled")) {
                return "[aborted]";
            }
            IJ.handleException(e);
            return "[aborted]";
        }
    }

    public static String runMacroFromJar(String name, String arg) {
        String macro = null;
        try {
            int n;
            ClassLoader pcl = IJ.getClassLoader();
            InputStream is = pcl.getResourceAsStream(name);
            if (is == null) {
                IJ.error("Macro Runner", "Unable to load \"" + name + "\" from jar file");
                return null;
            }
            InputStreamReader isr = new InputStreamReader(is);
            StringBuffer sb = new StringBuffer();
            char[] b = new char[8192];
            while ((n = isr.read(b)) > 0) {
                sb.append(b, 0, n);
            }
            macro = sb.toString();
            is.close();
        }
        catch (IOException e) {
            IJ.error("Macro Runner", "" + e);
        }
        if (macro != null) {
            return new Macro_Runner().runMacro(macro, arg);
        }
        return null;
    }

    public String runMacroFromIJJar(String name, String arg) {
        ImageJ ij = IJ.getInstance();
        Class<?> c = ij != null ? ij.getClass() : new ImageStack().getClass();
        name = name.substring(7);
        String macro = null;
        try {
            int n;
            InputStream is = c.getResourceAsStream("/macros/" + name + ".txt");
            if (is == null) {
                return this.runMacroFile(name, arg);
            }
            InputStreamReader isr = new InputStreamReader(is);
            StringBuffer sb = new StringBuffer();
            char[] b = new char[8192];
            while ((n = isr.read(b)) > 0) {
                sb.append(b, 0, n);
            }
            macro = sb.toString();
        }
        catch (IOException e) {
            String msg = e.getMessage();
            if (msg == null || msg.equals("")) {
                msg = "" + e;
            }
            IJ.showMessage("Macro Runner", msg);
        }
        if (macro != null) {
            return this.runMacro(macro, arg);
        }
        return null;
    }

    public String runJavaScript(String script, String arg) {
        Object js = null;
        if (!IJ.isMacOSX() || IJ.is64Bit()) {
            js = IJ.runPlugIn("ij.plugin.JavaScriptEvaluator", "");
        } else {
            boolean ok;
            js = IJ.runPlugIn("JavaScript", "");
            if (js == null && (ok = Macro_Runner.downloadJar("/download/tools/JavaScript.jar"))) {
                js = IJ.runPlugIn("JavaScript", "");
            }
        }
        script = Editor.getJSPrefix(arg) + script;
        if (IJ.isJava18()) {
            script = "load(\"nashorn:mozilla_compat.js\");" + script;
        }
        if (js != null) {
            return Macro_Runner.runScript(js, script, arg);
        }
        return null;
    }

    private static String runScript(Object plugin, String script, String arg) {
        block4: {
            if (plugin instanceof PlugInInterpreter) {
                PlugInInterpreter interp = (PlugInInterpreter)plugin;
                if (IJ.debugMode) {
                    IJ.log("Running " + interp.getName() + " script; arg=\"" + arg + "\"");
                }
                interp.run(script, arg);
                return interp.getReturnValue();
            }
            try {
                Class<?> c = plugin.getClass();
                Method m = c.getMethod("run", script.getClass(), arg.getClass());
                String string = (String)m.invoke(plugin, script, arg);
            }
            catch (Exception e) {
                if (!"Jython".equals(plugin.getClass().getName())) break block4;
                IJ.runPlugIn("Jython", script);
            }
        }
        return "" + plugin;
    }

    public static String runBeanShell(String script, String arg) {
        boolean ok;
        Object bsh;
        if (arg == null) {
            arg = "";
        }
        if ((bsh = IJ.runPlugIn("bsh", "")) == null && (ok = Macro_Runner.downloadJar("/plugins/bsh/BeanShell.jar"))) {
            bsh = IJ.runPlugIn("bsh", "");
        }
        if (bsh != null) {
            return Macro_Runner.runScript(bsh, script, arg);
        }
        return null;
    }

    public static String runPython(String script, String arg) {
        boolean ok;
        Object jython;
        if (arg == null) {
            arg = "";
        }
        if ((jython = IJ.runPlugIn("Jython", "")) == null && (ok = Macro_Runner.downloadJar("/plugins/jython/Jython.jar"))) {
            jython = IJ.runPlugIn("Jython", "");
        }
        if (jython != null) {
            return Macro_Runner.runScript(jython, script, arg);
        }
        return null;
    }

    public static boolean downloadJar(String url) {
        String name = url.substring(url.lastIndexOf("/") + 1);
        boolean ok = false;
        String msg = name + " was not found in the plugins\nfolder or it is outdated. Click \"OK\" to download\nit from the ImageJ website.";
        GenericDialog gd = new GenericDialog("Download " + name + "?");
        gd.addMessage(msg);
        gd.showDialog();
        if (!gd.wasCanceled() && !(ok = new PluginInstaller().install("http://imagej.nih.gov/ij" + url))) {
            IJ.error("Unable to download " + name + " from " + "http://imagej.nih.gov/ij" + url);
        }
        return ok;
    }

    public static String getFilePath() {
        return filePath;
    }

    public static void setFilePath(String path) {
        filePath = path;
    }
}

