/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.Prefs;
import ij.gui.GenericDialog;
import ij.gui.Plot;
import ij.gui.PlotMaker;
import ij.gui.PlotWindow;
import ij.gui.ProfilePlot;
import ij.gui.Roi;
import ij.plugin.PlugIn;
import ij.plugin.frame.Recorder;

public class Profiler
implements PlugIn,
PlotMaker {
    ImagePlus imp;
    boolean firstTime = true;
    boolean plotVertically;

    @Override
    public void run(String arg) {
        if (arg.equals("set")) {
            this.doOptions();
            return;
        }
        this.imp = IJ.getImage();
        if (this.firstTime) {
            this.plotVertically = Prefs.verticalProfile || IJ.altKeyDown();
        }
        Plot plot = this.getPlot();
        this.firstTime = false;
        if (plot == null) {
            return;
        }
        plot.setPlotMaker(this);
        plot.show();
        Roi roi = this.imp.getRoi();
        if (roi != null && roi.getType() == 0) {
            plot.getImagePlus().setProperty("Label", this.plotVertically ? "vertical" : "horizontal");
        }
    }

    @Override
    public Plot getPlot() {
        Roi roi = this.imp.getRoi();
        if (roi == null || !roi.isLine() && roi.getType() != 0) {
            if (this.firstTime) {
                IJ.error("Plot Profile", "Line or rectangular selection required");
            }
            return null;
        }
        ProfilePlot pp = new ProfilePlot(this.imp, this.plotVertically);
        return pp.getPlot();
    }

    @Override
    public ImagePlus getSourceImage() {
        return this.imp;
    }

    public void doOptions() {
        boolean fixedScale;
        double ymin = ProfilePlot.getFixedMin();
        double ymax = ProfilePlot.getFixedMax();
        boolean wasFixedScale = fixedScale = ymin != 0.0 || ymax != 0.0;
        GenericDialog gd = new GenericDialog("Plot Defaults");
        gd.setInsets(4, 0, 0);
        gd.addMessage("---------- Plot Defaults ---------");
        gd.addNumericField("Width:", PlotWindow.plotWidth, 0);
        gd.addNumericField("Height:", PlotWindow.plotHeight, 0);
        gd.addNumericField("Font size:", PlotWindow.getDefaultFontSize());
        gd.setInsets(5, 20, 0);
        gd.addCheckbox("Draw_ticks", !PlotWindow.noTicks);
        gd.addCheckbox("Auto-close", PlotWindow.autoClose);
        gd.addCheckbox("List values", PlotWindow.listValues);
        gd.setInsets(15, 0, 0);
        gd.addMessage("------- Profile Plot Options -------");
        gd.setInsets(5, 20, 0);
        gd.addCheckbox("Fixed y-axis scale", fixedScale);
        gd.addNumericField("Minimum Y:", ymin, 2);
        gd.addNumericField("Maximum Y:", ymax, 2);
        gd.setInsets(10, 20, 0);
        gd.addCheckbox("Vertical profile", Prefs.verticalProfile);
        gd.addCheckbox("Interpolate line profiles", PlotWindow.interpolate);
        gd.addHelp("http://imagej.nih.gov/ij/docs/menus/edit.html#plot-options");
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        int w = (int)gd.getNextNumber();
        int h = (int)gd.getNextNumber();
        if (w < 160) {
            w = 160;
        }
        if (h < 90) {
            h = 90;
        }
        int fontSize = (int)gd.getNextNumber();
        if (!gd.invalidNumber()) {
            PlotWindow.plotWidth = w;
            PlotWindow.plotHeight = h;
            PlotWindow.setDefaultFontSize(fontSize);
        }
        PlotWindow.noTicks = !gd.getNextBoolean();
        PlotWindow.autoClose = gd.getNextBoolean();
        PlotWindow.listValues = gd.getNextBoolean();
        fixedScale = gd.getNextBoolean();
        ymin = gd.getNextNumber();
        ymax = gd.getNextNumber();
        Prefs.verticalProfile = gd.getNextBoolean();
        PlotWindow.interpolate = gd.getNextBoolean();
        if (!(fixedScale || wasFixedScale || ymin == 0.0 && ymax == 0.0)) {
            fixedScale = true;
        }
        if (!fixedScale) {
            ymin = 0.0;
            ymax = 0.0;
        } else if (ymin > ymax) {
            double tmp = ymin;
            ymin = ymax;
            ymax = tmp;
        }
        ProfilePlot.setMinAndMax(ymin, ymax);
        if (!Recorder.scriptMode()) {
            Recorder.recordString("setOption(\"InterpolateLines\", " + PlotWindow.interpolate + ");\n");
        }
    }
}

