/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.CompositeImage;
import ij.IJ;
import ij.ImagePlus;
import ij.LookUpTable;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.HistogramWindow;
import ij.gui.NewImage;
import ij.macro.Interpreter;
import ij.measure.Calibration;
import ij.plugin.filter.Analyzer;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import ij.process.LUT;
import java.awt.Color;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.image.ColorModel;

public class HistogramPlot
extends ImagePlus {
    static final double SCALE = Prefs.getGuiScale();
    static final int HIST_WIDTH = (int)(SCALE * 256.0);
    static final int HIST_HEIGHT = (int)(SCALE * 128.0);
    static final int XMARGIN = (int)(20.0 * SCALE);
    static final int YMARGIN = (int)(10.0 * SCALE);
    static final int WIN_WIDTH = HIST_WIDTH + (int)(44.0 * SCALE);
    static final int WIN_HEIGHT = HIST_HEIGHT + (int)(118.0 * SCALE);
    static final int BAR_HEIGHT = (int)(SCALE * 12.0);
    static final int INTENSITY1 = 0;
    static final int INTENSITY2 = 1;
    static final int RGB = 2;
    static final int RED = 3;
    static final int GREEN = 4;
    static final int BLUE = 5;
    static final Color frameColor = new Color(30, 60, 120);
    int rgbMode = -1;
    ImageStatistics stats;
    boolean stackHistogram;
    Calibration cal;
    long[] histogram;
    LookUpTable lut;
    int decimalPlaces;
    int digits;
    long newMaxCount;
    boolean logScale;
    int yMax;
    int srcImageID;
    Rectangle frame;
    Font font = new Font("SansSerif", 0, (int)(12.0 * SCALE));
    boolean showBins;
    int col1;
    int col2;
    int row1;
    int row2;
    int row3;
    int row4;
    int row5;

    public HistogramPlot() {
        this.setImage(NewImage.createRGBImage("Histogram", WIN_WIDTH, WIN_HEIGHT, 1, 4));
    }

    public void draw(String title, ImagePlus imp, int bins) {
        this.draw(imp, bins, 0.0, 0.0, 0);
    }

    public void draw(ImagePlus imp, int bins, double histMin, double histMax, int yMax) {
        boolean limitToThreshold = (Analyzer.getMeasurements() & 0x100) != 0;
        ImageProcessor ip = imp.getProcessor();
        if (ip.getMinThreshold() != -808080.0 && ip.getLutUpdateMode() == 2) {
            limitToThreshold = false;
        }
        if (imp.isRGB() && this.rgbMode < 0) {
            this.rgbMode = 0;
        }
        if (this.rgbMode == 3 || this.rgbMode == 4 || this.rgbMode == 5) {
            int channel = this.rgbMode - 2;
            ColorProcessor cp = (ColorProcessor)imp.getProcessor();
            ip = cp.getChannel(channel, null);
            ImagePlus imp2 = new ImagePlus("", ip);
            imp2.setRoi(imp.getRoi());
            this.stats = imp2.getStatistics(27, bins, histMin, histMax);
        } else {
            this.stats = this.rgbMode == 2 ? this.RGBHistogram(imp, bins, histMin, histMax) : imp.getStatistics(27 + (limitToThreshold ? 256 : 0), bins, histMin, histMax);
        }
        this.draw(imp, this.stats);
    }

    private ImageStatistics RGBHistogram(ImagePlus imp, int bins, double histMin, double histMax) {
        ImageProcessor ip = (ColorProcessor)imp.getProcessor();
        ip = ip.crop();
        int w = ip.getWidth();
        int h = ip.getHeight();
        ByteProcessor ip2 = new ByteProcessor(w * 3, h);
        ByteProcessor temp = null;
        for (int i = 0; i < 3; ++i) {
            temp = ((ColorProcessor)ip).getChannel(i + 1, temp);
            ip2.insert(temp, i * w, 0);
        }
        ImagePlus imp2 = new ImagePlus("imp2", ip2);
        return imp2.getStatistics(27, bins, histMin, histMax);
    }

    public void draw(ImagePlus imp, ImageStatistics stats) {
        if (imp.isRGB() && this.rgbMode < 0) {
            this.rgbMode = 0;
        }
        this.stackHistogram = stats.stackStatistics;
        this.stats = stats;
        this.yMax = stats.histYMax;
        this.cal = imp.getCalibration();
        boolean limitToThreshold = (Analyzer.getMeasurements() & 0x100) != 0;
        imp.getMask();
        this.histogram = stats.getHistogram();
        this.lut = imp.createLut();
        int type = imp.getType();
        boolean fixedRange = type == 0 || type == 3 || imp.isRGB();
        this.ip.setColor(Color.white);
        this.ip.resetRoi();
        this.ip.fill();
        ImageProcessor srcIP = imp.getProcessor();
        this.drawHistogram(imp, this.ip, fixedRange, stats.histMin, stats.histMax);
    }

    protected void drawHistogram(ImageProcessor ip, boolean fixedRange) {
        this.drawHistogram(null, ip, fixedRange, 0.0, 0.0);
    }

    void drawHistogram(ImagePlus imp, ImageProcessor ip, boolean fixedRange, double xMin, double xMax) {
        this.setTitle("Histogram of " + imp.getShortTitle());
        long maxCount2 = 0L;
        int mode2 = 0;
        ip.setColor(Color.black);
        ip.setLineWidth(1);
        this.decimalPlaces = Analyzer.getPrecision();
        this.digits = this.cal.calibrated() || this.stats.binSize != 1.0 ? this.decimalPlaces : 0;
        long saveModalCount = this.histogram[this.stats.mode];
        for (int i = 0; i < this.histogram.length; ++i) {
            if (this.histogram[i] <= maxCount2 || i == this.stats.mode) continue;
            maxCount2 = this.histogram[i];
            mode2 = i;
        }
        this.newMaxCount = this.histogram[this.stats.mode];
        if (this.newMaxCount > maxCount2 * 2L && maxCount2 != 0L) {
            this.newMaxCount = (int)((double)maxCount2 * 1.5);
        }
        if (this.logScale) {
            this.drawLogPlot(this.yMax > 0 ? (long)this.yMax : this.newMaxCount, ip);
        }
        this.drawPlot(this.yMax > 0 ? (long)this.yMax : this.newMaxCount, ip);
        this.histogram[this.stats.mode] = saveModalCount;
        int x = XMARGIN + 1;
        int y = YMARGIN + HIST_HEIGHT + 2;
        if (imp == null) {
            this.lut.drawUnscaledColorBar(ip, x - 1, y, HIST_WIDTH, BAR_HEIGHT);
        } else {
            this.drawAlignedColorBar(imp, xMin, xMax, ip, x - 1, y, HIST_WIDTH, BAR_HEIGHT);
        }
        this.drawText(ip, x, y += BAR_HEIGHT + (int)(15.0 * SCALE), fixedRange);
        this.srcImageID = imp.getID();
    }

    void drawAlignedColorBar(ImagePlus imp, double xMin, double xMax, ImageProcessor ip, int x, int y, int width, int height) {
        ImageProcessor ipSource = imp.getProcessor();
        float[] pixels = null;
        FloatProcessor ipRamp = null;
        if (this.rgbMode >= 0) {
            ipRamp = new FloatProcessor(width, height);
            if (this.rgbMode == 3) {
                ipRamp.setColorModel(LUT.createLutFromColor(Color.red));
            } else if (this.rgbMode == 4) {
                ipRamp.setColorModel(LUT.createLutFromColor(Color.green));
            } else if (this.rgbMode == 5) {
                ipRamp.setColorModel(LUT.createLutFromColor(Color.blue));
            }
            pixels = (float[])((ImageProcessor)ipRamp).getPixels();
        } else {
            pixels = new float[width * height];
        }
        for (int j = 0; j < height; ++j) {
            for (int i = 0; i < width; ++i) {
                pixels[i + width * j] = (float)(xMin + (double)i * (xMax - xMin) / (double)(width - 1));
            }
        }
        double min = ipSource.getMin();
        double max = ipSource.getMax();
        if (ipSource.getNChannels() == 1) {
            ColorModel cm = null;
            if (imp.isComposite()) {
                if (this.stats != null && this.stats.pixelCount > ipSource.getPixelCount()) {
                    cm = LUT.createLutFromColor(Color.white);
                    min = this.stats.min;
                    max = this.stats.max;
                } else {
                    cm = ((CompositeImage)imp).getChannelLut();
                }
            } else {
                cm = ipSource.getMinThreshold() == -808080.0 ? ipSource.getColorModel() : ipSource.getCurrentColorModel();
            }
            ipRamp = new FloatProcessor(width, height, pixels, cm);
        }
        ((ImageProcessor)ipRamp).setMinAndMax(min, max);
        ImageProcessor bar = null;
        bar = ip instanceof ColorProcessor ? ipRamp.convertToRGB() : ipRamp.convertToByte(true);
        ip.insert(bar, x, y);
        ip.setColor(Color.black);
        ip.drawRect(x - 1, y, width + 2, height);
    }

    int scaleDown(ImageProcessor ip, double threshold) {
        double min = ip.getMin();
        double max = ip.getMax();
        if (max > min) {
            return (int)((threshold - min) / (max - min) * 255.0);
        }
        return 0;
    }

    void drawPlot(long maxCount, ImageProcessor ip) {
        if (maxCount == 0L) {
            maxCount = 1L;
        }
        this.frame = new Rectangle(XMARGIN, YMARGIN, HIST_WIDTH, HIST_HEIGHT);
        if (this.histogram.length == 256) {
            double scale2 = (double)HIST_WIDTH / 256.0;
            int barWidth = 1;
            if (SCALE > 1.0) {
                barWidth = 2;
            }
            if (SCALE > 2.0) {
                barWidth = 3;
            }
            for (int i = 0; i < 256; ++i) {
                int x = (int)((double)i * scale2);
                int y = (int)((double)HIST_HEIGHT * (double)this.histogram[i] / (double)maxCount);
                if (y > HIST_HEIGHT) {
                    y = HIST_HEIGHT;
                }
                for (int j = 0; j < barWidth; ++j) {
                    ip.drawLine(x + j + XMARGIN, YMARGIN + HIST_HEIGHT, x + j + XMARGIN, YMARGIN + HIST_HEIGHT - y);
                }
            }
        } else if (this.histogram.length <= HIST_WIDTH) {
            for (int i = 0; i < HIST_WIDTH; ++i) {
                int index = (int)((double)i * (double)this.histogram.length / (double)HIST_WIDTH);
                int y = (int)((double)HIST_HEIGHT * (double)this.histogram[index] / (double)maxCount);
                if (y > HIST_HEIGHT) {
                    y = HIST_HEIGHT;
                }
                ip.drawLine(i + XMARGIN, YMARGIN + HIST_HEIGHT, i + XMARGIN, YMARGIN + HIST_HEIGHT - y);
            }
        } else {
            double xscale = (double)HIST_WIDTH / (double)this.histogram.length;
            for (int i = 0; i < this.histogram.length; ++i) {
                long value = this.histogram[i];
                if (value <= 0L) continue;
                int y = (int)((double)HIST_HEIGHT * (double)value / (double)maxCount);
                if (y > HIST_HEIGHT) {
                    y = HIST_HEIGHT;
                }
                int x = (int)((double)i * xscale) + XMARGIN;
                ip.drawLine(x, YMARGIN + HIST_HEIGHT, x, YMARGIN + HIST_HEIGHT - y);
            }
        }
        ip.setColor(frameColor);
        ip.drawRect(this.frame.x - 1, this.frame.y, this.frame.width + 2, this.frame.height + 1);
        ip.setColor(Color.black);
    }

    void drawLogPlot(long maxCount, ImageProcessor ip) {
        this.frame = new Rectangle(XMARGIN, YMARGIN, HIST_WIDTH, HIST_HEIGHT);
        ip.drawRect(this.frame.x - 1, this.frame.y, this.frame.width + 2, this.frame.height + 1);
        double max = Math.log(maxCount);
        ip.setColor(Color.gray);
        if (this.histogram.length == 256) {
            double scale2 = (double)HIST_WIDTH / 256.0;
            int barWidth = 1;
            if (SCALE > 1.0) {
                barWidth = 2;
            }
            if (SCALE > 2.0) {
                barWidth = 3;
            }
            for (int i = 0; i < 256; ++i) {
                int y;
                int x = (int)((double)i * scale2);
                int n = y = this.histogram[i] == 0L ? 0 : (int)((double)HIST_HEIGHT * Math.log(this.histogram[i]) / max);
                if (y > HIST_HEIGHT) {
                    y = HIST_HEIGHT;
                }
                for (int j = 0; j < barWidth; ++j) {
                    ip.drawLine(x + j + XMARGIN, YMARGIN + HIST_HEIGHT, x + j + XMARGIN, YMARGIN + HIST_HEIGHT - y);
                }
            }
        } else if (this.histogram.length <= HIST_WIDTH) {
            for (int i = 0; i < HIST_WIDTH; ++i) {
                int y;
                int index = (int)((double)i * (double)this.histogram.length / (double)HIST_WIDTH);
                int n = y = this.histogram[index] == 0L ? 0 : (int)((double)HIST_HEIGHT * Math.log(this.histogram[index]) / max);
                if (y > HIST_HEIGHT) {
                    y = HIST_HEIGHT;
                }
                ip.drawLine(i + XMARGIN, YMARGIN + HIST_HEIGHT, i + XMARGIN, YMARGIN + HIST_HEIGHT - y);
            }
        } else {
            double xscale = (double)HIST_WIDTH / (double)this.histogram.length;
            for (int i = 0; i < this.histogram.length; ++i) {
                long value = this.histogram[i];
                if (value <= 0L) continue;
                int y = (int)((double)HIST_HEIGHT * Math.log(value) / max);
                if (y > HIST_HEIGHT) {
                    y = HIST_HEIGHT;
                }
                int x = (int)((double)i * xscale) + XMARGIN;
                ip.drawLine(x, YMARGIN + HIST_HEIGHT, x, YMARGIN + HIST_HEIGHT - y);
            }
        }
        ip.setColor(Color.black);
    }

    void drawText(ImageProcessor ip, int x, int y, boolean fixedRange) {
        ip.setFont(this.font);
        ip.setAntialiasedText(true);
        double hmin = this.cal.getCValue(this.stats.histMin);
        double hmax = this.cal.getCValue(this.stats.histMax);
        double range = hmax - hmin;
        if (fixedRange && !this.cal.calibrated() && hmin == 0.0 && hmax == 255.0) {
            range = 256.0;
        }
        ip.drawString(this.d2s(hmin), x - 4, y);
        ip.drawString(this.d2s(hmax), x + HIST_WIDTH - this.getWidth(hmax, ip) + 10, y);
        if (this.rgbMode >= 0) {
            x += HIST_WIDTH / 2;
            ++y;
            ip.setJustification(1);
            boolean weighted = ((ColorProcessor)ip).weightedHistogram();
            switch (this.rgbMode) {
                case 0: {
                    ip.drawString(weighted ? "Intensity (weighted)" : "Intensity (unweighted)", x, y);
                    break;
                }
                case 1: {
                    ip.drawString(weighted ? "Intensity (unweighted)" : "Intensity (weighted)", x, y);
                    break;
                }
                case 2: {
                    ip.drawString("R+G+B", x, y);
                    break;
                }
                case 3: {
                    ip.drawString("Red", x, y);
                    break;
                }
                case 4: {
                    ip.drawString("Green", x, y);
                    break;
                }
                case 5: {
                    ip.drawString("Blue", x, y);
                }
            }
            ip.setJustification(0);
        }
        double binWidth = range / (double)this.stats.nBins;
        this.showBins = (binWidth = Math.abs(binWidth)) != 1.0 || !fixedRange;
        this.col1 = XMARGIN + 5;
        this.col2 = XMARGIN + HIST_WIDTH / 2;
        this.row1 = y + (int)(25.0 * SCALE);
        if (this.showBins) {
            this.row1 -= (int)(8.0 * SCALE);
        }
        this.row2 = this.row1 + (int)(15.0 * SCALE);
        this.row3 = this.row2 + (int)(15.0 * SCALE);
        this.row4 = this.row3 + (int)(15.0 * SCALE);
        this.row5 = this.row4 + (int)(15.0 * SCALE);
        long count = this.stats.longPixelCount > 0L ? this.stats.longPixelCount : (long)this.stats.pixelCount;
        String modeCount = " (" + this.stats.maxCount + ")";
        if (modeCount.length() > 12) {
            modeCount = "";
        }
        ip.drawString("N: " + count, this.col1, this.row1);
        ip.drawString("Min: " + this.d2s(this.stats.min), this.col2, this.row1);
        ip.drawString("Mean: " + this.d2s(this.stats.mean), this.col1, this.row2);
        ip.drawString("Max: " + this.d2s(this.stats.max), this.col2, this.row2);
        ip.drawString("StdDev: " + this.d2s(this.stats.stdDev), this.col1, this.row3);
        ip.drawString("Mode: " + this.d2s(this.stats.dmode) + modeCount, this.col2, this.row3);
        if (this.showBins) {
            ip.drawString("Bins: " + this.d2s(this.stats.nBins), this.col1, this.row4);
            ip.drawString("Bin Width: " + this.d2s(binWidth), this.col2, this.row4);
        }
    }

    private String d2s(double d) {
        if ((double)((int)d) == d) {
            return IJ.d2s(d, 0);
        }
        return IJ.d2s(d, 3, 8);
    }

    int getWidth(double d, ImageProcessor ip) {
        return ip.getStringWidth(this.d2s(d));
    }

    public int[] getHistogram() {
        int[] hist = new int[this.histogram.length];
        for (int i = 0; i < this.histogram.length; ++i) {
            hist[i] = (int)this.histogram[i];
        }
        return hist;
    }

    public double[] getXValues() {
        double[] values = new double[this.stats.nBins];
        for (int i = 0; i < this.stats.nBins; ++i) {
            values[i] = this.cal.getCValue(this.stats.histMin + (double)i * this.stats.binSize);
        }
        return values;
    }

    @Override
    public void show() {
        if (IJ.isMacro() && Interpreter.isBatchMode()) {
            super.show();
        } else {
            new HistogramWindow(this, WindowManager.getImage(this.srcImageID));
        }
    }
}

