/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.plugin.ColorPanel;
import ij.plugin.PlugIn;
import ij.plugin.frame.Recorder;
import java.awt.Button;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class LUT_Editor
implements PlugIn,
ActionListener {
    private ImagePlus imp;
    Button openButton;
    Button saveButton;
    Button resizeButton;
    Button invertButton;
    ColorPanel colorPanel;
    int bitDepth;

    @Override
    public void run(String args) {
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp == null) {
            IJ.showMessage("LUT Editor", "No images are open");
            return;
        }
        this.bitDepth = imp.getBitDepth();
        if (this.bitDepth == 24) {
            IJ.showMessage("LUT Editor", "RGB images do not use LUTs");
            return;
        }
        if (this.bitDepth != 8) {
            imp.getProcessor().resetMinAndMax();
            imp.updateAndDraw();
        }
        this.colorPanel = new ColorPanel(imp);
        if (this.colorPanel.getMapSize() != 256) {
            IJ.showMessage("LUT Editor", "LUT must have 256 entries");
            return;
        }
        boolean recording = Recorder.record;
        Recorder.record = false;
        boolean red = false;
        boolean green = false;
        boolean blue = false;
        GenericDialog gd = new GenericDialog("LUT Editor");
        Panel buttonPanel = new Panel(new GridLayout(4, 1, 0, 5));
        this.openButton = new Button("Open...");
        this.openButton.addActionListener(this);
        buttonPanel.add(this.openButton);
        this.saveButton = new Button("Save...");
        this.saveButton.addActionListener(this);
        buttonPanel.add(this.saveButton);
        this.resizeButton = new Button("Set...");
        this.resizeButton.addActionListener(this);
        buttonPanel.add(this.resizeButton);
        this.invertButton = new Button("Invert...");
        this.invertButton.addActionListener(this);
        buttonPanel.add(this.invertButton);
        Panel panel = new Panel();
        panel.add(this.colorPanel);
        panel.add(buttonPanel);
        gd.addPanel(panel, 10, new Insets(10, 0, 0, 0));
        gd.showDialog();
        Recorder.record = recording;
        if (gd.wasCanceled()) {
            this.colorPanel.cancelLUT();
            return;
        }
        this.colorPanel.applyLUT();
        String lutName = imp.getProp("CurrentLUT");
        if (lutName != null && !lutName.endsWith(" (edited)")) {
            imp.setProp("CurrentLUT", lutName + " (edited)");
        }
    }

    void save() {
        try {
            IJ.run("LUT...");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.openButton) {
            this.colorPanel.open();
        } else if (source == this.saveButton) {
            this.save();
        } else if (source == this.resizeButton) {
            this.colorPanel.resize();
        } else if (source == this.invertButton) {
            this.colorPanel.invert();
        }
    }
}

