/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.Macro;
import ij.gui.GenericDialog;
import ij.io.SaveDialog;
import ij.plugin.PlugIn;
import ij.plugin.frame.Editor;
import ij.text.TextWindow;
import ij.util.Tools;

public class NewPlugin
implements PlugIn {
    public static final int MACRO = 0;
    public static final int JAVASCRIPT = 1;
    public static final int PLUGIN = 2;
    public static final int PLUGIN_FILTER = 3;
    public static final int PLUGIN_FRAME = 4;
    public static final int TEXT_FILE = 5;
    public static final int TABLE = 6;
    public static final int MACRO_TOOL = 7;
    public static final int PLUGIN_TOOL = 8;
    public static final int TEMPLATE = 9;
    private static int rows = 24;
    private static int columns = 80;
    private static int tableWidth = 350;
    private static int tableHeight = 250;
    private int type = 0;
    private String name = "Macro.ijm";
    private boolean monospaced;
    private boolean menuBar = true;
    private Editor ed;

    @Override
    public void run(String arg) {
        this.type = -1;
        if (arg.startsWith("text") || arg.equals("")) {
            this.type = 5;
            this.name = IJ.altKeyDown() ? "Untitled.ijm" : "Untitled.txt";
        } else if (arg.equals("macro")) {
            this.type = 0;
            this.name = "Macro.ijm";
        } else if (arg.equals("macro-tool")) {
            this.type = 9;
            this.name = "Circle_Tool.txt";
        } else if (arg.equals("javascript")) {
            this.type = 1;
            this.name = "Script.js";
        } else if (arg.equals("plugin")) {
            this.type = 9;
            this.name = "My_Plugin.src";
        } else if (arg.equals("frame")) {
            this.type = 9;
            this.name = "Plugin_Frame.src";
        } else if (arg.equals("plugin-tool")) {
            this.type = 9;
            this.name = "Prototype_Tool.src";
        } else if (arg.equals("filter")) {
            this.type = 9;
            this.name = "Filter_Plugin.src";
        } else if (arg.equals("table")) {
            String options = Macro.getOptions();
            if (IJ.isMacro() && options != null && options.indexOf("[Text File]") != -1) {
                this.type = 5;
                this.name = "Untitled.txt";
                arg = "text+dialog";
            } else {
                this.type = 6;
                this.name = "Table";
            }
        }
        this.menuBar = true;
        if ((arg.equals("text+dialog") || this.type == 6) && !this.showDialog()) {
            return;
        }
        if (this.type == -1) {
            this.createPlugin("Converted_Macro.java", 2, arg);
        } else if (this.type == 9 || this.type == 0 || this.type == 5 || this.type == 1) {
            if (this.type == 5 && this.name.equals("Macro")) {
                this.name = "Untitled.txt";
            }
            this.createMacro(this.name);
        } else if (this.type == 6) {
            this.createTable();
        } else {
            this.createPlugin(this.name, this.type, arg);
        }
    }

    public void createMacro(String name) {
        int options = (this.monospaced ? 1 : 0) + (this.menuBar ? 2 : 0);
        if (name.endsWith(".ijm") || name.endsWith(".js")) {
            options |= 4;
        }
        if (name.endsWith(".ijm")) {
            options |= 8;
        }
        String text = "";
        this.ed = new Editor(rows, columns, 0, options);
        if (this.type == 9) {
            text = Tools.openFromIJJarAsString("/macros/" + name);
        }
        if (name.endsWith(".src")) {
            name = name.substring(0, name.length() - 4) + ".java";
        }
        if (this.type == 0 && !name.endsWith(".ijm")) {
            name = SaveDialog.setExtension(name, ".ijm");
        } else if (this.type == 1 && !name.endsWith(".js")) {
            if (name.equals("Macro")) {
                name = "script";
            }
            name = SaveDialog.setExtension(name, ".js");
        }
        if (text != null) {
            this.ed.create(name, text);
        }
    }

    void createTable() {
        new TextWindow(this.name, "", tableWidth, tableHeight);
    }

    public void createPlugin(String name, int type, String methods) {
        this.ed = (Editor)IJ.runPlugIn("ij.plugin.frame.Editor", "");
        if (this.ed == null) {
            return;
        }
        String pluginName = name;
        if (!name.endsWith(".java") && !name.endsWith(".JAVA")) {
            name = SaveDialog.setExtension(name, ".java");
        }
        String className = pluginName.substring(0, pluginName.length() - 5);
        String text = "";
        text = text + "import ij.*;\n";
        text = text + "import ij.process.*;\n";
        text = text + "import ij.gui.*;\n";
        text = text + "import java.awt.*;\n";
        text = text + "import ij.plugin.*;\n";
        text = text + "\n";
        text = text + "public class " + className + " implements PlugIn {\n";
        text = text + "\n";
        text = text + "\tpublic void run(String arg) {\n";
        text = text + methods;
        text = text + "\t}\n";
        text = text + "\n";
        text = text + "}\n";
        this.ed.create(pluginName, text);
    }

    public boolean showDialog() {
        String heightUnit;
        String widthUnit;
        int height;
        int width;
        String title;
        if (this.type == 6) {
            title = "New Table";
            this.name = "Table";
            width = tableWidth;
            height = tableHeight;
            widthUnit = "pixels";
            heightUnit = "pixels";
        } else {
            title = "New Text Window";
            this.name = "Untitled";
            width = columns;
            height = rows;
            widthUnit = "characters";
            heightUnit = "lines";
        }
        GenericDialog gd = new GenericDialog(title);
        gd.addStringField("Name:", this.name, 16);
        gd.addMessage("");
        gd.addNumericField("Width:", width, 0, 3, widthUnit);
        gd.addNumericField("Height:", height, 0, 3, heightUnit);
        if (this.type != 6) {
            gd.setInsets(5, 30, 0);
            gd.addCheckbox("Menu Bar", true);
            gd.setInsets(0, 30, 0);
            gd.addCheckbox("Monospaced Font", this.monospaced);
        }
        gd.showDialog();
        if (gd.wasCanceled()) {
            return false;
        }
        this.name = gd.getNextString();
        width = (int)gd.getNextNumber();
        height = (int)gd.getNextNumber();
        if (width < 1) {
            width = 1;
        }
        if (height < 1) {
            height = 1;
        }
        if (this.type != 6) {
            this.menuBar = gd.getNextBoolean();
            this.monospaced = gd.getNextBoolean();
            columns = width;
            rows = height;
            if (rows > 100) {
                rows = 100;
            }
            if (columns > 200) {
                columns = 200;
            }
        } else {
            tableWidth = width;
            tableHeight = height;
            if (tableWidth < 128) {
                tableWidth = 128;
            }
            if (tableHeight < 75) {
                tableHeight = 75;
            }
        }
        return true;
    }

    public Editor getEditor() {
        return this.ed;
    }
}

