/*
 * Decompiled with CFR 0.152.
 */
package ij.process;

import ij.Prefs;
import ij.plugin.filter.Convolver;
import ij.process.BinaryProcessor;
import ij.process.ByteBlitter;
import ij.process.FloatBlitter;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.PixelGrabber;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Random;

public class ByteProcessor
extends ImageProcessor {
    static final int ERODE = 10;
    static final int DILATE = 11;
    protected byte[] pixels;
    protected byte[] snapshotPixels;
    private int bgColor = 255;
    private boolean bgColorSet;
    private int min = 0;
    private int max = 255;
    private int binaryCount;
    private int binaryBackground;
    static double oldx;
    static double oldy;

    public ByteProcessor(Image img) {
        this.width = img.getWidth(null);
        this.height = img.getHeight(null);
        this.resetRoi();
        this.pixels = new byte[this.width * this.height];
        PixelGrabber pg = new PixelGrabber(img, 0, 0, this.width, this.height, false);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException e) {
            System.err.println(e);
        }
        this.cm = pg.getColorModel();
        if (this.cm instanceof IndexColorModel) {
            this.pixels = (byte[])pg.getPixels();
        }
        if (this.cm instanceof IndexColorModel && ((IndexColorModel)this.cm).getTransparentPixel() != -1) {
            IndexColorModel icm = (IndexColorModel)this.cm;
            int mapSize = icm.getMapSize();
            byte[] reds = new byte[mapSize];
            byte[] greens = new byte[mapSize];
            byte[] blues = new byte[mapSize];
            icm.getReds(reds);
            icm.getGreens(greens);
            icm.getBlues(blues);
            this.cm = new IndexColorModel(8, mapSize, reds, greens, blues);
        }
    }

    public ByteProcessor(int width, int height) {
        this(width, height, new byte[width * height], null);
    }

    public ByteProcessor(int width, int height, byte[] pixels) {
        this(width, height, pixels, null);
    }

    public ByteProcessor(int width, int height, byte[] pixels, ColorModel cm) {
        if (pixels != null && width * height != pixels.length) {
            throw new IllegalArgumentException("width*height!=pixels.length");
        }
        this.width = width;
        this.height = height;
        this.resetRoi();
        this.pixels = pixels;
        this.cm = cm;
    }

    public ByteProcessor(BufferedImage bi) {
        if (bi.getType() != 10) {
            throw new IllegalArgumentException("Type!=TYPE_BYTE_GRAYY");
        }
        WritableRaster raster = bi.getRaster();
        DataBuffer buffer = raster.getDataBuffer();
        this.pixels = ((DataBufferByte)buffer).getData();
        this.width = raster.getWidth();
        this.height = raster.getHeight();
        this.resetRoi();
    }

    public ByteProcessor(ImageProcessor ip, boolean scale) {
        ImageProcessor bp = ip instanceof ByteProcessor ? ip.duplicate() : ip.convertToByte(scale);
        this.width = bp.getWidth();
        this.height = bp.getHeight();
        this.resetRoi();
        this.pixels = (byte[])bp.getPixels();
        this.cm = bp.getCurrentColorModel();
    }

    @Override
    public Image createImage() {
        if (this.cm == null) {
            this.cm = this.getDefaultColorModel();
        }
        return this.createBufferedImage();
    }

    Image createBufferedImage() {
        if (this.raster == null) {
            SampleModel sm = this.getIndexSampleModel();
            DataBufferByte db = new DataBufferByte(this.pixels, this.width * this.height, 0);
            this.raster = Raster.createWritableRaster(sm, db, null);
        }
        if (this.image == null || this.cm != this.cm2) {
            if (this.cm == null) {
                this.cm = this.getDefaultColorModel();
            }
            this.image = new BufferedImage(this.cm, this.raster, false, null);
            this.cm2 = this.cm;
        }
        return this.image;
    }

    @Override
    public BufferedImage getBufferedImage() {
        if (this.isDefaultLut()) {
            BufferedImage bi = new BufferedImage(this.width, this.height, 10);
            Graphics2D g = bi.createGraphics();
            g.drawImage(this.createImage(), 0, 0, null);
            return bi;
        }
        return (BufferedImage)this.createBufferedImage();
    }

    @Override
    public ImageProcessor createProcessor(int width, int height) {
        ByteProcessor ip2 = new ByteProcessor(width, height, new byte[width * height], this.getColorModel());
        if (this.baseCM != null) {
            ((ImageProcessor)ip2).setMinAndMax(this.min, this.max);
        }
        ip2.setInterpolationMethod(this.interpolationMethod);
        return ip2;
    }

    @Override
    public ImageProcessor crop() {
        ImageProcessor ip2 = this.createProcessor(this.roiWidth, this.roiHeight);
        byte[] pixels2 = (byte[])ip2.getPixels();
        for (int ys = this.roiY; ys < this.roiY + this.roiHeight; ++ys) {
            int offset1 = (ys - this.roiY) * this.roiWidth;
            int offset2 = ys * this.width + this.roiX;
            for (int xs = 0; xs < this.roiWidth; ++xs) {
                pixels2[offset1++] = this.pixels[offset2++];
            }
        }
        return ip2;
    }

    @Override
    public ImageProcessor duplicate() {
        ImageProcessor ip2 = this.createProcessor(this.width, this.height);
        byte[] pixels2 = (byte[])ip2.getPixels();
        System.arraycopy(this.pixels, 0, pixels2, 0, this.width * this.height);
        return ip2;
    }

    @Override
    public void snapshot() {
        this.snapshotWidth = this.width;
        this.snapshotHeight = this.height;
        if (this.snapshotPixels == null || this.snapshotPixels != null && this.snapshotPixels.length != this.pixels.length) {
            this.snapshotPixels = new byte[this.width * this.height];
        }
        System.arraycopy(this.pixels, 0, this.snapshotPixels, 0, this.width * this.height);
    }

    @Override
    public void reset() {
        if (this.snapshotPixels != null) {
            System.arraycopy(this.snapshotPixels, 0, this.pixels, 0, this.width * this.height);
        }
    }

    @Override
    public void swapPixelArrays() {
        if (this.snapshotPixels == null) {
            return;
        }
        for (int i = 0; i < this.pixels.length; ++i) {
            byte pixel = this.pixels[i];
            this.pixels[i] = this.snapshotPixels[i];
            this.snapshotPixels[i] = pixel;
        }
    }

    @Override
    public void reset(ImageProcessor mask) {
        if (mask == null || this.snapshotPixels == null) {
            return;
        }
        if (mask.getWidth() != this.roiWidth || mask.getHeight() != this.roiHeight) {
            throw new IllegalArgumentException(this.maskSizeError(mask));
        }
        byte[] mpixels = (byte[])mask.getPixels();
        int y = this.roiY;
        int my = 0;
        while (y < this.roiY + this.roiHeight) {
            int i = y * this.width + this.roiX;
            int mi = my * this.roiWidth;
            for (int x = this.roiX; x < this.roiX + this.roiWidth; ++x) {
                if (mpixels[mi++] == 0) {
                    this.pixels[i] = this.snapshotPixels[i];
                }
                ++i;
            }
            ++y;
            ++my;
        }
    }

    @Override
    public void setSnapshotPixels(Object pixels) {
        this.snapshotPixels = (byte[])pixels;
        this.snapshotWidth = this.width;
        this.snapshotHeight = this.height;
    }

    @Override
    public Object getSnapshotPixels() {
        return this.snapshotPixels;
    }

    @Override
    public void fill(ImageProcessor mask) {
        if (mask == null) {
            this.fill();
            return;
        }
        int roiWidth = this.roiWidth;
        int roiHeight = this.roiHeight;
        int roiX = this.roiX;
        int roiY = this.roiY;
        if (!(mask.getWidth() == roiWidth && mask.getHeight() == roiHeight || (mask = this.getMask()) != null && mask.getWidth() == roiWidth && mask.getHeight() == roiHeight)) {
            return;
        }
        byte[] mpixels = (byte[])mask.getPixels();
        int y = roiY;
        int my = 0;
        while (y < roiY + roiHeight) {
            int i = y * this.width + roiX;
            int mi = my * roiWidth;
            for (int x = roiX; x < roiX + roiWidth; ++x) {
                if (mpixels[mi++] != 0) {
                    this.pixels[i] = (byte)this.fgColor;
                }
                ++i;
            }
            ++y;
            ++my;
        }
    }

    @Override
    public int getPixel(int x, int y) {
        if (x >= 0 && x < this.width && y >= 0 && y < this.height) {
            return this.pixels[y * this.width + x] & 0xFF;
        }
        return 0;
    }

    @Override
    public final int get(int x, int y) {
        return this.pixels[y * this.width + x] & 0xFF;
    }

    @Override
    public final void set(int x, int y, int value) {
        this.pixels[y * this.width + x] = (byte)value;
    }

    @Override
    public final int get(int index) {
        return this.pixels[index] & 0xFF;
    }

    @Override
    public final void set(int index, int value) {
        this.pixels[index] = (byte)value;
    }

    @Override
    public final float getf(int x, int y) {
        return this.pixels[y * this.width + x] & 0xFF;
    }

    @Override
    public final void setf(int x, int y, float value) {
        this.pixels[y * this.width + x] = (byte)(value + 0.5f);
    }

    @Override
    public final float getf(int index) {
        return this.pixels[index] & 0xFF;
    }

    @Override
    public final void setf(int index, float value) {
        this.pixels[index] = (byte)value;
    }

    @Override
    public double getInterpolatedPixel(double x, double y) {
        if (this.interpolationMethod == 2) {
            return this.getBicubicInterpolatedPixel(x, y, this);
        }
        if (x < 0.0) {
            x = 0.0;
        }
        if (x >= (double)this.width - 1.0) {
            x = (double)this.width - 1.001;
        }
        if (y < 0.0) {
            y = 0.0;
        }
        if (y >= (double)this.height - 1.0) {
            y = (double)this.height - 1.001;
        }
        return this.getInterpolatedPixel(x, y, this.pixels);
    }

    @Override
    public final int getPixelInterpolated(double x, double y) {
        if (this.interpolationMethod == 1) {
            if (x < 0.0 || y < 0.0 || x >= (double)(this.width - 1) || y >= (double)(this.height - 1)) {
                return 0;
            }
            return (int)Math.round(this.getInterpolatedPixel(x, y, this.pixels));
        }
        if (this.interpolationMethod == 2) {
            int value = (int)(this.getBicubicInterpolatedPixel(x, y, this) + 0.5);
            if (value < 0) {
                value = 0;
            }
            if (value > 255) {
                value = 255;
            }
            return value;
        }
        return this.getPixel((int)(x + 0.5), (int)(y + 0.5));
    }

    @Override
    public float getPixelValue(int x, int y) {
        if (x >= 0 && x < this.width && y >= 0 && y < this.height) {
            if (this.cTable == null) {
                return this.pixels[y * this.width + x] & 0xFF;
            }
            return this.cTable[this.pixels[y * this.width + x] & 0xFF];
        }
        return Float.NaN;
    }

    @Override
    public void setColor(Color color) {
        this.drawingColor = color;
        this.fgColor = this.getBestIndex(color);
        this.fillValueSet = true;
    }

    @Override
    public void setBackgroundColor(Color color) {
        this.setBackgroundValue(this.getBestIndex(color));
    }

    @Override
    public void setValue(double value) {
        this.fgColor = (int)value;
        if (this.fgColor < 0) {
            this.fgColor = 0;
        }
        if (this.fgColor > 255) {
            this.fgColor = 255;
        }
        this.fillValueSet = true;
    }

    @Override
    public double getForegroundValue() {
        return this.fgColor;
    }

    @Override
    public void setBackgroundValue(double value) {
        this.bgColor = (int)value;
        if (this.bgColor < 0) {
            this.bgColor = 0;
        }
        if (this.bgColor > 255) {
            this.bgColor = 255;
        }
        this.bgColorSet = true;
    }

    @Override
    public double getBackgroundValue() {
        return this.bgColor;
    }

    @Override
    public void putPixelValue(int x, int y, double value) {
        if (x >= 0 && x < this.width && y >= 0 && y < this.height) {
            if (value > 255.0) {
                value = 255.0;
            } else if (value < 0.0) {
                value = 0.0;
            }
            this.pixels[y * this.width + x] = (byte)(value + 0.5);
        }
    }

    @Override
    public final void putPixel(int x, int y, int value) {
        if (x >= 0 && x < this.width && y >= 0 && y < this.height) {
            if (value > 255) {
                value = 255;
            }
            if (value < 0) {
                value = 0;
            }
            this.pixels[y * this.width + x] = (byte)value;
        }
    }

    @Override
    public void drawPixel(int x, int y) {
        if (x >= this.clipXMin && x <= this.clipXMax && y >= this.clipYMin && y <= this.clipYMax) {
            this.pixels[y * this.width + x] = (byte)this.fgColor;
        }
    }

    @Override
    public Object getPixels() {
        return this.pixels;
    }

    @Override
    public Object getPixelsCopy() {
        if (this.snapshotPixels != null && this.snapshotCopyMode) {
            this.snapshotCopyMode = false;
            return this.snapshotPixels;
        }
        byte[] pixels2 = new byte[this.width * this.height];
        System.arraycopy(this.pixels, 0, pixels2, 0, this.width * this.height);
        return pixels2;
    }

    @Override
    public void setPixels(Object pixels) {
        if (pixels != null && this.pixels != null && ((byte[])pixels).length != this.pixels.length) {
            throw new IllegalArgumentException("");
        }
        this.pixels = (byte[])pixels;
        this.resetPixels(pixels);
        if (pixels == null) {
            this.snapshotPixels = null;
        }
        this.raster = null;
        this.image = null;
    }

    @Override
    public double getMin() {
        return this.min;
    }

    @Override
    public double getMax() {
        return this.max;
    }

    @Override
    public void setMinAndMax(double min, double max) {
        if (max < min) {
            return;
        }
        this.min = (int)Math.round(min);
        this.max = (int)Math.round(max);
        if (this.rLUT1 == null) {
            if (this.cm == null) {
                this.makeDefaultColorModel();
            }
            this.baseCM = this.cm;
            IndexColorModel m = (IndexColorModel)this.cm;
            this.rLUT1 = new byte[256];
            this.gLUT1 = new byte[256];
            this.bLUT1 = new byte[256];
            m.getReds(this.rLUT1);
            m.getGreens(this.gLUT1);
            m.getBlues(this.bLUT1);
            this.rLUT2 = new byte[256];
            this.gLUT2 = new byte[256];
            this.bLUT2 = new byte[256];
        }
        if (this.rLUT2 == null) {
            return;
        }
        for (int i = 0; i < 256; ++i) {
            if ((double)i < min) {
                this.rLUT2[i] = this.rLUT1[0];
                this.gLUT2[i] = this.gLUT1[0];
                this.bLUT2[i] = this.bLUT1[0];
                continue;
            }
            if ((double)i > max) {
                this.rLUT2[i] = this.rLUT1[255];
                this.gLUT2[i] = this.gLUT1[255];
                this.bLUT2[i] = this.bLUT1[255];
                continue;
            }
            int index = i - this.min;
            if ((index = (int)(256.0 * (double)index / (max - min))) < 0) {
                index = 0;
            }
            if (index > 255) {
                index = 255;
            }
            this.rLUT2[i] = this.rLUT1[index];
            this.gLUT2[i] = this.gLUT1[index];
            this.bLUT2[i] = this.bLUT1[index];
        }
        this.cm = new IndexColorModel(8, 256, this.rLUT2, this.gLUT2, this.bLUT2);
        this.minThreshold = -808080.0;
    }

    @Override
    public void resetMinAndMax() {
        this.setMinAndMax(0.0, 255.0);
    }

    @Override
    public void setThreshold(double minThreshold, double maxThreshold, int lutUpdate) {
        super.setThreshold(minThreshold, maxThreshold, lutUpdate);
        if (this.minThreshold < 0.0 && this.minThreshold != -808080.0) {
            this.minThreshold = 0.0;
        }
        if (this.maxThreshold > 255.0) {
            this.maxThreshold = 255.0;
        }
    }

    @Override
    public void copyBits(ImageProcessor ip, int xloc, int yloc, int mode) {
        boolean temporaryFloat;
        boolean bl = temporaryFloat = ip.getBitDepth() == 32 && (mode == 5 || mode == 6);
        if (temporaryFloat) {
            FloatProcessor ipFloat = this.convertToFloatProcessor();
            new FloatBlitter(ipFloat).copyBits(ip, xloc, yloc, mode);
            this.setPixels(1, ipFloat);
        } else {
            ip = ip.convertToByte(true);
            new ByteBlitter(this).copyBits(ip, xloc, yloc, mode);
        }
    }

    @Override
    public void applyTable(int[] lut) {
        for (int y = this.roiY; y < this.roiY + this.roiHeight; ++y) {
            int lineEnd;
            int lineStart = y * this.width + this.roiX;
            int i = lineEnd = lineStart + this.roiWidth;
            while (--i >= lineStart) {
                this.pixels[i] = (byte)lut[this.pixels[i] & 0xFF];
            }
        }
    }

    @Override
    public void convolve3x3(int[] kernel) {
        int scale = 0;
        int k1 = kernel[0];
        int k2 = kernel[1];
        int k3 = kernel[2];
        int k4 = kernel[3];
        int k5 = kernel[4];
        int k6 = kernel[5];
        int k7 = kernel[6];
        int k8 = kernel[7];
        int k9 = kernel[8];
        for (int i = 0; i < kernel.length; ++i) {
            scale += kernel[i];
        }
        if (scale == 0) {
            scale = 1;
        }
        byte[] pixels2 = (byte[])this.getPixelsCopy();
        int xEnd = this.roiX + this.roiWidth;
        int yEnd = this.roiY + this.roiHeight;
        for (int y = this.roiY; y < yEnd; ++y) {
            int p = this.roiX + y * this.width;
            int p6 = p - (this.roiX > 0 ? 1 : 0);
            int p3 = p6 - (y > 0 ? this.width : 0);
            int p9 = p6 + (y < this.height - 1 ? this.width : 0);
            int v2 = pixels2[p3] & 0xFF;
            int v5 = pixels2[p6] & 0xFF;
            int v8 = pixels2[p9] & 0xFF;
            if (this.roiX > 0) {
                ++p3;
                ++p6;
                ++p9;
            }
            int v3 = pixels2[p3] & 0xFF;
            int v6 = pixels2[p6] & 0xFF;
            int v9 = pixels2[p9] & 0xFF;
            int x = this.roiX;
            while (x < xEnd) {
                if (x < this.width - 1) {
                    ++p3;
                    ++p6;
                    ++p9;
                }
                int v1 = v2;
                v2 = v3;
                v3 = pixels2[p3] & 0xFF;
                int v4 = v5;
                v5 = v6;
                v6 = pixels2[p6] & 0xFF;
                int v7 = v8;
                v8 = v9;
                v9 = pixels2[p9] & 0xFF;
                int sum = k1 * v1 + k2 * v2 + k3 * v3 + k4 * v4 + k5 * v5 + k6 * v6 + k7 * v7 + k8 * v8 + k9 * v9;
                if ((sum = (sum + scale / 2) / scale) > 255) {
                    sum = 255;
                }
                if (sum < 0) {
                    sum = 0;
                }
                this.pixels[p] = (byte)sum;
                ++x;
                ++p;
            }
        }
    }

    @Override
    public void filter(int type) {
        byte[] pixels2 = (byte[])this.getPixelsCopy();
        if (this.width == 1) {
            this.filterEdge(type, pixels2, this.roiHeight, this.roiX, this.roiY, 0, 1);
            return;
        }
        int sum2 = 0;
        int sum = 0;
        int[] values = new int[10];
        if (type == 2) {
            values = new int[10];
        }
        int rowOffset = this.width;
        int binaryForeground = 255 - this.binaryBackground;
        for (int y = this.yMin; y <= this.yMax; ++y) {
            int offset = this.xMin + y * this.width;
            int p2 = pixels2[offset - rowOffset - 1] & 0xFF;
            int p3 = pixels2[offset - rowOffset] & 0xFF;
            int p5 = pixels2[offset - 1] & 0xFF;
            int p6 = pixels2[offset] & 0xFF;
            int p8 = pixels2[offset + rowOffset - 1] & 0xFF;
            int p9 = pixels2[offset + rowOffset] & 0xFF;
            for (int x = this.xMin; x <= this.xMax; ++x) {
                int p1 = p2;
                p2 = p3;
                p3 = pixels2[offset - rowOffset + 1] & 0xFF;
                int p4 = p5;
                p5 = p6;
                p6 = pixels2[offset + 1] & 0xFF;
                int p7 = p8;
                p8 = p9;
                p9 = pixels2[offset + rowOffset + 1] & 0xFF;
                switch (type) {
                    case 0: {
                        sum = (p1 + p2 + p3 + p4 + p5 + p6 + p7 + p8 + p9 + 4) / 9;
                        break;
                    }
                    case 1: {
                        int sum1 = p1 + 2 * p2 + p3 - p7 - 2 * p8 - p9;
                        sum2 = p1 + 2 * p4 + p7 - p3 - 2 * p6 - p9;
                        sum = (int)Math.sqrt(sum1 * sum1 + sum2 * sum2);
                        if (sum <= 255) break;
                        sum = 255;
                        break;
                    }
                    case 2: {
                        values[1] = p1;
                        values[2] = p2;
                        values[3] = p3;
                        values[4] = p4;
                        values[5] = p5;
                        values[6] = p6;
                        values[7] = p7;
                        values[8] = p8;
                        values[9] = p9;
                        sum = this.findMedian(values);
                        break;
                    }
                    case 3: {
                        sum = p5;
                        if (p1 < sum) {
                            sum = p1;
                        }
                        if (p2 < sum) {
                            sum = p2;
                        }
                        if (p3 < sum) {
                            sum = p3;
                        }
                        if (p4 < sum) {
                            sum = p4;
                        }
                        if (p6 < sum) {
                            sum = p6;
                        }
                        if (p7 < sum) {
                            sum = p7;
                        }
                        if (p8 < sum) {
                            sum = p8;
                        }
                        if (p9 >= sum) break;
                        sum = p9;
                        break;
                    }
                    case 4: {
                        sum = p5;
                        if (p1 > sum) {
                            sum = p1;
                        }
                        if (p2 > sum) {
                            sum = p2;
                        }
                        if (p3 > sum) {
                            sum = p3;
                        }
                        if (p4 > sum) {
                            sum = p4;
                        }
                        if (p6 > sum) {
                            sum = p6;
                        }
                        if (p7 > sum) {
                            sum = p7;
                        }
                        if (p8 > sum) {
                            sum = p8;
                        }
                        if (p9 <= sum) break;
                        sum = p9;
                        break;
                    }
                    case 10: {
                        if (p5 == this.binaryBackground) {
                            sum = this.binaryBackground;
                            break;
                        }
                        int count = 0;
                        if (p1 == this.binaryBackground) {
                            ++count;
                        }
                        if (p2 == this.binaryBackground) {
                            ++count;
                        }
                        if (p3 == this.binaryBackground) {
                            ++count;
                        }
                        if (p4 == this.binaryBackground) {
                            ++count;
                        }
                        if (p6 == this.binaryBackground) {
                            ++count;
                        }
                        if (p7 == this.binaryBackground) {
                            ++count;
                        }
                        if (p8 == this.binaryBackground) {
                            ++count;
                        }
                        if (p9 == this.binaryBackground) {
                            ++count;
                        }
                        if (count >= this.binaryCount) {
                            sum = this.binaryBackground;
                            break;
                        }
                        sum = binaryForeground;
                        break;
                    }
                    case 11: {
                        if (p5 == binaryForeground) {
                            sum = binaryForeground;
                            break;
                        }
                        int count = 0;
                        if (p1 == binaryForeground) {
                            ++count;
                        }
                        if (p2 == binaryForeground) {
                            ++count;
                        }
                        if (p3 == binaryForeground) {
                            ++count;
                        }
                        if (p4 == binaryForeground) {
                            ++count;
                        }
                        if (p6 == binaryForeground) {
                            ++count;
                        }
                        if (p7 == binaryForeground) {
                            ++count;
                        }
                        if (p8 == binaryForeground) {
                            ++count;
                        }
                        if (p9 == binaryForeground) {
                            ++count;
                        }
                        sum = count >= this.binaryCount ? binaryForeground : this.binaryBackground;
                    }
                }
                this.pixels[offset++] = (byte)sum;
            }
        }
        if (this.xMin == 1) {
            this.filterEdge(type, pixels2, this.roiHeight, this.roiX, this.roiY, 0, 1);
        }
        if (this.yMin == 1) {
            this.filterEdge(type, pixels2, this.roiWidth, this.roiX, this.roiY, 1, 0);
        }
        if (this.xMax == this.width - 2) {
            this.filterEdge(type, pixels2, this.roiHeight, this.width - 1, this.roiY, 0, 1);
        }
        if (this.yMax == this.height - 2) {
            this.filterEdge(type, pixels2, this.roiWidth, this.roiX, this.height - 1, 1, 0);
        }
    }

    void filterEdge(int type, byte[] pixels2, int n, int x, int y, int xinc, int yinc) {
        int sum = 0;
        int binaryForeground = 255 - this.binaryBackground;
        int bg = this.binaryBackground;
        int fg = binaryForeground;
        for (int i = 0; i < n; ++i) {
            int p9;
            int p8;
            int p7;
            int p6;
            int p5;
            int p4;
            int p3;
            int p2;
            int p1;
            if (!Prefs.padEdges && type == 10 || type == 11) {
                p1 = this.getEdgePixel0(pixels2, bg, x - 1, y - 1);
                p2 = this.getEdgePixel0(pixels2, bg, x, y - 1);
                p3 = this.getEdgePixel0(pixels2, bg, x + 1, y - 1);
                p4 = this.getEdgePixel0(pixels2, bg, x - 1, y);
                p5 = this.getEdgePixel0(pixels2, bg, x, y);
                p6 = this.getEdgePixel0(pixels2, bg, x + 1, y);
                p7 = this.getEdgePixel0(pixels2, bg, x - 1, y + 1);
                p8 = this.getEdgePixel0(pixels2, bg, x, y + 1);
                p9 = this.getEdgePixel0(pixels2, bg, x + 1, y + 1);
            } else if (Prefs.padEdges && type == 10) {
                p1 = this.getEdgePixel1(pixels2, fg, x - 1, y - 1);
                p2 = this.getEdgePixel1(pixels2, fg, x, y - 1);
                p3 = this.getEdgePixel1(pixels2, fg, x + 1, y - 1);
                p4 = this.getEdgePixel1(pixels2, fg, x - 1, y);
                p5 = this.getEdgePixel1(pixels2, fg, x, y);
                p6 = this.getEdgePixel1(pixels2, fg, x + 1, y);
                p7 = this.getEdgePixel1(pixels2, fg, x - 1, y + 1);
                p8 = this.getEdgePixel1(pixels2, fg, x, y + 1);
                p9 = this.getEdgePixel1(pixels2, fg, x + 1, y + 1);
            } else {
                p1 = this.getEdgePixel(pixels2, x - 1, y - 1);
                p2 = this.getEdgePixel(pixels2, x, y - 1);
                p3 = this.getEdgePixel(pixels2, x + 1, y - 1);
                p4 = this.getEdgePixel(pixels2, x - 1, y);
                p5 = this.getEdgePixel(pixels2, x, y);
                p6 = this.getEdgePixel(pixels2, x + 1, y);
                p7 = this.getEdgePixel(pixels2, x - 1, y + 1);
                p8 = this.getEdgePixel(pixels2, x, y + 1);
                p9 = this.getEdgePixel(pixels2, x + 1, y + 1);
            }
            switch (type) {
                case 0: {
                    sum = (p1 + p2 + p3 + p4 + p5 + p6 + p7 + p8 + p9 + 4) / 9;
                    break;
                }
                case 1: {
                    int sum1 = p1 + 2 * p2 + p3 - p7 - 2 * p8 - p9;
                    int sum2 = p1 + 2 * p4 + p7 - p3 - 2 * p6 - p9;
                    sum = (int)Math.sqrt(sum1 * sum1 + sum2 * sum2);
                    if (sum <= 255) break;
                    sum = 255;
                    break;
                }
                case 3: {
                    sum = p5;
                    if (p1 < sum) {
                        sum = p1;
                    }
                    if (p2 < sum) {
                        sum = p2;
                    }
                    if (p3 < sum) {
                        sum = p3;
                    }
                    if (p4 < sum) {
                        sum = p4;
                    }
                    if (p6 < sum) {
                        sum = p6;
                    }
                    if (p7 < sum) {
                        sum = p7;
                    }
                    if (p8 < sum) {
                        sum = p8;
                    }
                    if (p9 >= sum) break;
                    sum = p9;
                    break;
                }
                case 4: {
                    sum = p5;
                    if (p1 > sum) {
                        sum = p1;
                    }
                    if (p2 > sum) {
                        sum = p2;
                    }
                    if (p3 > sum) {
                        sum = p3;
                    }
                    if (p4 > sum) {
                        sum = p4;
                    }
                    if (p6 > sum) {
                        sum = p6;
                    }
                    if (p7 > sum) {
                        sum = p7;
                    }
                    if (p8 > sum) {
                        sum = p8;
                    }
                    if (p9 <= sum) break;
                    sum = p9;
                    break;
                }
                case 10: {
                    if (p5 == this.binaryBackground) {
                        sum = this.binaryBackground;
                        break;
                    }
                    int count = 0;
                    if (p1 == this.binaryBackground) {
                        ++count;
                    }
                    if (p2 == this.binaryBackground) {
                        ++count;
                    }
                    if (p3 == this.binaryBackground) {
                        ++count;
                    }
                    if (p4 == this.binaryBackground) {
                        ++count;
                    }
                    if (p6 == this.binaryBackground) {
                        ++count;
                    }
                    if (p7 == this.binaryBackground) {
                        ++count;
                    }
                    if (p8 == this.binaryBackground) {
                        ++count;
                    }
                    if (p9 == this.binaryBackground) {
                        ++count;
                    }
                    if (count >= this.binaryCount) {
                        sum = this.binaryBackground;
                        break;
                    }
                    sum = binaryForeground;
                    break;
                }
                case 11: {
                    if (p5 == binaryForeground) {
                        sum = binaryForeground;
                        break;
                    }
                    int count = 0;
                    if (p1 == binaryForeground) {
                        ++count;
                    }
                    if (p2 == binaryForeground) {
                        ++count;
                    }
                    if (p3 == binaryForeground) {
                        ++count;
                    }
                    if (p4 == binaryForeground) {
                        ++count;
                    }
                    if (p6 == binaryForeground) {
                        ++count;
                    }
                    if (p7 == binaryForeground) {
                        ++count;
                    }
                    if (p8 == binaryForeground) {
                        ++count;
                    }
                    if (p9 == binaryForeground) {
                        ++count;
                    }
                    sum = count >= this.binaryCount ? binaryForeground : this.binaryBackground;
                }
            }
            this.pixels[x + y * this.width] = (byte)sum;
            x += xinc;
            y += yinc;
        }
    }

    final int getEdgePixel(byte[] pixels2, int x, int y) {
        if (x <= 0) {
            x = 0;
        }
        if (x >= this.width) {
            x = this.width - 1;
        }
        if (y <= 0) {
            y = 0;
        }
        if (y >= this.height) {
            y = this.height - 1;
        }
        return pixels2[x + y * this.width] & 0xFF;
    }

    final int getEdgePixel1(byte[] pixels2, int foreground, int x, int y) {
        if (x < 0 || x > this.width - 1 || y < 0 || y > this.height - 1) {
            return foreground;
        }
        return pixels2[x + y * this.width] & 0xFF;
    }

    final int getEdgePixel0(byte[] pixels2, int background, int x, int y) {
        if (x < 0 || x > this.width - 1 || y < 0 || y > this.height - 1) {
            return background;
        }
        return pixels2[x + y * this.width] & 0xFF;
    }

    @Override
    public void erode() {
        if (this.isInvertedLut()) {
            this.filter(3);
        } else {
            this.filter(4);
        }
    }

    @Override
    public void dilate() {
        if (this.isInvertedLut()) {
            this.filter(4);
        } else {
            this.filter(3);
        }
    }

    public void erode(int count, int background) {
        this.binaryCount = count;
        this.binaryBackground = background;
        this.filter(10);
    }

    public void dilate(int count, int background) {
        this.binaryCount = count;
        this.binaryBackground = background;
        this.filter(11);
    }

    public void outline() {
        new BinaryProcessor(this).outline();
    }

    public void skeletonize() {
        new BinaryProcessor(this).skeletonize();
    }

    public void skeletonize(int foreground) {
        new BinaryProcessor(this).skeletonize(foreground);
    }

    private final int findMedian(int[] values) {
        for (int i = 1; i <= 4; ++i) {
            int max = 0;
            int mj = 1;
            for (int j = 1; j <= 9; ++j) {
                if (values[j] <= max) continue;
                max = values[j];
                mj = j;
            }
            values[mj] = 0;
        }
        int max = 0;
        for (int j = 1; j <= 9; ++j) {
            if (values[j] <= max) continue;
            max = values[j];
        }
        return max;
    }

    @Override
    public void medianFilter() {
        this.filter(2);
    }

    @Override
    public void noise(double standardDeviation) {
        if (rnd == null) {
            rnd = new Random();
        }
        if (!Double.isNaN(seed)) {
            rnd.setSeed((int)seed);
        }
        seed = Double.NaN;
        for (int y = this.roiY; y < this.roiY + this.roiHeight; ++y) {
            int i = y * this.width + this.roiX;
            for (int x = this.roiX; x < this.roiX + this.roiWidth; ++x) {
                boolean inRange = false;
                do {
                    int ran;
                    int v;
                    boolean bl = inRange = (v = (this.pixels[i] & 0xFF) + (ran = (int)Math.round(rnd.nextGaussian() * standardDeviation))) >= 0 && v <= 255;
                    if (!inRange) continue;
                    this.pixels[i] = (byte)v;
                } while (!inRange);
                ++i;
            }
        }
    }

    @Override
    public void scale(double xScale, double yScale) {
        boolean checkCoordinates;
        int ymax;
        int ymin;
        int xmax;
        int xmin;
        double xCenter = (double)this.roiX + (double)this.roiWidth / 2.0;
        double yCenter = (double)this.roiY + (double)this.roiHeight / 2.0;
        if (!this.bgColorSet && this.isInvertedLut()) {
            this.bgColor = 0;
        }
        if (xScale > 1.0 && yScale > 1.0) {
            xmin = (int)(xCenter - (xCenter - (double)this.roiX) * xScale);
            if (xmin < 0) {
                xmin = 0;
            }
            if ((xmax = xmin + (int)((double)this.roiWidth * xScale) - 1) >= this.width) {
                xmax = this.width - 1;
            }
            if ((ymin = (int)(yCenter - (yCenter - (double)this.roiY) * yScale)) < 0) {
                ymin = 0;
            }
            if ((ymax = ymin + (int)((double)this.roiHeight * yScale) - 1) >= this.height) {
                ymax = this.height - 1;
            }
        } else {
            xmin = this.roiX;
            xmax = this.roiX + this.roiWidth - 1;
            ymin = this.roiY;
            ymax = this.roiY + this.roiHeight - 1;
        }
        byte[] pixels2 = (byte[])this.getPixelsCopy();
        ByteProcessor ip2 = null;
        if (this.interpolationMethod == 2) {
            ip2 = new ByteProcessor(this.getWidth(), this.getHeight(), pixels2, null);
            ((ImageProcessor)ip2).setBackgroundValue(this.getBackgroundValue());
        }
        boolean bl = checkCoordinates = xScale < 1.0 || yScale < 1.0;
        if (this.interpolationMethod == 2) {
            for (int y = ymin; y <= ymax; ++y) {
                double ys = ((double)y - yCenter) / yScale + yCenter;
                int index1 = y * this.width + xmin;
                int index2 = this.width * (int)ys;
                for (int x = xmin; x <= xmax; ++x) {
                    double xs = ((double)x - xCenter) / xScale + xCenter;
                    int value = (int)(this.getBicubicInterpolatedPixel(xs, ys, ip2) + 0.5);
                    if (value < 0) {
                        value = 0;
                    }
                    if (value > 255) {
                        value = 255;
                    }
                    this.pixels[index1++] = (byte)value;
                }
            }
        } else {
            double xlimit = (double)this.width - 1.0;
            double xlimit2 = (double)this.width - 1.001;
            double ylimit = (double)this.height - 1.0;
            double ylimit2 = (double)this.height - 1.001;
            for (int y = ymin; y <= ymax; ++y) {
                double ys = ((double)y - yCenter) / yScale + yCenter;
                int ysi = (int)ys;
                if (ys < 0.0) {
                    ys = 0.0;
                }
                if (ys >= ylimit) {
                    ys = ylimit2;
                }
                int index1 = y * this.width + xmin;
                int index2 = this.width * (int)ys;
                for (int x = xmin; x <= xmax; ++x) {
                    double xs = ((double)x - xCenter) / xScale + xCenter;
                    int xsi = (int)xs;
                    if (checkCoordinates && (xsi < xmin || xsi > xmax || ysi < ymin || ysi > ymax)) {
                        this.pixels[index1++] = (byte)this.bgColor;
                        continue;
                    }
                    if (this.interpolationMethod == 1) {
                        if (xs < 0.0) {
                            xs = 0.0;
                        }
                        if (xs >= xlimit) {
                            xs = xlimit2;
                        }
                        this.pixels[index1++] = (byte)((int)(this.getInterpolatedPixel(xs, ys, pixels2) + 0.5) & 0xFF);
                        continue;
                    }
                    this.pixels[index1++] = pixels2[index2 + xsi];
                }
            }
        }
    }

    private final double getInterpolatedPixel(double x, double y, byte[] pixels) {
        int xbase = (int)x;
        int ybase = (int)y;
        double xFraction = x - (double)xbase;
        double yFraction = y - (double)ybase;
        int offset = ybase * this.width + xbase;
        int lowerLeft = pixels[offset] & 0xFF;
        int lowerRight = pixels[offset + 1] & 0xFF;
        int upperRight = pixels[offset + this.width + 1] & 0xFF;
        int upperLeft = pixels[offset + this.width] & 0xFF;
        double upperAverage = (double)upperLeft + xFraction * (double)(upperRight - upperLeft);
        double lowerAverage = (double)lowerLeft + xFraction * (double)(lowerRight - lowerLeft);
        return lowerAverage + yFraction * (upperAverage - lowerAverage);
    }

    @Override
    public ImageProcessor resize(int dstWidth, int dstHeight) {
        if (this.roiWidth == dstWidth && this.roiHeight == dstHeight) {
            return this.crop();
        }
        if ((this.width == 1 || this.height == 1) && this.interpolationMethod != 0) {
            return this.resizeLinearly(dstWidth, dstHeight);
        }
        double srcCenterX = (double)this.roiX + (double)this.roiWidth / 2.0;
        double srcCenterY = (double)this.roiY + (double)this.roiHeight / 2.0;
        double dstCenterX = (double)dstWidth / 2.0;
        double dstCenterY = (double)dstHeight / 2.0;
        double xScale = (double)dstWidth / (double)this.roiWidth;
        double yScale = (double)dstHeight / (double)this.roiHeight;
        if (this.interpolationMethod != 0) {
            if (dstWidth != this.width) {
                dstCenterX += xScale / 4.0;
            }
            if (dstHeight != this.height) {
                dstCenterY += yScale / 4.0;
            }
        }
        ImageProcessor ip2 = this.createProcessor(dstWidth, dstHeight);
        byte[] pixels2 = (byte[])ip2.getPixels();
        int inc = this.getProgressIncrement(dstWidth, dstHeight);
        if (this.interpolationMethod == 2) {
            for (int y = 0; y <= dstHeight - 1; ++y) {
                if (inc != 0 && y % inc == 0) {
                    this.showProgress((double)y / (double)dstHeight);
                }
                double ys = ((double)y - dstCenterY) / yScale + srcCenterY;
                int index1 = this.width * (int)ys;
                int index2 = y * dstWidth;
                for (int x = 0; x <= dstWidth - 1; ++x) {
                    double xs = ((double)x - dstCenterX) / xScale + srcCenterX;
                    int value = (int)(this.getBicubicInterpolatedPixel(xs, ys, this) + 0.5);
                    if (value < 0) {
                        value = 0;
                    }
                    if (value > 255) {
                        value = 255;
                    }
                    pixels2[index2++] = (byte)value;
                }
            }
        } else {
            double xlimit = (double)this.width - 1.0;
            double xlimit2 = (double)this.width - 1.001;
            double ylimit = (double)this.height - 1.0;
            double ylimit2 = (double)this.height - 1.001;
            for (int y = 0; y <= dstHeight - 1; ++y) {
                if (inc != 0 && y % inc == 0) {
                    this.showProgress((double)y / (double)dstHeight);
                }
                double ys = ((double)y - dstCenterY) / yScale + srcCenterY;
                if (this.interpolationMethod == 1) {
                    if (ys < 0.0) {
                        ys = 0.0;
                    }
                    if (ys >= ylimit) {
                        ys = ylimit2;
                    }
                }
                int index1 = this.width * (int)ys;
                int index2 = y * dstWidth;
                for (int x = 0; x <= dstWidth - 1; ++x) {
                    double xs = ((double)x - dstCenterX) / xScale + srcCenterX;
                    if (this.interpolationMethod == 1) {
                        if (xs < 0.0) {
                            xs = 0.0;
                        }
                        if (xs >= xlimit) {
                            xs = xlimit2;
                        }
                        pixels2[index2++] = (byte)((int)(this.getInterpolatedPixel(xs, ys, this.pixels) + 0.5) & 0xFF);
                        continue;
                    }
                    pixels2[index2++] = this.pixels[index1 + (int)xs];
                }
            }
        }
        if (inc != 0) {
            this.showProgress(1.0);
        }
        return ip2;
    }

    @Override
    public void rotate(double angle) {
        if (angle % 360.0 == 0.0) {
            return;
        }
        byte[] pixels2 = (byte[])this.getPixelsCopy();
        ByteProcessor ip2 = null;
        if (this.interpolationMethod == 2) {
            ip2 = new ByteProcessor(this.getWidth(), this.getHeight(), pixels2, null);
            ((ImageProcessor)ip2).setBackgroundValue(this.getBackgroundValue());
        }
        double centerX = (double)this.roiX + (double)(this.roiWidth - 1) / 2.0;
        double centerY = (double)this.roiY + (double)(this.roiHeight - 1) / 2.0;
        int xMax = this.roiX + this.roiWidth - 1;
        if (!this.bgColorSet && this.isInvertedLut()) {
            this.bgColor = 0;
        }
        double angleRadians = -angle / 57.29577951308232;
        double ca = Math.cos(angleRadians);
        double sa = Math.sin(angleRadians);
        double tmp1 = centerY * sa - centerX * ca;
        double tmp2 = -centerX * sa - centerY * ca;
        double dwidth = this.width;
        double dheight = this.height;
        double xlimit = (double)this.width - 1.0;
        double xlimit2 = (double)this.width - 1.001;
        double ylimit = (double)this.height - 1.0;
        double ylimit2 = (double)this.height - 1.001;
        if (this.interpolationMethod == 2) {
            for (int y = this.roiY; y < this.roiY + this.roiHeight; ++y) {
                int index = y * this.width + this.roiX;
                double tmp3 = tmp1 - (double)y * sa + centerX;
                double tmp4 = tmp2 + (double)y * ca + centerY;
                for (int x = this.roiX; x <= xMax; ++x) {
                    double xs = (double)x * ca + tmp3;
                    double ys = (double)x * sa + tmp4;
                    int value = (int)(this.getBicubicInterpolatedPixel(xs, ys, ip2) + 0.5);
                    if (value < 0) {
                        value = 0;
                    }
                    if (value > 255) {
                        value = 255;
                    }
                    this.pixels[index++] = (byte)value;
                }
            }
        } else {
            for (int y = this.roiY; y < this.roiY + this.roiHeight; ++y) {
                int index = y * this.width + this.roiX;
                double tmp3 = tmp1 - (double)y * sa + centerX;
                double tmp4 = tmp2 + (double)y * ca + centerY;
                for (int x = this.roiX; x <= xMax; ++x) {
                    double xs = (double)x * ca + tmp3;
                    double ys = (double)x * sa + tmp4;
                    if (xs >= -0.01 && xs < dwidth && ys >= -0.01 && ys < dheight) {
                        if (this.interpolationMethod == 1) {
                            if (xs < 0.0) {
                                xs = 0.0;
                            }
                            if (xs >= xlimit) {
                                xs = xlimit2;
                            }
                            if (ys < 0.0) {
                                ys = 0.0;
                            }
                            if (ys >= ylimit) {
                                ys = ylimit2;
                            }
                            this.pixels[index++] = (byte)(this.getInterpolatedPixel(xs, ys, pixels2) + 0.5);
                            continue;
                        }
                        int ixs = (int)(xs + 0.5);
                        int iys = (int)(ys + 0.5);
                        if (ixs >= this.width) {
                            ixs = this.width - 1;
                        }
                        if (iys >= this.height) {
                            iys = this.height - 1;
                        }
                        this.pixels[index++] = pixels2[this.width * iys + ixs];
                        continue;
                    }
                    this.pixels[index++] = (byte)this.bgColor;
                }
            }
        }
    }

    @Override
    public void flipVertical() {
        for (int y = 0; y < this.roiHeight / 2; ++y) {
            int index1 = (this.roiY + y) * this.width + this.roiX;
            int index2 = (this.roiY + this.roiHeight - 1 - y) * this.width + this.roiX;
            for (int i = 0; i < this.roiWidth; ++i) {
                byte tmp = this.pixels[index1];
                this.pixels[index1++] = this.pixels[index2];
                this.pixels[index2++] = tmp;
            }
        }
    }

    @Override
    public int[] getHistogram() {
        if (this.mask != null) {
            return this.getHistogram(this.mask);
        }
        int[] histogram = new int[256];
        for (int y = this.roiY; y < this.roiY + this.roiHeight; ++y) {
            int i = y * this.width + this.roiX;
            for (int x = this.roiX; x < this.roiX + this.roiWidth; ++x) {
                int v;
                int n = v = this.pixels[i++] & 0xFF;
                histogram[n] = histogram[n] + 1;
            }
        }
        return histogram;
    }

    public int[] getHistogram(ImageProcessor mask) {
        int rx = this.roiX;
        int ry = this.roiY;
        int rw = this.roiWidth;
        int rh = this.roiHeight;
        if (mask.getWidth() != rw || mask.getHeight() != rh) {
            throw new IllegalArgumentException(this.maskSizeError(mask));
        }
        int[] histogram = new int[256];
        byte[] mpixels = (byte[])mask.getPixels();
        int y = ry;
        int my = 0;
        while (y < ry + rh) {
            int i = y * this.width + rx;
            int mi = my * rw;
            for (int x = rx; x < rx + rw; ++x) {
                if (mpixels[mi++] != 0) {
                    int v;
                    int n = v = this.pixels[i] & 0xFF;
                    histogram[n] = histogram[n] + 1;
                }
                ++i;
            }
            ++y;
            ++my;
        }
        return histogram;
    }

    @Override
    public void threshold(int level) {
        for (int i = 0; i < this.width * this.height; ++i) {
            this.pixels[i] = (this.pixels[i] & 0xFF) <= level ? 0 : -1;
        }
    }

    public void applyLut() {
        if (this.rLUT2 == null) {
            return;
        }
        if (this.isInvertedLut()) {
            for (int i = 0; i < this.width * this.height; ++i) {
                this.pixels[i] = (byte)(255 - this.rLUT2[this.pixels[i] & 0xFF]);
            }
        } else {
            for (int i = 0; i < this.width * this.height; ++i) {
                this.pixels[i] = this.rLUT2[this.pixels[i] & 0xFF];
            }
        }
        this.setMinAndMax(0.0, 255.0);
    }

    @Override
    public void convolve(float[] kernel, int kernelWidth, int kernelHeight) {
        ImageProcessor ip2 = this.convertToFloat();
        ip2.setRoi(this.getRoi());
        new Convolver().convolve(ip2, kernel, kernelWidth, kernelHeight);
        ip2 = ip2.convertToByte(false);
        byte[] pixels2 = (byte[])ip2.getPixels();
        System.arraycopy(pixels2, 0, this.pixels, 0, this.pixels.length);
    }

    public FloatProcessor[] toFloatProcessors() {
        FloatProcessor[] fp = new FloatProcessor[]{(FloatProcessor)this.convertToFloat()};
        return fp;
    }

    public void setFromFloatProcessors(FloatProcessor[] fp) {
        ImageProcessor ip2 = fp[0].convertToByte(false);
        this.setPixels(ip2.getPixels());
    }

    public float[][] toFloatArrays() {
        float[][] a = new float[1][];
        ImageProcessor fp = this.convertToFloat();
        a[0] = (float[])fp.getPixels();
        return a;
    }

    public void setFromFloatArrays(float[][] arrays) {
        ImageProcessor ip2 = new FloatProcessor(this.roiWidth, this.roiHeight, arrays[0], null);
        ip2 = ip2.convertToByte(false);
        this.setPixels(ip2.getPixels());
    }

    @Override
    public FloatProcessor toFloat(int channelNumber, FloatProcessor fp) {
        int size = this.width * this.height;
        if (fp == null || fp.getWidth() != this.width || fp.getHeight() != this.height) {
            fp = new FloatProcessor(this.width, this.height, new float[size], this.cm);
        }
        float[] fPixels = (float[])fp.getPixels();
        for (int i = 0; i < size; ++i) {
            fPixels[i] = this.pixels[i] & 0xFF;
        }
        fp.setRoi(this.getRoi());
        fp.setMask(this.mask);
        fp.setMinAndMax(this.min, this.max);
        fp.setThreshold(this.minThreshold, this.maxThreshold, 2);
        return fp;
    }

    @Override
    public void setPixels(int channelNumber, FloatProcessor fp) {
        float[] fPixels = (float[])fp.getPixels();
        int size = this.width * this.height;
        for (int i = 0; i < size; ++i) {
            float value = fPixels[i] + 0.5f;
            if (value < 0.0f) {
                value = 0.0f;
            }
            if (value > 255.0f) {
                value = 255.0f;
            }
            this.pixels[i] = (byte)value;
        }
        this.setMinAndMax(fp.getMin(), fp.getMax());
    }

    @Override
    public boolean isBinary() {
        for (int i = 0; i < this.width * this.height; ++i) {
            if (this.pixels[i] == 0 || this.pixels[i] == -1) continue;
            return false;
        }
        return true;
    }

    @Override
    public int getBitDepth() {
        return 8;
    }

    @Override
    public ByteProcessor createMask() {
        if (this.getMinThreshold() == -808080.0) {
            return null;
        }
        int minThreshold = (int)this.getMinThreshold();
        int maxThreshold = (int)this.getMaxThreshold();
        ByteProcessor mask = new ByteProcessor(this.width, this.height);
        byte[] mpixels = (byte[])mask.getPixels();
        for (int i = 0; i < this.pixels.length; ++i) {
            int value = this.pixels[i] & 0xFF;
            if (value < minThreshold || value > maxThreshold) continue;
            mpixels[i] = -1;
        }
        return mask;
    }

    @Override
    byte[] create8BitImage() {
        return this.pixels;
    }
}

