/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.flamingo.common;

import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import org.pushingpixels.flamingo.api.common.AbstractCommandButton;
import org.pushingpixels.flamingo.api.common.icon.ResizableIcon;
import org.pushingpixels.substance.api.ColorSchemeAssociationKind;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.SubstanceColorScheme;
import org.pushingpixels.substance.internal.animation.StateTransitionTracker;
import org.pushingpixels.substance.internal.utils.HashMapKey;
import org.pushingpixels.substance.internal.utils.LazyResettableHashMap;
import org.pushingpixels.substance.internal.utils.SubstanceColorSchemeUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.icon.TransitionAware;

@TransitionAware
public class TransitionAwareResizableIcon
implements ResizableIcon {
    protected int width;
    protected int height;
    private JComponent comp;
    private StateTransitionTrackerDelegate stateTransitionTrackerDelegate;
    private Delegate delegate;
    private LazyResettableHashMap<Icon> iconMap;

    public TransitionAwareResizableIcon(AbstractCommandButton button, StateTransitionTrackerDelegate stateTransitionTrackerDelegate, Delegate delegate, Dimension initialDim) {
        this.comp = button;
        this.stateTransitionTrackerDelegate = stateTransitionTrackerDelegate;
        this.delegate = delegate;
        this.iconMap = new LazyResettableHashMap("TransitionAwareResizableIcon");
        this.width = initialDim.width;
        this.height = initialDim.height;
    }

    private Icon getIconToPaint() {
        StateTransitionTracker stateTransitionTracker = this.stateTransitionTrackerDelegate.getStateTransitionTracker();
        StateTransitionTracker.ModelStateInfo modelStateInfo = stateTransitionTracker.getModelStateInfo();
        Map<ComponentState, StateTransitionTracker.StateContributionInfo> activeStates = modelStateInfo.getStateContributionMap();
        ComponentState currState = modelStateInfo.getCurrModelState();
        SubstanceColorScheme baseScheme = SubstanceColorSchemeUtilities.getColorScheme(this.comp, ColorSchemeAssociationKind.MARK, currState);
        float baseAlpha = SubstanceColorSchemeUtilities.getAlpha(this.comp, currState);
        HashMapKey keyBase = SubstanceCoreUtilities.getHashKey(baseScheme.getDisplayName(), Float.valueOf(baseAlpha), this.width, this.height);
        Icon layerBase = this.iconMap.get(keyBase);
        if (layerBase == null) {
            Icon baseFullOpacity = this.delegate.getColorSchemeIcon(baseScheme, this.width, this.height);
            if (baseAlpha == 1.0f) {
                layerBase = baseFullOpacity;
                this.iconMap.put(keyBase, layerBase);
            } else {
                BufferedImage baseImage = SubstanceCoreUtilities.getBlankImage(baseFullOpacity.getIconWidth(), baseFullOpacity.getIconHeight());
                Graphics2D g2base = baseImage.createGraphics();
                g2base.setComposite(AlphaComposite.SrcOver.derive(baseAlpha));
                baseFullOpacity.paintIcon(this.comp, g2base, 0, 0);
                g2base.dispose();
                layerBase = new ImageIcon(baseImage);
                this.iconMap.put(keyBase, layerBase);
            }
        }
        if (currState.isDisabled() || activeStates.size() == 1) {
            return layerBase;
        }
        BufferedImage result = SubstanceCoreUtilities.getBlankImage(layerBase.getIconWidth(), layerBase.getIconHeight());
        Graphics2D g2d = result.createGraphics();
        layerBase.paintIcon(this.comp, g2d, 0, 0);
        for (Map.Entry<ComponentState, StateTransitionTracker.StateContributionInfo> activeEntry : activeStates.entrySet()) {
            float stateContribution;
            ComponentState activeState = activeEntry.getKey();
            if (activeState == currState || !((stateContribution = activeEntry.getValue().getContribution()) > 0.0f)) continue;
            g2d.setComposite(AlphaComposite.SrcOver.derive(stateContribution));
            SubstanceColorScheme scheme = SubstanceColorSchemeUtilities.getColorScheme(this.comp, ColorSchemeAssociationKind.MARK, activeState);
            float alpha = SubstanceColorSchemeUtilities.getAlpha(this.comp, activeState);
            HashMapKey key = SubstanceCoreUtilities.getHashKey(scheme.getDisplayName(), Float.valueOf(alpha), this.width, this.height);
            Icon layer = this.iconMap.get(key);
            if (layer == null) {
                Icon fullOpacity = this.delegate.getColorSchemeIcon(scheme, this.width, this.height);
                if (alpha == 1.0f) {
                    layer = fullOpacity;
                    this.iconMap.put(key, layer);
                } else {
                    BufferedImage image = SubstanceCoreUtilities.getBlankImage(fullOpacity.getIconWidth(), fullOpacity.getIconHeight());
                    Graphics2D g2layer = image.createGraphics();
                    g2layer.setComposite(AlphaComposite.SrcOver.derive(alpha));
                    fullOpacity.paintIcon(this.comp, g2layer, 0, 0);
                    g2layer.dispose();
                    layer = new ImageIcon(image);
                    this.iconMap.put(key, layer);
                }
            }
            layer.paintIcon(this.comp, g2d, 0, 0);
        }
        g2d.dispose();
        return new ImageIcon(result);
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        this.getIconToPaint().paintIcon(c, g, x, y);
    }

    @Override
    public void setDimension(Dimension newDimension) {
        this.width = newDimension.width;
        this.height = newDimension.height;
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }

    @Override
    public int getIconWidth() {
        return this.width;
    }

    public static interface StateTransitionTrackerDelegate {
        public StateTransitionTracker getStateTransitionTracker();
    }

    public static interface Delegate {
        public Icon getColorSchemeIcon(SubstanceColorScheme var1, int var2, int var3);
    }
}

