/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.flamingo.ribbon.gallery.oob;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import org.pushingpixels.flamingo.api.common.icon.ResizableIcon;
import org.pushingpixels.substance.api.SubstanceColorScheme;

public class ColorSchemeResizableIcon
implements ResizableIcon {
    private int currWidth;
    private int currHeight;
    private SubstanceColorScheme scheme;

    public ColorSchemeResizableIcon(SubstanceColorScheme scheme, int startWidth, int startHeight) {
        this.scheme = scheme;
        this.currWidth = startWidth;
        this.currHeight = startHeight;
    }

    @Override
    public void setDimension(Dimension newDimension) {
        this.currWidth = newDimension.width;
        this.currHeight = newDimension.height;
    }

    @Override
    public int getIconHeight() {
        return this.currHeight;
    }

    @Override
    public int getIconWidth() {
        return this.currWidth;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.translate(x, y);
        double R = Math.max(3.0, (double)this.currHeight / 10.0);
        double r = R / 2.0;
        double s = ((double)this.currHeight - 2.0 * R) / 2.0;
        double cx = (double)this.currWidth / 2.0;
        double dx = s * Math.sqrt(3.0) / 2.0;
        R = Math.floor(R);
        Color color1 = this.scheme == null ? Color.red : this.scheme.getUltraDarkColor();
        Color color2 = this.scheme == null ? Color.yellow : this.scheme.getDarkColor();
        Color color3 = this.scheme == null ? Color.green : this.scheme.getMidColor();
        Color color4 = this.scheme == null ? Color.cyan : this.scheme.getLightColor();
        Color color5 = this.scheme == null ? Color.blue : this.scheme.getExtraLightColor();
        Color color6 = this.scheme == null ? Color.magenta : this.scheme.getUltraLightColor();
        this.paintCircle(graphics, cx, R, R, color1, true);
        if (this.currHeight > 16) {
            this.paintCircle(graphics, cx + dx, R + 0.5 * s, R, color2, true);
        }
        this.paintCircle(graphics, cx + dx, R + 1.5 * s, R, color3, true);
        if (this.currHeight > 16) {
            this.paintCircle(graphics, cx, (double)(this.currHeight - 1) - R, R, color4, true);
        }
        this.paintCircle(graphics, cx + 1.0 - dx, R + 1.5 * s, R, color5, true);
        if (this.currHeight > 16) {
            this.paintCircle(graphics, cx + 1.0 - dx, R + 0.5 * s, R, color6, true);
        }
        if (r >= 2.0) {
            this.paintCircle(graphics, cx + 0.5 + dx / 2.0, R + 0.25 * s, r, color1, false);
            this.paintCircle(graphics, cx + dx, R + s, r, color2, false);
            this.paintCircle(graphics, cx + 0.5 + dx / 2.0, R + ((double)(this.currHeight - 1) + 1.5 * s) / 2.0, r, color3, false);
            this.paintCircle(graphics, cx - 0.5 - dx / 2.0, R + ((double)(this.currHeight - 1) + 1.5 * s) / 2.0, r, color4, false);
            this.paintCircle(graphics, cx - dx, R + s, r, color5, false);
            this.paintCircle(graphics, cx - 0.5 - dx / 2.0, R + 0.25 * s, r, color6, false);
        }
        graphics.dispose();
    }

    private void paintCircle(Graphics2D graphics, double xc, double yc, double r, Color color, boolean toDrawOutline) {
        Ellipse2D.Double shape = new Ellipse2D.Double(xc - r, yc - r, 2.0 * r, 2.0 * r);
        this.paintShape(graphics, shape, color, toDrawOutline);
    }

    private void paintShape(Graphics2D graphics, Shape shape, Color color, boolean toDrawOutline) {
        graphics.setColor(color);
        graphics.fill(shape);
        if (toDrawOutline) {
            graphics.setColor(color.darker());
            graphics.draw(shape);
        }
    }
}

