/*
 * Decompiled with CFR 0.152.
 */
package plugins.ylemontag.mathoperations;

import java.util.LinkedList;

public class Controller {
    private boolean _cancelFlag = false;
    private LinkedList<JobProbe> _probes = new LinkedList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushProbe(JobProbe probe) {
        LinkedList<JobProbe> linkedList = this._probes;
        synchronized (linkedList) {
            this._probes.addLast(probe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearProbes() {
        LinkedList<JobProbe> linkedList = this._probes;
        synchronized (linkedList) {
            this._probes.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getProgress() {
        int currentStep = 0;
        int maxStep = 0;
        LinkedList<JobProbe> linkedList = this._probes;
        synchronized (linkedList) {
            for (JobProbe probe : this._probes) {
                currentStep = (int)((long)currentStep + probe.getCurrentStep());
                maxStep = (int)((long)maxStep + probe.getMaxStep());
            }
        }
        if (maxStep <= 0) {
            return -1.0;
        }
        double progress = (double)currentStep / (double)maxStep;
        if (progress >= 1.0) {
            return 1.0;
        }
        if (progress <= 0.0) {
            return 0.0;
        }
        return progress;
    }

    public void cancelComputation() {
        this._cancelFlag = true;
    }

    public void checkPoint() throws CanceledByUser {
        if (this._cancelFlag) {
            throw new CanceledByUser();
        }
    }

    public static interface JobProbe {
        public long getCurrentStep();

        public long getMaxStep();
    }

    public static class CanceledByUser
    extends Exception {
        private static final long serialVersionUID = 1L;
    }
}

